<?php
namespace Resrequest\API\V1\Rpc\RoomingGetStock;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ApiProblem\ApiProblemResponse;
use ZF\ApiProblem\ApiProblem;
use ZF\ContentNegotiation\JsonModel;

class RoomingGetStockController extends AbstractActionController
{
    protected $em;
    protected $auth;
    protected $legacy;

    public function __construct($em, $auth)
    {
        $this->em = $em;
        $this->auth = $auth;
        $this->legacy = __DIR__."/../../../../../../../Application/src/Resrequest/legacy/";
    }

    public function roomingGetStockAction()
    {
        $params = $this->bodyParams();
        $db = $this->em->getConnection();

        $username = false;
        $identity = $this->getIdentity();
        if($identity instanceof \ZF\MvcAuth\Identity\AuthenticatedIdentity) {
            $username = $identity->getAuthenticationIdentity()['user_id'];
        }

        if($username === false) {
            return new ApiProblemResponse(
                new ApiProblem(403, "Unable to find user")
            );
        }

        $this->auth->setupContext($this->auth->getUserByName($username));

        $user = $db->fetchAssoc("
            SELECT
                pr_user.pr_user_id,
                sc_user.sc_group_id
            FROM
                sc_user
                INNER JOIN pr_user ON pr_user.pr_user_id = sc_user.pr_user_id
            WHERE
                pr_user.pr_user_name = ?
        ",[$username]);
        if($user === false) {
            return new ApiProblemResponse(
                new ApiProblem(403, "Unable to find user")
            );
        }

        $accommFilter = array();
        if(
            array_key_exists("accomm_filter",$params)
            && is_array($params['accomm_filter'])
            && sizeof($params['accomm_filter']) > 0
            && !empty($params['accomm_filter'][0])
        ) {
            $accommFilter = $params['accomm_filter'];
        } else {
            return new ApiProblemResponse(
                new ApiProblem(400, "Invalid or missing accommodation filter")
            );
        }

        if(
            !array_key_exists("period",$params)
            || !is_array($params['period'])
            || !array_key_exists("from",$params['period'])
            || !array_key_exists("to",$params['period'])
        ) {
            return new ApiProblemResponse(
                new ApiProblem(400, "Invalid period")
            );
        }
        $fromDate = $params['period']['from'];
        $toDate = $params['period']['to'];

        $accommACL = array_column($db->fetchAll("
            SELECT DISTINCT
                ac_accomm_type.ac_accomm_type_ix
            FROM
                sc_accomm
                INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = sc_accomm.ac_accomm_type_id
                INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
            WHERE
                sc_accomm.sc_group_id = ?
                AND ac_accomm_type.ac_accomm_type_inactive_yn = '0'
                AND ac_accomm_type.ac_accomm_type_ix IN (?)
                AND pr_business.pr_bus_inactive_yn = '0'
        ",[
            $user['sc_group_id'],
            $accommFilter
        ],[
            \PDO::PARAM_INT,
            \Doctrine\DBAL\Connection::PARAM_STR_ARRAY
        ]),'ac_accomm_type_ix');

        require_once($this->legacy . "class.stock.php");

        $list = [];

        // TODO $resItemList = join(":", $GLOBALS['lDB']->get("SELECT rv_reservation_item_ix FROM rv_reservation_item WHERE rv_reservation_id = '$wizResId'", 3));
        $stock = new \Stock(false, $fromDate, $toDate, false, false, false, ""); // TODO $resItemList);
        foreach($accommACL as $ac_accomm_type_id) {
	        $stock->SetAccommTypeId($ac_accomm_type_id);
            $list[] = [
                'accommodation_id'=>$ac_accomm_type_id,
                'availability' => $stock->ToAvailability()
            ];
        }

        return new JsonModel($list);
    }
}
