<?php
namespace Resrequest\API\V1\Rpc\RoomingSetItem;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ApiProblem\ApiProblemResponse;
use ZF\ApiProblem\ApiProblem;
use ZF\ContentNegotiation\JsonModel;

class RoomingSetItemController extends AbstractActionController
{
    protected $em;
    protected $authenticate;
    protected $authorise;

    public function __construct($em, $authenticate, $authorise)
    {
        $this->em = $em;
        $this->authenticate = $authenticate;
        $this->authorise = $authorise;
        $this->legacy = __DIR__."/../../../../../../../Application/src/Resrequest/legacy/";
    }

    public function roomingSetItemAction()
    {
        $params = $this->bodyParams();
        $db = $this->em->getConnection();

        $username = false;
        $identity = $this->getIdentity();
        if($identity instanceof \ZF\MvcAuth\Identity\AuthenticatedIdentity) {
            $username = $identity->getAuthenticationIdentity()['user_id'];
        }

        if($username === false) {
            return new ApiProblemResponse(
                new ApiProblem(403, "Unable to find user")
            );
        }

        $this->authenticate->setupContext($this->authenticate->getUserByName($username));

        $user = $db->fetchAssoc("
            SELECT
                pr_user.pr_user_id,
                sc_user.sc_group_id
            FROM
                sc_user
                INNER JOIN pr_user ON pr_user.pr_user_id = sc_user.pr_user_id
            WHERE
                pr_user.pr_user_name = ?
        ",[$username]);
        if($user === false) {
            return new ApiProblemResponse(
                new ApiProblem(403, "Unable to find user")
            );
        }

        $access = $this->authorise->getAccess([
            'functions'=>[81],
            'environment'=>["isMaster","isProperty"]
        ]);
        if($access['functions'][81] < 10 ) {
            return new ApiProblemResponse(
                new ApiProblem(403, "Access denied")
            );
        }

        // Check that room item is identifiable
        if(
            (
                !array_key_exists("reservation_item_id",$params)
                || empty($params['reservation_item_id'])
            ) && (
                !array_key_exists("res_item_group_id",$params)
                || empty($params['res_item_group_id'])
            )
        ) {
            return new JsonModel([
                'status'=>false,
                'errors'=>[
                    ['index'=>0, 'error'=>"Unable to process invalid room data"]
                ]
            ]);
        }

        // Validate requested
        if(
            (
                array_key_exists("requested_yn",$params)
                && !array_key_exists("requested_reason",$params)
            ) || (
                !array_key_exists("requested_yn",$params)
                && array_key_exists("requested_reason",$params)
            )
        ) {
            return new JsonModel([
                'status'=>false,
                'errors'=>[
                    ['index'=>0, 'error'=>"Invalid room request"]
                ]
            ]);
        }

        if(array_key_exists("status_ind",$params) && !$access['environment']['isProperty']) {
            return new ApiProblemResponse(
                new ApiProblem(403, "Access denied")
            );
        }

        // Look up itinerary information
        if(empty($params['res_item_group_id'])) {
            $rv_reservation_item_id = $params['reservation_item_id'];
            $rv_res_item_group_id = "";
        } else {
            $rv_reservation_item_id = $db->fetchColumn("
                SELECT
                    rv_res_item_group.rv_reservation_item_id
                FROM
                    rv_res_item_group
                WHERE
                    rv_res_item_group.rv_res_item_group_ix = ?
            ",[$params['res_item_group_id']]);
            $rv_res_item_group_id = $params['res_item_group_id'];
        }
        if(empty($rv_reservation_item_id)) {
            return new JsonModel([
                'status'=>false,
                'errors'=>[
                    ['index'=>0, 'error'=>"Unable to process invalid room data"]
                ]
            ]);
        }

        require_once($this->legacy . "db.rv_res_item_group.php");

        // Set room and requested state
        if(
            array_key_exists("room_id",$params)
            || array_key_exists("requested_yn",$params)
        ) {
            if(array_key_exists("room_id",$params)) {
                if(empty($params['room_id'])) {
                    $params['room_id'] = "0";
                }
            } else {
                $roomId = $db->fetchColumn("
                    SELECT
                        rv_res_item_group.ac_accomm_room_id
                    FROM
                        rv_res_item_group
                    WHERE
                        rv_res_item_group.rv_res_item_group_ix = ?
                ",[$rv_res_item_group_id]);
                if($roomId !== false) {
                    $params['room_id'] = $roomId;
                }
            }

            if(array_key_exists("requested_yn",$params)) {
                $params['requested_yn'] = (empty($params['requested_yn'])?"0":"1");
            } else {
                $params['requested_yn'] = "0";
                $params['requested_reason'] = "";
                $requested = $db->fetchAssoc("
                    SELECT
                        rv_res_item_group.rv_room_requested_yn,
                        rv_res_item_group.rv_room_request_reason
                    FROM
                        rv_res_item_group
                    WHERE
                        rv_res_item_group.rv_res_item_group_ix = ?
                ",[$rv_res_item_group_id]);
                if($requested !== false) {
                    $params['requested_yn'] = $requested['rv_room_requested_yn'];
                    $params['requested_reason'] = $requested['rv_room_request_reason'];
                }
            }

            // Set the room if supplied and create a group if necessary
            if(array_key_exists("room_id",$params)) {
                if(empty($params['room_id'])) {
                    $params['room_id'] = "0";
                }

                $itinerary = $db->fetchAssoc("
                    SELECT
                        rv_reservation_item.rv_reservation_id,
                        rv_reservation_item.pr_business_id,
                        rv_reservation_item.rv_item_date_arrive,
                        rv_reservation_item.rv_item_date_depart
                    FROM
                        rv_reservation_item
                    WHERE
                        rv_reservation_item.rv_reservation_item_ix = ?
                ",[$rv_reservation_item_id]);
                if(empty($itinerary)) {
                    return new JsonModel([
                        'status'=>false,
                        'errors'=>[
                            ['index'=>0, 'error'=>"Itinerary not found"]
                        ]
                    ]);
                }

                $rv_reservation_id = $itinerary['rv_reservation_id'];

                if(!empty($params['room_id'])) {
                    // Is the room allowed? (exists and is active for the itinerary period)
                    $roomCheck = $db->fetchAssoc("
                        SELECT
                            IF(COUNT(*) > 0, true, false) AS allow,
                            ac_accomm_type.pr_business_id
                        FROM
                            ac_accomm_room
                            INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
                        WHERE
                            ac_accomm_room.ac_accomm_room_ix = ?
                            AND (
                                ac_accomm_type.ac_accomm_type_inactive_yn = '0'
                                OR (
                                    ac_accomm_type.ac_accomm_type_inactive_yn != '0'
                                    AND ac_accomm_type.ac_accomm_type_inactive_date >= ?
                                )
                            )
                            AND (
                                (
                                    ac_accomm_room.ac_accomm_room_inactive_yn = '0'
                                    AND ac_accomm_room_create_date <= ?
                                ) OR (
                                    ac_accomm_room.ac_accomm_room_inactive_yn != '0'
                                    AND ac_accomm_room_inactive_date > ?
                                )
                            )
                    ",[
                        $params['room_id'],
                        $itinerary['rv_item_date_depart'],
                        $itinerary['rv_item_date_arrive'],
                        $itinerary['rv_item_date_depart']
                    ]);

                    if(!$roomCheck['allow']) {
                        return new JsonModel([
                            'status'=>false,
                            'errors'=>[
                                ['index'=>0, 'error'=>"Room or accommodation type inactive or invalid"]
                            ]
                        ]);
                    }

                    if($itinerary['pr_business_id'] != $roomCheck['pr_business_id']) {
                        return new JsonModel([
                            'status'=>false,
                            'errors'=>[
                                ['index'=>0, 'error'=>"Itinerary property does not match selected room property"]
                            ]
                        ]);
                    }

                    // Check availability
                    $blockCheck = $db->fetchColumn("
                        SELECT
                            COUNT(*)
                        FROM
                            ac_accomm_room_block
                            INNER JOIN ac_accomm_block ON
                                ac_accomm_block.ac_accomm_block_ix = ac_accomm_room_block.ac_accomm_block_id
                        WHERE
                            ac_accomm_room_id = ?
                            AND (
                                (
                                    ? >= ac_accomm_block.ac_start_date
                                    AND ? < ac_accomm_block.ac_end_date
                                ) OR (
                                    ? > ac_accomm_block.ac_start_date
                                    AND ? <= ac_accomm_block.ac_end_date
                                ) OR (
                                    ? < ac_accomm_block.ac_start_date
                                    AND ? > ac_accomm_block.ac_end_date
                                )
                            )
                    ",[
                        $params['room_id'],
                        $itinerary['rv_item_date_arrive'],
                        $itinerary['rv_item_date_arrive'],
                        $itinerary['rv_item_date_depart'],
                        $itinerary['rv_item_date_depart'],
                        $itinerary['rv_item_date_arrive'],
                        $itinerary['rv_item_date_depart']
                    ]);
                    if($blockCheck > 0) {
                        return new JsonModel([
                            'status'=>false,
                            'errors'=>[
                                ['index'=>0, 'error'=>"Selected room is blocked during the travel period of this itinerary"]
                            ]
                        ]);
                    }

                    $availCheck = $db->fetchAll("
                        SELECT
                            rv_res_item_group.rv_res_item_group_ix
                        FROM
                            rv_res_item_group
                            INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
                        WHERE
                            ac_accomm_room_id = ?
                            AND rv_res_item_group.rv_res_item_group_ix != ?
                            AND (
                                (
                                    rv_reservation_item.rv_item_date_arrive >= ?
                                    AND rv_reservation_item.rv_item_date_arrive < ?
                                ) OR (
                                    (
                                        (
                                            rv_reservation_item.rv_item_date_depart > ?
                                            AND rv_res_item_group.rv_grp_status_ind <> '8'
                                        ) OR (
                                            rv_res_item_group.rv_grp_status_time > ?
                                            AND rv_res_item_group.rv_grp_status_ind = '8'
                                        )
                                    ) AND (
                                        (
                                            rv_reservation_item.rv_item_date_depart <= ?
                                            AND rv_res_item_group.rv_grp_status_ind <> '8'
                                        ) OR (
                                            rv_res_item_group.rv_grp_status_time <= ?
                                            AND rv_res_item_group.rv_grp_status_ind = '8'
                                        )
                                    )
                                ) OR (
                                    rv_reservation_item.rv_item_date_arrive < ?
                                    AND (
                                        (
                                            rv_reservation_item.rv_item_date_depart > ?
                                            AND rv_res_item_group.rv_grp_status_ind <> '8'
                                        ) OR (
                                            rv_res_item_group.rv_grp_status_time > ?
                                            AND rv_res_item_group.rv_grp_status_ind = '8'
                                        )
                                    )
                                ) OR (
                                    rv_res_item_group.rv_grp_status_ind = '5'
                                    AND ? < ?
                                )
                            )
                    ",[
                        $params['room_id'],
                        $rv_res_item_group_id,
                        $itinerary['rv_item_date_arrive'],
                        $itinerary['rv_item_date_depart'],
                        $itinerary['rv_item_date_arrive'],
                        $itinerary['rv_item_date_arrive'] . " 23:59:59",
                        $itinerary['rv_item_date_depart'],
                        $itinerary['rv_item_date_depart'] . " 23:59:59",
                        $itinerary['rv_item_date_arrive'],
                        $itinerary['rv_item_date_depart'],
                        $itinerary['rv_item_date_depart'] . " 23:59:59",
                        $itinerary['rv_item_date_arrive'],
                        date("Y-m-d")
                    ]);

                    if(sizeof($availCheck) > 0) {
                        return new JsonModel([
                            'status'=>false,
                            'errors'=>[
                                ['index'=>0, 'error'=>"Selected room is already used by another itinerary"]
                            ]
                        ]);
                    }
                }

                // Update rooming
                if(empty($rv_res_item_group_id)) {
                    $rv_res_item_group_id = db_rv_res_item_group_insert($rv_reservation_item_id, $params['room_id'], $params['requested_yn'],$params['requested_reason']);
                } else {
                    db_rv_res_item_group_set_room($rv_res_item_group_id, $params['room_id'], $params['requested_yn'],$params['requested_reason']);
                }
                
                require_once($this->legacy . "functions.rooming.php");
                require_once($this->legacy . "functions.reservation.php");
                if ($params['room_id'] == '0') {
                  ammendReservation($rv_reservation_id, "Rooming (Deallocate)");	
                } else {
                  ammendReservation($rv_reservation_id, "Rooming (Allocate [".getRoomDesc($params['room_id'])."])");	
                }
            }
        }

        // Check in / out
        if(array_key_exists("status_ind",$params)) {
            if(empty($rv_res_item_group_id)) {
                return new JsonModel([
                    'status'=>false,
                    'errors'=>[
                        ['index'=>0, 'error'=>"Cannot check in/out itinerary without group"]
                    ]
                ]);
            }
            if(
                $params['status_ind'] != "2"
                && $params['status_ind'] != "5"
                && $params['status_ind'] != "8"
            ) {
                return new JsonModel([
                    'status'=>false,
                    'errors'=>[
                        ['index'=>0, 'error'=>"Invalid check in/out status"]
                    ]
                ]);
            }
            if(!array_key_exists("status_time",$params)) {
                $params['status_time'] = false;
            }
            db_rv_res_item_group_set_status($rv_res_item_group_id,$params['status_ind'],$params['status_time']);
        }

        return new JsonModel([
            'status'=>true
        ]);
    }
}
