<?php
namespace Resrequest\API\V1\Rpc\SystemCommand;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\ViewModel;
use Resrequest\Tools\Controller\EnterpriseController;
use Resrequest\DB\Service\EnterpriseDatabaseService;

class SystemCommandController extends AbstractActionController
{
    protected $em, $password, $sm;
    private $params;

    public function __construct($em, $enterprise, $sm)
    {
        $this->em = $em;
        $this->sm = $sm;
        $this->password = $enterprise->passwords['systemcommand'];
        $this->shortName = $enterprise->config['shortName'];
        $this->principalId = $enterprise->config['principalId'];
        $this->databaseName = $enterprise->config['databaseName'];
        $this->environment = $enterprise->config['environment'];
        $this->archive = $enterprise->config['archive'];
        $this->codeVersion = $enterprise->config['codeVersion'];
    }

    public function systemCommandAction()
    {
        $this->params = $this->bodyParams();
        $result = array();

        $username = false;
        $identity = $this->getIdentity();
        if ($identity instanceof \ZF\MvcAuth\Identity\AuthenticatedIdentity) {
            $username = $identity->getAuthenticationIdentity()['user_id'];
        }

        if (
            $username === false &&
            (!isset($this->params['securityHash']) || $this->params['securityHash'] !== $this->password)
        ) {
            return new ViewModel(['data' => '', 'error' => 'Invalid security hash', 'code' => 401]); // Unauthorized
        }

        $data = $this->params['data']['data'];

        if (!isset($data['action'])) {
            return new ViewModel(['data' => '', 'error' => 'No action specified', 'code' => 409]); // Conflict
        }

        if (!empty(trim($data['action']))) {
            switch ($data['action']) {
                case "checkMigrations":
                    putenv("DB_NAME=" . $this->databaseName);
                    exec('php public/index.php migrations:status', $migrationsStatus);
                    $newMigrations = substr($migrationsStatus[19], 59);
                    $result = $newMigrations;
                    break;

                case "runMigrations":
                    putenv("DB_NAME=" . $this->databaseName);
                    exec('php public/index.php migrations:migrate --no-interaction', $output);
                    $result = ucfirst(str_replace("  ++ ", "", join(", ", array_splice($output, -3))));
                    break;

                case "getCodeVersions":
                    exec('cd /var/www/html && ls rr_*', $output);
                    foreach ($output as $line) {
                        if (substr($line, 0, 3) == "rr_") {
                            $line = str_replace(":", "", $line);
                            $result[] = array(
                                "dirname" => $line,
                                "name" => str_replace("rr_", "", $line)
                            );
                        }
                    }
                    break;

                case "setSymlink":
                    exec('cd /var/www/html/symlinks && ls -1', $outputExistingSymlinks);
                    foreach ($outputExistingSymlinks as $line) {
                        if (strpos($line, $data['shortname']) !== false) {
                            exec('cd /var/www/html/symlinks && rm ' . $data['shortname'], $deleteSymlink);
                        }
                    }
                    if (substr($data['dir'], -1) == '/') {
                        $data['dir'] = substr($data['dir'], -1);
                    }
                    exec('cd /var/www/html/symlinks && ln -s /var/www/html/' . $data['dir'] . ' ' . $data['shortname'], $newSymlink);
                    exec('cd /var/www/html/symlinks && ls -l', $outputExistingSymlinks);
                    foreach ($outputExistingSymlinks as $line) {
                        if (strpos($line, $data['shortname'] . " -> ") !== false) {
                            $symlinkParts = explode($data['shortname'] . " -> ", $line);
                            $result = "Symlink " . $data['shortname'] . " has been set to dir " . $symlinkParts[1];
                        }
                    }
                    break;
            }
        }

        return new ViewModel([
            'result' => $result
        ]);
    }
}
