<?php
namespace Resrequest\API\V1\Rpc\SystemDiagnostics;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\ViewModel;

class SystemDiagnosticsController extends AbstractActionController
{
    protected $em, $password;
    private $params;

    public function __construct($em, $enterprise)
    {
        $this->em = $em;
        $this->password = $enterprise->passwords['systemdiagnostics'];
    }

    public function systemDiagnosticsAction()
    {
        $this->params = $this->bodyParams();

        if (!isset($this->params['securityHash']) || $this->params['securityHash'] !== $this->password) {
            return new ViewModel(['data' => '', 'error' => 'Invalid security hash', 'code' => 401]); // Unauthorized
        }

        $results = array();
        if (!isset($this->params['tests']) || empty($this->params['tests'])) {
            $tests = array();
        } else {
            $tests = explode(",", $this->params['tests']);
        }

        if (empty($tests) || in_array("InsecureCensysadPassword", $tests)) {
            $query = $this->em->createQueryBuilder();
            $results['InsecureCensysadPassword'] = $query
                ->select(
                    [
                        "TRIM(CONCAT(prPersona.prNameFirst, ' ', prPersona.prNameLast)) AS name"
                    ]
                )
                ->from('Resrequest\DB\Enterprise\Entity\PrUser', 'prUser')
                ->leftJoin('Resrequest\DB\Enterprise\Entity\PrPersona', 'prPersona', 'with', 'prPersona.prPersonaIx = prUser.prUserId')
                ->where('prUser.prUserName = :username')
                ->andWhere('prUser.prUserPassword >= :password')
                ->setParameters(
                    [
                        'username' => "censysad",
                        'password' => "censysad1"
                    ]
                )
                ->getQuery()
                ->getResult();
        }

        if (empty($tests) || in_array("EmptyFolios", $tests)) {
            $query = $this->em->createQueryBuilder();
            $results['EmptyFolios'] = $query
                ->select(
                    [
                        "fnFolio.fnFolioIx AS id"
                    ]
                )
                ->from('Resrequest\DB\Enterprise\Entity\FnFolio', 'fnFolio')
                ->leftJoin('Resrequest\DB\Enterprise\Entity\RvReservationItem', 'rvReservationItem', 'with', 'rvReservationItem.fnFolioId = fnFolio.fnFolioIx')
                ->leftJoin('Resrequest\DB\Enterprise\Entity\RvExtra', 'rvExtra', 'with', 'rvExtra.fnFolioId = fnFolio.fnFolioIx')
                ->where('rvReservationItem.rvReservationItemIx IS NULL')
                ->andWhere('rvExtra.rvExtraIx IS NULL')
                ->getQuery()
                ->getResult();
        }

        if (empty($tests) || in_array("ReservationItemGroupWithNoResItem", $tests)) {
            $query = $this->em->createQueryBuilder();
            $results['ReservationItemGroupWithNoResItem'] = $query
                ->select(
                    [
                        "rvResItemGroup.rvResItemGroupIx AS id"
                    ]
                )
                ->from('Resrequest\DB\Enterprise\Entity\RvResItemGroup', 'rvResItemGroup')
                ->leftJoin('Resrequest\DB\Enterprise\Entity\RvReservationItem', 'rvReservationItem', 'with', 'rvReservationItem.rvReservationItemIx = rvResItemGroup.rvReservationItemId')
                ->where('rvReservationItem.rvReservationItemIx IS NULL')
                ->getQuery()
                ->getResult();
        }

        if (empty($tests) || in_array("ReservationItemGuestWithNoGuests", $tests)) {
            $query = $this->em->createQueryBuilder();
            $results['ReservationItemGuestWithNoGuests'] = $query
                ->select(
                    [
                        "rvResItemGuest.rvResItemGuestIx AS id"
                    ]
                )
                ->from('Resrequest\DB\Enterprise\Entity\RvResItemGuest', 'rvResItemGuest')
                ->leftJoin('Resrequest\DB\Enterprise\Entity\PrPersona', 'prPersona', 'with', 'prPersona.prPersonaIx = rvResItemGuest.prGuestId')
                ->leftJoin('Resrequest\DB\Enterprise\Entity\RvResItemGroup', 'rvResItemGroup', 'with', 'rvResItemGroup.rvResItemGroupIx = rvResItemGuest.rvResItemGroupId')
                ->leftJoin('Resrequest\DB\Enterprise\Entity\RvReservationItem', 'rvReservationItem', 'with', 'rvReservationItem.rvReservationItemIx = rvResItemGuest.rvReservationItemId')
                ->where('rvResItemGroup.rvResItemGroupIx IS NULL')
                ->where('rvReservationItem.rvReservationItemIx IS NULL')
                ->getQuery()
                ->getResult();
        }

        if (empty($tests) || in_array("ReservationsWithNoItineraries", $tests)) {
            $query = $this->em->createQueryBuilder();
            $results['ReservationsWithNoItineraries'] = $query
                ->select(
                    [
                        "rvReservation.rvReservationIx AS id"
                    ]
                )
                ->from('Resrequest\DB\Enterprise\Entity\RvReservation', 'rvReservation')
                ->leftJoin('Resrequest\DB\Enterprise\Entity\RvReservationItem', 'rvReservationItem', 'with', 'rvReservationItem.rvReservationId = rvReservation.rvReservationIx')
                ->where('rvReservationItem.rvReservationItemIx IS NULL')
                ->getQuery()
                ->getResult();
        }

        if (empty($tests) || in_array("ReservationsWithNoFolios", $tests)) {
            $query = $this->em->createQueryBuilder();
            $results['ReservationsWithNoFolios'] = $query
                ->select(
                    [
                        "rvReservation.rvReservationIx AS id"
                    ]
                )
                ->from('Resrequest\DB\Enterprise\Entity\RvReservation', 'rvReservation')
                ->leftJoin('Resrequest\DB\Enterprise\Entity\FnFolio', 'fnFolio', 'with', 'fnFolio.rvReservationId = rvReservation.rvReservationIx')
                ->where('fnFolio.fnFolioIx IS NULL')
                ->getQuery()
                ->getResult();
        }

        if (empty($tests) || in_array("ReservationsDateLimit", $tests)) {
            $query = $this->em->createQueryBuilder();
            $results['ReservationsDateLimit'] = $query
                ->select(
                    [
                        "rfDefault.rfDateResLimit AS date"
                    ]
                )
                ->from('Resrequest\DB\Enterprise\Entity\RfDefault', 'rfDefault')
                ->getQuery()
                ->getResult();
        }

        if (empty($tests) || in_array("DataTransfers", $tests)) {
            $results['DataTransfers'] = array();
            $dataTransfers = array();
            $environments = array();

            $now = explode("-", date("Y-m-d-H-i-s"));
            $checkDate = date("Y-m-d", mktime($now[3], $now[4], $now[5], $now[1], $now[2]-2, $now[0]));
            $nowLess4hr = date("Y-m-d H:i:s", mktime($now[3]-4, $now[4], $now[5], $now[1], $now[2], $now[0]));
            $nowLess24hr = date("Y-m-d H:i:s", mktime($now[3]-24, $now[4], $now[5], $now[1], $now[2], $now[0]));
            $nowLess48hr = date("Y-m-d H:i:s", mktime($now[3]-48, $now[4], $now[5], $now[1], $now[2], $now[0]));
            $nowLess168hr = date("Y-m-d H:i:s", mktime($now[3]-168, $now[4], $now[5], $now[1], $now[2], $now[0]));
            $nowLess336hr = date("Y-m-d H:i:s", mktime($now[3]-168, $now[4], $now[5], $now[1], $now[2], $now[0]));
            $nowLess6mt = date("Y-m-d H:i:s", mktime($now[3], $now[4], $now[5], $now[1]-6, $now[2], $now[0]));
            $nowLess1wk = date("Y-m-d", mktime($now[3]-24, $now[4], $now[5], $now[1], $now[2]-7, $now[0]));
            $nowLess2wk = date("Y-m-d", mktime($now[3]-24, $now[4], $now[5], $now[1], $now[2]-14, $now[0]));

            $query = $this->em->createQueryBuilder();
            $rfDatabase = $query
                ->select(
                    [
                        "rfDatabase.rfDbCode",
                        "rfDatabase.rfDbInactiveYn",
                        "rfDatabase.rfDbDescription",
                        "rfDatabase.rfDbTrfAutoYn",
                        "rfDatabase.rfDbTrfAutoNote"
                    ]
                )
                ->from('Resrequest\DB\Enterprise\Entity\RfDatabase', 'rfDatabase')
                ->getQuery()
                ->getResult();

            foreach ($rfDatabase as $env) {
                if ($env['rfDbCode'][0] == "W") {
                    continue;
                }

                $lastTransfer = "";
                $lastTransferWarn = false;
                $inactive = ($env['rfDbInactiveYn'] == "1" ? true : false);
                if (!$inactive) {
                    $has_active = true;

                    $query = $this->em->createQueryBuilder();
                    $lastTransfer = $query
                        ->select(
                            [
                                "MAX(tcTransfer.tcTrfTimeStart) AS lastTransfer"
                            ]
                        )
                        ->from('Resrequest\DB\Enterprise\Entity\TcTransfer', 'tcTransfer')
                        ->getQuery()
                        ->getOneOrNullResult();
                    $lastTransfer = $lastTransfer['lastTransfer'];

                    if ($lastTransfer < $nowLess48hr) {
                        $lastTransferWarn = "error";
                        $hasWarn = true;
                    } elseif ($lastTransfer < $nowLess24hr) {
                        $lastTransferWarn = "warning";
                        $hasWarn = true;
                    } elseif ($lastTransfer < $nowLess4hr) {
                        $lastTransferWarn = "info";
                        $hasWarn = true;
                    } elseif (!empty($lastTransfer)) {
                        $lastTransferWarn = "success";
                    }
                }

                if (!empty($lastTransfer)) { 
                    $lastTransferArray = explode(" ",$lastTransfer);
                } else {
                    $lastTransfer = "";
                    $lastTransferArray = array("","");
                }

                $environments[] = array(
                    'code'=>$env['rfDbCode'],
                    'description'=>$env['rfDbDescription'],
                    'inactive'=>$inactive,
                    'inactiveX'=>($env['rfDbInactiveYn'] == "1" ? "x" : ""),
                    'lastTransfer'=>$lastTransfer,
                    'lastTransferDate'=>$lastTransferArray[0],
                    'lastTransferTime'=>$lastTransferArray[1],
                    'lastTransferWarn'=>$lastTransferWarn,
                    'auto'=>($env['rfDbTrfAutoYn'] != 0 ? true : false),
                    'autoNote'=>($env['rfDbTrfAutoYn'] != 0 ? $env['rfDbTrfAutoNote'] : "")
                );
            }

            if (!$has_active) {
                $environments[] = array(
                    'code'=>"Wx",
                    'description'=>"",
                    'inactive'=>false,
                    'inactiveX'=>"",
                    'lastTransfer'=>"n/a",
                    'lastTransferDate'=>"n/a",
                    'lastTransferTime'=>"n/a",
                    'lastTransferWarn'=>false,
                    'auto'=>false,
                    'autoNote'=>""
                );
            }

            $query = $this->em->createQueryBuilder();
            $dateRecordedChanged = $query
                ->select(
                    [
                        "MAX(rvReservation.rvDateRecorded) AS dateRecorded",
                        "MAX(rvReservation.rvDateChanged) AS dateChanged"
                    ]
                )
                ->from('Resrequest\DB\Enterprise\Entity\RvReservation', 'rvReservation')
                ->getQuery()
                ->getOneOrNullResult();
            $lastReservationCreate = $dateRecordedChanged['dateRecorded'];
            $lastReservationUpdate = $dateRecordedChanged['dateChanged'];

            if (empty($lastReservationCreate)) {
                $lastReservationCreateWarn = false;
            } elseif ($lastReservationCreate < $nowLess2wk) {
                $lastReservationCreateWarn = "error";
                $hasWarn = true;
            } elseif ($lastReservationCreate < $nowLess1wk) {
                $lastReservationCreateWarn = "warning";
                $hasWarn = true;
            } elseif (!empty($lastReservationCreate)) {
                $lastReservationCreateWarn = "success";
            }

            if (empty($lastReservationUpdate)) {
                $lastReservationUpdateWarn = false;
            } elseif ($lastReservationUpdate < $nowLess2wk) {
                $lastReservationUpdateWarn = "error";
                $hasWarn = true;
            } elseif ($lastReservationUpdate < $nowLess1wk) {
                $lastReservationUpdateWarn = "warning";
                $hasWarn = true;
            } elseif (!empty($lastReservationUpdate)) {
                $lastReservationUpdateWarn = "success";
            }

            $query = $this->em->createQueryBuilder();
            $lastApi = $query
                ->select(
                    [
                        "MAX(adApi.adApiTime) AS apiTime"
                    ]
                )
                ->from('Resrequest\DB\Enterprise\Entity\AdApi', 'adApi')
                ->where('adApi.adApiFunction = :acGetStock')
                ->setParameters(
                    [
                        'acGetStock' => 'ac_get_stock'
                    ]
                )
                ->getQuery()
                ->getOneOrNullResult();
            $lastApi = $lastApi['apiTime'];

            if (empty($lastApi)) {
                $lastApi = "";
            }

            if (empty($lastApi)) {
                $lastApiWarn = false;
            } elseif ($lastApi < $nowLess336hr && $lastApi > $nowLess6mt) {
                $lastApiWarn = "error";
                $hasWarn = true;
            } elseif ($lastApi < $nowLess168hr && $lastApi > $nowLess6mt) {
                $lastApiWarn = "warning";
                $hasWarn = true;
            } else {
                $lastApiWarn = "success";
            }
            
            $lastApiArray = array_pad(explode(" ",$lastApi),2,"");

            $query = $this->em->createQueryBuilder();
            $masterId = $query
                ->select(
                    [
                        "rfDatabase.rfDbCode AS dbCode"
                    ]
                )
                ->from('Resrequest\DB\Enterprise\Entity\RfSystem', 'rfSystem')
                ->innerJoin('Resrequest\DB\Enterprise\Entity\RfDatabase', 'rfDatabase', 'with', 'rfDatabase.rfDatabaseId = rfSystem.rfSysDbMasterId')
                ->getQuery()
                ->getOneOrNullResult();
            $masterId = $masterId['dbCode'];

            if (strtoupper($masterId[0]) == "W") {
                $master = "Web";
            } else {
                $master = "Offline";
            }
                    

            $results['DataTransfers'] = array(
                "environments"=>$environments,
                'lastReservationCreate'=>$lastReservationCreate,
                'lastReservationCreateWarn'=>$lastReservationCreateWarn,
                'lastReservationUpdate'=>$lastReservationUpdate,
                'lastReservationUpdateWarn'=>$lastReservationUpdateWarn,
                'lastApi'=>$lastApi,
                'lastApiDate'=>$lastApiArray[0],
                'lastApiTime'=>$lastApiArray[1],
                'lastApiWarn'=>$lastApiWarn,
                'hasWarn'=>$hasWarn,
                'master'=>$master
            );
        }

        return new ViewModel([
            'results' => $results
        ]);


    }
}
