<?php
namespace Resrequest\API\V1\Rpc\SystemScripts;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\ViewModel;

class SystemScriptsController extends AbstractActionController
{
    protected $em, $password;
    private $params;

    public function __construct($em, $enterprise)
    {
        $this->em = $em;
        $this->password = $enterprise->passwords['systemscripts'];
        $this->shortName = $enterprise->config['shortName'];
        $this->principalId = $enterprise->config['principalId'];
        $this->databaseName = $enterprise->config['databaseName'];
        $this->environment = $enterprise->config['environment'];
        $this->archive = $enterprise->config['archive'];
        $this->codeVersion = $enterprise->config['codeVersion'];
    }

    public function systemScriptsAction()
    {
        $this->params = $this->bodyParams();

        $username = false;
        $identity = $this->getIdentity();
        if ($identity instanceof \ZF\MvcAuth\Identity\AuthenticatedIdentity) {
            $username = $identity->getAuthenticationIdentity()['user_id'];
        }

        if (
            $username === false &&
            (!isset($this->params['securityHash']) || $this->params['securityHash'] !== $this->password)
        ) {
            return new ViewModel(['data' => '', 'error' => 'Invalid security hash', 'code' => 401]); // Unauthorized
        }

        if (!empty(trim($this->params['data']['script']))) {
			$scriptData = base64_decode($this->params['data']['script']);
			$scriptData = str_replace(array("\r", "\n", "\t"), " ", $scriptData);
			if (!empty($this->params['data']['params']) && is_array($this->params['data']['params'])) {
				foreach ($this->params['data']['params'] as $param => $value) {
					$scriptData = str_replace("{{" . $param . "}}", $value, $scriptData);
				}
			}

			$results = array();
			$scripts = explode(";", $scriptData);
			foreach ($scripts as $key => $script) {
				if (empty(trim($script))) {
					continue;
				}
                $type = strtolower(substr(trim($script), 0, 6));
                if (!in_array($type, array("select", "insert", "update", "insert", "delete"))) {
                    continue;
                }

                $error = "";

                try {
                    $db = $this->em->getConnection();
                    $stmt = $db->prepare(trim($script));
                    $stmt->execute();
                }
                catch(DBALException $e){
                    $error = $e->getMessage();
                }    
                catch(\Exception $e){
                    $error = $e->getMessage();
                }

                $records = $stmt->rowCount();
                if ($error != '') {
                    $results[] = array(
                        array(
                            ucfirst($type) . " statement" => "An error occurred: " . $error
                        )
                    );
                    continue;
                }

				if ($type == "select") {
                    $results[] = $stmt->fetchAll();
                } else {
                    $results[] = array(
                        array(
                            ucfirst($type) . " statement" => $records . " record" . ($records == 1 ? '' : 's') . " " . $type . ($type == "insert" ? "ed" : "d")
                        )
                    );
                }                
			}
        }

        return new ViewModel([
            'result' => $results
        ]);


    }
}
