<?php
namespace Resrequest\API\V1\Rpc\WorkflowsDeleteWorkflow;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\JsonModel;

use Resrequest\DB\Enterprise\Entity\AwWorkflow;

class WorkflowsDeleteWorkflowController extends AbstractActionController
{
    protected $em;
    private $data, $params, $message, $status;
    private $awWorkflow;

    public function __construct($em) {
        $this->em = $em;
        $this->db = $this->em->getConnection();
        $this->data = [];
        $this->params = null;
        $this->message = "Workflow could not be deleted.";
        $this->status = "error";
        $this->awWorkflow = '\Resrequest\DB\Enterprise\Entity\AwWorkflow';
    }

    public function workflowsDeleteWorkflowAction()
    {
        $this->params = $this->bodyParams();

        if(!isset($this->params['awWorkflowId']) || $this->params['awWorkflowId'] == "") {
            return $this->response(["status" => "error", "message" => "Invalid workflow"]);
        }

        $awWorkflow = $this->em->find($this->awWorkflow, $this->params['awWorkflowId']);
        $this->status = "success";
        $this->message = "Workflow not found";
        if ($awWorkflow) {
          $this->em->remove($awWorkflow);
          $this->em->flush();
          $this->status = "success";
          $this->message = "Workflow deleted";
        }

        return $this->response(["message" => $this->message, "status" => $this->status]);
    }

    private function response($data) {
        return new JsonModel($data);
    }
}
