<?php
namespace Resrequest\API\V1\Rpc\WorkflowsEditWorkflow;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\JsonModel;
use DateTime;

use Resrequest\DB\Enterprise\Entity\AwWorkflow;

class WorkflowsEditWorkflowController extends AbstractActionController
{
    protected $em;
    private $db, $params, $status, $message, $data;

    public function __construct($em) {
      $this->em = $em;
      $this->db = $this->em->getConnection();
      $this->params = null;
      $this->status = "error";
      $this->message = "";
      $this->data = [];
      $this->awWorkflow = '\Resrequest\DB\Enterprise\Entity\AwWorkflow';
      $this->defaultTz = date("e");
    }

    public function workflowsEditWorkflowAction()
    {
        $this->params = $this->bodyParams();

        $awWorkflowId = $this->params['awWorkflowId'] ?? null;

        $awWorkflowName = $this->params['awWorkflowName'] ?? "";
        if(empty($awWorkflowName)) {
            return $this->response(["status" => "error", "message" => "Please fill in workflow name."]);
        }
        $awWorkflowDescription = $this->params['awWorkflowDescription'] ?? "";
        $awWorkflowTypeInd = $this->params['awWorkflowTypeInd'] ?? "";
        if((int)$awWorkflowTypeInd !== 0 && empty($awWorkflowTypeInd)) {
            return $this->response(["status" => "error", "message" => "Please fill in workflow type."]);
        }
        if(!in_array((int)$awWorkflowTypeInd, [AwWorkflow::AW_WORKFLOW_TYPE_GUEST_CHECKIN_REMINDER, AwWorkflow::AW_WORKFLOW_TYPE_PROV_EXPIRY_REMINDER, AwWorkflow::AW_WORKFLOW_TYPE_PAYMENTS_DUE])) {
            return $this->response(["status" => "error", "message" => "Workflow type not recognised."]);
        }
        $awWorkflowInactiveYn = (int)$this->params['awWorkflowInactiveYn'] === 1 ? $this->params['awWorkflowInactiveYn'] : '0';
        $awWorkflowBeforeAfterInd = $this->params['awWorkflowBeforeAfterInd'] ?? "";
        if((int)$awWorkflowBeforeAfterInd !== 0 && empty($awWorkflowBeforeAfterInd)) {
            return $this->response(["status" => "error", "message" => "Please fill in workflow before or after indicator."]);
        }
        if(!in_array((int)$awWorkflowBeforeAfterInd, [
          AwWorkflow::AW_WORKFLOW_BEFORE,
          AwWorkflow::AW_WORKFLOW_AFTER,
        ])) {
            return $this->response(["status" => "error", "message" => "Workflow before/after not recognised."]);
        }
        $awWorkflowTriggerId = $this->params['awWorkflowTriggerId'] ?? "";
        $awWorkflowTime = $this->params['awWorkflowTime'] ?? "00:00";
        $awWorkflowTimeTz = $this->params['awWorkflowTimeTz'] ?? $this->defaultTz;

        $awWorkflowConfig = $this->params['awWorkflowConfig'];

        if (
            (int)$awWorkflowTypeInd == AwWorkflow::AW_WORKFLOW_TYPE_PROV_EXPIRY_REMINDER
            || (int)$awWorkflowTypeInd == AwWorkflow::AW_WORKFLOW_TYPE_PAYMENTS_DUE
        ) {
            $awWorkflowBeforeAfterInd = 0;
            $awWorkflowTriggerId = 5;
            $awWorkflowScheduleDays = 0;
        } else {
            $awWorkflowScheduleDays = $this->params['awWorkflowScheduleDays'] ?? "";
            if(empty($awWorkflowScheduleDays)) {
                return $this->response(["status" => "error", "message" => "Please fill in workflow scheduled days."]);
            }
            if(empty($awWorkflowTime)) {
                return $this->response(["status" => "error", "message" => "Please fill in workflow timezone."]);
            }
            if(empty($awWorkflowTime)) {
                return $this->response(["status" => "error", "message" => "Please fill in workflow time."]);
            }
            if(empty($awWorkflowTriggerId)) {
                return $this->response(["status" => "error", "message" => "Please fill in workflow trigger id."]);
            }
        }

        $prUserId = isset($_SESSION['userid']) ? $_SESSION['userid'] : null;

        try {
            // Disable foreign key checks
            $this->em->getConnection()->executeQuery('SET FOREIGN_KEY_CHECKS=0;');

            $awWorkflow = $this->em->find($this->awWorkflow, $this->params['awWorkflowId']);

            if(!isset($awWorkflow)) {
                return $this->response(["status" => "error", "message" => "The workflow could not be found"]);
            }

            $awWorkflow->setAwWorkflowName($awWorkflowName)
                ->setAwWorkflowDescription($awWorkflowDescription)
                ->setAwWorkflowTypeInd($awWorkflowTypeInd)
                ->setAwWorkflowInactiveYn($awWorkflowInactiveYn)
                ->setAwWorkflowScheduleDays($awWorkflowScheduleDays)
                ->setAwWorkflowBeforeAfterInd($awWorkflowBeforeAfterInd)
                ->setAwWorkflowTriggerId($awWorkflowTriggerId)
                ->setAwWorkflowConfig($awWorkflowConfig)
                ->setAwWorkflowTime($awWorkflowTime)
                ->setAwWorkflowTimeTz($awWorkflowTimeTz)
                ->setAdModifyUserId($prUserId)
                ->setAdModifyDate(new \DateTime())
                ->setAdModifyDateTz(date("e"));
            $this->em->persist($awWorkflow);
            $this->em->flush();

            // Re-enable foreign key checks
            $this->em->getConnection()->executeQuery('SET FOREIGN_KEY_CHECKS=1;');
        }
        catch (\Exception $e) {
            // Re-enable FK checks here too, to ensure they're not left disabled if an error occurs
            $this->em->getConnection()->executeQuery('SET FOREIGN_KEY_CHECKS=1;');

            return $this->response(['status' => 'error', 'message' => 'An error occurred while updating the workflow.']);
        }

        return $this->response(["message" => "Workflow successfully updated.", "status" => "success"]);
    }

    private function response($data) {
        return new JsonModel($data);
    }
}
