<?php
namespace Resrequest\API\V1\Rpc\WorkflowsGetWorkflow;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ApiProblem\ApiProblemResponse;
use ZF\ApiProblem\ApiProblem;
use ZF\ContentNegotiation\JsonModel;

use Resrequest\DB\Enterprise\Entity\AwWorkflow;

class WorkflowsGetWorkflowController extends AbstractActionController
{
    protected $em;
    private $db, $params, $status, $message, $data;
    protected $enterprise;
    protected $authoriseService;

    public function __construct($em, $enterprise, $authoriseService) {
        $this->em = $em;
        $this->db = $this->em->getConnection();
        $this->params = null;
        $this->status = "error";
        $this->message = "";
        $this->data = [];
        $this->enterprise = $enterprise;
        $this->authoriseService = $authoriseService;
    }

    public function workflowsGetWorkflowAction()
    {
        $this->params = $this->bodyParams();

        $awWorkflowId = $this->params['awWorkflowId'] ?? null;
        $canEdit = true;

        $dbCode = $this->enterprise->config['environment'];
        if (strtoupper($dbCode[0]) != "W" && strtoupper($dbCode[0]) != "R") {
          $canEdit = false;
        }

        $query = $this->em->createQueryBuilder();
        $masterDbCode = $query
            ->select(
                [
                    "rfDatabase.rfDbCode AS dbCode"
                ]
            )
            ->from('Resrequest\DB\Enterprise\Entity\RfSystem', 'rfSystem')
            ->innerJoin('Resrequest\DB\Enterprise\Entity\RfDatabase', 'rfDatabase', 'with', 'rfDatabase.rfDatabaseId = rfSystem.rfSysDbMasterId')
            ->getQuery()
            ->getOneOrNullResult();
        $masterDbCode = $masterDbCode['dbCode'];
        if ($dbCode != $masterDbCode) {
          $canEdit = false;
        }        

        $functionAccess = $this->authoriseService->getAccess([
            'functions'=>[6002]
        ]);

        if(!isset($functionAccess['functions'][6002]) || $functionAccess['functions'][6002] < 4) {
          return new ApiProblemResponse(
              new ApiProblem(403, "Access denied")
          );
        }

        if ($functionAccess['functions'][6002] <= 5) {
          $canEdit = false;
        }

        $awWorkflowTriggers = require_once(__DIR__ . '/../../../../../../../Application/src/Resrequest/legacy/data.awftriggers.php');

        $sql = "
          SELECT 
            aw_workflow.aw_workflow_ix,
            aw_workflow.aw_workflow_db,
            aw_workflow.aw_workflow_name,
            aw_workflow.aw_workflow_description,
            aw_workflow.aw_workflow_type_ind,
            aw_workflow.aw_workflow_inactive_yn,
            aw_workflow.aw_workflow_schedule_days,
            aw_workflow.aw_workflow_config,
            aw_workflow.aw_workflow_before_after_ind,
            aw_workflow.aw_workflow_trigger_id,
            aw_workflow.aw_workflow_time,
            aw_workflow.aw_workflow_time_tz,
            aw_workflow.aw_workflow_last_run_timestamp,
            aw_workflow.aw_workflow_last_run_timestamp_tz,
            aw_workflow.ad_create_date,
            aw_workflow.ad_create_date_tz,
            aw_workflow.ad_create_user_id
          FROM  
            aw_workflow
        ";
        if ($awWorkflowId) {
          $sql .= "
            WHERE 
                aw_workflow.aw_workflow_ix = '".$awWorkflowId."'";
        }
        $awWorkflows = $this->db->fetchAll($sql);

        $sources = $this->db->fetchAll("
          SELECT
              rf_source_ix as id,
              rf_source_desc as name
            FROM
              rf_source"
        );

        foreach ($awWorkflows as $awWorkflow) {
          $this->data[] = [
              'awWorkflowId' => $awWorkflow['aw_workflow_ix'],
              'awWorkflowDb' => $awWorkflow['aw_workflow_db'],
              'awWorkflowName' => $awWorkflow['aw_workflow_name'],
              'awWorkflowDescription' => $awWorkflow['aw_workflow_description'],
              'awWorkflowTypeInd' => $awWorkflow['aw_workflow_type_ind'],
              'awWorkflowTypeIndDescription' => AwWorkflow::getWorkflowTypeDescription($awWorkflow['aw_workflow_type_ind']),
              'awWorkflowInactiveYn' => $awWorkflow['aw_workflow_inactive_yn'],
              'awWorkflowScheduleDays' => $awWorkflow['aw_workflow_schedule_days'],
              'awWorkflowConfig' => json_decode($awWorkflow['aw_workflow_config'], true),
              'awWorkflowBeforeAfterInd' => $awWorkflow['aw_workflow_before_after_ind'],
              'awWorkflowBeforeAfterIndDescription' => AwWorkflow::getWorkflowBeforeAfterDescription($awWorkflow['aw_workflow_before_after_ind']),
              'awWorkflowTriggerId' => $awWorkflow['aw_workflow_trigger_id'],
              'awWorkflowTriggerName' => $awWorkflowTriggers[$awWorkflow['aw_workflow_trigger_id']]['awWorkflowTriggerName'],
              'awWorkflowTime' => $awWorkflow['aw_workflow_time'],
              'awWorkflowTimeTz' => $awWorkflow['aw_workflow_time_tz'],
              'awWorkflowLastRun' => $awWorkflow['aw_workflow_last_run_timestamp'],
              'awWorkflowLastRunTz' => $awWorkflow['aw_workflow_last_run_timestamp_tz'],
              'adCreateDate' => $awWorkflow['ad_create_date'],
              'adCreateDateTz' => $awWorkflow['ad_create_date_tz'],
              'adCreateUserId' => $awWorkflow['ad_create_user_id'],
              'canEdit' => $canEdit,
              'sources' => $sources,
          ];
        }
        $this->status = "success";
        $this->message = "Workflow(s) found";

        return $this->response(["status" => $this->status, "message" => $this->message, "data" => $this->data]);
    }

    private function response($data) {
        return new JsonModel($data);
    }
}
