<?php
namespace Resrequest\API\V1\Rpc\WorkflowsGetWorkflowTrigger;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\JsonModel;
use Resrequest\DB\Enterprise\Entity\AwWorkflowTrigger;

class WorkflowsGetWorkflowTriggerController extends AbstractActionController
{
    protected $em;
    private $db, $params, $status, $message, $data;

    public function __construct($em) {
        $this->em = $em;
        $this->db = $this->em->getConnection();
        $this->params = null;
        $this->status = "error";
        $this->message = "";
        $this->data = [];
    }

    public function workflowsGetWorkflowTriggerAction()
    {
        $this->params = $this->bodyParams();

        $awWorkflowTriggerId = $this->params['awWorkflowTriggerId'] ?? null;

        $awWorkflowTriggers = require_once(__DIR__ . '/../../../../../../../Application/src/Resrequest/legacy/data.awftriggers.php');

        foreach ($awWorkflowTriggers as $awWorkflowTrigger) {
            if (
                (
                    $awWorkflowTriggerId
                    && $awWorkflowTrigger['aw_workflow_trigger_id'] == $awWorkflowTriggerId
                )
                || !$awWorkflowTriggerId
            ) {
                $this->data[] = $awWorkflowTrigger;
            }
        }
        $this->status = "success";
        $this->message = "Workflow trigger(s) found";

        return $this->response(["status" => $this->status, "message" => $this->message, "data" => $this->data]);
    }

    private function response($data) {
        return new JsonModel($data);
    }
}
