<?php
namespace Resrequest\API\V1\Rpc\WorkflowsRunWorkflow;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\JsonModel;
use Resrequest\Application\Workflow\Workflow;
use Resrequest\Application\Reminder\Reminder;

define('WORKFLOWS_RUN_SERVER' , dirname(dirname(dirname(dirname(dirname(dirname(dirname(dirname(__FILE__))))))))); //Go back 5 directories
define('WORKFLOWS_RUN_ROOT', WORKFLOWS_RUN_SERVER. '/Application/src/Resrequest/legacy');
require_once(WORKFLOWS_RUN_ROOT . '/class.form.php');
require_once(WORKFLOWS_RUN_ROOT . '/class.mysqldb.php');
require_once(WORKFLOWS_RUN_ROOT . '/class.mysqlfield.php');
require_once(WORKFLOWS_RUN_ROOT . '/class.mysqltable.php');
require_once(WORKFLOWS_RUN_ROOT . '/functions.template.php');
require_once(WORKFLOWS_RUN_ROOT . '/functions.cache.php');
require_once(WORKFLOWS_RUN_ROOT . '/functions.system.php');
require_once(WORKFLOWS_RUN_ROOT . '/functions.php');
require_once(WORKFLOWS_RUN_ROOT . '/functions.reservation.php');
require_once(WORKFLOWS_RUN_ROOT . '/inc.setup.php');
require_once(WORKFLOWS_RUN_ROOT . '/ac_logon.php');
require_once(WORKFLOWS_RUN_ROOT . '/inc.globalarrays.php');
require_once(WORKFLOWS_RUN_ROOT . '/functions.mail.php');
require_once(WORKFLOWS_RUN_ROOT . '/class.audit.php');

class WorkflowsRunWorkflowController extends AbstractActionController
{
  protected $em;
  private $data, $params, $db, $username, $message, $status;
  private $dbService;

  public function __construct($em, $dbService) {
    $this->em = $em;
    $this->db = $this->em->getConnection();
    $this->data = [];
    $this->params = null;
    $this->username = null;
    $this->message = "";
    $this->lastIdSql = "SELECT @last_insert_id;";
    $this->status = "error";
    $this->dbService = $dbService;
  }

  public function workflowsRunWorkflowAction()
  {
    $host = $_SERVER['SERVER_NAME'];
    $workflow = new Workflow($this->dbService, $host, $GLOBALS['dbName']);
    $params = $this->bodyParams();
    $run = $workflow->run($params['awWorkflowId']);


    $reminder = new Reminder($this->dbService, $host, $GLOBALS['dbName'], true);
    $reminder->send();

    return $run;
  }

  private function response($data) {
    return new JsonModel($data);
  }
}
