<?php
/**
 * Zend Framework (http://framework.zend.com/)
 *
 * @link      http://github.com/zendframework/ZendSkeletonApplication for the canonical source repository
 * @copyright Copyright (c) 2005-2015 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

namespace Resrequest\Application;

use Resrequest\Application\Chart\ChartBuilder;
use Resrequest\Application\Chart\ChartContainer;
use Resrequest\Application\Chart\ChartFactory;

class Module
{
	public function getConfig()
	{
		return include __DIR__ . '/config/module.config.php';
	}

	public function getAutoloaderConfig()
	{
		return array(
			'Zend\Loader\StandardAutoloader' => array(
				'namespaces' => array(
					__NAMESPACE__ => __DIR__ . '/src/' . str_replace("\\", "/", __NAMESPACE__),
				),
			),
		);
	}

	public function getServiceConfig() {
		return array(
			'factories' => array(
				'Resrequest\Application\Chart\ChartBuilder' => function($sm) {
					$enterprise = $sm->get('Resrequest\Setup\Service\Enterprise');
					$em = $sm->get('EnterpriseEntityManager');
					
					$chartFactory = new ChartFactory;

					return new ChartBuilder($enterprise, $em, $chartFactory);
				},
				'Resrequest\Application\Chart\ChartContainer' => function($sm) {
					$enterprise = $sm->get('Resrequest\Setup\Service\Enterprise');
					$em = $sm->get('EnterpriseEntityManager');
					$chartBuilder = $sm->get('Resrequest\Application\Chart\ChartBuilder');
					
					return new ChartContainer($enterprise, $em, $chartBuilder);
				},
			),
		);
	}
}
