<?php
/**
 * Zend Framework (http://framework.zend.com/)
 *
 * @link      http://github.com/zendframework/ZendSkeletonApplication for the canonical source repository
 * @copyright Copyright (c) 2005-2015 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

return array(
	'legacy_folder' => '/module/Resrequest/Application/src/Resrequest/legacy', // Everything is relative to the application path in ZF2
	'router' => array(
		'routes' => array(
			'home' => array(
				'type' => 'Zend\Mvc\Router\Http\Literal',
				'options' => array(
					'route'    => '/',
					'defaults' => array(
						'controller' => 'Resrequest\Application\Controller\Index',
						'action'     => 'index',
					),
				),
			),
			'application' => array(
				'type' => 'Zend\Mvc\Router\Http\Literal',
				'options' => array(
					'route'    => '/application',
					'defaults' => array(
						'__NAMESPACE__' => 'Resrequest\Application\Controller',
						'controller'    => 'Index',
						'action'        => 'index',
					),
				),
				'may_terminate' => true,
				'child_routes' => array(
					'default' => array(
						'type'    => 'Segment',
						'options' => array(
							'route'    => '/[:controller[/:action]]',
							'constraints' => array(
								'controller' => '[a-zA-Z][a-zA-Z0-9_-]*',
								'action'     => '[a-zA-Z][a-zA-Z0-9_-]*',
							),
							'defaults' => array(
							),
						),
					),
				),
			),
			'reservation.php' => array(
				'type' => 'Zend\Mvc\Router\Http\Segment',
				'options' => array(
					'route'    => '/:script',
					'defaults' => array(
						'controller' => 'MaglLegacyApplication\Controller\Legacy',
						'action'     => 'index',
					),
					'constraints' => array(
						'script' => '\breservation.php\b',
					),
				),
				'priority' => 2,
			),
			'api' => array(
				'type' => 'Zend\Mvc\Router\Http\Regex',
				'options' => array(
					'regex'    => '/(?<path>\bapi\b.*/)',
					'defaults' => array(
						'controller' => 'MaglLegacyApplication\Controller\Legacy',
						'action'     => 'index',
					),
					'spec' => '/[:path]',
				),
				'priority' => 2
				,
			),
			'legacy' => array(
				'type' => 'Zend\Mvc\Router\Http\Regex',
				'options' => array(
					'regex'    => '(?<script>.+\.php)|/',
					'defaults' => array(
						'controller' => 'MaglLegacyApplication\Controller\Legacy',
						'action'     => 'index',
						'script'     => 'index.php',
					),
					'spec' => '/[:script]',
				),
			),
			/* Other utilities either in the 'utils' directory or the rr api */
			'utils' => array(
				'type' => 'Zend\Mvc\Router\Http\Regex',
				'options' => array(
					'regex'    => '/(?<script>\butils\b.*/.+\.php)|(?<path>\butils\b.*/)',
					'defaults' => array(
						'controller' => 'MaglLegacyApplication\Controller\Legacy',
						'action'     => 'index',
					),
					'spec' => '/[:path][:script]',
				),
				'priority' => 2,
			),
		),
	),
	'magl_legacy_application' => array(
		'doc_root' => array(
			'module/Resrequest/Application/src/Resrequest/legacy',
		), // the legacy apps DOCUMENT_ROOT (can be more than one) for including files
		'index_files' => array("index.php","index.htm","index.html"),
		'globals' => array(
			'get' => true, // should $_GET be filled with variables from route match?
			'request' => true, // should $_GET be filled with variables from route match?
		),
	),
	'service_manager' => array(
		'abstract_factories' => array(
			'Zend\Cache\Service\StorageCacheAbstractServiceFactory',
			'Zend\Log\LoggerAbstractServiceFactory',
		),
		'factories' => array(
			'translator' => 'Zend\Mvc\Service\TranslatorServiceFactory',
		),
	),
	'translator' => array(
		'locale' => 'en_US',
		'translation_file_patterns' => array(
			array(
				'type'     => 'gettext',
				'base_dir' => __DIR__ . '/../language',
				'pattern'  => '%s.mo',
			),
		),
	),
	'controllers' => array(
		'invokables' => array(
			'Resrequest\Application\Controller\Index' => 'Resrequest\Application\Controller\IndexController',
		),
	),
	'view_manager' => array(
		'display_not_found_reason' => true,
		'display_exceptions'       => true,
		'doctype'                  => 'HTML5',
		'not_found_template'       => 'error/404',
		'exception_template'       => 'error/index',
		'template_map' => array(
			'layout/layout'           => __DIR__ . '/../view/layout/application/layout.phtml',
			'resrequest/application/index/index' => __DIR__ . '/../view/application/index/index.phtml',
			'error/404'               => __DIR__ . '/../view/error/404.phtml',
			'error/index'             => __DIR__ . '/../view/error/index.phtml',
		),
		'controller_map' => array(
			'Resrequest\Application' => true,
		),
		'template_path_stack' => array(
			__DIR__ . '/../view',
		),
	),
);
