/*
 * UIkit sets the height of images to auto. Images that specify their
 * style height easily override this. However if those images have their
 * height specified as an attribute instead, then the UIkit auto height
 * overrides it. This javascript file restores those heights as styles
 * which then override the UIkit height.
 */
$('img').each(function(key, img) {
    if (img.hasAttribute('height')) {
        img.style.height = img.getAttribute('height');
    }
});