// Chart variables
var agentActivityChart;
var bedNightActivityChart;
var salesPerEmployeePerWeekdayChart;
var dialChart;
var bookingsByStatusChart
var bookingsByNationalityChart;
var bookingRevenueYieldChart;

function loadCharts() {
    callApi({
        type: "POST",
        url: chartApiUrl,
        data: JSON.stringify({
            "contactId": pr_persona_id,
            "chartRequest": {
                "agentActivity": 'thisYear',
                "dial": 'thisYear',
                "bedNightActivity": 'thisYearAndLastYear',
                "salesPerEmployeePerWeekday": 'thisMonth',
                "bookingsByStatus": 'thisYear',
                "bookingsByNationality": 'thisYear',
                "cards": 'thisYear',
            }
        }),
        success: function (data) {
            agentActivityChart = new FusionCharts({
                type: "scrollcombidy2d",
                renderAt: "agent-activity-chart",
                width: "100%",
                height: "100%",
                dataFormat: "json",
                dataSource: data.agentActivityChart
            }).render();

            if (data.agentActivityChart.dataset === false) {
                $('#agent-activity-chart').hide();
                $('#agent-activity-chart-no-data').show();
            }


            bedNightActivityChart = new FusionCharts({
                type: "scrollline2d",
                renderAt: "bed-night-activity-chart",
                width: "768",
                height: "400",
                dataFormat: "json",
                dataSource: data.bedNightActivityChart
            }).render();

            if (data.bedNightActivityChart.dataset === false) {
                $('#bed-night-activity-chart').hide();
                $('#bed-night-activity-chart-no-data').show();
            }


            salesPerEmployeePerWeekdayChart = new FusionCharts({
                type: "heatmap",
                renderAt: "bookings-per-employee-per-weekday-chart",
                width: "331",
                height: "400",
                dataFormat: "json",
                dataSource: data.salesPerEmployeePerWeekdayChart
            }).render();

            if (data.salesPerEmployeePerWeekdayChart.dataset === false) {
                $('#bookings-per-employee-per-weekday-chart').hide();
                $('#bookings-per-employee-per-weekday-chart-no-data').show();
            }


            dialChart = new FusionCharts({
                type: "angulargauge",
                renderAt: "dial-chart",
                width: "430",
                height: "280",
                dataFormat: "json",
                dataSource: data.dialChart
            }).render();


            bookingsByStatusChart = new FusionCharts({
                type: "doughnut2d",
                renderAt: "bookings-by-status-chart",
                width: "384",
                height: "350",
                dataFormat: "json",
                dataSource: data.bookingsByStatusChart
            }).render();

            if (data.bookingsByStatusChart.data === false) {
                $('#bookings-by-status-chart').hide();
                $('#bookings-by-status-chart-no-data').show();
            }


            bookingsByNationalityChart = new FusionCharts({
                type: "doughnut2d",
                renderAt: "bookings-by-nationality-chart",
                width: "384",
                height: "350",
                dataFormat: "json",
                dataSource: data.bookingsByNationalityChart
            }).render();

            if (data.bookingsByNationalityChart.data === false) {
                $('#bookings-by-nationality-chart').hide();
                $('#bookings-by-nationality-chart-no-data').show();
            }

            setCardsData(data.cards);
            setupDatePickers(data.dateOptions)

            loadRevenueAndYieldChart();

            // Remove loading overlay and spinner
            $('#overview-loader').fadeOut(1200);
            $('#overview-overlay').fadeOut(1200);
        }
    });
}

function setupDatePickers(dateOptions) {
    $('.thisWeek').html('This week (' + dateOptions.thisWeek.startDate + ' to ' + dateOptions.thisWeek.endDate + ')');
    $('.thisMonth').html('This month (' + dateOptions.thisMonth.startDate + ' to ' + dateOptions.thisMonth.endDate + ')');
    $('.thisQuarter').html('This quarter (' + dateOptions.thisQuarter.startDate + ' to ' + dateOptions.thisQuarter.endDate + ')');
    $('.thisYear').html('This year (' + dateOptions.thisYear.startDate + ' to ' + dateOptions.thisYear.endDate + ')');
    $('.thisYearAndLastYear').html('This year & last year');

    $(".chart-datepicker").change(function (event) {
        $(this).prop('disabled', true);
        reloadCharts($(this).attr('id'), $(this).val())
    });
}

function loadRevenueAndYieldChart() {
    if (agentOverviewLevel === 15) {
        $('#group-5-loader').css('display', 'flex');
        $('#group-5-overlay').css('display', 'flex');
        // Hide booking revenue yield chart
        bookingRevenueYieldChart = new FusionCharts({
            type: "scrollCombiDY2D",
            renderAt: "booking-revenue-yield-chart",
            width: "768",
            height: "350",
            dataFormat: "json",
            dataSource: null
        }).render();

        callApi({
            type: "POST",
            url: chartApiUrl,
            data: JSON.stringify({
                "contactId": pr_persona_id,
                "chartRequest": {
                    "bookingRevenueYield": ''
                }
            }),
            success: function (data) {
                bookingRevenueYieldChart.setJSONData(data.bookingRevenueYieldChart);
                if (!data.bookingRevenueYieldChart) {
                    $('#booking-revenue-yield-chart').hide();
                    $('#booking-revenue-yield-chart-no-data').show();
                }

                $('#group-5-loader').fadeOut(500);
                $('#group-5-overlay').fadeOut(500);
            }
        });
    } else {
        let bookingRevenueYield = document.getElementById('booking-revenue-yield-container');
        bookingRevenueYield.parentNode.removeChild(bookingRevenueYield);
    }
}

function reloadCharts(chartGroup, dateOption) {
    if (chartGroup == 'group-1-datepicker') {
        $('#group-1-loader').css('display', 'flex');
        $('#group-1-overlay').css('display', 'flex');

        $('#group-3-loader').css('display', 'flex');
        $('#group-3-overlay').css('display', 'flex');

        callApi({
            type: "POST",
            url: chartApiUrl,
            data: JSON.stringify({
                "contactId": pr_persona_id,
                "chartRequest": {
                    "dial": dateOption,
                    "cards": dateOption,
                    "bookingsByStatus": dateOption,
                    "bookingsByNationality": dateOption,
                }
            })
        }).then(function (data) {
            dialChart.setJSONData(data.dialChart);
            setCardsData(data.cards);

            if (data.bookingsByStatusChart.data === false) {
                $('#bookings-by-status-chart').hide();
                $('#bookings-by-status-chart-no-data').show();
            } else {
                $('#bookings-by-status-chart').show();
                $('#bookings-by-status-chart-no-data').hide();
                bookingsByStatusChart.setJSONData(data.bookingsByStatusChart);
            }

            if (data.bookingsByNationalityChart.data === false) {
                $('#bookings-by-nationality-chart').hide();
                $('#bookings-by-nationality-chart-no-data').show();
            } else {
                $('#bookings-by-nationality-chart').show();
                $('#bookings-by-nationality-chart-no-data').hide();
                bookingsByNationalityChart.setJSONData(data.bookingsByNationalityChart);
            }

            $('#group-1-loader').fadeOut(500);
            $('#group-1-overlay').fadeOut(500);
            $('#group-1-datepicker').prop('disabled', false);

            $('#group-3-loader').fadeOut(500);
            $('#group-3-overlay').fadeOut(500);
            $('#group-3-datepicker').prop('disabled', false);
        });
    } else if (chartGroup == 'group-2-datepicker') {
        callApi({
            type: "POST",
            url: chartApiUrl,
            data: JSON.stringify({
                "contactId": pr_persona_id,
                "chartRequest": {
                    "agentActivity": dateOption
                }
            }),
            success: function (data) {
                agentActivityChart.setJSONData(data.agentActivityChart);
            }
        });
    } else if (chartGroup == 'group-4-datepicker') {
        callApi({
            type: "POST",
            url: chartApiUrl,
            data: JSON.stringify({
                "contactId": pr_persona_id,
                "chartRequest": {
                    "bedNightActivity": dateOption
                }
            }),
            success: function (data) {
                bedNightActivityChart.setJSONData(data.bedNightActivityChart);
            }
        });
    } else if (chartGroup == 'group-5') {

    }
}

function setCardsData(cards) {
    $('#bookings-created-card-value').html(cards.bookingsCreatedCard.value);
    $('#bookings-created-card-value-title').html(cards.bookingsCreatedCard.valueTitle);
    $('#bookings-created-card-compare-value-title').html(cards.bookingsCreatedCard.compareValueTitle);

    // Set values of confirmed bookings card
    $('#confirmed-bookings-card-value').html(cards.confirmedBookingsCard.value);
    $('#confirmed-bookings-card-value-title').html(cards.confirmedBookingsCard.valueTitle);
    $('#confirmed-bookings-card-compare-value-title').html(cards.confirmedBookingsCard.compareValueTitle);

    // Set values of cancelled bookings card
    $('#cancelled-bookings-card-value').html(cards.cancelledBookingsCard.value);
    $('#cancelled-bookings-card-value-title').html(cards.cancelledBookingsCard.valueTitle);
    $('#cancelled-bookings-card-compare-value-title').html(cards.cancelledBookingsCard.compareValueTitle);

    if (cards.bookingsCreatedCard.value - cards.bookingsCreatedCard.compareValue > 0) {
        $('#bookings-created-card-compare-value').html(cards.bookingsCreatedCard.compareValue);

        if (cards.bookingsCreatedCard.compareValuePercentage === false) {
            $('#bookings-created-card-compare-value-percentage').html('-');
            $('#bookings-created-card-compare-value-percentage').css('color', '#000000');
        } else {
            $('#bookings-created-card-compare-value-percentage').html('+' + cards.bookingsCreatedCard.compareValuePercentage + '%');
            $('#bookings-created-card-compare-value-percentage').css('color', '#4674dd');
        }

        $('#bookings-created-card-trend-icon').html('trending_up').css('color', '#4674dd');
    } else if (cards.bookingsCreatedCard.value - cards.bookingsCreatedCard.compareValue < 0) {
        $('#bookings-created-card-compare-value').html(cards.bookingsCreatedCard.compareValue);

        if (cards.bookingsCreatedCard.compareValuePercentage === false) {
            $('#bookings-created-card-compare-value-percentage').html('-');
            $('#bookings-created-card-compare-value-percentage').css('color', '#000000');
        } else {
            $('#bookings-created-card-compare-value-percentage').css('color', '#ff333a');
            $('#bookings-created-card-compare-value-percentage').html(cards.bookingsCreatedCard.compareValuePercentage + '%');
        }

        $('#bookings-created-card-trend-icon').html('trending_down').css('color', '#ff333a');
    } else {
        $('#bookings-created-card-compare-value').html(cards.bookingsCreatedCard.compareValue);
        $('#bookings-created-card-compare-value-percentage').html('-');
        $('#bookings-created-card-compare-value-percentage').css('color', '#000000');
    }

    if (cards.cancelledBookingsCard.value - cards.cancelledBookingsCard.compareValue > 0) {
        $('#cancelled-bookings-card-compare-value').html(cards.cancelledBookingsCard.compareValue);

        if (cards.cancelledBookingsCard.compareValuePercentage === false) {
            $('#cancelled-bookings-card-compare-value-percentage').html('-');
            $('#cancelled-bookings-card-compare-value-percentage').css('color', '#000000');
        } else {
            $('#cancelled-bookings-card-compare-value-percentage').html('+' + cards.cancelledBookingsCard.compareValuePercentage + '%');
            $('#cancelled-bookings-card-compare-value-percentage').css('color', '#4674dd');
        }

        $('#cancelled-bookings-card-trend-icon').html('trending_up').css('color', '#4674dd');
    } else if (cards.cancelledBookingsCard.value - cards.cancelledBookingsCard.compareValue < 0) {
        $('#cancelled-bookings-card-compare-value').html(cards.cancelledBookingsCard.compareValue);

        if (cards.cancelledBookingsCard.compareValuePercentage === false) {
            $('#cancelled-bookings-card-compare-value-percentage').html('-');
            $('#cancelled-bookings-card-compare-value-percentage').css('color', '#000000');
        } else {
            $('#cancelled-bookings-card-compare-value-percentage').html(cards.cancelledBookingsCard.compareValuePercentage + '%');
            $('#cancelled-bookings-card-compare-value-percentage').css('color', '#ff333a');
        }

        $('#cancelled-bookings-card-trend-icon').html('trending_down').css('color', '#ff333a');
    } else {
        $('#cancelled-bookings-card-compare-value').html(cards.cancelledBookingsCard.compareValue);
        $('#cancelled-bookings-card-compare-value-percentage').html('-');
        $('#cancelled-bookings-card-compare-value-percentage').css('color', '#000000');
    }

    if (cards.confirmedBookingsCard.value - cards.confirmedBookingsCard.compareValue > 0) {
        $('#confirmed-bookings-card-compare-value').html(cards.confirmedBookingsCard.compareValue);

        if (cards.confirmedBookingsCard.compareValuePercentage === false) {
            $('#confirmed-bookings-card-compare-value-percentage').html('-');
            $('#confirmed-bookings-card-compare-value-percentage').css('color', '#000000');
        } else {
            $('#confirmed-bookings-card-compare-value-percentage').html('+' + cards.confirmedBookingsCard.compareValuePercentage + '%');
            $('#confirmed-bookings-card-compare-value-percentage').css('color', '#4674dd');
        }

        $('#confirmed-bookings-card-trend-icon').html('trending_up').css('color', '#4674dd');
    } else if (cards.confirmedBookingsCard.value - cards.confirmedBookingsCard.compareValue < 0) {
        $('#confirmed-bookings-card-compare-value').html(cards.confirmedBookingsCard.compareValue);

        if (cards.confirmedBookingsCard.compareValuePercentage === false) {
            $('#confirmed-bookings-card-compare-value-percentage').html('-');
            $('#confirmed-bookings-card-compare-value-percentage').css('color', '#000000');
        } else {
            $('#confirmed-bookings-card-compare-value-percentage').html(cards.confirmedBookingsCard.compareValuePercentage + '%');
            $('#confirmed-bookings-card-compare-value-percentage').css('color', '#ff333a');
        }

        $('#confirmed-bookings-card-trend-icon').html('trending_down').css('color', '#ff333a');
    } else {
        $('#confirmed-bookings-card-compare-value').html(cards.confirmedBookingsCard.compareValue);
        $('#confirmed-bookings-card-compare-value-percentage').html('-');
        $('#confirmed-bookings-card-compare-value-percentage').css('color', '#000000');
    }
}
