var aLastRequest;

function aRequestReset() {
	// NOP: kept to allow existing code to continue working
}

function aRequestCreate() {
	var aRequest;

	try {
		aRequest = new XMLHttpRequest();
	} catch (trymicrosoft) {
		try {
			aRequest = new ActiveXObject("Msxml2.XMLHTTP");
		} catch (othermicrosoft) {
			try {
				aRequest = new ActiveXObject("Microsoft.XMLHTTP");
			} catch (failed) {
				aRequest = false;
			}
		}
	}
	aLastRequest = aRequest;

	return aRequest;
}

function aRequestGet(aUrl, aChangeFunc) {
	var aRequest = aRequestCreate();

	aRequest.open("GET", aUrl, true);
	aRequest.onreadystatechange = function() {
		aRequestChange(aRequest,aChangeFunc);
	};
	aRequest.send(null);

	return aRequest;
}

function aRequestPost(aUrl, aChangeFunc, aNames, aValues) {
	var aRequest = aRequestCreate();
	var postList = "";
	var count = 0;

	if(!aUrl) {
		aUrl = window.location;
	}
	aRequest.open("POST", aUrl, true);
	aRequest.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
	aRequest.onreadystatechange = function() {
		aRequestChange(aRequest,aChangeFunc);
	};
	
	for(count = 0; count < aNames.length; count++) {
		if(postList != "") { postList += "&"; }
		postList += aNames[count] + "=" + encodeURIComponent(aValues[count]);
	}
	aRequest.send(postList);

	return aRequest;
}

function aRequestPostEx(aUrl, aData, aCallback) {
	let names = Object.keys(aData);
	let values = Object.values(aData);

	return aRequestPost(aUrl, (status, data) => {
		if(status) {
			try {
				data = JSON.parse(data);
			} catch (error) {
				data = false;
			}
			aCallback(data);
		}
	}, names, values);
}

function aRequestAbort(aRequest) {
	if(!aRequest) {
		aRequest = aLastRequest;
	}
	try {
		aRequest.abort();
	} catch (abortFailed) {
	}
}

function aRequestChange(aRequest,aChangeFunc) {
	var result = true;
	try {
		if (aRequest.readyState != 4) {
			result = false;
		} else {
			if (aRequest.status != 200) {
				result = false;
			}
		}
	} catch (changeFailed) {
		result = false;
	}
	if(result) {
		aChangeFunc(true,aRequest.responseText);
	} else {
		aChangeFunc(false);
	}

}
