this.BlockBookingDetails = function(validationMessage) {
	this.validationMessage = (typeof validationMessage != 'undefined') ? validationMessage : null;

	this.cookieButton = Get_Cookie("savePressedButton");
	this.pagemode = "";
	this.enabledButtons = [];
	this.impressedButtons = [];
	this.validator = new Validator();
	this.periodsDelete = null;
	this.periodsGenerateSeries = null;
	this.periodsCreateReservation = null;
	this.itinerariesDelete = null;
	this.defaultRowHeight = "23";
	this.lastRate = null;
	this.ddRateAll = false;
	this.ddRateElement = "";
	this.confirmRateSelect = null;
	this.confirmRateSelectLabel = null;
	this.allocationsGenerated = false;
	this.reservationsGenerated = false;
	this.periodExpandList = [];

	this.initialisePage = function() {
		var t = this;

		if (this.validationMessage != "" && this.validationMessage != null) {
			showMessage(this.validationMessage,"Validation Failure",500,500);
		}

		initTop();
		setOnChange();
		buttonPress = blockbookingdetails.buttonPress;
		agentNoteShow = blockbookingdetails.agentInfoToggle;
		rateDropdownHide = this.ddRateHide;
		rateDropdownSet = this.ddRateSet;
		rateDropdownToggle = this.ddRateToggle;
		updateForm = this.getAgentDefaultRate;
		validator = this.validator;

		var saveURL = Get_Cookie("saveURL"); // Get the menu item selected before we asked about saving
		if(saveURL != "" && saveURL != null) {
			Set_Cookie("saveURL",""); // Clear the saved menu option
			window.location = saveURL; // Go to the saved menu selection
		}

		var savePressedButton = Get_Cookie("savePressedButton");
		if(savePressedButton != "" && savePressedButton!= null) {
			Set_Cookie("savePressedButton","");
			buttonPressGeneric_continue(savePressedButton,false,"")
		}

		//"New","Open","Edit","Save","Delete","Previous","Next","Audit","Print","Copy","Paste","Calendar","Internet","Home","Help"
		this.pagemode = id("mode").value;
		switch (this.pagemode) {
			case "modeNew":
				this.enabledButtons = new Array("Save","Open","Back","Forward","Calendar","Internet","Home","Help","NewWindow");
				this.impressedButtons = new Array("New");
				Set_Cookie("cookieBlockBookingActionState","");
				break;
			case "modeEdit":
				var navi = "0";
				if($("form")[0].record.value == $("form")[0].recordnext.value) {
					this.enabledButtons = new Array("New","Open","Save","Previous","Back","Forward","Print","Calendar","Internet","Home","Help","NewWindow");
					this.impressedButtons = new Array("Edit");
				} else {
					navi++;
				}
				if ($("form")[0].record.value == $("form")[0].recordprev.value) {
					this.enabledButtons = new Array("Open","Save","Next","Back","Forward","Print","Calendar","Internet","Home","Help","NewWindow");
					this.impressedButtons = new Array("Edit");
				} else {
					navi++;
				}
				if (navi == "2") {
					this.enabledButtons = new Array("New","Open","Save","Next","Previous","Back","Forward","Print","Calendar","Internet","Home","Help","NewWindow");
					this.impressedButtons = new Array("Edit");
				}
				if (navi == "0") {
					this.enabledButtons = new Array("New","Open","Save","Back","Forward","Print","Calendar","Internet","Home","Help","NewWindow");
					this.impressedButtons = new Array("Edit");
				}
				var impressedList = new Array("Edit");
				Set_Cookie("cookieBlockBookingActionState","edit,"+blockBookingRecord);
				break;
			case "modeView":
				var navi = "0";
				if ($("form")[0].record.value == $("form")[0].recordnext.value) {
					this.enabledButtons = new Array("New","Open","Edit","Previous","Back","Forward","Calendar","Internet","Home","Help","NewWindow");
				} else {
					navi++;
				}
				if ($("form")[0].record.value == $("form")[0].recordprev.value) {
					this.enabledButtons = new Array("New","Open","Edit","Next","Back","Forward","Calendar","Internet","Home","Help","NewWindow");
				} else {
					navi++;
				}
				if (navi == "2") {
					this.enabledButtons = new Array("New","Open","Edit","Next","Previous","Back","Forward","Print","Calendar","Internet","Home","Help","NewWindow");
				}
				if (navi == "0") {
					this.enabledButtons = new Array("New","Open","Edit","Back","Forward","Print","Calendar","Internet","Home","Help","NewWindow");
				}
				Set_Cookie("cookieBlockBookingActionState","");
				break;
			default:
				Set_Cookie("cookieBlockBookingActionState","");
		}

		disableButtons();
		enableButtons(this.enabledButtons);
		impressButtons(this.impressedButtons);

		this.pageView(this.pagemode);
		this.lastRate = id("hidAgentDefaultRate").value;

		this.validator.validateAll();
		this.validator.addConstraints();

		this.toggleAll();
		// expand all the period rows that were edited
		for (var period in periodExpandList) {
			var periodId = periodExpandList[period];
			if (periodId != "" && periodId != null) {
				this.toggle(id("img_" + periodId));
			}
		}

		this.setOverbookings();

		this.bindEvents();

        $('.tooltip').not('.tooltipstered').tooltipster({
            theme: 'tooltipster-shadow',
            side: 'bottom',
            contentAsHTML: true
        });
	}

	/**
	 * bindEvents - bind the appropriate events to their triggers/elements
	 */
	this.bindEvents = function() {
		var t = this;
		/* Bind events start */
		// unbind all existing click events for #buttonDelete
		$('#buttonDelete').attr('onclick','').unbind('click');
		$('#buttonDelete').click(function() {
			t.buttonPress("Delete");
		});
		/* Block booking events */
		$('#agent_button').click(function() {
			t.popup("agent");
		});
		$('#agentPop').click(function() {
			t.popup("agentinfo");
		});
		$('#agentPop').mouseover(function() {
			overlib('Show agent information',BELOW,OFFSETY,17,OFFSETX,-135,WIDTH,130);
		});
		$('#agentPop').mouseout(function() {
			nd();
		});
		$('#agent_name, #contact_name').on('input', function() {
			t.validator.validateAll();
		});
		$('#contact_button').click(function() {
			t.popup("contact");
		});
		$('#btnContactInfo').click(function() {
			t.popup("contactinfo");
		});
		$('#btnContactInfo').mouseover(function() {
			overlib('Show contact information',BELOW,OFFSETY,17,OFFSETX,-135,WIDTH,130);
		});
		$('#btnContactInfo').mouseout(function() {
			nd();
		});
		/* Period events start */
		// Bind open new period dialog to "Add Period" button
		var dlgblockperiod = new dlgBlockPeriod(blockBookingRecord, "#btnPeriodAdd", "reservation.php?6009", "Add Block Period", 600, 650, "tblBlockBookingPeriods");
		dlgblockperiod.init();
		$("#txtPeriodSearch").tablesearch("tbyBlockPeriodRows");
		/* Period menu start */
		$("input[bl_block_period_ix][name='btnPeriodMenu']").each(function() {
			$(this).click(function(e) {
				var bl_block_period_ix = $(this).attr("bl_block_period_ix");
				t.periodShowMenu(e,bl_block_period_ix);
			});
		});
		$("#divPeriodMenu tr.imgLink").each(function() {
			$(this).mouseover(function() {
				$(this).addClass("colGreen");
			});
			$(this).mouseout(function() {
				$(this).removeClass("colGreen");
			});
		});
		$("#divPeriodMenu #menuPeriodView").click(function() {
			var bl_block_period_ix = $("#divPeriodMenu").attr("bl_block_period_ix");
			var periodDetails = $("#divBlockBookingPeriods").find("[bl_block_period_ix='"+ bl_block_period_ix +"']");
			var dlgblockperiod = new dlgBlockPeriod(blockBookingRecord, null, "reservation.php?6011+" + bl_block_period_ix, "Edit Block Period", 600, 650, "tblBlockBookingPeriods", bl_block_period_ix,periodDetails );
			dlgblockperiod.init();
		});
		$("#divPeriodMenu #menuPeriodAddItinerary").click(function() {
			t.itineraryCreate();
		});
		$("#divPeriodMenu #menuPeriodDelete").click(function() {
			t.periodConfirmDelete();
		});
		$("#divPeriodMenu #menuPeriodGenerateSeries").click(function() {
			t.periodConfirmGenerateSeries();
		});
		$("#divPeriodMenu #menuViewAllocations").click(function() {
			t.periodViewAllocations("#divPeriodMenu");
		});
		$("#divPeriodMenu #menuViewTimeline").click(function() {
			var allocationId = $("#divPeriodMenu").attr("allocation_id");
			var dlgTitle = "Allocation Timeline: " + allocationId;
			var dlgallocationtimeline = new dlgAllocationTimeline(allocationId, dlgTitle, 600, 650);
			dlgallocationtimeline.init();
		});
		$("#divPeriodMenu #menuCreateReservation").click(function() {
			t.periodCreateReservation();
		});
		$('#divPeriodMenu').click(function(event) {
			event.cancelBubble = true;
		});
		$('#tdPeriodMenuClose').click(function() {
			window.click();
		});
		/* Period menu end */
		/* Period events end */

		/* Itinerary events start */
		/* Itinerary menu start */
		$("input[bl_block_itinerary_ix][name='btnItineraryMenu']").each(function() {
			$(this).click(function(e) {
				t.itineraryShowMenu(e, $(this).attr("bl_block_itinerary_ix"));
			});
		});
		$("#divItineraryMenu tr.imgLink").each(function() {
			$(this).mouseover(function() {
				$(this).addClass("colGreen");
			});
			$(this).mouseout(function() {
				$(this).removeClass("colGreen");
			});
		});
		$('#divItineraryMenu').click(function(event) {
			event.cancelBubble = true;
		});
		$('#tdItineraryMenuClose').click(function() {
			window.click();
		});
		$("#divItineraryMenu #menuItineraryEdit").click(function() {
			t.itineraryEdit($("#divItineraryMenu").attr("bl_block_itinerary_ix"));
		});
		$("#divItineraryMenu #menuItineraryDelete").click(function() {
			t.itineraryConfirmDelete();
		});
		/* Itinerary menu end */
		$("tr[bl_block_period_ix][recordType='itinerary']").each(function() {
			$(this).mouseover(function() {
				$(this).children("td").addClass('colGreen');
				$(this).css('cursor', 'pointer');
			});
			$(this).mouseout(function() {
				$(this).children("td").removeClass('colGreen');
			});
			$(this).click(function() {
				t.itineraryEdit($(this).attr("bl_block_itinerary_ix"));
			});
		});
		$('#selItineraryAccommodation').change(function() {
			 t.setAccommodation();
		});
		$('#txtItineraryFromDay, #txtItineraryToDay').keyup(function() {
			 id("txtItineraryNights").value = t.getNights();
		});
		$('#btnRateItinirary').click(function() {
			t.ddRateShow("ddRateSelectItinerary");
		});
		$('#btnItineraryOK').click(function(event) {
			 t.itineraryApply(event);
		});
		$('#btnItineraryOK').mouseout(function() {
			nd();
		});
		$('#btnItineraryCancel').click(function() {
			 t.itineraryUnEdit("cancel");
		});
		$('#btnItineraryCancel').mouseout(function() {
			nd();
		});
		/* Itinerary events end */

		// Set changed filter when a field is changed
		$("#tblMain input").change(function() {
			changedFilter = true;
		});
		/* Bind events end */
	}

	/**
	 * buttonPress - process actions for toolbar button click events
	 */
	this.buttonPress = function(button) {
		switch (button) {
			case "New":
				window.location = actionNewUrl;
				break;
			case "Open":
				window.location = actionOpenUrl;
				break;
			case "Edit":
				window.location = actionEditUrl;
				break;
			case "Save":
				if (blockbookingdetails.validateInput()) {
					wait.show('circle');
					blockbookingdetails.validateSave();
				}
				break;
			case "Print":
				window.print();
				break;
			case "Delete":
				blockbookingdetails.blockBookingConfirmDelete();
				break;
			default:
				showMessage("This function not yet implemented","Notice",261,140);
				break;
		}
	}

	/**
	 * validateInput - validate user input
	 */
	this.validateInput = function() {
		var valid = true;
		var message = [];
		if(id("txtBlockName").value.toString().replace(/\s*/,"") == "") {
			id("txtBlockName").focus();
			message.push("Please enter a 'Name'");
			valid = false;
		}
		if(id("txtBlockAbbrev").value.length > 5) {
			id("txtBlockAbbrev").focus();
			message.push("'Abbreviation cannot be longer than 5 characters");
			valid = false;
		}
		if(id("selConsultant").value == "-1" || id("selConsultant").value == "" || id("selConsultant").value == null) {
			id("selConsultant").focus();
			message.push("Please select a 'Consultant'");
			valid = false;
		}
		if(id("rv_agent_id").value == "") {
			id("agentPop").focus();
			message.push("Please select an 'Agent'");
			valid = false;
		}
		if(id("rv_corr_persona_id").value == "") {
			id("contact_button").focus();
			message.push("Please select a 'Contact'");
			valid = false;
		}
		if (!valid) {
			showValidationList(message, "Validation Failure", 300, 200);
		}
		this.validator.validateAll();
		return valid;
	}

	/**
	 * validateSave - server side validation of input data
	 */
	this.validateSave = function() {
		var sNames = ['bl_block_ix','bl_block_name','bl_block_abbrev','validateBlockBooking'];
		var sValues	= [id('hidBlockNumber').value, id("txtBlockName").value, id("txtBlockAbbrev").value, "true"];
		aRequestReset();
		aRequestPost(actionEditUrl, blockbookingdetails.validateSaveAfter, sNames, sValues);
	}

	this.validateSaveAfter = function(cStatus,cData) {
		if (!cStatus) {
			return;
		}
		cDataArray = cData.split("\n");
		try {
			payload = JSON.parse(cDataArray[0]);
		}catch(e){
			payload = {"result": "fail"};
		}
		if (payload["result"] != "success") {
			var message = payload["message"];
			showValidationList(payload["message"], "Saving Error", 300, 200);
			wait.hide();
		} else {
			blockbookingdetails.save();
		}
	}

	/**
	 * save - do ajax save of all data, including period and itinerary template stuff
	 */
	this.save = function() {
		var t = this;
		var periodList = [];
		var itineraryList = [];
		var periodRows = id("tblBlockBookingPeriods").rows;

		for (var count = 0; count < periodRows.length; count++) {
			var row = periodRows[count];
			var bl_block_period_ix = row.getAttribute("bl_block_period_ix");
			if (bl_block_period_ix != null) {
				if (row.getAttribute("action") != "" && row.getAttribute("action") != null) {
					var item = [];
					if (row.getAttribute("recordType") == "period") {
						item['action'] = row.getAttribute("action");
						item['bl_block_id'] = row.getAttribute("bl_block_id");
						item['bl_block_period_ix'] = bl_block_period_ix;
						item['bl_per_date_start_series_fst'] = row.getAttribute("bl_per_date_start_series_fst");
						item['bl_per_date_start_series_lst'] = row.getAttribute("bl_per_date_start_series_lst");
						item['bl_per_recurrence_per_ind'] = row.getAttribute("bl_per_recurrence_per_ind");
						item['bl_per_recurrence_per_1'] = row.getAttribute("bl_per_recurrence_per_1");
						item['bl_per_recurrence_per_2'] = row.getAttribute("bl_per_recurrence_per_2");
						item['bl_per_recurrence_per_3'] = row.getAttribute("bl_per_recurrence_per_3");
						item['bl_per_recurrence_per_4'] = row.getAttribute("bl_per_recurrence_per_4");
						item['bl_per_recurrence_per_5'] = row.getAttribute("bl_per_recurrence_per_5");
						item['bl_per_expiry_ind'] = row.getAttribute("bl_per_expiry_ind");
						item['bl_per_expiry_lead_time_days'] = row.getAttribute("bl_per_expiry_lead_time_days");
						item['bl_per_expiry_lead_time_date'] = row.getAttribute("bl_per_expiry_lead_time_date");
						periodList[periodList.length] = item;
						if (row.getAttribute("action") != "new") {
							t.periodExpandList.push(bl_block_period_ix);
						}
					}
				}

				try {
					var itineraryRows = id("tblItineraries_" + bl_block_period_ix).rows;
				} catch (e) {
					var itineraryRows = [];
				}
				for (var c = 0; c < itineraryRows.length; c++) {
					var row = itineraryRows[c];
					if (row.getAttribute("action") != "" && row.getAttribute("action") != null) {
						var item = [];
						if (row.getAttribute("recordType") == "itinerary") {
							item['action'] = row.getAttribute("action");
							item['bl_block_itinerary_ix'] = row.getAttribute("bl_block_itinerary_ix");
							item['bl_block_period_id'] = row.getAttribute("bl_block_period_id");
							item['ac_accomm_type_id'] = row.getAttribute("ac_accomm_type_id");
							item['rt_rate_type_id'] = row.getAttribute("rt_rate_type_id");
							item['bl_itinerary_day_start'] = row.getAttribute("bl_itinerary_day_start");
							item['bl_itinerary_day_end'] = row.getAttribute("bl_itinerary_day_end");
							item['bl_block_itinerary_rooms'] = row.getAttribute("bl_block_itinerary_rooms");
							item['bl_block_itinerary_pax'] = row.getAttribute("bl_block_itinerary_pax");
							itineraryList[itineraryList.length] = item;
							if ($("tr[recordType='period'][bl_block_period_ix='"+ row.getAttribute("bl_block_period_id") +"']").attr("action") != "new") {
								t.periodExpandList.push(row.getAttribute("bl_block_period_id"));
							}
						}
					}
				}
			}
		}

		var blockPeriods = serialize(periodList);
		var blockItineraries = serialize(itineraryList);

		var sNames = [
			'bl_block_ix',
			'bl_block_name',
			'bl_block_abbrev',
			'rv_consultant_id',
			'rv_agent_id',
			'rv_agent_contact_persona_id',
			'rv_agent_ref',
			'bl_block_commission_perc',
			'bl_block_note',
			'bl_block_note_internal',
			'blockPeriods',
			'blockItineraries'
		];
		var sValues	= [
			id('hidBlockNumber').value,
			id('txtBlockName').value,
			id('txtBlockAbbrev').value,
			id('selConsultant').value,
			id('rv_agent_id').value,
			id('rv_corr_persona_id').value,
			id('txtAgentReference').value,
			id('txtCommissionPerc').value,
			id('txtBlockNote').value,
			id('txtBlockMemo').value,
			blockPeriods,
			blockItineraries
		];
		var url = "";
		switch (this.pagemode) {
			case "modeNew":
				url = actionNewPersistUrl;
				break;
			case "modeEdit":
				url = actionEditPersistUrl;
				break;
			case "modeView":
				break;
			default:
				showMessage("There was an error determining the current page mode","Error",261,140);
				break;
		}
		aRequestReset();
		aRequestPost(url, this.afterSave, sNames, sValues);
	}

	this.afterSave = function(cStatus,cData) {
		var hideWait = false;
		if (!cStatus) {
			return;
		}
		cDataArray = cData.split("\n");
		try {
			payload = JSON.parse(cDataArray[0]);
		}catch(e){
			payload = {"result": "fail"};
		}
		if (payload["result"] != "success") {
			showMessage(cData);
			showMessage("There was an error saving block booking data","Error",261,140);
			hideWait = true;
		} else {
			switch (blockbookingdetails.pagemode) {
				case "modeNew":
					bl_block_ix = payload["bl_block_ix"];
					window.location = actionEditUrl + "+" + bl_block_ix;
					break;
				case "modeEdit":
					var ad_modify_date = payload["ad_modify_date"];
					$("#lblBlockModified").html(ad_modify_date);
					var modify_user_name = payload["modify_user_name"];
					$("#lblBlockModifiedBy").html(modify_user_name);
					if (payload["reload"] == "true") {
						var strPeriodExpandList = "";
						if (blockbookingdetails.periodExpandList.length > 0) {
							strPeriodExpandList += "+" + blockbookingdetails.periodExpandList.join(",");
						}
						if (payload["periodExpandList"].length > 0) {
							strPeriodExpandList += "+" + payload["periodExpandList"].join(",");
						}
						window.location = actionEditUrl + strPeriodExpandList;
					} else {
						hideWait = true;
					}
					break;
				case "modeView":
					hideWait = true;
					break;
				default:
					blockbookingdetails.readOnly();
					hideWait = true;
					break;
			}
		}
		if (hideWait) {
			wait.hide();
		}
		changedFilter = false;
	}

	this.blockBookingConfirmDelete = function() {
		wait.show('circle');
		this.registerFunctions(this.blockBookingDelete, this.blockBookingDeleteCancel);

		openConfirm("Are you sure you want to delete this block template?");
	}

	this.blockBookingDelete = function() {
		var sNames = ['recordType','bl_block_id'];
		var sValues	= ['blockBooking', blockBookingRecord];
		var url = actionDeleteUrl;
		aRequestReset();
		aRequestPost(url, blockbookingdetails.afterBlockBookingDelete, sNames, sValues);
		blockbookingdetails.unRegisterFunctions();
	}

	this.afterBlockBookingDelete = function(cStatus,cData) {
		if (!cStatus) {
			return;
		}
		cDataArray = cData.split("\n");
		try {
			payload = JSON.parse(cDataArray[0]);
		}catch(e){
			payload = {"result": "fail"};
			showMessage(cData);
		}
		if (payload["result"] != "success") {
			showValidationList(payload["message"], "Deletion Failure", 300, 200);
			wait.hide();
		} else {
			window.location = actionListUrl; // Go to the block template listing page
		}
	}

	this.blockBookingDeleteCancel = function() {
		wait.hide();
	}

	/**
	 * pageView - set element state (visibility, active/disabled etc) of elements depending on which mode the page is on.
	 * 	the modes are:
	 * 		new: "modeNew"
	 * 		edit: "modeEdit"
	 * 		view: "modeView"
	 */
	this.pageView = function() {
		switch (this.pagemode) {
			case "modeNew":
				id("tblHeader").style.display = "none";
				id("divBlockBookingPeriods").style.display = "none";
				id("titleSpan").innerHTML = "Create New Block Template";
				break;
			case "modeEdit":
				if ((this.hasAllocations() || this.hasReservations())) {
					id("agent_button").style.display = "none";
					id("agentPop").style.display = "none";
					id("contact_button").style.display = "none";
					id("btnContactInfo").style.display = "none";
					$("[name='spaButtonLabelToggle']").removeClass("collapse");
				}
				break;
			case "modeView":
				this.readOnly();
				break;
			default:
				this.readOnly();
				break;
		}
	}

	/**
	 * popup - call one of the existing RR popups
	 */
	this.popup = function(type) {
		switch(type) {
			case 'contact':
				var rv_agent_id = (id("rv_agent_id").value != "") ? id("rv_agent_id").value : "";
				openPopup("reservation.php?692+11+"+rv_agent_id,350,525);
				break;
			case 'agent':
				openPopup('reservation.php?679',280,420);
				break;
			case 'agentinfo':
				var agent_id = id("rv_agent_id").value;
				var agent_name = id("agent_name").value;
				if(agent_id != "" && agent_id != 0){
                    url = "reservation.php?683+"
                        + agent_id
                        + "+"
                        + agent_name;
                    openPopup(url,550,550);
				}else{
					openMessage("There are no details for this agent","a",80);
				}
				break;
			case 'contactinfo':
				var persona_id = id("rv_corr_persona_id").value;
				if(persona_id != "" && persona_id != 0){
					url = "reservation.php?682+"
						+ persona_id;
					openPopup(url,240,300);
				}else{
					openMessage("There are no details for this contact","a",80);
				}
				break;
			default:
				showMessage("Popup " + type + " not found");
				break;
		}
	}

	this.agentInfoToggle = function() {
		if(id("agent_name").value == "Direct"){
			id("agentPop").style.visibility = "hidden";
		}else{
			id("agentPop").style.visibility = "visible";
		}
	}

	/**
	 * readOnly - make the entire page readonly
	 */
	this.readOnly = function() {
		id("txtBlockName").disabled = true;
		id("selConsultant").disabled = true;
		id("contact_button").style.display = "none";
		id("txtAgentReference").disabled = true;
		id("txtCommissionPerc").disabled = true;
		id("txtBlockNote").disabled = true;
		id("txtBlockMemo").disabled = true;
		id("btnPeriodAdd").style.display = "none";
		$("[name='btnPeriodMenu']").css('display', "none");
		$("[name='btnPeriodMenu']").closest("td").html("&nbsp;");
		$("[name='btnItineraryMenu']").css('display', "none");
		$("[name='btnItineraryMenu']").closest("td").html("&nbsp;");
		id("agent_button").style.display = "none";
		id("agentPop").style.display = "none";
		id("contact_button").style.display = "none";
		id("btnContactInfo").style.display = "none";
		$("[name='spaButtonLabelToggle']").removeClass("collapse");
	}

	/* Period functions start */
	this.periodShowMenu = function(e,bl_block_period_ix) {
		// TODO editing a new (un-saved) period doesn't work
		// 		need to be able to pass the dialog values from unsaved period
		var t = this;
		if (!e) { e = window.event; }
		stopBubble(e);

		var posx = 100;
		var posy = 0;

		if (e.pageX || e.pageY) {
			posx = e.pageX;
			posy = e.pageY;
		} else if (e.clientX || e.clientY) 	{
			posx = e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
			posy = e.clientY + document.body.scrollTop + document.documentElement.scrollTop;
		}

		id("menuPeriodView").className = "imgLink";
		if (bl_block_period_ix == "" || bl_block_period_ix === null) {
			id("menuPeriodView").className = "collapse";
		}
		var periodItineraries = $("tr[bl_block_period_ix='" + bl_block_period_ix + "'][recordType='itinerary']").not("[action='edit']").not("[action='new']").not("[action='update']");
		if (t.hasAllocations(bl_block_period_ix)) {
			id("menuPeriodAddItinerary").style.display = "none";
			id("menuPeriodDelete").style.display = "none";
			id("menuViewAllocations").style.display = "";
			id("menuViewTimeline").style.display = "";
			id("menuCreateReservation").style.display = "";
			id("menuPeriodGenerateSeries").style.display = "none";
		} else {
			id("menuPeriodView").style.display = "";
			id("menuPeriodAddItinerary").style.display = "";
			id("menuPeriodDelete").style.display = "";
			id("menuViewAllocations").style.display = "none";
			id("menuViewTimeline").style.display = "none";
			id("menuCreateReservation").style.display = "none";
			var isUnsaved = false;
			if ($("tr[bl_block_period_ix='" + bl_block_period_ix + "'][recordType='itinerary']").hasClass("linkRowUnsaved") || $("#tblItineraries_" + bl_block_period_ix).find("tr.linkRowUnsaved").length > 0) {
				isUnsaved = true;
			}
			if (periodItineraries.length == 0 || isUnsaved == true) {
				id("menuPeriodGenerateSeries").style.display = "none";
			} else if (periodItineraries.length > 0) {
				id("menuPeriodGenerateSeries").style.display = "";
			}
		}

		id("divPeriodMenu").style.display	= "";
		posx -= id("divPeriodMenu").offsetWidth;
		id("divPeriodMenu").style.left = posx + "px";
		id("divPeriodMenu").style.top = posy + "px";
		$("#divPeriodMenu").attr("bl_block_period_ix", bl_block_period_ix);
		$("#divPeriodMenu").attr("allocation_id", $("tr[bl_block_period_ix='" + bl_block_period_ix + "'][recordType='period']").attr("allocation_id"));
	}

	this.periodConfirmDelete = function(periodList) {
		wait.show('circle');
		this.registerFunctions(this.periodDelete, this.periodDeleteCancel);

		this.periodsDelete = (periodList != null && typeof periodList != 'undefined') ? periodList : $("#divPeriodMenu").attr("bl_block_period_ix");
		openConfirm("Are you sure you want to delete this period?");
	}

	this.periodDelete = function() {
		var periods = blockbookingdetails.periodsDelete.split(",");
		var deletePeriods = [];
		var hasItineraries = false;
		$.each(periods, function(key, value) {
			var periodItineraries = $("tr[bl_block_period_ix='" + value + "'][recordType='itinerary']")
			if (periodItineraries.length == 0) {
				var tr = $("tr[bl_block_period_ix='" + value + "']");
				if (tr.attr("action") != "new") {
					deletePeriods.push(value);
				}
				tr.remove();
			} else {
				hasItineraries = true;
			}
		});
		if (deletePeriods.length > 0) {
			var sNames = ['recordType','deletePeriods'];
			var sValues	= ['period', deletePeriods];
			var url = actionDeleteUrl;
			aRequestReset();
			aRequestPost(url, blockbookingdetails.afterPeriodDelete, sNames, sValues);
		}
		blockbookingdetails.unRegisterFunctions();
		if (hasItineraries) {
			showMessage("Some periods could not be deleted because they are still linked to itineraries. Please delete all a period's itineraries before deleting the period.");
		}
		wait.hide();
	}

	this.afterPeriodDelete = function(cStatus,cData) {
		if (!cStatus) {
			return;
		}
		cDataArray = cData.split("\n");
		try {
			payload = JSON.parse(cDataArray[0]);
		}catch(e){
			payload = {"result": "fail"};
		}
		if (payload["result"] != "success") {
			showValidationList(payload["message"], "Deletion Failure", 300, 200);
		}
		wait.hide();
	}

	this.periodDeleteCancel = function() {
		wait.hide();
	}

	this.periodConfirmGenerateSeries = function(periodList) {
		if(!this.itineraryIsEdit()) {
			return false;
		}
		var t = this;
		var h = 200;
		var w = 350;

		this.periodsGenerateSeries = (periodList != null && typeof periodList != 'undefined') ? periodList : $("#divPeriodMenu").attr("bl_block_period_ix");
		$("#dlgOverbookingConfirm").modal({
            closeHTML: "<i class='material-icons modal-close' style='color: white; cursor: pointer;'>close</i>",
			overlayId: 'dialog-overlay',
			containerId: 'dialog-container',
			zIndex: 80, // above main menu and also above "Req received; Contact us and Logoff"
			containerCss:{
				height:h,
				width:w
			},
			autoPosition: true,
			escClose: true,
			onOpen: function (dialog) {
				dialog.overlay.fadeIn(1, function () {
					dialog.container.fadeIn(1, function () {
						dialog.data.fadeIn(1, function () {
							$('#dialog-container form').fadeIn(1, function () {
								wait.hide();
							});
						});
					});
				});
			},
			onShow: function (dialog) {
				var canOverbook = id("hidCanOverbook").value == "1" ? true : false;
				$('#tdOverbookingConfirmTitle').html("Warning");
				if (canOverbook) {
					$("#tdOverbookingConfirmMessage").html("Generating allocation items may result in overbookings. Do you want to continue and create overbooked items or skip items that would cause an overbooking?");
				} else {
					$("#btnOverbookingConfirmSkip").hide();
					$("#tdOverbookingConfirmMessage").html("Generating allocation items that result in overbookings will be skipped");
				}

				$("#btnOverbookingConfirmContinue").click(function() {
					$.modal.close();
					t.periodGenerateSeries(canOverbook);
				});
				$("#btnOverbookingConfirmSkip").click(function() {
					$.modal.close();
					t.periodGenerateSeries(true);
				});
				$("#btnOverbookingConfirmCancel").click(function() {
					$.modal.close();
				});
			},
			onClose: function (dialog) {
				$('#dialog-container .dialog-message').fadeOut();
				$('#dialog-container form').fadeOut(1);
				dialog.data.fadeOut(1, function () {
					dialog.container.fadeOut(1, function () {
						dialog.overlay.fadeOut(1, function () {
							$.modal.close();
						});
					});
				});
			}
		});
	}

	/**
	 * periodGenerateSeries - generate all the allocations for a block period
	 */
	this.periodGenerateSeries = function(skipOverbookings) {
		var skipOverbookings = (typeof skipOverbookings != 'undefined') ? skipOverbookings : false;
		wait.show('circle');
		var generateSeriesPeriods = serialize(blockbookingdetails.periodsGenerateSeries.split(","));
		if (generateSeriesPeriods.length > 0) {
			var sNames = ['editAction','generateSeriesPeriods', 'skipOverbookings'];
			var sValues	= ['generateSeries', generateSeriesPeriods, skipOverbookings];
			var url = "reservation.php?6012+";
			aRequestReset();
			aRequestPost(url, blockbookingdetails.afterPeriodGenerateSeries, sNames, sValues);
		}
	}

	this.afterPeriodGenerateSeries = function(cStatus,cData) {
		var t = this;
		if (!cStatus) {
			return;
		}
		cDataArray = cData.split("\n");
		try {
			payload = JSON.parse(cDataArray[0]);
		}catch(e){
			payload = {"result": "fail"};
		}
		if (payload["result"] != "success") {
			if (payload["message"]) {
				showValidationList(payload["message"], "Allocation Generation Failure", 300, 200);
			} else {
				showMessage("An error occurred during series generation","Series Generation Failure",300,200);
			}
		} else {
			$.each(payload["periodDetails"], function(key, value) {
				// Update period values
				$("tr[bl_block_itinerary_ix='" + key + "']");
				var allocationId = "";
				var allocationCount = "";
				var allocationExpiredCount = "";
				for (var k in value) {
					if (key === 'length' || !value.hasOwnProperty(k)) continue;
					allocationId = k;
					allocationCount = value[k]['total_items'];
					allocationExpiredCount = value[k]['expired_items'];
				}
				$("tr[bl_block_period_ix='" + key + "'][recordType='period']").attr("allocation_id", allocationId);
				var allocLink = $("<span>");
				allocLink.prop("id", "spaSeries" + key);
				allocLink.addClass("link");
				allocLink.mouseover(function() {
					overlib('View allocations ', LEFT, WIDTH, 100);
				});
				allocLink.mouseout(function() {
					nd();
				});
				allocLink.click(function(){
					blockbookingdetails.periodViewAllocations("tr[bl_block_period_ix=" + key + "]");
				});
				allocLink.text(allocationExpiredCount + "/" + allocationCount);
				$("tr[bl_block_period_ix='" + key + "'] td").eq(5).html(allocLink);

				// Update block header values
				var expiredBlocks = parseInt($("#spaBlockSeries").text().split("/")[0]) + parseInt(allocationExpiredCount);
				var totalBlocks = parseInt($("#spaBlockSeries").text().split("/")[1]) + parseInt(allocationCount);
				$("#spaBlockSeries").text(expiredBlocks + "/" + totalBlocks);
			});
		}
		blockbookingdetails.reloadOverbookings();
		wait.hide();
	}

	this.periodGenerateSeriesCancel = function() {
		wait.hide();
	}

	/**
	 * periodViewAllocations - open the agent (allocations) popup for this period
	 */
	this.periodViewAllocations = function(elem) {
		if (this.hasAllocations($(elem).attr("bl_block_period_ix"))) {
			var allocation_id = $(elem).attr("allocation_id");
			openPopup("reservation.php?270+"+id("rv_agent_id").value+"+"+allocation_id+"++++++1",700,600);
		} else {
			showMessage("This period does not yet have any allocations");
		}
	}

	/**
	 * periodCreateReservation - get the appropriate data to open the create reservation from template dialog
	 */
	this.periodCreateReservation = function() {
		if(!this.itineraryIsEdit()) {
			return false;
		}
		this.checkUnsaved();
		wait.show('circle');

		var allocation_id = $("#divPeriodMenu").attr("allocation_id");

		var sNames = ['getAllocationDates', 'bl_block_ix', 'allocation_id'];
		var sValues	= ["true", id('hidBlockNumber').value, allocation_id];
		aRequestReset();
		aRequestPost(actionViewUrl, this.afterPeriodCreateReservation, sNames, sValues);
	}

	/**
	 * afterPeriodCreateReservation - open the create reservation from template dialog
	 */
	this.afterPeriodCreateReservation = function(cStatus,cData) {
		if (!cStatus) {
			return;
		}
		cDataArray = cData.split("\n");
		try {
			payload = JSON.parse(cDataArray[0]);
		}catch(e){
			payload = {"result": "fail"};
		}
		if (payload["result"] != "success") {
			if (typeof payload["message"] == 'undefined') {
				wait.hide();
				aRequestReset();
				showMessage("<h2>ERROR OCCURRED</h2>" + cData);
				return;
			} else {
				wait.hide();
				aRequestReset();
				showValidationList(payload["message"], "Error", 300, 200);
				return;
			}
		} else {
			var bl_block_period_ix = $("#divPeriodMenu").attr("bl_block_period_ix");
			var itineraryRows = [];
			try {
				var itineraryRows = id("tblItineraries_" + bl_block_period_ix).rows;
			} catch (e) {
				var itineraryRows = [];
			}
			var itineraries = [];

			for (var count = 1; count < itineraryRows.length; count++) {
				var row = itineraryRows[count];
				var item = [];
				item['max_pax'] = row.getAttribute("bl_block_itinerary_pax");
				item['room_max'] = row.getAttribute("bl_block_itinerary_rooms");
				item['rt_rate_type_id'] = row.getAttribute("rt_rate_type_id");
				item['ac_accomm_type_id'] = row.getAttribute("ac_accomm_type_id");
				itineraries.push(item);
			}
			var datesOfStay = payload['allocationDates'];
			var rv_agent_id = id('rv_agent_id').value;
			var rv_corr_persona_id = id('rv_corr_persona_id').value;
			var dlgreservationfromtemplate = new dlgReservationFromTemplate(
				rv_agent_id,
				rv_corr_persona_id,
				itineraries,
				datesOfStay,
				"wizardStep2",
				"Create Reservation from Block",
				"100%",
				740,
				bl_block_period_ix
			);
			dlgreservationfromtemplate.init();
		}
	}

	this.periodCreateReservationCancel = function() {
		wait.hide();
	}
	/* Period functions end */

	/* Itinerary functions start */
	/**
	 * itineraryCreate - create a new itinerary row (doesn't persist data)
	 */
	this.itineraryCreate = function() {
		var t = this;
		window.click();

		if(!this.itineraryIsEdit()) {
			return false;
		}
		var bl_block_period_ix = $("#divPeriodMenu").attr("bl_block_period_ix");
		if ($("#trItineraries_" + bl_block_period_ix).length == 0) {
			var html = "<tr id='trItineraries_" + bl_block_period_ix + "'>" +
			"	<td class='bl'>&nbsp;</td>" +
			"	<td style='padding:3px 3px 5px 3px;' colspan='7'>" +
			"		<div style='border: 1px solid #dddddd'>" +
			"			<table id='tblItineraries_" + bl_block_period_ix + "' width='100%' cellspacing='0' cellpadding='0' align='center' class='margin-top:3px;' >" +
			"					<col width='180' />	<!-- Property -->" +
			"					<col width='184' />	<!-- Accomm -->" +
			"					<col width='165' /> <!-- Rate -->" +
			"					<col width='31' /> <!-- Start -->" +
			"					<col width='31' /> <!-- End -->" +
			"					<col width='31' /> <!-- Nights -->" +
			"					<col width='31' /> <!-- Rooms -->" +
			"					<col width='31' /> <!-- Pax -->" +
			"					<col width='52' />" +
			"					<thead>" +
			"						<tr>" +
			"							<th name=\"thItineraryProperty\"  style='line-height:18px;' class='colLt br bb'>Property</th>" +
			"							<th name=\"thItineraryAccomm\" style='line-height:18px;' class='colLt br bb'>Accommodation</th>" +
			"							<th name=\"thItineraryRate\" style='line-height:18px;' class='colLt br bb'>Rate</th>" +
			"							<th name=\"thItineraryStart\" style='line-height:18px;' class='colLt br bb'><abbr style='cursor: help;' class='tooltip' title='Start day'>Start</abbr></th>" +
			"							<th name=\"thItineraryEnd\" style='line-height:18px;' class='colLt br bb'><abbr style='cursor: help;' class='tooltip' title='End day'>End</abbr></th>" +
			"							<th name=\"thItineraryNights\" style='line-height:18px;' class='colLt br bb'><abbr style='cursor: help;' class='tooltip' title='Nights'>Nts</abbr></th>" +
			"							<th name=\"thItineraryRooms\" style='line-height:18px;' class='colLt br bb'><abbr style='cursor: help;' class='tooltip' title='Rooms'>Rms</abbr></th>" +
			"							<th name=\"thItineraryRooms\" style='line-height:18px;' class='colLt br bb'><abbr style='cursor: help;' class='tooltip' title='Number of Pax'>Pax</abbr></th>" +
			"							<th name=\"thItineraryPax\" style='line-height:18px;' class='colLt bb'>" +
			"								<img src='/resource/Resrequest/Application/public/img/1x1.gif' width='5' alt='' />" +
			"							</th>" +
			"						</tr>" +
			"					</thead>"+
			"					<tbody>" +
			"					</tbody>" +
			"			</table>" +
			"		</div>" +
			"	</td>" +
			"	<td class='br'>&nbsp;</td>" +
			"</tr>";
			$("#tblBlockBookingPeriods > tbody > tr[bl_block_period_ix='" + bl_block_period_ix + "']").after(html);
		}

		// Expand the period to show the itineraries
		var newSrc = "/resource/Resrequest/Application/public/img/property_expanded.gif";
		$("#img_" + bl_block_period_ix).attr("src", newSrc);
		$("#trItineraries_" + bl_block_period_ix).show();

		this.itineraryUnEdit("new");

		var newTr = $('<tr>');
		var randLetter = String.fromCharCode(65 + Math.floor(Math.random() * 26));
		var newTrId = randLetter + Date.now();
		newTr.prop("id", newTrId);
		newTr.height(this.defaultRowHeight);
		newTr.attr("bl_block_period_ix", bl_block_period_ix);
		newTr.attr("bl_block_itinerary_ix", newTrId);
		newTr.attr("action", "new"); // actions: new; update; delete
		newTr.attr("recordType", "itinerary"); // blockRecordTypes: period; itinerary
		newTr.mouseover(function() {
			$('[bl_block_period_ix=' + newTrId + '] td').css('background-color', '#F2F2F2');
		});
		newTr.mouseout(function() {
			$('[bl_block_period_ix=' + newTrId + '] td').css('background-color', '');
		});
		$("tr[itineraryLatest]").removeAttr("itineraryLatest");
		newTr.attr("itineraryLatest", "true");

		var newTd = $("<td>");
		newTd.prop("colspan", "8");

		$('#tblItineraries_' + bl_block_period_ix + ' > tbody:last')
			.append(newTr.append(newTd).append($("<td>").html("&nbsp;")));

		// Workaround for Mozilla bug 167801:
		// https://bugzilla.mozilla.org/show_bug.cgi?id=167801
		if (is_ie) {
			id("divItineraryEditRow").style.position = "absolute";
		} else {
			id("divItineraryEditRow").style.position = "fixed";
		}

		id("divItineraryEditRow").style.display = "";
		id("divItineraryEditRow").setAttribute("bl_block_itinerary_ix", newTrId);
		id("divItineraryEditRow").setAttribute("action", "new");

		this.itineraryDivPosition();
		$(window).scroll(function() {
			t.itineraryDivPosition();
		});
		$(window).resize(function() {
			t.itineraryDivPosition();
		});
		var lastRooms = "";
		var lastPax = "";
		if ($('#tblItineraries_' + bl_block_period_ix + ' > tbody > tr:not([bl_block_itinerary_ix='+ newTrId +']):last').length > 0) {
			lastRooms = $('#tblItineraries_' + bl_block_period_ix + ' > tbody tr:first').attr("bl_block_itinerary_rooms");
			lastPax = $('#tblItineraries_' + bl_block_period_ix + ' > tbody tr:first').attr("bl_block_itinerary_pax");
		}
		id("hidItineraryAccommId").value = "";
		id("hidItineraryAccommName").value = "";
		id("hidItineraryPropertyName").value = "";
		id("selItineraryAccommodation").value = "";
		$("#ddRateSelectItinerary").val(this.lastRate);
		id("txtItineraryFromDay").value = this.getMaxLastDay(bl_block_period_ix);
		id("txtItineraryToDay").value = "";
		id("txtItineraryNights").value = "";
		id("txtItineraryRooms").value = (typeof lastRooms == 'undefined') ? "" : lastRooms;
		id("txtItineraryPax").value = (typeof lastPax == 'undefined') ? "" : lastPax;

		blockbookingdetails.validator.validateAll();

        $('.tooltip').not('.tooltipstered').tooltipster({
            theme: 'tooltipster-shadow',
            side: 'bottom',
            contentAsHTML: true
        });
	}

	/**
	 * itineraryApply - makes a "read only" row in the itineraries table for a period from user's input
	 */
	this.itineraryApply = function(e) {
		var t = this;

		if (this.itineraryValidate()) {
			var itineraryAction = id("divItineraryEditRow").getAttribute("action");
			// Get values from divItineraryEditRow
			var propertyName = id("hidItineraryPropertyName").value.replace("\\", "");
			var accommodationName = id("hidItineraryAccommName").value.replace("\\", "");
			var rateName = id("ddRateSelectItineraryLabel").value;
			var fromDay = id("txtItineraryFromDay").value;
			var toDay = id("txtItineraryToDay").value;
			var nights = t.getNights();
			var numberRooms = id("txtItineraryRooms").value;
			var numberPax = id("txtItineraryPax").value;
			this.lastRate = id("ddRateSelectItinerary").value;

			var currentTr = $("#tblBlockBookingPeriods tr[bl_block_itinerary_ix='" + id("divItineraryEditRow").getAttribute("bl_block_itinerary_ix") + "']");

			switch(itineraryAction) {
				case 'new':
					currentTr.prop("class", "linkRowUnsaved");
					currentTr.mouseover(function() {
						currentTr.children("td").addClass('colGreen');
						currentTr.css('cursor', 'pointer');
						overlib('Not saved. Click "Save" to save new items',LEFT, WIDTH, 120);
					});
					currentTr.mouseout(function() {
						currentTr.children("td").removeClass('colGreen');
						nd();
					});
					// Set attributes and values to be posted on click "Save"
					currentTr.attr("bl_block_period_id",currentTr.attr("bl_block_period_ix"));
					currentTr.attr("ac_accomm_type_id",id("hidItineraryAccommId").value);
					currentTr.attr("rt_rate_type_id",id("ddRateSelectItinerary").value);
					currentTr.attr("rt_rate_type_desc",id("ddRateSelectItineraryLabel").value);
					currentTr.attr("bl_itinerary_day_start",fromDay);
					currentTr.attr("bl_itinerary_day_end",toDay);
					currentTr.attr("bl_itinerary_nights",nights);
					currentTr.attr("bl_block_itinerary_rooms",numberRooms);
					currentTr.attr("bl_block_itinerary_pax", numberPax);
					currentTr.click(function() {
						t.itineraryEdit($(this).attr("bl_block_itinerary_ix"));
					});

					// Create a cell for each column value
					for (var count = 0; count < 6; count++) {
						var newTd = $("<td>");
						currentTr.append(newTd);
					}
					currentTrCells = currentTr.children("td");
					// TODO get index by finding the name of the column and using that index
					currentTrCells.eq(0).prop("colspan", "");
					currentTrCells.eq(0).html(propertyName);
					currentTrCells.eq(1).html(accommodationName);
					currentTrCells.eq(2).html(rateName);
					currentTrCells.eq(3).addClass("txtc").html(fromDay);
					currentTrCells.eq(4).addClass("txtc").html(toDay);
					currentTrCells.eq(5).addClass("txtc").html(nights);
					currentTrCells.eq(6).addClass("txtc").html(numberRooms);
					currentTrCells.eq(7).addClass("txtc").html(numberPax);
					var btnItineraryMenu = $('<input/>', {
						type: "button",
						text: "",
						class: "button bDropDown",
						name: "btnItineraryMenu",
						css: {"width":"14", "height":"18", "background-position":"center center"},
						id: 'btnItineraryMenu_'+currentTr.prop("id"),
						click: function(event) { t.itineraryShowMenu(event,currentTr.prop("id")); }
					});
					currentTrCells.eq(8).append(btnItineraryMenu);
					currentTrCells.eq(8).prop("class", "br");
					currentTrCells.eq(8).prop("align", "center");

					this.itineraryUnEdit("create");
					break;
				case 'edit':
					currentTr.prop("class", "linkRowUnsaved");
					currentTr.mouseover(function() {
						currentTr.css('background-color', "#F2F2F2");
						overlib('Not saved. Click "Save" to save edited items',LEFT, WIDTH, 120);
					});
					currentTr.mouseout(function() {
						currentTr.css('background-color', '');
						nd();
					});
					// Set attributes and values to be posted on click "Save"
					currentTr.attr("bl_block_period_id",currentTr.attr("bl_block_period_ix"));
					currentTr.attr("ac_accomm_type_id",id("hidItineraryAccommId").value);
					currentTr.attr("rt_rate_type_id",id("ddRateSelectItinerary").value);
					currentTr.attr("rt_rate_type_desc",id("ddRateSelectItineraryLabel").value);
					currentTr.attr("bl_itinerary_day_start",fromDay);
					currentTr.attr("bl_itinerary_day_end",toDay);
					currentTr.attr("bl_itinerary_day_nights",nights);
					currentTr.attr("bl_block_itinerary_rooms",numberRooms);
					currentTr.attr("bl_block_itinerary_pax", numberPax);

					currentTrCells = currentTr.children("td");
					// TODO get index by finding the name of the column and using that index
					currentTrCells.eq(0).html(propertyName);
					currentTrCells.eq(1).html(accommodationName);
					currentTrCells.eq(2).html(rateName);
					currentTrCells.eq(3).html(fromDay);
					currentTrCells.eq(4).html(toDay);
					currentTrCells.eq(5).html(nights);
					currentTrCells.eq(6).html(numberRooms);
					currentTrCells.eq(7).html(numberPax);

					this.itineraryUnEdit("create");
					break;
				default:
					break;
			}
		}
	}

	this.itineraryUnEdit = function(action) {
		switch(action) {
			case 'new':
				id("divItineraryEditRow").style.display = "none";
				break;
			case 'create':
				id("divItineraryEditRow").style.display = "none";
				break;
			case 'cancel':
				id("divItineraryEditRow").style.display = "none";
				var bl_block_itinerary_ix = id("divItineraryEditRow").getAttribute("bl_block_itinerary_ix");
				var currentTr = $("tr[bl_block_itinerary_ix='" + bl_block_itinerary_ix + "']");
				if (currentTr.attr("action") == "new") {
					currentTr.remove();
				} else {
					currentTr.attr("action", "");
					currentTr.removeClass("linkRowUnsaved");
					currentTr.mouseover(function() {
						currentTr.css('background-color', '#F2F2F2');
					});
					currentTr.mouseout(function() {
						currentTr.css('background-color', '');
					});
				}
				this.itineraryNewRow = false;
				break;
			case 'edit':
				id("divItineraryEditRow").style.display = "none";
				break;
			default:
				id("divItineraryEditRow").style.display = "none";
				break;
		}
	}

	this.itineraryIsEdit = function (checkUnsaved) {
		var checkUnsaved = (typeof checkUnsaved != 'undefined') ? checkUnsaved : false;
		if (id("divItineraryEditRow").style.display != "none") {
			showMessage("Apply or cancel the active itinerary. ");
			return false;
		}
		if (id("mode").value == "modeView") {
			showMessage("Cannot edit itinerary in read only mode. Click 'Edit Record' in the toolbar to edit");
			return false;
		}
		if (checkUnsaved) {
			this.checkUnsaved();
		}
		return true;
	}

	/**
	 * itineraryDivPosition - adjust itinerary edit area position based on page state and actions
	 */
	this.itineraryDivPosition = function() {
		var currentItineraryId = $("#divItineraryEditRow").attr("bl_block_itinerary_ix");
		var rowPosition = null;
		if ($("#divItineraryEditRow").is(":visible") && currentItineraryId.length > 0) {
			var row = $("tr[bl_block_itinerary_ix=" + currentItineraryId + "]");
			var rowPosition = row.position();
			//if (typeof rowPosition
			$("#divItineraryEditRow").css("left", rowPosition.left);
			$("#divItineraryEditRow").css("top", rowPosition.top - $("body").scrollTop());
		}
	}

	this.itineraryConfirmDelete = function(itineraryList) {
		wait.show('circle');
		this.registerFunctions(this.itineraryDelete, this.itineraryDeleteCancel);

		this.itinerariesDelete = (itineraryList != null && typeof itineraryList != 'undefined') ? itineraryList : $("#divItineraryMenu").attr("bl_block_itinerary_ix");
		openConfirm("Are you sure you want to delete this itinerary?");
	}

	this.itineraryDelete = function() {
		var itineraries = blockbookingdetails.itinerariesDelete.split(",");
		var deleteItineraries = [];
		$.each(itineraries, function(key, value) {
			var tr = $("tr[bl_block_itinerary_ix='" + value + "']");
			if (tr.attr("action") != "new") {
				deleteItineraries.push(value);
			}
			tr.remove();
		});
		if (deleteItineraries.length > 0) {
			var sNames = ['recordType','deleteItineraries'];
			var sValues	= ['itinerary', deleteItineraries];
			var url = actionDeleteUrl;
			aRequestReset();
			aRequestPost(url, blockbookingdetails.afterItineraryDelete, sNames, sValues);
		} else {
			wait.hide();
		}
		blockbookingdetails.unRegisterFunctions();
	}

	this.afterItineraryDelete = function(cStatus,cData) {
		if (!cStatus) {
			return;
		}
		cDataArray = cData.split("\n");
		try {
			payload = JSON.parse(cDataArray[0]);
		}catch(e){
			payload = {"result": "fail"};
		}
		if (payload["result"] != "success") {
			showValidationList(payload["message"], "Deletion Failure", 300, 200);
		}
		wait.hide();
	}

	this.itineraryDeleteCancel = function() {
		wait.hide();
	}

	this.itineraryValidate = function() {
		// TODO should not be able to enter itinerary dates for a period
		// that would overlap. Ensure that the start date entered is greater
		// or equal to maximum end date previously entered
		message = [];
		if (id("hidItineraryAccommId").value == "") {
			message.push("Select a property and accommodation type.");
		}

		if (id("ddRateSelectItinerary").value == "") {
			message.push("Select a rate.");
		}

		if (id("txtItineraryFromDay").selectedIndex == 0) {
			id("txtItineraryFromDay").focus();
			message.push("Select a start day.");
		}

		if(id("txtItineraryToDay").selectedIndex == 0) {
			id("txtItineraryToDay").focus();
			message.push("Select an end day.");
		}

		if(id("txtItineraryRooms").value.toString().search(/^-*\d+$/) == -1) {
			id("txtItineraryRooms").focus();
			message.push("Enter a valid number of rooms.");
		}

		if(id("txtItineraryPax").value.toString().search(/^-*\d+$/) == -1 || parseInt(id("txtItineraryPax").value) < 0) {
			id("txtItineraryPax").focus();
			message.push("Enter a valid number of pax.");
		}

		if (this.getNights() < 1) {
			id("txtItineraryFromDay").focus();
			message.push("Enter an end day that is greater than the start day.");
		}
		if (message.length > 0 || $("#divItineraryEditRow .validate_error").lenth > 0) {
			showValidationList(message, "Validation Failure", 300, 200);
			return false;
		} else {
			return true;
		}
	}

	this.itineraryShowMenu = function(e,bl_block_itinerary_ix) {
		var t = this;
		if (!e) { e = window.event; }
		stopBubble(e);

		var posx = 100;
		var posy = 0;

		if (e.pageX || e.pageY) {
			posx = e.pageX;
			posy = e.pageY;
		} else if (e.clientX || e.clientY) 	{
			posx = e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
			posy = e.clientY + document.body.scrollTop + document.documentElement.scrollTop;
		}

		id("menuItineraryEdit").className = "imgLink";
		var bl_block_period_ix = $("tr[bl_block_itinerary_ix='" + bl_block_itinerary_ix + "']").attr("bl_block_period_ix");
		if (bl_block_itinerary_ix == "" || bl_block_itinerary_ix === null || t.hasAllocations(bl_block_period_ix)) {
			id("menuItineraryEdit").className = "collapse";
		}
		if (t.hasAllocations(bl_block_period_ix)) {
			id("menuItineraryDelete").className = "collapse";
		}

		id("divItineraryMenu").style.display = "";
		posx -= id("divItineraryMenu").offsetWidth;
		id("divItineraryMenu").style.left = posx + "px";
		id("divItineraryMenu").style.top = posy + "px";
		$("#divItineraryMenu").attr("bl_block_itinerary_ix", bl_block_itinerary_ix);
	}

	this.itineraryEdit = function(bl_block_itinerary_ix) {
		var t = this;
		window.click();
		if(!this.itineraryIsEdit()) {
			return false;
		}

		this.itineraryUnEdit("new");

		var bl_block_period_ix = $("tr[bl_block_itinerary_ix='" + bl_block_itinerary_ix + "']").attr("bl_block_period_ix");
		if (t.hasAllocations(bl_block_period_ix)) {
			showMessage("Itinerary cannot be edited because allocations have already been generated");
			return false;
		}
		var itineraryTr = $("#tblItineraries_" + bl_block_period_ix + " tr[bl_block_itinerary_ix='" + bl_block_itinerary_ix + "']");
		var itineraryAction = itineraryTr.attr("action");
		if (itineraryAction != "new") {
			itineraryTr.attr("action", "update"); // actions: new; update; delete
		}

		// Workaround for Mozilla bug 167801:
		// https://bugzilla.mozilla.org/show_bug.cgi?id=167801
		if (is_ie) {
			id("divItineraryEditRow").style.position = "absolute";
		} else {
			id("divItineraryEditRow").style.position = "fixed";
		}
		id("divItineraryEditRow").style.display = "";
		id("divItineraryEditRow").setAttribute("action", "edit");
		id("divItineraryEditRow").setAttribute("bl_block_itinerary_ix", bl_block_itinerary_ix);

		var editRow = $("tr[bl_block_itinerary_ix='" + bl_block_itinerary_ix + "']");
		editRow.prop("id", "editRow");

		this.itineraryDivPosition();
		$(window).scroll(function() {
			t.itineraryDivPosition();
		});
		$(window).resize(function() {
			t.itineraryDivPosition();
		});
		editRow.prop("id", "");

		id("hidItineraryAccommId").value = "";
		id("hidItineraryAccommName").value = "";
		id("hidItineraryPropertyName").value = "";

		id("selItineraryAccommodation").value = itineraryTr.attr("ac_accomm_type_id");
		id("ddRateSelectItineraryLabel").value = itineraryTr.attr("rt_rate_type_desc");
		id("txtItineraryFromDay").value = itineraryTr.attr("bl_itinerary_day_start");
		id("txtItineraryToDay").value = itineraryTr.attr("bl_itinerary_day_end");
		id("txtItineraryNights").value = (typeof itineraryTr.attr("bl_itinerary_nights") == 'undefined') ? "" : typeof itineraryTr.attr("bl_itinerary_nights");
		id("txtItineraryRooms").value = (typeof itineraryTr.attr("bl_block_itinerary_rooms") == 'undefined') ? "" : itineraryTr.attr("bl_block_itinerary_rooms");
		id("txtItineraryPax").value = (typeof itineraryTr.attr("bl_block_itinerary_pax") == 'undefined') ? "" : itineraryTr.attr("bl_block_itinerary_pax");

		this.setAccommodation();
		blockbookingdetails.validator.validateAll();
	}

	/**
	 * getMaxLastDay - get the maximum of the most recent or last entered "End day" for an itinerary
	 */
	this.getMaxLastDay = function(bl_block_period_ix) {
		var items = [];
		$("#tblItineraries_" + bl_block_period_ix + " tbody tr[recordType='itinerary'] td:nth-child(5)").each(function(){
			items.push($(this).text());
		});
		var maxDay = (items.length > 0) ? Math.max.apply(Math,items) : 1;
		return maxDay;
	}

	this.setAccommodation = function() {
		var accommId = id("selItineraryAccommodation").options[id("selItineraryAccommodation").selectedIndex].getAttribute("ac_accomm_type_ix");
		var accommName = id("selItineraryAccommodation").options[id("selItineraryAccommodation").selectedIndex].getAttribute("ac_accomm_desc");
		var propertyName = id("selItineraryAccommodation").options[id("selItineraryAccommodation").selectedIndex].getAttribute("propertyName");
		id("hidItineraryAccommId").value = accommId;
		id("hidItineraryAccommName").value = accommName;
		id("hidItineraryPropertyName").value = propertyName;

		if (id("txtItineraryPax").value == "") {
			id("txtItineraryPax").value = accommodationAdultLimit[accommId];
		}
		this.validator.validateAll();
	}

	/**
	 * getNights - get number of nights between the from and to day
	 */
	this.getNights = function() {
		var fromDay = id("txtItineraryFromDay").value == "" ? 0 : id("txtItineraryFromDay").value;
		var toDay = id("txtItineraryToDay").value == "" ? 0 : id("txtItineraryToDay").value;
		var nights = ""
		if (parseInt(toDay) > parseInt(fromDay)) {
			nights = fromDay == toDay ? 0 : parseInt(toDay) - parseInt(fromDay);
		}
		return nights;
	}
	/* Itinerary functions end */

	/* Register functions to be executed by confirm popups */
	this.registerFunctions = function(funcConfirm, funcCancel) {
		confirmFunction = funcConfirm;
		nameConfirm = "confirmFunction";
		eval(nameConfirm + " = " + funcConfirm + ";");
		responseFunctions.push(nameConfirm);
		if (funcCancel != null) {
			cancelFunction = funcCancel;
			nameCancel = "cancelFunction";
			eval(nameCancel + " = " + funcCancel + ";");
			cancelFunctions.push(nameCancel);
		}
	}

	/* Un-register functions to be executed by confirm popups */
	this.unRegisterFunctions = function() {
		var nameConrirm = "confirmFunction";
		var confirmIndex = responseFunctions.indexOf(nameConfirm);
		if (confirmIndex != -1) {
			responseFunctions.splice(confirmIndex, 1);
		}
		eval(nameConfirm + " = function(){};");

		var nameConrirm = "confirmFunction";
		var cancelIndex = cancelFunctions.indexOf("cancelFunction");
		if (cancelIndex != -1) {
			cancelFunctions.splice(cancelIndex, 1);
			eval(nameCancel + " = function(){};");
		}
	}

	this.ddRateShow = function (elem, force) {
		this.ddRateElement = elem;
		if(id("ddRate").className == "" && force !== true) {
			this.ddRateHide();
		} else {
			aRequestReset();
			aRequestPost("reservation.php?297+"+id("rv_agent_id").value + "+" + (this.ddRateAll?"1":"0"),this.ddRateLoad,[],[]);
		}
	}

	this.ddRateHide = function() {
		id("ddRate").className = "collapse";
	}

	this.ddRateLoad = function(result, response) {
		var elem = blockbookingdetails.ddRateElement;
		if(result) {
			id("ddRate").innerHTML = response;
			id("ddRate").className = "";
			id("ddRate").style.top = getTop(id(elem + "Label")) + id(elem + "Label").offsetHeight;
			id("ddRate").style.left = getLeft(id(elem + "Label"));
		}
	}

	this.ddRateSet = function(rateId,rateLabel,hasAgent) {
		var elem = blockbookingdetails.ddRateElement;
		if(!hasAgent) {
			blockbookingdetails.confirmRateSelect = rateId;
			blockbookingdetails.confirmRateSelectLabel = rateLabel;
			delAction = "rate";
			blockbookingdetails.registerFunctions(blockbookingdetails.ddRateSetConfirm, blockbookingdetails.ddRateSetCancel);
			openConfirm("You have selected a rate type not allocated to the agent / direct contact. Would you like to continue?");
			return;
		}
		id(elem).value = rateId;
		id(elem + "Label").value = rateLabel;
		blockbookingdetails.ddRateHide(elem);
	}

	this.ddRateSetConfirm = function() {
		var elem = blockbookingdetails.ddRateElement;
		id(elem).value = blockbookingdetails.confirmRateSelect;
		id(elem + "Label").value = blockbookingdetails.confirmRateSelectLabel;
		blockbookingdetails.ddRateHide(elem);
		blockbookingdetails.unRegisterFunctions();
	}

	this.ddRateSetCancel = function() {
		var elem = blockbookingdetails.ddRateElement;
		blockbookingdetails.ddRateHide(elem);
		blockbookingdetails.unRegisterFunctions();
	}

	this.ddRateToggle = function(e) {
		var elem = blockbookingdetails.ddRateElement;
		blockbookingdetails.ddRateAll = !blockbookingdetails.ddRateAll;
		blockbookingdetails.ddRateShow(elem,true);
	}

	this.selectRate = function(elem){
		var rateId = id("ddRate").value;

		var rateRay = new Array();
		for(a=0;a<rateData.length;a++){
		  if(rateData[a] == rateId){
			 rateRay = rateData[a+1];
			 break;
		  }
		}

		var rateEcho = "";
		for(b=0;b<rateRay.length;b++){
		  if (b==rateRay.length-1){
			 rateEcho = document.getElementById("rateEcho");
			 rateEcho.innerHTML = rateRay[b];
			 break;
		  }
	   }
	}

	/**
	 * toggle - toggle showing itineraries for a period
	 */
	this.toggle = function(elem) {
		if (typeof elem != 'undefined' && elem != null) {
			var src = $(elem).attr("src");
			var newSrc = (src == "/resource/Resrequest/Application/public/img/property_expanded.gif") ? "/resource/Resrequest/Application/public/img/property_collapsed.gif" : "/resource/Resrequest/Application/public/img/property_expanded.gif";
			$(elem).attr("src", newSrc);
			var tr = $("#trItineraries_" + $(elem).prop("id").split("_")[1]);
			tr.toggle();
			this.itineraryDivPosition();
		}
	}

	/**
	 * toggleAll - toggle showing all itineraries for all periods
	 */
	this.toggleAll = function(img) {
		if (img) {
			if (img.src.indexOf("/resource/Resrequest/Application/public/img/property_expanded.gif") > 0) {
				var newSrc = "/resource/Resrequest/Application/public/img/property_collapsed.gif";
				img.src = newSrc;
				$("[name='toggleImage']").each(function() {
					$("#trItineraries_" + $(this).prop("id").split("_")[1]).hide();
					$(this).attr("src", newSrc);
				});
			} else {
				var newSrc = "/resource/Resrequest/Application/public/img/property_expanded.gif";
				img.src = newSrc;
				$("[name='toggleImage']").each(function() {
					$("#trItineraries_" + $(this).prop("id").split("_")[1]).show();
					$(this).attr("src", newSrc);
				});
			}
		} else {
			$("[name='toggleImage']").each(function() {
				$("#trItineraries_" + $(this).prop("id").split("_")[1]).toggle();
				var newSrc = ($(this).attr("src") == "/resource/Resrequest/Application/public/img/property_collapsed.gif") ? "/resource/Resrequest/Application/public/img/property_expanded.gif" : "/resource/Resrequest/Application/public/img/property_collapsed.gif";
				$(this).attr("src", newSrc);
			});
		}
		this.itineraryDivPosition();
	}

	/**
	 * reloadOverbookings - reload overbooking count as a total and for each period
	 */
	this.reloadOverbookings = function() {
		$("#spaOverbookings").html("<img src='/resource/Resrequest/Application/public/img/wait16.gif' />");
		$("span[id^='spaPeriodOverbookings']").html("<img src='/resource/Resrequest/Application/public/img/wait16.gif' />");
		this.setOverbookings();
	}

	this.setOverbookings = function() {
		aRequestReset();
		aRequestPost(actionViewUrl, this.afterSetOverbookings, ['bl_block_ix', 'getOverbookings'], [id('hidBlockNumber').value,'true']);
	}

	this.afterSetOverbookings = function(cStatus,cData) {
		var t = this;
		if (!cStatus) {
			return;
		}
		cDataArray = cData.split("\n");
		try {
			payload = JSON.parse(cDataArray[0]);
		}catch(e){
			payload = {"result": "fail"};
		}
		var overbookingItems = payload['overbookings'];
		var totalOverbookings = 0;
		$.each(overbookingItems, function(key, value) {
			if (Object.prototype.toString.call(value) === '[object Object]') {
				totalOverbookings += parseInt(Object.keys(value).length);
				$("#spaPeriodOverbookings" + key).html(Object.keys(value).length);
			}
		});
		$("#spaOverbookings").html(totalOverbookings);
		// If no overbooking info is found - set to 0
		$("#spaOverbookings").find("img").replaceWith("0");
		$("span[id^='spaPeriodOverbookings']").find("img").replaceWith("0");
	}

	/**
	 * periodViewOverbookings - open the agent/allocation popup and show only overbooked item blocks
	 */
	this.periodViewOverbookings = function(elem) {
		if (this.hasAllocations($(elem).attr("bl_block_period_ix"))) {
			if (this.hasAllocations($(elem).attr("bl_block_period_ix"))) {
				var allocation_id = $(elem).attr("allocation_id");
				openPopup("reservation.php?270+"+id("rv_agent_id").value+"+"+allocation_id+"+++++1",700,600);
			} else {
				showMessage("This period does not yet have any overbookings");
			}
		} else {
			showMessage("This period does not yet have any allocations and therefore no overbookings");
		}
	}

	this.checkUnsaved = function() {
		var changed = (typeof changedFilter != 'undefined') ? changedFilter : false;
		var trUpdate = $("tr[action='update']").length;
		var trNew = $("tr[action='new']").length;
		var trEdit = $("tr[action='edit']").length;
		if (trUpdate > 0 || trNew > 0 || trEdit > 0 || changed == true) {
			showMessage("You have unsaved data. Please save unsaved data before completing this action");
			return false;
		}
	}

	this.hasAllocations = function(bl_block_period_ix) {
		var hasAllocations = false;
		var strPeriod = "";

		if (typeof bl_block_period_ix != 'undefined') {
			strPeriod = "[bl_block_period_ix='" + bl_block_period_ix + "']";
		}
		$("tr[recordtype='period']" + strPeriod + ":not([action='new']) td:nth-child(6)").each(function() {
			var expiredTotalAllocations = $(this).find("span").html().split("/");
			if (expiredTotalAllocations.length > 0) {
				if (typeof parseInt(expiredTotalAllocations[1]) == "number") {
					if (parseInt(expiredTotalAllocations[1]) > 0) {
						hasAllocations = true;
					}
				}
			}
		});
		return hasAllocations;
	}

	this.hasReservations = function() {
		var hasReservations = false;
		$("tr[recordtype='period'] td:nth-child(7)").each(function() {
			var numberReservations = $(this).find("span").html();
			if (typeof numberReservations == "number") {
				if (parseInt(numberReservations) > 0) {
					hasReservations = true;
				}
			}
		});
		return hasReservations;
	}

	this.hasOverbookings = function() {
		var hasOverbookings = false;
		$("tr[recordtype='period'] td:nth-child(8)").each(function() {
			var numberOverbookings = $(this).find("span").html();
			if (typeof numberOverbookings == "number") {
				if (parseInt(numberOverbookings) > 0) {
					hasOverbookings = true;
				}
			}
		});
		return hasOverbookings;
	}

	this.getAgentDefaultRate = function() {
		if (blockbookingdetails.pagemode == "modeNew") {
			$("#ddRateSelectLabel").addClass("element_loading");

			var sNames = [
				'getAgentDefaultRate',
				'rv_agent_id'
			];
			var sValues	= [
				"true",
				id('rv_agent_id').value
			];
			aRequestReset();
			aRequestPost(actionNewUrl, blockbookingdetails.afterGetAgentDefaultRate, sNames, sValues);
		}
	}

	this.afterGetAgentDefaultRate = function(cStatus,cData) {
		if (!cStatus) {
			return;
		}
		cDataArray = cData.split("\n");
		try {
			payload = JSON.parse(cDataArray[0]);
		}catch(e){
			payload = {"result": "fail"};
		}
		if (payload["result"] != "success") {
			showMessage("There was an error getting the default rate for the selected agent","Error",261,140);
		} else {
			var rt_rate_type_id = payload["rt_rate_type_id"];
			$("#hidAgentDefaultRate").val(rt_rate_type_id);
			var rate_description = payload["rate_description"];
			$("#ddRateSelectLabel").val(rate_description);
			$("#ddRateSelectLabel").removeClass("element_loading");
		}
		changedFilter = false;
	}
}

function click() {
	if (id("divPeriodMenu")) {
		id("divPeriodMenu").style.display = "none";
	}
	if (id("divItineraryMenu")) {
		id("divItineraryMenu").style.display = "none";
	}
}

