// Variables requiring different scope due to aRequestPost
var pagemode = null;
var readOnly = null;
var bl_block_period_ix = null;
var periodTable = null;

/**
 * dlgBlockPeriod - a modal dialog to show block period details
 * @param string bl_block_ix
 * @param <jQuery text input object> invokerElement
 * @param string url
 * @param string title
 * @param int h
 * @param int w
 * @param string periodTable
 * @param string bl_block_period_ix
 * @param obj periodDetails
 *
 * Requires:
 * 	- jquery
 * 	- simplemodal
 *
 * Example usage:
 *	var dlgblockperiod = new dlgBlockPeriod("RS123", "#btnPeriodAdd", "reservation.php?6009", "Add Block Period", 600, 650, "tblBlockBookingPeriods");
 *	dlgblockperiod.init();
 *
 */
this.dlgBlockPeriod = function(bl_block_ix, invokerElement, url, title, h, w, periodTable, bl_block_period_ix, periodDetails) {
	// Set parameter scope
	this.bl_block_ix = bl_block_ix;
	this.invokerElement = invokerElement;
	this.url = url;
	this.title = title;
	this.h = h;
	this.w = w;
	this.periodTable = (typeof periodTable != 'undefined') ? periodTable : null;
	this.bl_block_period_ix = (typeof bl_block_period_ix != 'undefined') ? bl_block_period_ix : null;
	this.periodDetails = (typeof periodDetails != 'undefined') ? periodDetails : null;

	// Declare other global parameters
	this.message = null;
	this.validator = new Validator();
	this.allocation_id = null;
	this.hasAllocation = false;
	this.canOverbook = false;
	this.sNames = [];
	this.sValues = [];
	this.saveUrl = null;
	this.pagemode = null;

	this.init = function () {
		var t = this;
		// load the dialog css
		if (document.createStyleSheet) {
			// for ie
			document.createStyleSheet('/resource/Resrequest/Application/public/css/dialog.css');
		} else {
			$("head").append($("<link rel='stylesheet' href='/resource/Resrequest/Application/public/css/dialog.css' type='text/css' media='screen' />"));
		}
		// If this dialog isn't invoked by clicking on a specific element, it is to display details of
		// an existing period - so load the dialog upon initialisation
		if (typeof this.invokerElement != 'undefined' && this.invokerElement != null && this.invokerElement != "") {
			$(invokerElement).click(function (e) {
				if (!e) { e = window.event; }
				stopBubble(e);
				e.preventDefault();
				t.generateDialog();
			});
		} else {
			t.generateDialog();
		}
	}

	this.generateDialog = function() {
		var t = this;
		wait.show('circle');

		// load the dialog form using ajax
		$.get(t.url, function(data){
			// create a modal dialog with the data
			$(data).modal({
                closeHTML: "<i class='material-icons modal-close' style='color: white; cursor: pointer;'>close</i>",
				overlayId: 'dialog-overlay',
				containerId: 'dialog-container',
				zIndex: 80, // above main menu and also above "Req received; Contact us and Logoff"
				containerCss:{
					height:h,
					width:w
				},
				autoPosition: true,
				escClose: true,
				onOpen: function (dialog) {
					dialog.overlay.fadeIn(1, function () {
						dialog.container.fadeIn(1, function () {
							dialog.data.fadeIn(1, function () {
								$('#dialog-container form').fadeIn(1, function () {
									wait.hide();
								});
							});
						});
					});
				},
				onShow: function (dialog) {
					$('#tdTitle').html(t.title);
					t.validator.validateAll();
					t.validator.addConstraints();

					t.allocation_id = id("hidAllocationId").value;
					t.hasAllocation = (t.allocation_id == "") ? false : true;
					t.canOverbook = id("hidPeriodCanOverbook").value;
					t.pagemode = id("block_booking_period_mode").value;
					pagemode = t.pagemode;
					readOnly = t.readOnly;
					bl_block_period_ix = t.bl_block_period_ix;
					periodTable = t.periodTable;
					if (!t.canOverbook) {
						$("#btnAddPeriod").hide();
						$("#btnCancel").show();
					}
					$("#divBlockPeriod input:radio").click(function() {
						var radioId = $(this).prop("id");
						switch(radioId) {
							case 'radWeeklyWeekday':
								t.resetRecurrencePeriod();
								id("selWeeklyWeekday").disabled = false;
								id("selMonthlyDay").disabled = true;
								id("selOrdinalWeekOfMonth").disabled = true;
								id("selOrdinalOfMonthWeekday").disabled = true;
								id("selIntervalMonthOffsetInterval").disabled = true;
								id("selIntervalMonthOffsetDay").disabled = true;
								id("selIntervalMonthOffsetBeforeAfter").disabled = true;
								id("selIntervalMonthOrdinalWeekInterval").disabled = true;
								id("selIntervalMonthOrdinalWeekOrdinalWeek").disabled = true;
								id("selIntervalMonthOrdinalWeekWeekday").disabled = true;
								id("txtIntervalNumberDays").disabled = true;
								break;
							case 'radMonthlyDay':
								t.resetRecurrencePeriod();
								id("selWeeklyWeekday").disabled = true;
								id("selMonthlyDay").disabled = false;
								id("selOrdinalWeekOfMonth").disabled = true;
								id("selOrdinalOfMonthWeekday").disabled = true;
								id("selIntervalMonthOffsetInterval").disabled = true;
								id("selIntervalMonthOffsetDay").disabled = true;
								id("selIntervalMonthOffsetBeforeAfter").disabled = true;
								id("selIntervalMonthOrdinalWeekInterval").disabled = true;
								id("selIntervalMonthOrdinalWeekOrdinalWeek").disabled = true;
								id("selIntervalMonthOrdinalWeekWeekday").disabled = true;
								id("txtIntervalNumberDays").disabled = true;
								break;
							case 'radOrdinalOfMonth':
								t.resetRecurrencePeriod();
								id("selWeeklyWeekday").disabled = true;
								id("selMonthlyDay").disabled = true;
								id("selOrdinalWeekOfMonth").disabled = false;
								id("selOrdinalOfMonthWeekday").disabled = false;
								id("selIntervalMonthOffsetInterval").disabled = true;
								id("selIntervalMonthOffsetDay").disabled = true;
								id("selIntervalMonthOffsetBeforeAfter").disabled = true;
								id("selIntervalMonthOrdinalWeekInterval").disabled = true;
								id("selIntervalMonthOrdinalWeekOrdinalWeek").disabled = true;
								id("selIntervalMonthOrdinalWeekWeekday").disabled = true;
								id("txtIntervalNumberDays").disabled = true;
								break;
							case 'radIntervalMonthOffset':
								t.resetRecurrencePeriod();
								id("selWeeklyWeekday").disabled = true;
								id("selMonthlyDay").disabled = true;
								id("selOrdinalWeekOfMonth").disabled = true;
								id("selOrdinalOfMonthWeekday").disabled = true;
								id("selIntervalMonthOffsetInterval").disabled = false;
								id("selIntervalMonthOffsetDay").disabled = false;
								id("selIntervalMonthOffsetBeforeAfter").disabled = false;
								id("selIntervalMonthOrdinalWeekInterval").disabled = true;
								id("selIntervalMonthOrdinalWeekOrdinalWeek").disabled = true;
								id("selIntervalMonthOrdinalWeekWeekday").disabled = true;
								id("txtIntervalNumberDays").disabled = true;
								break;
							case 'radIntervalMonthOrdinalWeek':
								t.resetRecurrencePeriod();
								id("selWeeklyWeekday").disabled = true;
								id("selMonthlyDay").disabled = true;
								id("selOrdinalWeekOfMonth").disabled = true;
								id("selOrdinalOfMonthWeekday").disabled = true;
								id("selIntervalMonthOffsetInterval").disabled = true;
								id("selIntervalMonthOffsetDay").disabled = true;
								id("selIntervalMonthOffsetBeforeAfter").disabled = true;
								id("selIntervalMonthOrdinalWeekInterval").disabled = false;
								id("selIntervalMonthOrdinalWeekOrdinalWeek").disabled = false;
								id("selIntervalMonthOrdinalWeekWeekday").disabled = false;
								id("txtIntervalNumberDays").disabled = true;
								break;
							case 'radIntervalNumberDays':
								t.resetRecurrencePeriod();
								id("selWeeklyWeekday").disabled = true;
								id("selMonthlyDay").disabled = true;
								id("selOrdinalWeekOfMonth").disabled = true;
								id("selOrdinalOfMonthWeekday").disabled = true;
								id("selIntervalMonthOffsetInterval").disabled = true;
								id("selIntervalMonthOffsetDay").disabled = true;
								id("selIntervalMonthOffsetBeforeAfter").disabled = true;
								id("selIntervalMonthOrdinalWeekInterval").disabled = true;
								id("selIntervalMonthOrdinalWeekOrdinalWeek").disabled = true;
								id("selIntervalMonthOrdinalWeekWeekday").disabled = true;
								id("txtIntervalNumberDays").disabled = false;
								break;
							case 'radExpiryDays':
								t.resetExpiry();
								id("txtExpiryLeadTimeAmt").disabled = false;
								id("selExpiryDay").disabled = true;
								id("selExpiryMonth").disabled = true;
								id("selExpiryYear").disabled = true;
								break;
							case 'radExpiryDate':
								t.resetExpiry();
								var today = new Date();
								var dd = today.getDate();
								var mm = today.getMonth()+1;
								var yyyy = today.getFullYear();
								id("txtExpiryLeadTimeAmt").disabled = true;
								id("selExpiryDay").disabled = false;
								id("selExpiryDay").value = dd;
								id("selExpiryMonth").disabled = false;
								id("selExpiryMonth").value = mm;
								id("selExpiryYear").disabled = false;
								id("selExpiryYear").value = yyyy;
								break;
							default:
								break;
						}
					});
					$("#btnAddPeriod").click(function() {
						// If the periods (HTML) table is defined, append values to it
						// so that values may be saved in bulk, else save directly to db
						if (t.validate()) {
							var isUnsavedPeriod = (t.periodDetails != null && t.periodDetails.attr("action") == "new");
							if (t.periodTable != null && (isUnsavedPeriod || t.bl_block_period_ix == null)) {
								t.addPeriodTableRow();
								$.modal.close();
								window.scrollTo(0, document.body.scrollHeight);
							} else {
								t.saveConfirm();
							}
						}
					});
					$("#selFirstSeriesDay, #selFirstSeriesMonth, #selFirstSeriesYear").click(function(){
						t.dayMonthChanged("FirstSeries");
					});
					$("#selLastSeriesDay, #selLastSeriesMonth, #selLastSeriesYear").click(function(){
						t.dayMonthChanged("LastSeries");
					});

					t.pageView();
				},
			});
		});
	}

	this.validate = function () {
		this.message = [];
		var selFirstSeriesDayValue	= selValue("selFirstSeriesDay");
		var selFirstSeriesMonthIndex = id("selFirstSeriesMonth").selectedIndex;
		var selFirstSeriesMonthValue = selValue("selFirstSeriesMonth");
		var txtFirstSeriesYearValue = id("selFirstSeriesYear").value;
		var selLastSeriesDayValue = selValue("selLastSeriesDay");
		var selLastSeriesMonthIndex = id("selLastSeriesMonth").selectedIndex;
		var selLastSeriesMonthValue = selValue("selLastSeriesMonth");
		var txtLastSeriesYearValue = id("selLastSeriesYear").value;
		var radRecurrenceValue = $("input[name='radRecurrence']:checked").val();
		var radExpiryValue = $("input[name='radExpiry']:checked").val();

		if (selFirstSeriesDayValue == 0) {
			id("selFirstSeriesDay").focus();
			this.message.push("Select a start day for 'Start date of first series'.");
		}
		if (selFirstSeriesMonthIndex == 0) {
			id("selFirstSeriesMonth").focus();
			this.message.push("Select a start month for 'Start date of first series'.");
		}
		if (txtFirstSeriesYearValue == "" || isNaN(txtFirstSeriesYearValue)) {
			id("selFirstSeriesYear").focus();
			this.message.push("Enter a valid start year for 'Start date of first series'.");
		}
		if (selLastSeriesDayValue == 0) {
			id("selLastSeriesDay").focus();
			this.message.push("Select a start day for 'Start date of last series'.");
		}
		if (selLastSeriesMonthIndex == 0) {
			id("selLastSeriesMonth").focus();
			this.message.push("Select a start month for 'Start date of last series'.");
		}
		if (txtLastSeriesYearValue == "" || isNaN(txtLastSeriesYearValue)) {
			id("selLastSeriesYear").focus();
			this.message.push("Enter a valid start year for 'Start date of last series'.");
		}

		var today = new Date();
		var dd = today.getDate();
		var mm = today.getMonth()+1;
		var yyyy = today.getFullYear();
		today = new Date(yyyy + "/" + mm + "/" + dd);

		var fromDate = new Date(txtFirstSeriesYearValue + "/" + selFirstSeriesMonthValue + "/" + selFirstSeriesDayValue);
		var toDate = new Date(txtLastSeriesYearValue + "/" + selLastSeriesMonthValue + "/" + selLastSeriesDayValue);

		if (!this.hasAllocation) {
			if (fromDate < today) {
				id("selFirstSeriesDay").focus();
				this.message.push("'Start date of first block' should be today or a date in the future");
			}
			if (toDate < today) {
				id("selLastSeriesDay").focus();
				this.message.push("'Start date of last block' should be today or a date in the future");
			}
			var dateDiff = (toDate.getTime() - fromDate.getTime()) / 86400000; // number of milliseconds in a day
			if (dateDiff <= 0) {
				id("selFirstSeriesDay").focus();
				this.message.push("The 'Start date of last series' must be a date after 'Start date of first series'.");
			}
		}

		if (radRecurrenceValue == null) {
			this.message.push("Choose a 'Recurrence period'.");
		} else {
			switch(radRecurrenceValue) {
				case '1':
					if (id("selWeeklyWeekday").selectedIndex == 0) {
						id("selWeeklyWeekday").focus();
						this.message.push("Select a 'Recurrence period' weekday.");
					}
					break;
				case '2':
					if (id("selMonthlyDay").selectedIndex == 0) {
						id("selMonthlyDay").focus();
						this.message.push("Select a 'Recurrence period' day of the month.");
					}
					break;
				case '3':
					if (id("selOrdinalWeekOfMonth").selectedIndex == 0) {
						id("selOrdinalWeekOfMonth").focus();
						this.message.push("Select a 'Recurrence period' ordinal week.");
					}
					if (id("selOrdinalOfMonthWeekday").selectedIndex == 0) {
						id("selOrdinalOfMonthWeekday").focus();
						this.message.push("Select a 'Recurrence period' weekday.");
					}
					break;
				case '4':
					if (id("selIntervalMonthOffsetInterval").selectedIndex == 0 || id("selIntervalMonthOffsetDay").selectedIndex == 0 || id("selIntervalMonthOffsetBeforeAfter").selectedIndex == 0) {
						id("selIntervalMonthOffsetInterval").focus();
						this.message.push("Enter all 'Recurrence period' values correctly.");
					}
					break;
				case '5':
					if (id("selIntervalMonthOrdinalWeekInterval").selectedIndex == 0 || id("selIntervalMonthOrdinalWeekOrdinalWeek").selectedIndex == 0 || id("selIntervalMonthOrdinalWeekWeekday").selectedIndex == 0) {
						id("selIntervalMonthOrdinalWeekInterval").focus();
						this.message.push("Enter all 'Recurrence period' values correctly.");
					}
					break;
				default:
					break;
			}
		}
		if (radExpiryValue == null) {
			this.message.push("Choose an 'Expiry'.");
		} else {
			switch(radExpiryValue) {
				case '1':
					if (id("txtExpiryLeadTimeAmt").value == "") {
						this.message.push("Enter a 'Lead time'.");
						id("txtExpiryLeadTimeAmt").focus();
					}
					break;
				case '2':
					var selExpiryDayValue = selValue("selExpiryDay");
					var selExpiryMonthValue = selValue("selExpiryMonth");
					var txtExpiryYearValue = id("selExpiryYear").value;
					var expiryDate = new Date(txtExpiryYearValue + "/" + selExpiryMonthValue + "/" + selFirstSeriesDayValue);
					var today = new Date();
					var dd = today.getDate();
					var mm = today.getMonth()+1;
					var yyyy = today.getFullYear();
					today = new Date(yyyy + "/" + mm + "/" + dd);
					if (!isValidDate(expiryDate)) {
						this.message.push("Enter a valid expiry 'Date'.");
						id("txtExpiryLeadTimeAmt").focus();
					}
					if (!this.hasAllocation) {
						if (expiryDate < today) {
							this.message.push("Enter an expiry 'Date' after or on today's date.");
							id("selExpiryDay").focus();
						}
					}
					break;
				default:
					this.message.push("Choose an 'Expiry'.");
					break;
			}
		}

		this.validator.validateAll();

		if (this.message.length > 0 || $("#divBlockPeriod .validate_error").length > 0) {
			if (this.message.length > 0) {
				showValidationList(this.message, "Validation failure", 300, 200);
			}
			return false;
		}
		else {
			return true;
		}
	}

	this.pageView = function() {
		switch (this.pagemode) {
			case "modeNew":
				var today = new Date();
				var dd = today.getDate();
				var mm = today.getMonth()+1;
				var yyyy = today.getFullYear();
				id("selFirstSeriesDay").value = dd;
				id("selFirstSeriesMonth").value = mm;
				id("selFirstSeriesYear").value = yyyy;
				id("selLastSeriesDay").value = dd;
				id("selLastSeriesMonth").value = mm;
				id("selLastSeriesYear").value = yyyy;
				this.validator.validateAll();
				$('#selFirstSeriesDay').focus();
				break;
			case "modeEdit":
				var useUnsavedDetails = typeof this.periodDetails != 'undefined' && this.periodDetails.attr("action") == "new";
				var btnAddPeriodText = useUnsavedDetails?"Go":"Save";
				$("#btnAddPeriod span").html(btnAddPeriodText);
				var bl_per_date_start_series_fst = useUnsavedDetails?new Date(this.periodDetails.attr("bl_per_date_start_series_fst")):new Date(id("bl_per_date_start_series_fst").value);
				var bl_per_date_start_series_lst = useUnsavedDetails?new Date(this.periodDetails.attr("bl_per_date_start_series_lst")):new Date(id("bl_per_date_start_series_lst").value);
				var bl_per_recurrence_per_ind = useUnsavedDetails?this.periodDetails.attr("bl_per_recurrence_per_ind"):id("bl_per_recurrence_per_ind").value;
				var bl_per_recurrence_per_1 = useUnsavedDetails?this.periodDetails.attr("bl_per_recurrence_per_1"):id("bl_per_recurrence_per_1").value;
				var bl_per_recurrence_per_2 = useUnsavedDetails?this.periodDetails.attr("bl_per_recurrence_per_2"):id("bl_per_recurrence_per_2").value;
				var bl_per_recurrence_per_3 = useUnsavedDetails?this.periodDetails.attr("bl_per_recurrence_per_3"):id("bl_per_recurrence_per_3").value;
				var bl_per_recurrence_per_4 = useUnsavedDetails?this.periodDetails.attr("bl_per_recurrence_per_4"):id("bl_per_recurrence_per_4").value;
				var bl_per_recurrence_per_5 = useUnsavedDetails?this.periodDetails.attr("bl_per_recurrence_per_5"):id("bl_per_recurrence_per_5").value;
				var bl_per_expiry_ind = useUnsavedDetails?this.periodDetails.attr("bl_per_expiry_ind"):id("bl_per_expiry_ind").value;
				var bl_per_expiry_lead_time_days = useUnsavedDetails?this.periodDetails.attr("bl_per_expiry_lead_time_days"):id("bl_per_expiry_lead_time_days").value;
				var bl_per_expiry_lead_time_date = useUnsavedDetails?new Date(this.periodDetails.attr("bl_per_expiry_lead_time_date")):((id("bl_per_expiry_lead_time_date").value != "") ? new Date(id("bl_per_expiry_lead_time_date").value) : "");

				id("selFirstSeriesMonth").value = bl_per_date_start_series_fst.getMonth() + 1;
				id("selFirstSeriesYear").value = bl_per_date_start_series_fst.getFullYear();
				setDayList(id("selFirstSeriesDay"),id("selFirstSeriesMonth").value,id("selFirstSeriesYear").value);
				id("selFirstSeriesDay").value = bl_per_date_start_series_fst.getDate();
				id("selLastSeriesMonth").value = bl_per_date_start_series_lst.getMonth() + 1;
				id("selLastSeriesYear").value = bl_per_date_start_series_lst.getFullYear();
				setDayList(id("selLastSeriesDay"),id("selLastSeriesMonth").value,id("selLastSeriesYear").value);
				id("selLastSeriesDay").value = bl_per_date_start_series_lst.getDate();
				switch(bl_per_recurrence_per_ind) {
					case '1':
						$("#radWeeklyWeekday").click();
						id("selWeeklyWeekday").value = bl_per_recurrence_per_1;
						break;
					case '2':
						$("#radMonthlyDay").click();
						id("selMonthlyDay").value = bl_per_recurrence_per_1;
						break;
					case '3':
						$("#radOrdinalOfMonth").click();
						id("selOrdinalWeekOfMonth").value = bl_per_recurrence_per_2;
						id("selOrdinalOfMonthWeekday").value = bl_per_recurrence_per_1;
						break;
					case '4':
						$("#radIntervalMonthOffset").click();
						id("selIntervalMonthOffsetInterval").value = bl_per_recurrence_per_4;
						id("selIntervalMonthOffsetDay").value = bl_per_recurrence_per_1;
						id("selIntervalMonthOffsetBeforeAfter").value = bl_per_recurrence_per_5;
						break;
					case '5':
						$("#radIntervalMonthOrdinalWeek").click();
						id("selIntervalMonthOrdinalWeekInterval").value = bl_per_recurrence_per_4;
						id("selIntervalMonthOrdinalWeekOrdinalWeek").value = bl_per_recurrence_per_3;
						id("selIntervalMonthOrdinalWeekWeekday").value = bl_per_recurrence_per_1;
						break;
					case '6':
						$("#radIntervalNumberDays").click();
						id("txtIntervalNumberDays").value = bl_per_recurrence_per_4;
						break;
					default:
						break;
				}
				switch(bl_per_expiry_ind) {
					case '1':
						$("#radExpiryDays").click();
						id("txtExpiryLeadTimeAmt").value = bl_per_expiry_lead_time_days;
						break;
					case '2':
						$("#radExpiryDate").click();
						if (bl_per_expiry_lead_time_date != "") {
							id("selExpiryDay").value = bl_per_expiry_lead_time_date.getDate();
							id("selExpiryMonth").value = bl_per_expiry_lead_time_date.getMonth() + 1;
							id("selExpiryYear").value = bl_per_expiry_lead_time_date.getFullYear();
						}
						break;
					default:
						break;
				}
				$('#selFirstSeriesDay').focus();

				if (this.hasAllocation) {
					$("#spaBlockPeriodDescription").html("<i>Note: This period already has allocations therefore not all values can be saved</i>");
					id("selFirstSeriesDay").disabled = true;
					id("selFirstSeriesMonth").disabled = true;
					id("selFirstSeriesYear").disabled = true;
					id("selLastSeriesDay").disabled = true;
					id("selLastSeriesMonth").disabled = true;
					id("selLastSeriesYear").disabled = true;
					id("selWeeklyWeekday").disabled = true;
					id("selMonthlyDay").disabled = true;
					id("selOrdinalWeekOfMonth").disabled = true;
					id("selOrdinalOfMonthWeekday").disabled = true;
					id("selIntervalMonthOffsetInterval").disabled = true;
					id("selIntervalMonthOffsetDay").disabled = true;
					id("selIntervalMonthOffsetBeforeAfter").disabled = true;
					id("selIntervalMonthOrdinalWeekInterval").disabled = true;
					id("selIntervalMonthOrdinalWeekOrdinalWeek").disabled = true;
					id("selIntervalMonthOrdinalWeekWeekday").disabled = true;
					id("txtIntervalNumberDays").disabled = true;
					id("radWeeklyWeekday").disabled = true;
					id("radMonthlyDay").disabled = true;
					id("radOrdinalOfMonth").disabled = true;
					id("radIntervalMonthOffset").disabled = true;
					id("radIntervalMonthOrdinalWeek").disabled = true;
					id("radIntervalNumberDays").disabled = true;
				}
				this.validator.validateAll();
				break;
			case "modeView":
				this.readOnly();
				break;
			default:
				this.readOnly();
				break;
		}
	}

	this.readOnly = function() {
		id("selFirstSeriesDay").disabled = true;
		id("selFirstSeriesMonth").disabled = true;
		id("selFirstSeriesYear").disabled = true;
		id("selLastSeriesDay").disabled = true;
		id("selLastSeriesMonth").disabled = true;
		id("selLastSeriesYear").disabled = true;
		id("selWeeklyWeekday").disabled = true;
		id("selMonthlyDay").disabled = true;
		id("selOrdinalWeekOfMonth").disabled = true;
		id("selOrdinalOfMonthWeekday").disabled = true;
		id("selIntervalMonthOffsetInterval").disabled = true;
		id("selIntervalMonthOffsetDay").disabled = true;
		id("selIntervalMonthOffsetBeforeAfter").disabled = true;
		id("selIntervalMonthOrdinalWeekInterval").disabled = true;
		id("selIntervalMonthOrdinalWeekOrdinalWeek").disabled = true;
		id("selIntervalMonthOrdinalWeekWeekday").disabled = true;
		id("txtIntervalNumberDays").disabled = true;
		id("txtExpiryLeadTimeAmt").disabled = true;
		id("selExpiryDay").disabled = true;
		id("selExpiryMonth").disabled = true;
		id("selExpiryYear").disabled = true;
		id("radWeeklyWeekday").disabled = true;
		id("radMonthlyDay").disabled = true;
		id("radOrdinalOfMonth").disabled = true;
		id("radIntervalMonthOffset").disabled = true;
		id("radIntervalMonthOrdinalWeek").disabled = true;
		id("radExpiryDays").disabled = true;
		id("radExpiryDate").disabled = true;
	}

	this.addPeriodTableRow = function() {
		if (this.validate()) {
			if (this.bl_block_period_ix != null) {
				$("#tbyBlockPeriodRows").find("[bl_block_period_ix='"+this.bl_block_period_ix+"']").remove();
			}
			var numberPeriods = ($(this.invokerElement).attr("numberPeriods") >= 0) ? $(this.invokerElement).attr("numberPeriods") : 0;
			var periodTr1 = $('<tr>');
			var randLetter = String.fromCharCode(65 + Math.floor(Math.random() * 26));
			var newTrId = randLetter + Date.now();

			periodTr1.attr("bl_block_period_ix", newTrId);
			periodTr1.mouseover(function() {
				overlib('Not saved. Click "Save" to save new items',LEFT, WIDTH, 120);
			});
			periodTr1.mouseout(function() {
				nd();
			});
			periodTr1.attr("action", "new"); // actions: new; update; delete
			periodTr1.attr("recordType", "period"); // blockRecordTypes: period; itinerary
			periodTr1.attr("bl_block_id", this.bl_block_ix);

			var selFirstSeriesMonthValue = (id("selFirstSeriesMonth").value.length < 2 ? "0" + id("selFirstSeriesMonth").value : id("selFirstSeriesMonth").value);
			var selFirstSeriesDayValue = (id("selFirstSeriesDay").value.length < 2 ? "0" + id("selFirstSeriesDay").value : id("selFirstSeriesDay").value);
			var firstSeriesDateStr = id("selFirstSeriesYear").value + "-" + selFirstSeriesMonthValue + "-" + selFirstSeriesDayValue;
			var firstSeriesDate = new Date(firstSeriesDateStr);
			periodTr1.attr("bl_per_date_start_series_fst", firstSeriesDateStr);

			var selLastSeriesMonthValue = (id("selLastSeriesMonth").value.length < 2 ? "0" + id("selLastSeriesMonth").value : id("selLastSeriesMonth").value);
			var selLastSeriesDayValue = (id("selLastSeriesDay").value.length < 2 ? "0" + id("selLastSeriesDay").value : id("selLastSeriesDay").value);
			var lastSeriesDateStr = id("selLastSeriesYear").value + "-" + selLastSeriesMonthValue + "-" + selLastSeriesDayValue;
			var lastSeriesDate = new Date(lastSeriesDateStr);
			periodTr1.attr("bl_per_date_start_series_lst", lastSeriesDateStr);

			var firstSeriesDateDisplay = firstSeriesDate.getDate() + " " + firstSeriesDate.getMonthShortName() + " " + firstSeriesDate.getFullYear();
			var lastSeriesDateDisplay = lastSeriesDate.getDate() + " " + lastSeriesDate.getMonthShortName() + " " + lastSeriesDate.getFullYear();
			var recurrenceDisplay = "";
			var expiryDisplay = "";
			switch($("#divBlockPeriod input:radio[name='radRecurrence']:checked").prop("id")) {
				case 'radWeeklyWeekday':
					periodTr1.attr("bl_per_recurrence_per_ind", 1);
					periodTr1.attr("bl_per_recurrence_per_1", id("selWeeklyWeekday").value);
					periodTr1.attr("bl_per_recurrence_per_2", "");
					periodTr1.attr("bl_per_recurrence_per_3", "");
					periodTr1.attr("bl_per_recurrence_per_4", "");
					periodTr1.attr("bl_per_recurrence_per_5", "");
					recurrenceDisplay = "Weekly on " + id("selWeeklyWeekday").options[id("selWeeklyWeekday").selectedIndex].text;
					break;
				case 'radMonthlyDay':
					periodTr1.attr("bl_per_recurrence_per_ind", 2);
					periodTr1.attr("bl_per_recurrence_per_1", id("selMonthlyDay").value);
					periodTr1.attr("bl_per_recurrence_per_2", "");
					periodTr1.attr("bl_per_recurrence_per_3", "");
					periodTr1.attr("bl_per_recurrence_per_4", "");
					periodTr1.attr("bl_per_recurrence_per_5", "");
					recurrenceDisplay = "Monthly on the " + id("selMonthlyDay").options[id("selMonthlyDay").selectedIndex].text + " day of the month";
					break;
				case 'radOrdinalOfMonth':
					periodTr1.attr("bl_per_recurrence_per_ind", 3);
					periodTr1.attr("bl_per_recurrence_per_1", id("selOrdinalOfMonthWeekday").value);
					periodTr1.attr("bl_per_recurrence_per_2", id("selOrdinalWeekOfMonth").value);
					periodTr1.attr("bl_per_recurrence_per_3", "");
					periodTr1.attr("bl_per_recurrence_per_4", "");
					periodTr1.attr("bl_per_recurrence_per_5", "");
					recurrenceDisplay = "Every " + id("selOrdinalWeekOfMonth").options[id("selOrdinalWeekOfMonth").selectedIndex].text + " " + id("selOrdinalOfMonthWeekday").options[id("selOrdinalOfMonthWeekday").selectedIndex].text + " of the month";
					break;
				case 'radIntervalMonthOffset':
					periodTr1.attr("bl_per_recurrence_per_ind", 4);
					periodTr1.attr("bl_per_recurrence_per_1", id("selIntervalMonthOffsetDay").value);
					periodTr1.attr("bl_per_recurrence_per_2", "");
					periodTr1.attr("bl_per_recurrence_per_3", "");
					periodTr1.attr("bl_per_recurrence_per_4", id("selIntervalMonthOffsetInterval").value);
					periodTr1.attr("bl_per_recurrence_per_5", id("selIntervalMonthOffsetBeforeAfter").value);
					recurrenceDisplay = "Every " + id("selIntervalMonthOffsetInterval").options[id("selIntervalMonthOffsetInterval").selectedIndex].text + " month(s),  " + id("selIntervalMonthOffsetDay").options[id("selIntervalMonthOffsetDay").selectedIndex].text + " days " + id("selIntervalMonthOffsetBeforeAfter").options[id("selIntervalMonthOffsetBeforeAfter").selectedIndex].text + " of the month";
					break;
				case 'radIntervalMonthOrdinalWeek':
					periodTr1.attr("bl_per_recurrence_per_ind", 5);
					periodTr1.attr("bl_per_recurrence_per_1", id("selIntervalMonthOrdinalWeekWeekday").value);
					periodTr1.attr("bl_per_recurrence_per_2", "");
					periodTr1.attr("bl_per_recurrence_per_3", id("selIntervalMonthOrdinalWeekOrdinalWeek").value);
					periodTr1.attr("bl_per_recurrence_per_4", id("selIntervalMonthOrdinalWeekInterval").value);
					periodTr1.attr("bl_per_recurrence_per_5", "");
					recurrenceDisplay = "Every " + id("selIntervalMonthOrdinalWeekInterval").options[id("selIntervalMonthOrdinalWeekInterval").selectedIndex].text + " months " + " on the " + id("selIntervalMonthOrdinalWeekOrdinalWeek").options[id("selIntervalMonthOrdinalWeekOrdinalWeek").selectedIndex].text + " " + id("selIntervalMonthOrdinalWeekWeekday").options[id("selIntervalMonthOrdinalWeekWeekday").selectedIndex].text + " of the month";
					break;
				case 'radIntervalNumberDays':
					periodTr1.attr("bl_per_recurrence_per_ind", 6);
					periodTr1.attr("bl_per_recurrence_per_1", "");
					periodTr1.attr("bl_per_recurrence_per_2", "");
					periodTr1.attr("bl_per_recurrence_per_3", "");
					periodTr1.attr("bl_per_recurrence_per_4", id("txtIntervalNumberDays").value);
					periodTr1.attr("bl_per_recurrence_per_5", "");
					recurrenceDisplay = "Every " + id("txtIntervalNumberDays").value + " days";
					break;
				default:
					break;
			}
			switch($("#divBlockPeriod input:radio[name='radExpiry']:checked").prop("id")) {
				case 'radExpiryDays':
					periodTr1.attr("bl_per_expiry_ind", "1");
					periodTr1.attr("bl_per_expiry_lead_time_days", id("txtExpiryLeadTimeAmt").value);
					periodTr1.attr("bl_per_expiry_lead_time_date", "");
					expiryDisplay = "Lead time " + id("txtExpiryLeadTimeAmt").value + " day(s)";
					break;
				case 'radExpiryDate':
					periodTr1.attr("bl_per_expiry_ind", "2");
					periodTr1.attr("bl_per_expiry_lead_time_days", "");
					var expiryDateStr = id("selExpiryYear").value + "-" + id("selExpiryMonth").value + "-" + id("selExpiryDay").value;
					var expiryDate = new Date(expiryDateStr);
					periodTr1.attr("bl_per_expiry_lead_time_date", expiryDateStr);
					expiryDisplay = "On " + expiryDate.getDate() + " " + expiryDate.getMonthShortName() + " " + expiryDate.getFullYear();
					break;
				default:
					break;
			}
			$("#trNoPeriods").remove();
			var btnPeriodMenu = $("<input/>", {
				type: "button",
				text: "",
				bl_block_period_ix: newTrId,
				class: "button bDropDown",
				name: "btnPeriodMenu",
				css: {"width":"14px", "height":"18px", "background-position":"center center"},
				id: 'btnPeriodMenu_'+newTrId,
				onclick:  "blockbookingdetails.periodShowMenu(event, '" + newTrId + "');"
			});
			var toggleImage = "<img id='img_" + newTrId + "' onclick='blockbookingdetails.toggle(this);' src='/resource/Resrequest/Application/public/img/property_collapsed.gif' name='toggleImage'></img>";
			var firstSeriesDateDisplayTd = $("<td>");
			firstSeriesDateDisplayTd.prop("class", "bt");
			firstSeriesDateDisplayTd.html(firstSeriesDateDisplay);
			var lastSeriesDateDisplayTd = $("<td>");
			lastSeriesDateDisplayTd.prop("class", "bt");
			lastSeriesDateDisplayTd.html(lastSeriesDateDisplay);
			var recurrenceDisplayTd = $("<td>");
			recurrenceDisplayTd.prop("class", "bt");
			recurrenceDisplayTd.html(recurrenceDisplay);
			var expiryDisplayTd = $("<td>");
			expiryDisplayTd.prop("class", "txtvt bt");
			expiryDisplayTd.html(expiryDisplay);
			var allocationsTd = $("<td>");
			allocationsTd.prop("class", "bt");
			allocationsTd.html("&nbsp;");
			var drawDownsTd = $("<td>");
			drawDownsTd.prop("class", "bt");
			drawDownsTd.html("&nbsp;");
			var overbookingsTd = $("<td>");
			overbookingsTd.prop("class", "bt");
			overbookingsTd.html("&nbsp;");
			var periodButtonsTd = $("<td>").append(btnPeriodMenu);
			periodButtonsTd.prop("class", "bt br");
			periodButtonsTd.prop("align", "center");
			periodTr1.append($("<td>").prop("class", "bl bt").html(toggleImage))
				.append(firstSeriesDateDisplayTd)
				.append(lastSeriesDateDisplayTd)
				.append(recurrenceDisplayTd)
				.append(expiryDisplayTd)
				.append(allocationsTd)
				.append(drawDownsTd)
				.append(overbookingsTd)
				.append(periodButtonsTd);
			periodTr1.find("td").addClass("linkRowUnsaved");
			$('#' + this.periodTable + ' > tbody:last')
				.append(periodTr1);
			$(this.invokerElement).attr("numberPeriods", parseInt(numberPeriods) + 1);
		}
	}

	this.saveConfirm = function() {
		var t = this;
		// rememver values for dialog before it's closed
		t.setValues();
		$.modal.close();

		var w = 300;
		var h = 200;
		if (t.hasAllocation) {
			$(" <div id='dlgBlockOverbooking' class='dialog-content' style='display: none;'> <form action='#'> <div class='overlayPopup' style='background: white; class='outLtt'> <span> <table border='0' cellpadding='0' cellspacing='0' summary='' class='' width='100%' height='100%'> <tr> <td id='tdBlockOverbookingConfirmTitle' class='colDk bb txtb dialog-title' style='padding: 5px 10px;'></td> </tr> <tr> <td><img src='/resource/Resrequest/Application/public/img/1x1.gif' width='10' height='5' alt='' /></td> </tr> <tr> <td height='100%' id='tdBlockOverbookingConfirmMessage' style='padding: 10px;'> &nbsp; </td> </tr> <tr> <td colspan='4'><img src='/resource/Resrequest/Application/public/img/1x1.gif' height='10' alt='' /></td> </tr> <tr> <td height='20' colspan='4' align='center' class='colLt' style='padding: 5px;'> <button id='btnBlockOverbookingConfirmContinue' type='button' class='button masterButton' style='text-align: center;'> Continue </button> <button id='btnBlockOverbookingConfirmCancel' type='button' class='button' style='text-align: center;'> Cancel </button> </td> </tr> </table> </span>		</div> </form> </div>").modal({
				closeHTML: "<a href='#' title='Close' class='modal-close'><i class='material-icons modal-close simplemodal-close' style='color: white; cursor: pointer;'>close</i></a>",
				overlayId: 'dialog-overlay',
				containerId: 'dialog-container',
				zIndex: 80, // above main menu, also above "Req received; Contact us and Logoff"
				containerCss:{
          width:w,
          height:h
				},
				autoPosition: true,
				escClose: true,
				onOpen: function (dialog) {
					dialog.overlay.fadeIn(1, function () {
						dialog.container.fadeIn(1, function () {
							dialog.data.fadeIn(1, function () {
								$('#dialog-container form').fadeIn(1, function () {
								});
							});
						});
					});
				},
				onShow: function (dialog) {
					$('#tdBlockOverbookingConfirmTitle').html("Warning");
					if (t.canOverbook) {
						$("#tdBlockOverbookingConfirmMessage").html("Performing this action may result in a change in availability/stock or in overbookings. Do you want to continue and potentially overbook items?");
					}

					$("#btnBlockOverbookingConfirmContinue").click(function() {
						t.sValues[12] = true; // Do overbook
						$.modal.close();
						t.save();
					});
					$("#btnBlockOverbookingConfirmCancel").click(function() {
						$.modal.close();
					});
				},
				onClose: function (dialog) {
					$('#dialog-container .dialog-message').fadeOut();
					$('#dialog-container form').fadeOut(1);
					dialog.data.fadeOut(1, function () {
						dialog.container.fadeOut(1, function () {
							dialog.overlay.fadeOut(1, function () {
								$.modal.close();
							});
						});
					});
				}
			});
		} else {
			t.save();
		}
	}

	this.setValues = function() {
		var t = this;
		t.sNames = [
			'bl_block_period_ix',
			'bl_per_date_start_series_fst',
			'bl_per_date_start_series_lst',
			'bl_per_recurrence_per_ind',
			'bl_per_recurrence_per_1',
			'bl_per_recurrence_per_2',
			'bl_per_recurrence_per_3',
			'bl_per_recurrence_per_4',
			'bl_per_recurrence_per_5',
			'bl_per_expiry_ind',
			'bl_per_expiry_lead_time_days',
			'bl_per_expiry_lead_time_date',
			'adjustAllocationExpiry'
		];

		var selFirstSeriesMonthValue = (id("selFirstSeriesMonth").value.length < 2 ? "0" + id("selFirstSeriesMonth").value : id("selFirstSeriesMonth").value);
		var selFirstSeriesDayValue = (id("selFirstSeriesDay").value.length < 2 ? "0" + id("selFirstSeriesDay").value : id("selFirstSeriesDay").value);
		var bl_per_date_start_series_fst = id("selFirstSeriesYear").value + "-" + selFirstSeriesMonthValue + "-" + selFirstSeriesDayValue;

		var selLastSeriesMonthValue = (id("selLastSeriesMonth").value.length < 2 ? "0" + id("selLastSeriesMonth").value : id("selLastSeriesMonth").value);
		var selLastSeriesDayValue = (id("selLastSeriesDay").value.length < 2 ? "0" + id("selLastSeriesDay").value : id("selLastSeriesDay").value);
		var bl_per_date_start_series_lst = id("selLastSeriesYear").value + "-" + selLastSeriesMonthValue + "-" + selLastSeriesDayValue;

		var bl_per_recurrence_per_ind = null;
		var bl_per_recurrence_per_1 = null;
		var bl_per_recurrence_per_2 = null;
		var bl_per_recurrence_per_3 = null;
		var bl_per_recurrence_per_4 = null;
		var bl_per_recurrence_per_5 = null;

		switch($("#divBlockPeriod input:radio[name='radRecurrence']:checked").prop("id")) {
			case 'radWeeklyWeekday':
				bl_per_recurrence_per_ind = 1;
				bl_per_recurrence_per_1 = id("selWeeklyWeekday").value;
				bl_per_recurrence_per_2 =  "";
				bl_per_recurrence_per_3 =  "";
				bl_per_recurrence_per_4 =  "";
				bl_per_recurrence_per_5 =  "";
				break;
			case 'radMonthlyDay':
				bl_per_recurrence_per_ind = 2;
				bl_per_recurrence_per_1 = id("selMonthlyDay").value;
				bl_per_recurrence_per_2 =  "";
				bl_per_recurrence_per_3 =  "";
				bl_per_recurrence_per_4 =  "";
				bl_per_recurrence_per_5 =  "";
				break;
			case 'radOrdinalOfMonth':
				bl_per_recurrence_per_ind = 3;
				bl_per_recurrence_per_1 = id("selOrdinalOfMonthWeekday").value;
				bl_per_recurrence_per_2 =  id("selOrdinalWeekOfMonth").value;
				bl_per_recurrence_per_3 =  "";
				bl_per_recurrence_per_4 =  "";
				bl_per_recurrence_per_5 =  "";
				break;
			case 'radIntervalMonthOffset':
				bl_per_recurrence_per_ind = 4;
				bl_per_recurrence_per_1 = id("selIntervalMonthOffsetDay").value;
				bl_per_recurrence_per_2 =  "";
				bl_per_recurrence_per_3 =  "";
				bl_per_recurrence_per_4 =  id("selIntervalMonthOffsetInterval").value;
				bl_per_recurrence_per_5 =  id("selIntervalMonthOffsetBeforeAfter").value;
				break;
			case 'radIntervalMonthOrdinalWeek':
				bl_per_recurrence_per_ind = 5;
				bl_per_recurrence_per_1 = id("selIntervalMonthOrdinalWeekWeekday").value;
				bl_per_recurrence_per_2 =  "";
				bl_per_recurrence_per_3 =  id("selIntervalMonthOrdinalWeekOrdinalWeek").value;
				bl_per_recurrence_per_4 =  id("selIntervalMonthOrdinalWeekInterval").value;
				bl_per_recurrence_per_5 =  "";
				break;
			case 'radIntervalNumberDays':
				bl_per_recurrence_per_ind = 6;
				bl_per_recurrence_per_1 = "";
				bl_per_recurrence_per_2 =  "";
				bl_per_recurrence_per_3 =  "";
				bl_per_recurrence_per_4 =  id("txtIntervalNumberDays").value;
				bl_per_recurrence_per_5 =  "";
				break;
			default:
				break;
		}
		var bl_per_expiry_ind = 1;
		var bl_per_expiry_lead_time_days = null;
		var bl_per_expiry_lead_time_date = null;
		switch($("#divBlockPeriod input:radio[name='radExpiry']:checked").prop("id")) {
			case 'radExpiryDays':
				bl_per_expiry_ind = 1;
				bl_per_expiry_lead_time_days = id("txtExpiryLeadTimeAmt").value;
				bl_per_expiry_lead_time_date = "";
				break;
			case 'radExpiryDate':
				bl_per_expiry_ind = 2;
				bl_per_expiry_lead_time_days = id("txtExpiryLeadTimeAmt").value;
				var month = parseInt(id("selExpiryMonth").value) < 10 ? "0" + id("selExpiryMonth").value : id("selExpiryMonth").value;
				var day = parseInt(id("selExpiryDay").value) < 10 ? "0" + id("selExpiryDay").value : id("selExpiryDay").value;
				bl_per_expiry_lead_time_date = id("selExpiryYear").value + "-" + month + "-" + day;
				break;
			default:
				break;
		}
		t.sValues = [
			t.bl_block_period_ix,
			bl_per_date_start_series_fst,
			bl_per_date_start_series_lst,
			bl_per_recurrence_per_ind,
			bl_per_recurrence_per_1,
			bl_per_recurrence_per_2,
			bl_per_recurrence_per_3,
			bl_per_recurrence_per_4,
			bl_per_recurrence_per_5,
			bl_per_expiry_ind,
			bl_per_expiry_lead_time_days,
			bl_per_expiry_lead_time_date,
			false
		];
		t.saveUrl = dlgActionEditPersistUrl;
	}

	this.save = function() {
		wait.show('circle');

		var t = this;

		if (t.periodTable != null) {
			$('#' + this.periodTable + ' tr[bl_block_period_ix=' + t.bl_block_period_ix + '] td').eq(1).html("<img src='/resource/Resrequest/Application/public/img/wait16.gif' />");
			$('#' + this.periodTable + ' tr[bl_block_period_ix=' + t.bl_block_period_ix + '] td').eq(2).html("<img src='/resource/Resrequest/Application/public/img/wait16.gif' />");
			$('#' + this.periodTable + ' tr[bl_block_period_ix=' + t.bl_block_period_ix + '] td').eq(3).html("<img src='/resource/Resrequest/Application/public/img/wait16.gif' />");
			$('#' + this.periodTable + ' tr[bl_block_period_ix=' + t.bl_block_period_ix + '] td').eq(4).html("<img src='/resource/Resrequest/Application/public/img/wait16.gif' />");
			$('#' + this.periodTable + ' tr[bl_block_period_ix=' + t.bl_block_period_ix + '] td').eq(5).find("span").html("<img src='/resource/Resrequest/Application/public/img/wait16.gif' />");
		}
		aRequestPost(this.saveUrl, this.afterSave, this.sNames, this.sValues);
	}

	this.afterSave = function(cStatus,cData) {
		if (!cStatus) {
			return;
		}
		cDataArray = cData.split("\n");
		try {
			payload = JSON.parse(cDataArray[0]);
		}catch(e){
			payload = {"result": "fail"};
		}
		if (payload["result"] != "success") {
			showMessage("There was an error saving block period data","Error",261,140);
		} else {
			switch (pagemode) {
				case "modeNew":
					if (payload["reload"] == "true") {
						window.location = dlgActionEditUrl + "+" + blockPeriodRecord;
					}
					break;
				case "modeEdit":
					if (payload["reload"] == "true") {
						window.location = dlgActionEditUrl + "+" + blockPeriodRecord;
					} else {
						var periodDetails = payload['periodDetails'];
						$('#' + periodTable + ' tr[bl_block_period_ix=' + bl_block_period_ix + '] td').eq(1).html(periodDetails['bl_per_date_start_series_fst']);
						$('#' + periodTable + ' tr[bl_block_period_ix=' + bl_block_period_ix + '] td').eq(2).html(periodDetails['bl_per_date_start_series_lst']);
						$('#' + periodTable + ' tr[bl_block_period_ix=' + bl_block_period_ix + '] td').eq(3).html(periodDetails['recurrence']);
						$('#' + periodTable + ' tr[bl_block_period_ix=' + bl_block_period_ix + '] td').eq(4).html(periodDetails['expiry']);
						$('#' + periodTable + ' tr[bl_block_period_ix=' + bl_block_period_ix + '] td').eq(5).find("span").html(periodDetails['series_expired'] + "/" + periodDetails['series_total']);
					}
					break;
				case "modeView":
					break;
				default:
					readOnly();
					break;
			}
		}
		wait.hide();
	}

	this.resetRecurrencePeriod = function() {
		id("selWeeklyWeekday").selectedIndex = 0;
		id("selMonthlyDay").selectedIndex = 0;
		id("selOrdinalWeekOfMonth").selectedIndex = 0;
		id("selOrdinalOfMonthWeekday").selectedIndex = 0;
		id("selIntervalMonthOffsetInterval").selectedIndex = 0;
		id("selIntervalMonthOffsetDay").selectedIndex = 0;
		id("selIntervalMonthOffsetBeforeAfter").selectedIndex = 0;
		id("selIntervalMonthOrdinalWeekInterval").selectedIndex = 0;
		id("selIntervalMonthOrdinalWeekOrdinalWeek").selectedIndex = 0;
		id("selIntervalMonthOrdinalWeekWeekday").selectedIndex = 0;
	}

	this.resetExpiry = function() {
		id("txtExpiryLeadTimeAmt").value = "";
		id("selExpiryYear").value = "";
		id("selExpiryDay").selectedIndex = 0;
		id("selExpiryMonth").selectedIndex = 0;
	}

	this.dayMonthChanged = function(name) {
		dayObject = id("sel" + name + "Day");
		temp_month = id("sel" + name + "Month").selectedIndex;
		temp_year = id("sel" + name + "Year").value;

		setDayList(dayObject,temp_month,temp_year);
	}
};
