var enabledButtons = ["Back", "Forward", "Refresh", "Calendar", "Internet", "Home", "Help", "NewWindow"];

function initialisePage() {
	initTop();
	enableButtons(enabledButtons);
	$('#fullPageLoader').hide();
}

function loadItems() {
	$('#sales-items').addClass("collapse");

	let pr_business_id = $("#pr_business_id").val();
	if(pr_business_id == "") { // no invoicing unit selected
		return;
	}

	$('#fullPageLoader').show();
	aRequestPostEx("/reservation.php?1028", {
		action: "list_items",
		pr_business_id
	}, (data) => {
		$('#sales-item-list').empty();
		data.forEach((item) => {
			addItem(item);
		});
		if(data.length == 0) {
			addItem();
		}
		$('#sales-items').removeClass("collapse");
		$('#fullPageLoader').hide();
	});
}

function addItem(item) {
	if(!item) {
		item = {
			ac_pos_stock_ix: "",
			ac_pos_stock_code: "",
			ac_extra_id: "",
			ac_ext_desc: "",
			allow_edit: true,
			allow_delete: true
		}
	}

	$('#sales-item-list').append(`
			<div class="pos-sales-row" uk-grid>
				<input type="hidden" class="ac_pos_stock_ix" value="${encodeAttribute(item.ac_pos_stock_ix)}" />
				<input type="hidden" class="ac_extra_id" value="${encodeAttribute(item.ac_extra_id)}" />
				<div class="uk-width-expand">
					<input class="uk-input ac_pos_stock_code" value="${encodeAttribute(item.ac_pos_stock_code)}" ${item.allow_edit && !readOnly?"":"disabled"}>
				</div>
				<div class="uk-flex-inline uk-width-expand">
					<input disabled class="uk-input ac_ext_desc" value="${encodeAttribute(item.ac_ext_desc)}">
					<button class="btn btn-sqr btn-lgrey ac_extra_search" onclick="loadExtras(this)" ${item.allow_edit && !readOnly?"":"disabled"}>
						<i class="material-icons">search</i>
					</button>
				</div>
				<div class=${item.allow_delete?" uk-padding-remove ":""}>
					<button class="btn btn-sqr btn-dgrey uk-margin-left-xsm" onclick="deleteItem(this)" ${item.allow_delete && !readOnly?"":"disabled"}>
						<i class="material-icons">delete</i>
					</button>
				</div>
			</div>	
	`);

	$('#sales-item-list .ac_pos_stock_code').last().focus();
}

function deleteItem(obj) {
	$(obj).closest(".pos-sales-row").remove();
}

function saveItems() {
	let items = [];
	let validated = true;
	$('#sales-item-list').children("div").each(function() {
		let ac_pos_stock_ix = $(this).find(".ac_pos_stock_ix").val();
		let ac_pos_stock_code = $(this).find(".ac_pos_stock_code").val();
		let ac_extra_id = $(this).find(".ac_extra_id").val();
		
		if(ac_pos_stock_code.trim() == "") {
			$(this).find(".ac_pos_stock_code").focus();
			openMessage("Missing POS stock code");
			validated = false;
			return false;
		}

		if(ac_extra_id.trim() == "") {
			$(this).find(".ac_extra_search").focus();
			openMessage("Missing Extra");
			validated = false;
			return false;
		}
		
		items.push({
			ac_pos_stock_ix,
			ac_pos_stock_code,
			ac_extra_id
		});
	});

	if(!validated) {
		return false;
	}

	$('#fullPageLoader').show();
	let pr_business_id = $("#pr_business_id").val();
	aRequestPostEx("/reservation.php?1028", {
		action: "save_items",
		pr_business_id,
		items: JSON.stringify(items)
	}, (data) => {
		loadItems();
	});
}

let extraItem = "";
function loadExtras(obj) {
	let pr_business_id = $("#pr_business_id").val();
	if(pr_business_id == "") { // no invoicing unit selected
		return;
	}

	$('#fullPageLoader').show();
	aRequestPostEx("/reservation.php?1028", {
		action: "list_extras",
		pr_business_id
	}, (data) => {
		extraItem = obj;
		$('#extras-item-list').empty();
		data.forEach((item) => {
			addExtra(item);
		});
		if(data.length == 0) {
			$('#extras-item-list').append(`
				<div>
					<div class="uk-width-expand">
						<i>No extras found</i>
					</div>
				</div>	
			`);
		}
		$('#fullPageLoader').hide();
		UIkit.modal("#extrasDiv").show();
	});
}

function addExtra(item) {
	$('#extras-item-list').append(`
				<div class="extras-row uk-margin-remove-left tb-smaller-pop"  uk-grid onclick="selectExtra(this)">
					<input type="hidden" class="ac_extra_ix" value="${encodeAttribute(item.ac_extra_ix)}" />
					<div class="extra-category uk-width-expand ac_ext_desc uk-padding-remove-left">
						${encodeAttribute(item.ac_extra_cat_desc)}
					</div>
					<div class="extra-item uk-flex-inline uk-width-expand">
						${encodeAttribute(item.ac_ext_desc)}
					</div>
				</div>	
	`);
}

function closeExtras() {
	UIkit.modal("#extrasDiv").hide();
}

function selectExtra(obj) {
	let ac_ext_desc = $(obj).children("div").closest(".ac_ext_desc").text().trim();
	let ac_extra_id = $(obj).children("input").closest(".ac_extra_ix").val();
	$(extraItem).parent().parent().find(".ac_ext_desc").val(ac_ext_desc);
	$(extraItem).parent().parent().find(".ac_extra_id").val(ac_extra_id);

	closeExtras();
}

function filterSalesItems(){
	let search = document.getElementById("sales-item-filter").value.toLowerCase();
	document.querySelectorAll('.pos-sales-row').forEach(function(el, i){
		el.classList.add("collapse");
		let sales_row_code = el.querySelector('.ac_pos_stock_code').value;
		let sales_row_desc = el.querySelector('.ac_ext_desc').value;
		if (sales_row_code.toLowerCase().includes(search) || sales_row_desc.toLowerCase().includes(search)) {
			el.classList.remove('collapse');
		}
	});
}

function filterExtraCategories(){
	let search = document.getElementById("extra-category-filter").value.toLowerCase();
	document.querySelectorAll('.extras-row').forEach(function(el, i){
		el.classList.add("collapse");
		let extras_row_cat  = el.children[1].textContent;
		let extras_row_desc = el.children[2].textContent;
		if (extras_row_cat.toLowerCase().includes(search) || extras_row_desc.toLowerCase().includes(search)) {
			el.classList.remove('collapse');
		}
	});
}
