var enabledButtons = ["Back", "Forward", "Refresh", "Calendar", "Internet", "Home", "Help", "NewWindow"];


function initialisePage() {
	initTop();
	enableButtons(enabledButtons);
	$('#fullPageLoader').hide();
	$('#stock-location-list').hide();
	$('.save-new').show();
	$('th > i').hide();
	$('.actInd').hide();
	$('.firstSort').click();
}

function loadLocations() {
	$('#fullPageLoader').show();
	window.location.href = "/reservation.php?4001";

}

function deleteItem() {

	var buttons = {
		'a': {
			'id': 'btnDeleteLocationItem',
			'label': '&nbsp;&nbsp;Delete&nbsp;&nbsp;',
			'callback': 'doDeleteItem()',
			'class': 'btn_primary'
		},
		'b': {'label': 'Cancel', 'callback': 'closeOverlayPopup()', 'class': ''}
	};
	overlayPopup("Delete Stock Location", "<p> Are you sure you would like to delete this stock location? </p>", buttons, 400);
	return false;
}

function doDeleteItem() {
	if (!$('#ac_stock_ix').val()) {
		$('#pr_business_id').val("");
		$('#ac_stock_key_pos').val("");
		$('#ac_stock_name_rr').val("");
	} else {

		$('#fullPageLoader').show();
		aRequestPostEx("/reservation.php?4001", {
			action: "delete_location",
			ac_stock_ix: $('#ac_stock_ix').val()
		}, (data) => {
			loadLocations();
		});
	}
}

function validateEdit() {
	// check active/inactive
	document.getElementById('save-new').disabled = false;
}

function saveLocation() {
	let location = [];
	let validated = true;
	let ac_stock_ix = $('#ac_stock_ix').val();
	let pr_business_id = $('#pr_business_id').val();
	let ac_stock_key_pos = $('#ac_stock_key_pos').val();
	let ac_stock_name_rr = $('#ac_stock_name_rr').val();
	let ac_stock_key_pos_orig = $('#ac_stock_key_pos').attr('original');
	let ac_stock_name_rr_orig = $('#ac_stock_name_rr').attr('original');

	var ex_ac_stock_key_pos_yn = false; 
	var ex_ac_stock_name_rr_yn = false; 
	if (ac_stock_key_pos !== ac_stock_key_pos_orig) {
		$( ".ex_ac_stock_key_pos" ).each(function( ) {
			if (ac_stock_key_pos == $( this ).text()) {
				ex_ac_stock_key_pos_yn = true;
			}
		});
	};
	
	if (ac_stock_name_rr !== ac_stock_name_rr_orig) {
		$( ".ex_ac_stock_name_rr" ).each(function( ) {
			if (ac_stock_name_rr == $( this ).text()) {
				ex_ac_stock_name_rr_yn = true;
			}
		});
	};

	if (ex_ac_stock_key_pos_yn) {
		$('#ac_stock_key_pos').focus();
		openMessage("This code already exists");
		validated = false;
		return false;
	}
	if (ex_ac_stock_name_rr_yn) {
		$('#ac_stock_name_rr').focus();
		openMessage("This code already exists");
		validated = false;
		return false;
	}

	if(pr_business_id == "") {
		$("#pr_business_id").focus();
		openMessage("Please select a property");
		validated = false;
		return false;
	}
	
	if(ac_stock_key_pos.trim() == "") {
		$("#ac_stock_key_pos").focus();
		openMessage("Missing POS code");
		validated = false;
		return false;
	}
	
	if(ac_stock_name_rr.trim() == "") {
		$("#ac_stock_name_rr").focus();
		openMessage("Missing RR code");
		validated = false;
		return false;
	}

	location = [
		ac_stock_ix,
		pr_business_id,
		ac_stock_key_pos,
		ac_stock_name_rr
	]

	if(!validated) {
		return false;
	}

	$('#fullPageLoader').show();
	aRequestPostEx("/reservation.php?4001", {
		action: "save_locations",
		pr_business_id: pr_business_id,
		location: JSON.stringify(location)
	}, (data) => {
		loadLocations();
	});
}

var selectedLocation
function selectLocation(ac_stock_ix) {
	selectedLocation = ac_stock_ix;
	$('#fullPageLoader').show();

	aRequestPostEx("/reservation.php?4001", {
		action: "select_location",
		ac_stock_ix: ac_stock_ix,
	}, (data) => {
		populateEdit(data);
	});
}

function populateEdit(locationItemData) {
	if (typeof locationItemData === "object") {
		let costCentreLabel1 = "";
		let costCentreLabel2 = "";
		$('#pr_business_id').attr('disabled', 'disabled');
		$('.ac_stock_ix').val(locationItemData['ac_stock_ix']);
		$('.pr_business_id').val(locationItemData['pr_business_id']);
		$('.ac_stock_key_pos').val(locationItemData['ac_stock_key_pos']);
		$('.ac_stock_name_rr').val(locationItemData['ac_stock_name_rr']);
		$('.ac_stock_key_pos').attr('original',locationItemData['ac_stock_key_pos']);
		$('.ac_stock_name_rr').attr('original',locationItemData['ac_stock_name_rr']);
		if(locationItemData['fn_cost_centre_1_code']!= null) {
			costCentreLabel1 = locationItemData['fn_cost_centre_1_code'] += ": ";
		}
		if(locationItemData['fn_cost_centre_1_desc']!= null) {
			costCentreLabel1 += locationItemData['fn_cost_centre_1_desc'];
		}
		if(locationItemData['fn_cost_centre_2_code']!= null) {
			costCentreLabel2 = locationItemData['fn_cost_centre_2_code'] += ": ";
		}
		if(locationItemData['fn_cost_centre_2_desc']!= null) {
			costCentreLabel2 += locationItemData['fn_cost_centre_2_desc'];
		}
		$('#fn_cost_centre_1_id').val(costCentreLabel1);
		$('#fn_cost_centre_2_id').val(costCentreLabel2);
	}
	$('#fullPageLoader').hide();
}


