function dateFormat(prefix) {
	if(selIndex(prefix + "Day") == 0 || selIndex(prefix + "Month") == 0 || id(prefix+"Year").value == "" || id(prefix+"Year").value.search(/^\d{4}$/) == -1) {
		return false;
	}

	return id(prefix + "Year").value + "-" +
		(selIndex(prefix + "Month")<10?"0"+selIndex(prefix + "Month").toString():selIndex(prefix + "Month").toString()) + "-" +
		(selIndex(prefix + "Day")<10?"0"+selIndex(prefix + "Day").toString():selIndex(prefix + "Day").toString());
}

function dateVerify(prefix, label) {
	if(!label) {label = prefix;}
	result = true;
	if(selIndex(prefix + "Day") == 0) {
		id(prefix + "Day").focus();
		result = false;
	} else if(selIndex(prefix + "Month") == 0) {
		id(prefix + "Month").focus();
		result = false;
	} else if(id(prefix+"Year").value == "" || id(prefix+"Year").value.search(/^\d{4}$/) == -1) {
		id(prefix + "Year").focus();
		result = false;
	}
	if(!result) { openMessage("Please enter a valid "+label+" date","a",100); }
	return result;
}

function dateCompare(prefix1, prefix2) {
	if(dateFormat(prefix1) < dateFormat(prefix2)) {
		return -1;
	}
	if(dateFormat(prefix1) > dateFormat(prefix2)) {
		return 1;
	}
	if(dateFormat(prefix1) == dateFormat(prefix2)) {
		return 0;
	}
}

function dateVerifySmaller(prefix1, prefix2) {
	if(dateCompare(prefix1,prefix2) != -1 && dateCompare(prefix1,prefix2) != 0) {
		openMessage("Please enter a "+prefix1+" date that is smaller than the "+prefix2+" date","a",100);
		return false;
	}
	return true;
}

function dateVerifyGreater(prefix1, prefix2) {
	if(dateCompare(prefix1,prefix2) != 1) {
		openMessage("Please enter a "+prefix1+" date that is greater than the "+prefix2+" date","a",100);
		return false;
	}
	return true;
}

function dateCopy(prefix1, prefix2) {
	id(prefix2 + "Day").selectedIndex = id(prefix1 + "Day").selectedIndex;
	id(prefix2 + "Month").selectedIndex = id(prefix1 + "Month").selectedIndex;
	id(prefix2 + "Year").value = id(prefix1 + "Year").value;
}
