function initialisePage(e) {
	windowResize(656,480);

	if ( _invoiceId != "" ) {
		id("toggleTotalsHeader").className = "collapse printCollapse";
	}

	var busUnitUpper = busUnit.toUpperCase();
	id("busUnit").innerHTML = busUnitUpper;

	if ( id("resAccomm").className == "expand" ) {
		id("resAccommCheck").checked = true;
	} else {
		id("resAccommCheck").checked = false;
	}

	if(id("paymentPlan").className == "expand") {
		id("payPlanCheck").checked = true;
		id("cancelledPaymentToggle").className = "expand";
		defaultArray.push("paymentPlan");
	} else {  
		id("payPlanCheck").checked = false;
		id("cancelledPaymentToggle").className = "collapse printCollapse";
	}

	if(id("paymentReceipts").className == "expand") {
		id("payReceiptsCheck").checked = true;
		id("cancelledPaymentToggle").className = "expand";
		defaultArray.push("paymentReceipts");
	} else {
		id("payReceiptsCheck").checked = false;
		id("cancelledPaymentToggle").className = "collapse printCollapse";
	}  

	if(id("guestInformation").className == "expand") {
		id("guestInformationCheck").checked = true;
	}

	if(!id("costSummary").className.toString().match(/collapse/)) {
		id("costSummaryCheck").checked = true;
		id("commissionToggle").className = "expand";
		id("grossToggle").className = "expand";
		id("totalItemToggle").className = "expand";
		defaultArray.push("costSummary");
	} else {
		id("costSummaryCheck").checked = false;
		id("commissionToggle").className = "collapse printCollapse";
		id("grossToggle").className = "collapse printCollapse";
		id("totalItemToggle").className = "collapse printCollapse";
	}

	if(id("propertyNotes").className == "expand") {
		id("propertyNoteCheck").checked = true;
	} else {
		id("propertyNoteCheck").checked = false;
	}

	id("guestOnlineCheckIn").checked = false;
	id("publicPayments").checked = false;

	if(id("bookingTerms").className == "expand") {
		id("bookingTermsCheck").checked = true;
	} else {
		id("bookingTermsCheck").checked = false;
	}

	if(id("bankDetails").className == "expand") {
		id("bankDetailsCheck").checked = true;
		defaultArray.push("bankDetails");
	} else {
		id("bankDetailsCheck").checked = false;
	}

	if(id("exchangeRate").className == "expand") {
		id("exchNoteCheck").checked = true;      
	} else {
		id("exchNoteCheck").checked = false;      
	}

	if(id("commissionToggle").className == "expand" && _hideCommission == "no" ) {
		id("commisionCheck").checked = true;
		toggle(e,'commissionColumn');
	}

	if(id("extraNotes").className == "expand") {
		id("extraNoteCheck").checked = true;
	} else {
		id("extraNoteCheck").checked = false;
	}

	if(id("creditCard").className == "expand") {   
		id("creditCardCheck").checked = true;
	} else {
		id("creditCardCheck").checked = false;
	}

	if(_showServiceDate == "1") {
		id("serviceDateCheck").checked = true;
	} else {
		id("serviceDateCheck").checked = false;
	}

	if(_showSpecial == "1") {
		id("specialCheck").checked = true;
	} else {
		id("specialCheck").checked = false;
	}

	if(_showSpecialNote == "1") {
		id("specialNoteCheck").checked = true;
	} else {
		id("specialNoteCheck").checked = false;
	}

	if(_showTaxTableGL != "1") {
		id("showTaxTableGLCheck").checked = false;
	}

	if(_showTaxTableRate != "1") {
		id("showTaxTableRateCheck").checked = false;
	}

	if(_showTaxTableTotal != "1") {
		id("showTaxTableTotalCheck").checked = false;
	}

	if(_showTaxTable != "1") {
		id("showTaxTableCheck").checked = false;
	}
	toggle(e,'taxTable');

	if(id("reservationNotes").className == "expand") {
		id("resNoteCheck").checked = true;
	} else {
		id("resNoteCheck").checked = false;
	}

	if(id("propertyNotes").className == "expand") {
		id("propertyNoteCheck").checked = true;
	} else {
		id("propertyNoteCheck").checked = false;
	}

	if(_hideTax == "1") {
		id("showTaxCheck").checked = false;
		setTimeout("toggleTax();",100);
	}

	id("resDetCheck").checked = true;

	if ( _hasAccomm == "0" ) {
		id("resDetCheck").checked = false;
		toggle(e,"resDetails");
	}

	if ( _invoiceId != "" ) {
		toggle(e,"invoiceDateOnly");
	}

	/* START - Custom note setup */
	if ( _customIds != "" ) {
		var customIds = _customIds.split(",");
		for ( var count = 0; count < customIds.length; count++ ) {
			if ( id(customIds[count]+"CustCheck").checked === true ) {
				id(customIds[count]+"CustArea").className = "";
			}
		}
	}
	/* END - Custom note setup */

	setupAddress();


	if ( allowBankList == 'expand' ) {
		if ( !window.id('bankDetailsCheck').checked) {
			window.id('bankListToggle').className = 'collapse printCollapse';
		} else {
			window.id('bankListToggle').className = 'expand';
		}
	}

	toggleRateTypeSummaryNote();
	resetRateTypeSummaryTableWidth();

	toggleItems();	
}

function setupAddress() {
	if(id("addressSelect").options.length == 0) {
		if( _contactName != "") {
			createOption(id("addressSelect"),_contactName + " (Contact)","_contactDetail");
		}

		if(_agentName != "" && _agentName != _contactName) {
			createOption(id("addressSelect"),_agentName + " (Agent)","_agentDetail");
		}

		if(_consultantName != "" && _consultantName != _contactName && _consultantName != _agentName) {
			createOption(id("addressSelect"),_consultantName + " (Consultant)","_consultantDetail");
		}

		if(_billingContactName != "" && _billingContactName != _contactName && _billingContactName != _agentName && _billingContactName != _consultantName) {
			createOption(id("addressSelect"),_billingContactName + " (Billing Contact)","_billingContactDetail");
		}

		if(showContactDropdown == "class='expand'") {
			for(var count = 0; count < id("addressSelect").options.length; count++) {
				if(id("addressSelect").options[count].innerHTML.search("(Contact)") != -1) {
					id("addressSelect").selectedIndex = count;
				}
			}
		}
	}
	changeAddress();
}

function resetRateTypeSummaryTableWidth() {
	var width = 627;

	if(id("rateTypeSummaryNoteCheck").checked == false) {
		width -= 66;
	}

	if(id("hideFinCheck").checked == true) {
		width -= 83;
	}

	if(id("dayActivityCheck").checked == true) {
		width -= 92; 
	}

	id("rateTypeSummaryHeaderTable").style.width = width.toString() + "px";
	id("rateTypeSummaryTable").style.width = width.toString() + "px";
}


function dayActivity() {
	if(_docType == "Reservation Summary") {
		if(is_ie) {
			if ( id("depDate").className === "" ) {
				id("resAccommLabel").innerHTML = "Activity";
				id("resAccommArriveLabel").innerHTML = "Date";
				id("resAccommPropertyLabel").innerHTML = "&nbsp";
				id("resAccommAccommLabel").innerHTML = "&nbsp";
				id("resAccommRoomLabel").innerHTML = "Units";
				id("perRmHeader").innerHTML	= "Per Unit";
				id("chrgHeader").innerHTML = "Charge";

				id("depDate").className = "collapse printCollapse";
				id("depDateRate").className = "collapse printCollapse";
				id("numNights").className = "collapse printCollapse";
				id("numNightsRate").className = "collapse printCollapse";
			} else {
				id("resAccommLabel").innerHTML = "Accommodation";
				id("resAccommArriveLabel").innerHTML = "Arrive";
				id("resAccommPropertyLabel").innerHTML = "Property";
				id("resAccommAccommLabel").innerHTML = "Accomm";
				id("resAccommRoomLabel").innerHTML = "Rms";
				id("perRmHeader").innerHTML	= "Per Rm";
				id("chrgHeader").innerHTML = "Charge per night";

				id("depDate").className = "";
				id("depDateRate").className = "";
				id("numNights").className = "";
				id("numNightsRate").className = "";
			}
		} else {
			if(id("dayActivityCheck").checked) {
				id("resAccommLabel").innerHTML = "Activity";
				id("resAccommArriveLabel").innerHTML = "Date";
				id("resAccommPropertyLabel").innerHTML = "&nbsp";
				id("resAccommAccommLabel").innerHTML = "&nbsp";
				id("resAccommRoomLabel").innerHTML = "Units";
				id("perRmHeader").innerHTML	= "Per Unit";
				id("chrgHeader").innerHTML = "Charge";

				id("resAccommFooter").colSpan = "11";

				// Hide the depart date column
				$("#accommChrgTable tr:eq(0) td:nth-child(2)").hide();
				$("#accommChrgTable tr:gt(1) td:nth-child(2)").hide();

				// Hide the nights column
				$("#accommChrgTable tr:eq(0) td:nth-child(5)").hide();
				$("#accommChrgTable tr:gt(1) td:nth-child(5)").hide();

				// Override column widths
				id("accommChrgDepartCol").width = "110"; // property
				id("accommChrgPropertyCol").width = "104"; // accommodation type
				id("accommChrgAccommCol").width = "30"; // units
				id("accommChrgNightCol").width = "22"; // adults
				id("accommChrgRoomCol").width = "22"; // children
				id("accommChrgAdultCol").width = "35"; // group
				id("accommChrgChildCol").width = "50"; // per unit
				id("accommChrgGroupCol").width = "50"; // per adult
				id("accommChrgPerRoomCol").width = "50"; // per child
				id("accommChrgPerAdultCol").width = "90"; // amount due
				id("accommChrgPerChildCol").width = "0"; // unused
				id("accommChrgDueCol").width = "0"; // unused
			} else {
				id("resAccommLabel").innerHTML = "Accommodation";
				id("resAccommArriveLabel").innerHTML = "Arrive";
				id("resAccommPropertyLabel").innerHTML = "Property";
				id("resAccommAccommLabel").innerHTML = "Accomm";
				id("resAccommRoomLabel").innerHTML = "Rms";
				id("perRmHeader").innerHTML	= "Per Rm";
				id("chrgHeader").innerHTML = "Charge per night";

				id("resAccommFooter").colSpan = "13";

				// Show the depart date column
				$("#accommChrgTable tr:eq(0) td:nth-child(2)").show();
				$("#accommChrgTable tr:gt(1) td:nth-child(2)").show();

				// Show the nights column
				$("#accommChrgTable tr:eq(0) td:nth-child(5)").show();
				$("#accommChrgTable tr:gt(1) td:nth-child(5)").show();

				// Reset column widths
				id("accommChrgDepartCol").width = "64";
				id("accommChrgPropertyCol").width = "89";
				id("accommChrgAccommCol").width = "83";
				id("accommChrgNightCol").width = "22";
				id("accommChrgRoomCol").width = "22";
				id("accommChrgAdultCol").width = "22";
				id("accommChrgChildCol").width = "22";
				id("accommChrgGroupCol").width = "31";
				id("accommChrgPerRoomCol").width = "46";
				id("accommChrgPerAdultCol").width = "46";
				id("accommChrgPerChildCol").width = "46";
				id("accommChrgDueCol").width = "70";
			}
		}
	} else {
		if(is_ie) {
			if(id("invDepart").className === "") {
				id("invAccommLabel").innerHTML = "Activity";
				id("invAccommArriveLabel").innerHTML = "Date";
				id("invAccommPropertyLabel").innerHTML = "&nbsp;";
				id("invAccommAccommLabel").innerHTML = "&nbsp;";
				id("invAccommRoomLabel").innerHTML = "Units";
				id("invDepart").className = "collapse printCollapse";
				id("invNights").className = "collapse printCollapse";
			} else {
				id("invAccommLabel").innerHTML = "Accommodation";
				id("invAccommArriveLabel").innerHTML = "Arrive";
				id("invAccommPropertyLabel").innerHTML = "Property";
				id("invAccommAccommLabel").innerHTML = "Accomm";
				id("invAccommRoomLabel").innerHTML = "Rms";
				id("invDepart").className = "";
				id("invNights").className = "";
			}
		} else {
			if(id("dayActivityCheck").checked) {
				id("invAccommLabel").innerHTML = "Activity";
				id("invAccommArriveLabel").innerHTML = "Date";
				id("invAccommPropertyLabel").innerHTML = "&nbsp;";
				id("invAccommAccommLabel").innerHTML = "&nbsp;";
				id("invAccommRoomLabel").innerHTML = "Units";

				id("invAccommFooter").colSpan = "6";

				// Hide the depart date column
				$("#invAccommTable td:nth-child(2)").hide();

				// Hide the nights column
				$("#invAccommTable td:nth-child(5)").hide();

				// Override column widths
				id("invAccommDepartCol").width = "200"; // property
				id("invAccommPropertyCol").width = "200"; // accommodation type
				id("invAccommAccommCol").width = "49"; // units
				id("invAccommNightCol").width = "49"; // adults
				id("invAccommRoomCol").width = "49"; // children
				id("invAccommAdultCol").width = "0"; // unused
				id("invAccommChildCol").width = "0"; // unused
			} else {
				id("invAccommLabel").innerHTML = "Accommodation";
				id("invAccommArriveLabel").innerHTML = "Arrive";
				id("invAccommPropertyLabel").innerHTML = "Property";
				id("invAccommAccommLabel").innerHTML = "Accomm";
				id("invAccommRoomLabel").innerHTML = "Rms";

				id("invAccommFooter").colSpan = "8";

				// Show the depart date column
				$("#invAccommTable td:nth-child(2)").show();

				// Show the nights column
				$("#invAccommTable td:nth-child(5)").show();

				// Reset column widths
				id("invAccommDepartCol").width = "80";
				id("invAccommPropertyCol").width = "156";
				id("invAccommAccommCol").width = "150";
				id("invAccommNightCol").width = "40";
				id("invAccommRoomCol").width = "40";
				id("invAccommAdultCol").width = "40";
				id("invAccommChildCol").width = "40";
			}
		}
	}
	resetRateTypeSummaryTableWidth();
}

function hideFin() { // Hide financials
	var finArray = ["bankDetails","costComponent","exchNote","payPlan","payReceipts","cancelPay","creditCard","perPerson"];
	var totalArray = ["costSummary","commision","folio","invoice"];
	var is_ie = document.all ? true : false;

	if(id("bankidList").length == 0) {
		var bankArray = [];
	}

	// FINANCIALS //
	for(var f = 0; f < finArray.length; f++) {
		switch ( finArray[f] ) {
		case "bankDetails":
			id("bankDetailsCheck").checked = false;
			id("bankDetails").className = "collapse printCollapse";
			id("bankListToggle").className = "collapse printCollapse";
			break;
		case "exchNote":
			id("exchNoteCheck").checked = false;
			id("exchangeRate").className = "collapse printCollapse";
			break;
		case "payPlan":
			id("payPlanCheck").checked = false;
			id("paymentPlan").className = "collapse printCollapse";
			break;
		case "payReceipts":
			id("payReceiptsCheck").checked = false;
			id("paymentReceipts").className = "collapse printCollapse";
			break;
		case "cancelPay":
			id("cancelPayCheck").checked = false;
			id('payed1').className = 'expand';
			id('payed2').className = 'collapse printCollapse';
			break;
		default:
			if(id(finArray[f]+"Check").checked === true) {
				id(finArray[f]+"Check").checked = false;
				id(finArray[f]).className = "collapse printCollapse";
			}
			break;
		}
	}

	// TOTALS //
	for(var t = 0; t < totalArray.length; t++) {
		switch ( totalArray[t] ) {
		case "costSummary":
			id("costSummaryCheck").checked = false;
			id("costSummary").className = "collapse printCollapse";
			break;
		case "commision":
			id("commisionCheck").checked = false;
			id("commissionToggle").className = "collapse printCollapse";
			break;
		default:
			id(totalArray[t]+"Check").checked = false;
			id(totalArray[t]+"List").className = "collapse printCollapse";
			break;
		}
	}

	if (is_ie){
		id("accommChrgTot").className = "collapse printCollapse";
		id("accommChrgTotRate").className = "collapse printCollapse";
		id("accommChrgTotHeader").className = "collapse printCollapse";
		id("extraTotal").className = "collapse printCollapse";
		id("accomExtraTotal").className = "collapse printCollapse";
		id("travTotal").className = "collapse printCollapse";
	} else {
		// Hide accommodation section financials
		// 1. Hide the group headers "Charge per night" and "Due to supplier"
		$("#accommChrgTable tr:eq(0) td:nth-child(10)").hide();
		$("#accommChrgTable tr:eq(0) td:nth-child(11)").hide();
		// 2. Hide the amount headers
		$("#accommChrgTable tr:eq(1) td").hide();
		// 3. Hide the financial amounts in the data
		$("#accommChrgTable tr:gt(1) td:nth-child(10)").hide();
		$("#accommChrgTable tr:gt(1) td:nth-child(11)").hide();
		$("#accommChrgTable tr:gt(1) td:nth-child(12)").hide();
		$("#accommChrgTable tr:gt(1) td:nth-child(13)").hide();

		// Hide rate type summary financials
		$("#rateTypeSummaryTable td:nth-child(11)").hide();

		// Hide accommodation extras financials
		$("#accommExtraTable td:nth-child(10)").hide();

		// Hide reservation extras financials
		$("#resExtraTable td:nth-child(9)").hide();

		// Hide reservation travel financials
		$("#resTravelTable td:nth-child(11)").hide();
	}
	id("rateTypeHeader").className = "collapse printCollapse";
	id("paymentPlanHeader").className = "collapse printCollapse";

	if(id("hideFinCheck").checked === false) {
		for(var d = 0; d < defaultArray.length; d++) {
			switch ( defaultArray[d] ) {
			case "paymentPlan":
				id("payPlanCheck").checked = true;
				id("paymentPlan").className = "expand";
				break;
			case "paymentReceipts":
				id("payReceiptsCheck").checked = true;
				id("paymentReceipts").className = "expand";
				break;
			default:
				id(defaultArray[d]+"Check").checked = true;
				id(defaultArray[d]).className = "expand";
				id("bankListToggle").className = "expand";
				id('commissionToggle').className = "expand";
				break;
			}
		}
	
		if (is_ie){
			id("accommChrgTot").className = "";
			id("accommChrgTotRate").className = "";
			id("extraTotal").className = "";
			id("accomExtraTotal").className = "";
			id("travTotal").className = "";
			id("accommChrgTotHeader").className = "";
		} else {
			// Show accommodation section financials
			// 1. Show the group headers "Charge per night" and "Due to supplier"
			$("#accommChrgTable tr:eq(0) td:nth-child(10)").show();
			$("#accommChrgTable tr:eq(0) td:nth-child(11)").show();
			// 2. Show the amount headers
			$("#accommChrgTable tr:eq(1) td").show();
			// 3. Show the financial amounts in the data
			$("#accommChrgTable tr:gt(1) td:nth-child(10)").show();
			$("#accommChrgTable tr:gt(1) td:nth-child(11)").show();
			$("#accommChrgTable tr:gt(1) td:nth-child(12)").show();
			$("#accommChrgTable tr:gt(1) td:nth-child(13)").show();

			// Show rate type summary financials
			$("#rateTypeSummaryTable td:nth-child(11)").show();

			// Show accommodation extras financials
			$("#accommExtraTable td:nth-child(10)").show();

			// Show reservation extras financials
			$("#resExtraTable td:nth-child(9)").show();

			// Show reservation travel financials
			$("#resTravelTable td:nth-child(11)").show();
		}
		id("rateTypeHeader").className = "";
		id("paymentPlanHeader").className = "";
	}
	resetRateTypeSummaryTableWidth();
}

function toggle(e,section) {
	switch(section) {
	case "ShowHide":
		if(id("showHideForm").style.display == "none") {
			screenW = windowWidth();
			screenH = windowHeight();

			id("showHideForm").style.display = "";

			clickX = getClickPosition(e,"x");
			clickY = getClickPosition(e,"y");

			newX = clickX - id("showHideForm").offsetWidth;
			newY = clickY+4;

			if ( e.y > (screenH / 2) ) {
				newY = clickY - id("showHideForm").offsetHeight-4;
			}

			if ( newX < 0 ) {
				newX = 0;
			}

			id("showHideForm").style.left = newX;
			id("showHideForm").style.top = newY;
		} else {
			id("showHideForm").style.display = "none";
		}
		break;
	case "ShowHideCustNotes":
		if(id("showHideCustNotes").style.display == "none") {
			screenW = windowWidth();
			screenH = windowHeight();

			id("showHideCustNotes").style.display = "";

			clickX = getClickPosition(e,"x");
			clickY = getClickPosition(e,"y");

			newX = clickX - id("showHideCustNotes").offsetWidth;
			newY = clickY + 4;

			if(e.y > (screenH / 2)) {
				newY = clickY - id("showHideCustNotes").offsetHeight-4;
			}

			id("showHideCustNotes").style.left = newX;
			id("showHideCustNotes").style.top = newY;
		} else {
			id("showHideCustNotes").style.display = "none";
		}
		break;  
	case "Comment":
		if(id("commentArrow").value == " << Include comments") {
			id("commentArrow").value = " >> Remove comments";
			id("commentArea").className = "expand printCollapse";
			id("printComments").className = "collapse printExpand";
			id("datarows").scrollTop = 0;
			id("commentBox").focus();
		} else {
			id("commentArrow").value = " << Include comments";
			id("commentArea").className = "collapse printCollapse";
			id("printComments").className = "collapse printCollapse";
		}
		break;
	case "commissionColumn":
	case "gross":
		toggleTotalColumns();
		break;
	case "resDetails":
		if(id("resDetails").className == "collapse printCollapse") {
			id("resDetails").className = "expand";
			id("addressSelect").style.visibility = "visible";
			id("noRoomDetShow").className = "collapse printCollapse";
		} else {
			id("resDetails").className = "collapse printCollapse";
			id("addressSelect").style.visibility = "hidden";
			id("noRoomDetShow").className = "";
		}
		break;
	case "invoiceDateOnly":
		id("invoiceDateOnly").className = id("resDetails").className == "collapse printCollapse" ? "expand" : "collapse printCollapse";
		break;
	case "paymentPlanInv":
		if(id("payPlanInvCheck").checked) {
			id("payPlan2").className = "collapse printCollapse";
			id("payPlan3").className = "expand";
		} else {
			id("payPlan2").className = "expand";
			id("payPlan3").className = "collapse printCollapse";
		}
		break;
	case "itemConsolidate":
	case "serviceDate":
		toggleItems();
		break;
	case "costSummary":
		if(id(section).className.toString().match(/collapse printCollapse/)) {
			id(section).className = "expand printExpand";
			id("grossToggle").className = "expand";
			id("totalItemToggle").className = "expand";
		} else {
			id(section).className = "collapse printCollapse";
			id("grossToggle").className = "collapse printCollapse";
			id("totalItemToggle").className = "collapse printCollapse";
		}
		break;		
	case "taxTable":
		id("taxTable").className = "collapse printCollapse";
		id("taxTableWithoutRates").className = "collapse printCollapse";
		id("taxTableGL").className = "collapse printCollapse";
		id("taxTableGLWithoutRates").className = "collapse printCollapse";
		if(id("showTaxTableCheck").checked) {
			id("taxTableToggles").className = "expand printExpand";
			if(id("showTaxTableGLCheck").checked) {
				if(id("showTaxTableRateCheck").checked) {
					id("taxTableGLWithoutRates").className = "expand printExpand";
				} else {
					id("taxTableGL").className = "expand printExpand";
				}
			} else {
				if(id("showTaxTableRateCheck").checked) {
					id("taxTableWithoutRates").className = "expand printExpand";
				} else {
					id("taxTable").className = "expand printExpand";
				}
			}
			if(id("showTaxTableTotalCheck").checked) {
				if(id("taxTableTotalRow")) { id("taxTableTotalRow").className = "collapse printCollapse"; }
				if(id("taxTableTotalWithoutRatesRow")) { id("taxTableTotalWithoutRatesRow").className = "collapse printCollapse"; }
				if(id("taxTableTotalGLRow")) { id("taxTableTotalGLRow").className = "collapse printCollapse"; }
				if(id("taxTableTotalGLWithoutRatesRow")) { id("taxTableTotalGLWithoutRatesRow").className = "collapse printCollapse"; }
			} else {
				if(id("taxTableTotalRow")) { id("taxTableTotalRow").className = "expand printExpand"; }
				if(id("taxTableTotalWithoutRatesRow")) { id("taxTableTotalWithoutRatesRow").className = "expand printExpand"; }
				if(id("taxTableTotalGLRow")) { id("taxTableTotalGLRow").className = "expand printExpand"; }
				if(id("taxTableTotalGLWithoutRatesRow")) { id("taxTableTotalGLWithoutRatesRow").className = "expand printExpand"; }
			}

		} else {
			id("taxTableToggles").className = "collapse printCollapse";
		}
		break;
	case "specialNote":
		$(".docSpecialNoteDetail").toggleClass("collapse printCollapse");
		break;
	case "guestOnlineCheckIn":
		$(".showGuestOnlineCheckIn").toggleClass("collapse printCollapse");
		break;
	case "publicPayments":
		$(".showPublicPayments").toggleClass("collapse printCollapse");
		break;
	default:
		if(id(section).className.toString().match(/collapse printCollapse/)) {
			id(section).className = "expand printExpand";
		} else {
			id(section).className = "collapse printCollapse";
		}
		break;
	}
}

function toggleTotalColumns() {
	var count;
	var item;
	var descWidth = 238;

	// Hide all totals amount columns
	var list = ["gross","comm","nett","due"];
	for (item in list) {
		for ( count = 1; count <= 6; count++ ) {
			id(list[item]+count.toString()).className = "collapse printCollapse";
		}
	}

	if(is_ie) {
		id("costSummaryHeader").className = "collapse printCollapse";
		id("costSummaryData").className = "collapse printCollapse";
		id("costSummaryTotal").className = "collapse printCollapse";
		id('costSummaryHeader').style.display = "none";
		id('costSummaryData').style.display = "none";
		id('costSummaryTotal').style.display = "none";
	}

	// Show totals amount columns based on selected options
	if(id("grossCheck").checked) {
		list = ["gross"];
		descWidth = 538;
	} else if(!id("commisionCheck").checked) {
		list = ["due"];
		descWidth = 538;
	} else {
		list = ["gross","comm","nett","due"];
		if(is_ie) {
			id("costSummaryHeader").className = "";
			id("costSummaryData").className = "";
			id("costSummaryTotal").className = "";
			id('costSummaryHeader').style.display = "block";
			id('costSummaryData').style.display = "block";
			id('costSummaryTotal').style.display = "block";
		}
	}
	for (item in list) {
		for ( count = 1; count <= 6; count++ ) {
			var newClass = "br bb printExpand";
			if(count == 1) {
				newClass = "outLtt printExpand";
			}
			if (count == 5) {
				newClass = "br bb printExpand";
			}
			id(list[item]+count.toString()).className = newClass;
		}
	}
	for (count = 1; count <= 3; count++) {
		id('totalsId' + count.toString()).width = descWidth.toString();
	}
}

function toggleRateTypeSummaryNote() {
	if(id("rateTypeSummaryNoteCheck").checked) {
		if(is_ie) {
			id("rateTypeSummaryNote").className = "expand printExpand";
		} else {
			$("#rateTypeSummaryTable td:nth-child(10)").show();
		}
	} else {
		if(is_ie) {
			id("rateTypeSummaryNote").className = "collapse printCollapse";
		} else {
			$("#rateTypeSummaryTable td:nth-child(10)").hide();
		}
	}
	resetRateTypeSummaryTableWidth();
}

function toggleBanks(bankId) {
	if(id(bankId+"row").className == "collapse printCollapse") {
		id(bankId+"row").className = "expand";
	} else {
		id(bankId+"row").className = "collapse printCollapse";
	}
	
	if (buildBankList() == "") {
		id('bankDetails').className = "collapse printCollapse";
	} else {
		id('bankDetails').className = "expand printExpand";
	}	
}

function changeAddress() {
	id("addressField").innerHTML = eval( id("addressSelect").options[id("addressSelect").selectedIndex].value );
	id("addressPrint").innerHTML = id("addressSelect").options[id("addressSelect").selectedIndex].text;
}

function processResponse() {
	if(confAction == "printPDF") {
		_printCount++;
		id("btnOptions").style.visibility = "hidden";
		openPDF();
	}
}

function createInput(inputType) {
	var newInput;

	if(is_ie) {
		newInput = document.createElement("<input type='"+inputType+"'>");
	} else {
		newInput = document.createElement("input");
		newInput.setAttribute("type",inputType);
	}
	return newInput;
}

function createOption(selectObj, optionLabel, optionValue) {
	var newOption = new Option(optionLabel,optionValue);
	selectObj.options[selectObj.options.length] = newOption;
}


function buildToggleMap() {
	toggleMap = 0;

	toggleMap += id("payPlanCheck").checked ? 1 : 0;
	toggleMap += id("resNoteCheck").checked ? 2 : 0;
	toggleMap += id("bankDetailsCheck").checked ? 4 : 0;
	toggleMap += id("guestInformationCheck").checked?8:0;
	toggleMap += id("commisionCheck").checked?16:0;
	toggleMap += id("extraNoteCheck").checked?32:0;
	toggleMap += id("exchNoteCheck").checked?64:0;
	toggleMap += id("propertyNoteCheck").checked?128:0;
	toggleMap += id("internalMemoCheck").checked?256:0;
	toggleMap += (id("commentArrow").value == " >> Remove comments")?512:0;
	toggleMap += id("cancelNoteCheck").checked?1024:0;
	toggleMap += id("costComponentCheck").checked?2048:0;
	toggleMap += id("costSummaryCheck").checked?4096:0;
	toggleMap += id("roomingCheck").checked?8192:0;
	toggleMap += id("guestNoteCheck").checked?16384:0;
	toggleMap += id("guestMemoCheck").checked?32768:0;
	toggleMap += id("folioCheck").checked?65536:0;
	toggleMap += id("invoiceCheck").checked?131072:0;
	toggleMap += id("cancelPayCheck").checked?262144:0;
	toggleMap += id("resDetCheck").checked?524288:0;
	toggleMap += id("creditCardCheck").checked?1048576:0;
	toggleMap += id("bookingTermsCheck").checked?2097152:0;
	toggleMap += id("payReceiptsCheck").checked?4194304:0;
	toggleMap += id("resAccommCheck").checked?8388608:0;  
	toggleMap += id("roomingNamesCheck").checked ? 16777216 : 0;
	toggleMap += id("showTaxCheck").checked ? 33554432 : 0;
	toggleMap += id("originatorCheck").checked ? 67108864 : 0;
	toggleMap += id("rateTypeSummaryCheck").checked ? 134217728 : 0;
	toggleMap += id("rateTypeSummaryNoteCheck").checked ? 268435456 : 0;
	toggleMap += id("totalItemCheck").checked ? 536870912 : 0;
	toggleMap += id("grossCheck").checked ? 1073741824 : 0;
	toggleMap += id("perPersonCheck").checked ? 2147483648 : 0;
	toggleMap += id("guestOnlineCheckIn").checked ? 4294967296 : 0;
	toggleMap += id("publicPayments").checked ? 8589934592 : 0;
	
	return toggleMap;
}

function buildBankList() {
	var bankValue = [];
	if(id("bankidList").value != "") {
		var banks = id("bankidList").value.split(",");
		var bsize = banks.length;

		for(i=0; i<bsize; i++) {
			if ( id(banks[i]+"Check").checked ) {
				bankValue.push(banks[i]);
			}
		}
	}
	return bankValue.join(",");
}

function buildCustomNoteList() {
	var checkedCust = [];
	if( _customIds != "") {
		var customIds = _customIds.split(",");

		for ( var count = 0; count < customIds.length; count++ ) {
			if ( id(customIds[count]+"CustCheck").checked === true ) {
				checkedCust.push(customIds[count]);
			}
		}
	}
	return checkedCust.join(",");
}

function buildURL(renderOption) {
	_urlCount++;
	var toggleMap = buildToggleMap();
	var bankList = buildBankList();
	var customList = buildCustomNoteList();
	var dayActivity = id("dayActivityCheck").checked;
	var hideFinancials = id("hideFinCheck").checked;
	var showReference = id("ReferenceCheck").checked;
	var showSupplier = id("ServiceByCheck").checked;
	var showAgentComm = id("agentCommissionCheck").checked;
	var showPayPlanInv = id("payPlanInvCheck").checked?"1":"0";
	var showConsolidatedItems = id("itemConsolidateCheck").checked?"1":"0";
	var showServiceDate = id("serviceDateCheck").checked?"1":"0";
	var showSpecial = id("specialCheck").checked?"1":"0";
	var showSpecialNote = id("specialNoteCheck").checked?"1":"0";
	var showTaxTable = id("showTaxTableCheck").checked?"1":"0";
	var showTaxTableGL = id("showTaxTableGLCheck").checked?"1":"0";
	var showTaxTableRate = id("showTaxTableRateCheck").checked?"1":"0";
	var showTaxTableTotal = id("showTaxTableTotalCheck").checked?"1":"0";

	
	var url = [
		/*  0 */ "reservation.php?642",
		/*  1 */ _reservationId,
		/*  2 */ renderOption,
		/*  3 */ _folioId,
		/*  4 */ _invoiceId,
		/*  5 */ _randomId + "_" + _urlCount.toString(),
		/*  6 */ toggleMap,
		/*  7 */ "", // addressArg
		/*  8 */ "", // commentArg / emailTo
		/*  9 */ "", // emailPersonaId
		/* 10 */ bankList,
		/* 11 */ customList,
		/* 12 */ dayActivity,
		/* 13 */ hideFinancials,
		/* 14 */ "",
		/* 15 */ "" ,
		/* 16 */ showReference,
		/* 17 */ showSupplier,
		/* 18 */ showAgentComm,
		/* 19 */ showPayPlanInv,
		/* 20 */ showConsolidatedItems,
		/* 21 */ showServiceDate,
		/* 22 */ showTaxTable,
		/* 23 */ showTaxTableGL,
		/* 24 */ showTaxTableRate,
		/* 25 */ showTaxTableTotal,
		/* 26 */ showSpecial,
		/* 27 */ showSpecialNote
	];

	return url.join("+");
}

function prepareForm() { // This needs to be removed at some stage, it could cause odd bugs
	var commentInput = createInput("hidden");
	commentInput.name = 'comment';
	commentInput.value = id("commentBox").value;
	id("commentForm").appendChild(commentInput);

	var addressInput = createInput("hidden");
	addressInput.setAttribute("name","address");
	try {
		addressInput.value = eval(id("addressSelect").options[id("addressSelect").selectedIndex].value);
	} catch(e) {
		addressInput.value = "";
	}
	id("commentForm").appendChild(addressInput);
}

function openPDF() {
	if(_printCount == 0) {
		confAction = "printPDF";
		openConfirm("You are about to display the original invoice for printing, are you sure you want to do this?");
		return;
	}

	id("commentForm").action = buildURL(1);
	prepareForm();
				

	pdfWin = openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading PDF...",640,480,0,0,0,1,"pdfWin","opener.id('commentForm').submit()");
}

function emailPDF(testMailId) {
	if(_rf_mail_id != "" && testMailId != "1") {
		showHide();
		return 0;
	}

	id("commentForm").action = buildURL(2);
	prepareForm();

				
	pdfWin = openPopup("/resource/Resrequest/Application/public/html/wait.htm?Loading email popup...",595,484,0,0,0,0,"pdfWin","opener.id('commentForm').submit()");
	return true;
}

function showHide(above) {
	if(id("rfMail").style.display == "none") {
		screenW = parseInt(document.body.clientWidth,10);
		screenH = parseInt(document.body.clientHeight,10);

		id("rfMail").style.display = "";
		id("rfMail").style.left = screenW / 4;
		id("rfMail").style.top = screenH / 3;
		return 0;
	} else {
		id("rfMail").style.display = "none";
		emailPDF("1");
		return 1;
	}
}

function toggleTax() {
	var count, newClass;

	if(id("showTaxCheck").checked) { //id("taxCol1").className == "collapse") {
		newClass = "";
		newVisibility = "";
	} else {
		newClass = "collapse";
		newVisibility = "collapse";
	}

	count = 1;
	while(id("taxCol" + count.toString()) && count < 14) {
		if(document.all) {
			id("taxCol"+count.toString()).className = newClass;
		} else {
			id("taxCol"+count.toString()).style.visibility = newVisibility;
		}
		count++;
	}
	count = 14;
	while(id("taxCol" + count.toString())) {
		if(document.all) {
			id("taxCol"+count.toString()).className = newClass;
		} else {
			id("taxCol"+count.toString()).style.visibility = newVisibility;
		}
		count++;
	}

	toggleItems();
}

function toggleItems() {
	if(_docType == "Reservation Summary") {
		return false;
	}

	id("itemsFull").className = "collapse printCollapse";
	id("itemsFullWithDate").className = "collapse printCollapse";
	id("itemsFullNoTax").className = "collapse printCollapse";
	id("itemsFullNoTaxWithDate").className = "collapse printCollapse";
	id("itemsConsolidated").className = "collapse printCollapse";
	id("itemsConsolidatedWithDate").className = "collapse printCollapse";
	id("itemsConsolidatedNoTax").className = "collapse printCollapse";
	id("itemsConsolidatedNoTaxWithDate").className = "collapse printCollapse";
	if(id("itemConsolidateCheck").checked) {
		if(id("showTaxCheck").checked) {
			if(id("serviceDateCheck").checked) {
				id("itemsConsolidatedWithDate").className = "expand";
			} else {
				id("itemsConsolidated").className = "expand";
			}
		} else {
			if(id("serviceDateCheck").checked) {
				id("itemsConsolidatedNoTaxWithDate").className = "expand";
			} else {
				id("itemsConsolidatedNoTax").className = "expand";
			}
		}
	} else {
		if(id("showTaxCheck").checked) {
			if(id("serviceDateCheck").checked) {
				id("itemsFullWithDate").className = "expand";
			} else {
				id("itemsFull").className = "expand";
			}
		} else {
			if(id("serviceDateCheck").checked) {
				id("itemsFullNoTaxWithDate").className = "expand";
			} else {
				id("itemsFullNoTax").className = "expand";
			}
		}
	}		
	return true;
}

function bankDetailsToggle() {
	var bankList = buildBankList();
	if(allowBankList == 'expand') { 
		if(!id('bankDetailsCheck').checked) {
			id('bankListToggle').className = 'collapse printCollapse';
			id('bankDetails').className = "collapse printCollapse";
		} else {
			id('bankListToggle').className = 'expand';
			if ($bankList != "") {
				id('bankDetails').className = "expand printExpand";
			}
		}
	}

	if (bankList == "") {
		id('bankDetails').className = "collapse printCollapse";
	}	
}

function toggleSupplier(control) {
	if(control.checked) {
		id('extServ').className = "";
		id('accomExtServ').className = "";
		id('travServ').className = "";
		id("extDesc").style.width = "";
		id("travDesc").style.width = "";

		if ( !is_ie ) {
			collapseCol("extServ" ,1);
			collapseCol("accomExtServ" ,1);
			collapseCol("travServ" ,1);
		}
	} else {
		var extServWidth = id("extServ").offsetWidth;
		var travServWidth = id("travServ").offsetWidth;
		id('extServ').className = 'collapse';
		id('accomExtServ').className = 'collapse';
		id('travServ').className = 'collapse';

		if ( !is_ie ) {
			id("extDesc").style.width = id("extDesc").offsetWidth + extServWidth;
			id("travDesc").style.width = id("travDesc").offsetWidth + travServWidth;
			collapseCol("extServ" ,0);
			collapseCol("travServ" ,0);
		}
	}
}

function toggleReference(control) {
	if(control.checked) {
		id('extRef').className = "";
		id('accomExtRef').className = "";
		id('travRef').className = "";
		id("extDesc").style.width = "";
		id("travDesc").style.width = "";

		if ( !is_ie ) {
			collapseCol("extRef" ,1);
			collapseCol("accomExtRef" ,1);
			collapseCol("travRef" ,1);
		}
	} else {
		var extRefWidth = id("extRef").offsetWidth;
		var accomExtRefWidth = id("extRef").offsetWidth;
		var travRefWidth = id("travRef").offsetWidth;
		id('extRef').className = 'collapse';
		id('accomExtRef').className = 'collapse';
		id('travRef').className = 'collapse';

		if ( !is_ie ) {
			id("extDesc").style.width = id("extDesc").offsetWidth + extRefWidth;
			id("travDesc").style.width = id("travDesc").offsetWidth + travRefWidth;
			collapseCol("extRef" ,0);
			collapseCol("accomExtRef" ,0);
			collapseCol("travRef" ,0);
		}
	}
}
