/* Global event functions */

function windowOnLoad(e) {
	if(funcExists("createMenu")) {
		createMenu();
	}

	if ( window.isPopup ) {
		document.body.style.overflow = "hidden";
		document.body.className = "outLt";

		if(is_ie && opener && opener.document) {
			opener.document.body.setCapture();
		}
	}

	var finalResult;
	if(funcExists("initialisePage")) {
		finalResult = initialisePage();
	} else {
		finalResult = true;
	}

	if(Get_Cookie("inQuickFind") == "yes") {
		Set_Cookie("inQuickFind",false);
		quickFindShow();
	}

	if(Get_Cookie("inQuickDate") == "yes") {
		Set_Cookie("inQuickDate",false);
		showQuickDate();
	}
	return finalResult;
}

function windowOnUnload(e) {
	if ( opener && !opener.closed ) {
		if ( window.isPopup ) {
			try {
				opener.document.body.releaseCapture();
			} catch(e) {}
		}
	}
	if(funcExists("unload")) {
		return unload(e);
	}
	return true;
}

function windowOnClick(e) {
	if(id("lastResList")) {
		if(id("lastResList").style.display != "none") {
			hideLastResList();
		}
	}

	if(id("lastContactList")) {
		if(id("lastContactList").style.display != "none") {
			hideLastContactList();
		}
	}

	if(id("quickFindDiv")) {
		if(id("quickFindDiv").style.display != "none") {
			quickFindHide();
		}
	}

	if(funcExists("click")) {
		return click(e);
	}
	return true;
}

function windowOnDblClick(e) {
	if(funcExists("dblClick")) {
		return dblClick(e);
	}
	return true;
}

function windowOnMouseDown(e) {
	if(funcExists("mouseDown")) {
		return mouseDown(e);
	}
	return true;
}

function windowOnMouseUp(e) {
	if(funcExists("mouseUp")) {
		return mouseUp(e);
	}
	return true;
}


function windowOnMouseOver(e) {
	if(id("lastResList")) {
		if(id("lastResList").style.display != "none") {
			lastResOut();
		}
	}
	if(id("lastContactList")) {
		if(id("lastContactList").style.display != "none") {
			lastContactOut();
		}
	}	
	if(funcExists("mouseOver")) {
		return mouseOver(e);
	}
	return true;
}

function windowOnMouseMove(e) {
	if(funcExists("mouseMove")) {
		return mouseMove(e);
	}
	return true;
}

function windowOnMouseOut(e) {
	if(funcExists("mouseOut")) {
		return mouseOut(e);
	}
	return true;
}

function windowOnKeyPress(e) {
	if(funcExists("keyPress")) {
		return keyPress(e);
	}
	return true;
}

function windowOnKeyDown(e) {

	if(id("searchInputPlaceholder") && e.keyCode == 121) { // F10
		e.preventDefault();
		quickMenuActivate();
		id("searchInput").focus();
		return false;
	}
	if(id("searchInput") && e.keyCode == 27 && id("searchInput").style.display != "none") { // ESC
		e.preventDefault();
		quickMenuDeactivate();		
	}

	if ( funcExists("openHelp") && e.keyCode == 112 ) { //F1
		if ( is_ie ) {
			e.keyCode = 0;
		} else {
			openHelp();
		}
		stopBubble(e);
		return false;
	}
	if(id("quickFindDiv") && e.keyCode == 120) { // F9
		if(id("quickFindDiv").style.display !== "") {
			quickFindShow();
		} else {
			quickFindHide();
		}
		return false;
	}
	if(id("quickFindDiv") && e.keyCode == 27) {
		if(id("quickFindDiv").style.display != "none") {
			quickFindHide();
			return false;
		}
	}
	if(id("quickDateDiv") && e.keyCode == 123) { // F12 -- Availability Calendar Date Popup
		if(id("quickDateDiv").style.display !== "") {
			showQuickDate();
		} else {
			id("quickDateDiv").style.display = "none";
			event.returnValue = false;
		}
		stopBubble(e);
		return false;
	}
	if(id("quickDateDiv") && e.keyCode == 27) { // F12 -- Availability Calendar Date Popup
		if(id("quickDateDiv").style.display != "none") {
			id("quickDateDiv").style.display = "none";
			event.returnValue = false;
		}
	}
	if(funcExists("keyDown")) {
		return keyDown(e);
	}
	return true;
}

function windowOnKeyUp(e) {
	if(funcExists("keyUp")) {
		return keyUp(e);
	}
	return true;
}

// This function gets called from the menu, e = menu link (normally a js function call/statement)
function windowMenuClick(e) {
	if(funcExists("menuClick")) {
		return menuClick(e);
	}
	return true;
}

function windowOnResize(e) {
	if(funcExists("menuResize")) {
		menuResize();
	}
	if(funcExists("resize")) {
		return resize(e);
	}
	return true;
}

function windowOnHelp(e) {
	if(funcExists("help")) {
		return help(e);
	} else {
		if ( funcExists("openHelp") ) {
			e.cancelBubble = true;
			openHelp();
			return false;
		}
	}
	return true;	
}

function windowOnScroll(e) {
	if ( !e ) {
		e = window.event;
	}

	if ( id("lastResList") ) {
		if ( id("lastResList").style.display != "none" ) {
			hideLastResList();
		}
	}

	if ( id("lastContactList") ) {
		if ( id("lastContactList").style.display != "none" ) {
			hideLastContactList();
		}
	}	

	if ( id("quickFindDiv") ) {
		if ( id("quickFindDiv").style.display != "none" ) {
			quickFindHide();
		}
	}

	if ( is_ie ) {
		if ( funcExists("scroll") ) {
			return scroll();
		}
	}

	return true;
}
