var origin = "";
var enabledButtons = new Array("Back","Forward","Refresh","Print","Calendar","Internet","Home","Help","NewWindow");
var enabledFunctions = new Array("Back","Forward","Refresh","Print","Calendar","Internet","Home","Help");

var invoiceUnitData = [];
var fiscalatorData = [];
var mappingCategoryName = {
	currency: "Currencies",
	country: "Countries",
	taxrate: "Tax Rates",
	commodity: "Commodities",
	taxcommodity: "Tax Commodity",
	units: "Units"
}
var vatTaxRates = [];

function removeSlashes(string) {
	if (string.charAt(0) == "/") {
		string = string.slice(1);
	}
	if (string.charAt(-1) == "/") {
		string = string.slice(0, -1);
	}
	
	return string;
}

function fetchInvoicingUnits() {
	$(".invoiceUnitListRow").remove();
	showSection(['invoiceUnitListContainer']);
	$("#spinner").show();
	$.ajax({
		method: "POST",
		url: "reservation.php?6050",
		data:{
			'method': 'ajax',
			'action': 'fetchInvoicingUnits'
		},
	})
	.done(function(result) {
		fisDebug(result);
		result = JSON.parse(result);
		fisDebug("fetchInvoicingUnits");
		fisDebug(result);
		fiscalatorDetailsFetched = false;
		$.each(result, function(key, record) {
			invoiceUnitData[record.pr_business_id] = record;
			if (record.fiscalator_key != '') {
				fetchAccountDetails(record.pr_business_id);
				if (!fiscalatorDetailsFetched) {
					fetchFiscalatorDetails(record.fiscalator_key);
					fiscalatorDetailsFetched = true;
				}
			}
		});

		Object.keys(invoiceUnitData).forEach(function(key) {
			var hasAccount = (
				invoiceUnitData[key] &&
				invoiceUnitData[key]['account'] &&
				invoiceUnitData[key]['account'].business &&
				Object.keys(invoiceUnitData[key]['account'].business).length > 0
			) ? true : false;
			var hasFiscalatorKey = invoiceUnitData[key].fiscalator_key != "" ? true : false;

			var row = `
				<tr class="highlightRow invoiceUnitListRow">
					<td class="bl br">` + invoiceUnitData[key].invoice_unit_name + `</td>
					<td class="bl br">` + invoiceUnitData[key].pr_bus_inv_prefix + `</td>
					<td class="bl br uk-text-center">` + (invoiceUnitData[key].pr_bus_billing_yn == "1" ? "Y" : "N") + `</td>
					<td class="bl br uk-text-center">` + (invoiceUnitData[key].pr_bus_billing_prop_yn == "1" ? "Y" : "N") + `</td>					
					<td class="bl br uk-text-center">` + (hasFiscalatorKey != "" ? "Y" : "N") + `</td>
					<td class="br" align="center">
						<button
							class="button"
							onclick="showSetup('` + invoiceUnitData[key].pr_business_id + `');"
							style="width:55px;"
						>
							Setup
						</button>
						<button
							id="MappingButton` + invoiceUnitData[key].pr_business_id + `"
							class="button ` + (hasFiscalatorKey ? "" : "buttonDisabled") + `"
							onclick="showMapping('` + invoiceUnitData[key].pr_business_id + `');"
							style="width:55px;"
							` + (hasFiscalatorKey != "" ? "" : "disabled") + `
						>
							Mapping
						</button>
					</td>
				</tr>
			`;
			$("#invoicingUnitList").append(row);
		});

		var row = `
			<tr>
              <td class="bt" colspan="6"><img src="/resource/Resrequest/Application/public/img/1x1.gif" /></td>
            </tr>
		`;
		$("#invoicingUnitList").append(row);
		$("#spinner").hide();
	});
}

function createFiscalatorTenant(pr_business_id) {
	$("#spinner").show();
	$.ajax({
		method: "POST",
		url: fiscalatorUrl + "/tenant/create",
		data:{
			'name': invoiceUnitData[pr_business_id].invoice_unit_name
		},
	})
	.done(function(result) {
		$.ajax({
			method: "POST",
			url: "reservation.php?6050",
			data:{
				'method': 'ajax',
				'action': 'addTenantKey',
				'pr_business_id': pr_business_id,
				'key': result.key
			},
		})
		.done(function(result) {
			overlayPopup('Fiscalisation', result);
			fetchInvoicingUnits();
		});
	});
}

function showCloneMapping(pr_business_id) {
	$("#mappingCloneContainer").toggle();
	$("#cloneMappingCategory").empty();
	$("#cloneMappingSource").empty();
	Object.keys(mappingCategoryName).forEach(function(key) {
		$("#cloneMappingCategory").append(`<option value="` + key + `">` + mappingCategoryName[key] + `</option>`);
	});
	$("#cloneMappingCategory").select2();

	Object.keys(invoiceUnitData).forEach(function(key) {
		if (invoiceUnitData[key].fiscalator_key != "" && invoiceUnitData[key].pr_business_id != pr_business_id) {
			$("#cloneMappingSource").append(`<option value="` + invoiceUnitData[key].pr_business_id + `">` + invoiceUnitData[key].invoice_unit_name + `</option>`);
		}		
	});
	$("#cloneMappingSource").select2();
	$("#mappingActionCloneButton").html(
		`
			<button
				class="button"
				onclick="actionMappingClone('` + pr_business_id + `');"
				style="width:55px;"
			>
				Clone
			</button>
		`
	);
}

function actionMappingClone(pr_business_id) {
	$("#spinner").show();
	$.ajax({
		method: "post",
		url: fiscalatorUrl + "/mapclone",
		dataType: "json",
		headers: {
			"key": invoiceUnitData[pr_business_id].fiscalator_key
		},
		data: {
			"type": $("#cloneMappingCategory").val(),
			"sourceTenantKey": invoiceUnitData[$("#cloneMappingSource").val()].fiscalator_key
		},
	})
	.done(function(result) {
		showSetup(pr_business_id, true);
	});
}

function showSetup(pr_business_id, showClone=false) {
	var hasFiscalatorKey = invoiceUnitData[pr_business_id].fiscalator_key != "" ? true : false;
	$("#invoiceUnitNameText").text(invoiceUnitData[pr_business_id].invoice_unit_name);
	$("#fiscalatorKeyText").html( (hasFiscalatorKey ? invoiceUnitData[pr_business_id].fiscalator_key : '<em>No key</em>') );
	$("#fiscalatorKeyCreateButton").text('');

	var hasAccount = (
		invoiceUnitData[pr_business_id] &&
		invoiceUnitData[pr_business_id]['account'] &&
		invoiceUnitData[pr_business_id]['account'].business &&
		Object.keys(invoiceUnitData[pr_business_id]['account'].business).length > 0
	) ? true : false;

	if (!hasFiscalatorKey) {
		$("#fiscalatorKeyCreateButton").html(
			`
				<button
					class="button"
					onclick="createFiscalatorTenant('` + pr_business_id + `');"
					style="width:55px;"
				>
					Create
				</button>
			`
		);
	}

	if (hasFiscalatorKey && hasAccount) {
		$("#mappingCloneButton").html(
			`
				<button
					class="button"
					onclick="showCloneMapping('` + pr_business_id + `');"
					style="width:55px;"
				>
					Clone
				</button>
			`
		);
	}

	showSection(['invoiceUnitSetupContainer']);
	$("#fiscalSetupAccountRow").hide();
	$("#fiscalSetupMappingsRow").hide();

	if (hasFiscalatorKey) {
		fetchAccountDetails(pr_business_id);
		if (showClone) {
			showSection(['invoiceUnitSetupContainer', 'mappingCloneContainer']);
		}
	} else {
		$("#spinner").hide();	
	}
}

function fetchAccountDetails(pr_business_id) {
	$("#fiscalAccountText").empty();
	$("#fiscalAccountSetupButton").empty();
	$("#accountSetupIntegratorSaveButton").empty();
	$("#spinner").show();
	$.ajax({
		method: "POST",
		url: "reservation.php?6050",
		data:{
			'method': 'ajax',
			'action': 'fetchAccountDetails',
			'pr_business_id': pr_business_id
		}
	})
	.done(function(details) {
		fisDebug("fetchAccountDetails: " + pr_business_id);
		details = JSON.parse(details);
		fisDebug(details);
		invoiceUnitData[pr_business_id]['account'] = details;

		fisDebug(invoiceUnitData);
		$("#fiscalSetupAccountRow").show();
		if (
			invoiceUnitData[pr_business_id]['account'] && 
			invoiceUnitData[pr_business_id]['account'].business && 
			Object.keys(invoiceUnitData[pr_business_id]['account'].business).length > 0
		) {
			var integratorId = invoiceUnitData[pr_business_id]['account'].business.integratorId;
			var fiscalAccountText = "Account has been set up";
			if (fiscalatorData && fiscalatorData.fiscal_integrators) {
				fisDebug(fiscalatorData.fiscal_integrators);
				Object.keys(fiscalatorData.fiscal_integrators).forEach(function(key) {
					if (fiscalatorData.fiscal_integrators[key].integratorId == integratorId) {
						fiscalAccountText += " for " + fiscalatorData.fiscal_integrators[key].integratorName + " (" + fiscalatorData.fiscal_integrators[key].systemName + ")";
					}
				});
			}

			$("#fiscalAccountText").text(fiscalAccountText);
			$("#MappingButton" + pr_business_id).removeClass("buttonDisabled");
			$("#MappingButton" + pr_business_id).prop("disabled", false);
		} else {
			$("#fiscalAccountText").html("<em>No account set up</em>");
			$("#accountSetupIntegratorApiCredential1").val("");
			$("#accountSetupIntegratorApiUrl").val("");
			$("#accountSetupIntegratorDeviceUrl").val("");
			$("#accountSetupContactTIN").val("");
		}

		$("#fiscalAccountSetupButton").html(
			`
				<button
					class="button"
					onclick="showFiscalAccountSetup('` + pr_business_id + `');"
					style="width:55px;"
				>
					Setup
				</button>
			`
		);

		var integratorId = "";
		$("#accountSetupIntegrator").empty();
		$("#accountSetupIntegrator").append(`<option value="" selected disabled>Select option</option>`);
		if (fiscalatorData && fiscalatorData.fiscal_integrators) {
			Object.keys(fiscalatorData.fiscal_integrators).forEach(function(key) {
				var selected = "";
				if (
					invoiceUnitData[pr_business_id]['account'] && 
					invoiceUnitData[pr_business_id]['account'].business && 
					invoiceUnitData[pr_business_id]['account'].business.integratorId && 
					invoiceUnitData[pr_business_id]['account'].business.integratorId == fiscalatorData.fiscal_integrators[key].integratorId
				) {
					selected = "selected";
					integratorId = invoiceUnitData[pr_business_id]['account'].business.integratorId;
				}
				
				$("#accountSetupIntegrator").append(`<option value="` + fiscalatorData.fiscal_integrators[key].integratorId + `" ` + selected + `>` + fiscalatorData.fiscal_integrators[key].integratorName + `</option>`);
			});
		}

		$("#accountSetupIntegratorSaveButton").html(
			`
				<button
					class="button"
					onclick="saveAccountSetup('` + pr_business_id + `');"
					style="width:55px;"
				>
					Save
				</button>
			`
		);

		if (
			invoiceUnitData[pr_business_id] &&
			invoiceUnitData[pr_business_id]['account'] &&
			invoiceUnitData[pr_business_id]['account'].business &&
			invoiceUnitData[pr_business_id]['account'].business.integratorId &&
			invoiceUnitData[pr_business_id]['account'].business.integratorId != "" &&
			invoiceUnitData[pr_business_id]['account'].business.apiCredential1 != ""
		) {
			$("#accountSetupIntegratorSaveButton").append(
				`
					<button
						class="button"
						onclick="testAccountSetup('` + pr_business_id + `');"
						style="width:55px;"
					>
						Test API
					</button>
				`
			);
		}

		if (
			invoiceUnitData[pr_business_id] &&
			invoiceUnitData[pr_business_id]['account'] &&
			invoiceUnitData[pr_business_id]['account'].business &&
			invoiceUnitData[pr_business_id]['account'].business.integratorId &&
			invoiceUnitData[pr_business_id]['account'].business.integratorId == "1"
		) {
			$("#accountSetupIntegratorSaveButton").append(
				`
					<button
						class="button"
						onclick="testTin('` + pr_business_id + `');"
						style="width:55px;"
					>
						Test TIN
					</button>
				`
			);
		}

		if (
			invoiceUnitData[pr_business_id] &&
			invoiceUnitData[pr_business_id]['account'] &&
			invoiceUnitData[pr_business_id]['account'].business &&
			invoiceUnitData[pr_business_id]['account'].business.apiCredential1 &&
			invoiceUnitData[pr_business_id]['account'].business.apiCredential1 != ""
		) {
			$("#accountSetupIntegratorApiCredential1").val(invoiceUnitData[pr_business_id]['account'].business.apiCredential1);
			$("#accountSetupIntegratorTINContainer").hide();
			$("#accountSetupIntegratorDeviceUrlContainer").hide();
			switch (integratorId) {
				case "1":	// eTaxWare
					$("#accountSetupIntegratorTINContainer").show();
					$("#apiCredential1Label").text("Integrator API Key");
					$("#apiUrlLabel").text("Integrator API URL");
					break;
				case "2":	// Tremol
					$("#accountSetupIntegratorDeviceUrlContainer").show();
					$("#apiCredential1Label").text("Integrator Password");
					$("#apiUrlLabel").text("ZFP Labs Public URL");
					break;
				case "3":	// Tevin
					$("#apiCredential1Label").text("Integrator Sender ID");
					$("#apiUrlLabel").text("Integrator API URL");
					break;
				default:
					$("#apiCredential1Label").text("Credential 1");
					$("#apiUrlLabel").text("Integrator API URL");
					break;
			}
		}

		$("#accountSetupIntegratorApiUrl").val("");
		$("#accountSetupIntegratorDeviceUrl").val("");
		$("#accountSetupIntegratorTIN").val("");
		if (
			invoiceUnitData[pr_business_id] &&
			invoiceUnitData[pr_business_id]['account'] &&
			invoiceUnitData[pr_business_id]['account'].business &&
			invoiceUnitData[pr_business_id]['account'].business.apiUrl &&
			invoiceUnitData[pr_business_id]['account'].business.apiUrl != ""
		) {
			$("#accountSetupIntegratorApiUrl").val(invoiceUnitData[pr_business_id]['account'].business.apiUrl);
		}

		if (
			invoiceUnitData[pr_business_id] &&
			invoiceUnitData[pr_business_id]['account'] &&
			invoiceUnitData[pr_business_id]['account'].business &&
			invoiceUnitData[pr_business_id]['account'].business.deviceUrl &&
			invoiceUnitData[pr_business_id]['account'].business.deviceUrl != ""
		) {
			$("#accountSetupIntegratorDeviceUrl").val(invoiceUnitData[pr_business_id]['account'].business.deviceUrl);
		}

		if (
			invoiceUnitData[pr_business_id] &&
			invoiceUnitData[pr_business_id]['account'] &&
			invoiceUnitData[pr_business_id]['account'].business &&
			invoiceUnitData[pr_business_id]['account'].business.tin &&
			invoiceUnitData[pr_business_id]['account'].business.tin != ""
		) {
			$("#accountSetupIntegratorTIN").val(invoiceUnitData[pr_business_id]['account'].business.tin);
		}

		$.ajax({
			method: "POST",
			url: "reservation.php?6050",
			data:{
				'method': 'ajax',
				'action': 'getAccountContactStatutoryKey',
				'pr_business_id': pr_business_id
			},
		})
		.done(function(result) {
			if (result != "") {
				$("#accountSetupContactTIN").val(result);
			}
		});

		if (
			invoiceUnitData &&
			invoiceUnitData[pr_business_id] &&
			invoiceUnitData[pr_business_id]['account'] &&
			invoiceUnitData[pr_business_id]['account'].mapping
		) {
			var mappedItems = transformArrayKeys(invoiceUnitData[pr_business_id]['account'].mapping, "code", "name");
			var mappingCategories = [];
			if (mappedItems) {
				Object.keys(mappedItems).forEach(function(key) {
					mappingCategories.push(
						mappingCategoryName[key] + ": " + Object.keys(mappedItems[key].tenantCodes).length
					);
				});
				$("#mappingCountsText").html(mappingCategories.join("<br>"));
			}
		}
		$("#fiscalSetupMappingsRow").show();
		$("#spinner").hide();
	});
}

function updateCredentialLabel() {
	$("#accountSetupIntegratorTINContainer").hide();
	$("#accountSetupIntegratorDeviceUrlContainer").hide();
	switch ($("#accountSetupIntegrator").val()) {
		case "1":	// eTaxWare
			$("#accountSetupIntegratorTINContainer").show();
			$("#apiCredential1Label").text("Integrator API Key");
			$("#apiUrlLabel").text("Integrator API URL");
			break;
		case "2":	// Tremol
			$("#apiCredential1Label").text("Integrator Password");
			$("#apiUrlLabel").text("ZFP Labs Public URL");
			$("#accountSetupIntegratorDeviceUrlContainer").show();
			break;
		case "3":	// Tevin
			$("#apiCredential1Label").text("Integrator Sender ID");
			$("#apiUrlLabel").text("Integrator API URL");
			break;
		default:
			$("#apiCredential1Label").text("Credential 1");
			$("#apiUrlLabel").text("Integrator API URL");
			break;
	}
}

function saveAccountSetup(pr_business_id) {
	if ($("#accountSetupIntegrator").val() == "" || $("#accountSetupIntegrator").val() == null) {
		overlayPopup('Fiscalisation', "Select an integrator");
	} 
	else if ( 
		$("#accountSetupIntegratorDeviceUrl").val() != "" &&
		(
			$("#accountSetupIntegratorApiUrl").val().indexOf("http") == -1 ||
			$("#accountSetupIntegratorApiUrl").val().indexOf("://") == -1 ||
			$("#accountSetupIntegratorApiUrl").val().indexOf(":",10) == -1 ||
			$("#accountSetupIntegratorApiUrl").val().indexOf("/",10) == -1
		)
	)
	{
		overlayPopup('Fiscalisation', 
			"<div class='uk-text-left uk-margin-left'>ZFP Labs Public URL:"+
			"<br>Please enter the full URL including"+
			"<br>- http:// or https://,"+
			"<br>- the port"+
			"<br>- end with a '/'"+
			"<br>e.g. http://zfp-labs.com:4444/</div>");
		$("#accountSetupIntegratorApiUrl").focus();
	}
	else {
		$("#spinner").show();
		let $deviceUrl = ($("#accountSetupIntegratorDeviceUrl").val() != undefined || $("#accountSetupIntegratorDeviceUrl").val() != "") ? removeSlashes($("#accountSetupIntegratorDeviceUrl").val()) : "";
		$.ajax({
			method: "post",
			url: fiscalatorUrl + "/account",
			dataType: "json",
			headers: {
				"key": invoiceUnitData[pr_business_id].fiscalator_key
			},
			data:{
				'integratorId': $("#accountSetupIntegrator").val(),
				'apiCredential1': $("#accountSetupIntegratorApiCredential1").val(),
				'apiUrl': $("#accountSetupIntegratorApiUrl").val(),
				'deviceUrl': $deviceUrl,
				'tin': $("#accountSetupIntegratorTIN").val()
			},
		})
		.done(function(result) {
			fisDebug(result);
			overlayPopup('Fiscalisation', result.responseMessage);
			fetchAccountDetails(pr_business_id);

			$.ajax({
				method: "POST",
				url: "reservation.php?6050",
				data:{
					'method': 'ajax',
					'action': 'saveAccountContactStatutoryKey',
					'pr_business_id': pr_business_id,
					'contact_tin_statutory_key': $("#accountSetupContactTIN").val()
				},
			})
			.done(function(result) {
				$("#spinner").hide();
			});
		});
	}
}

function testAccountSetup(pr_business_id) {
	$("#spinner").show();
	$.ajax({
		method: "get",
		url: fiscalatorUrl + "/accounttest",
		dataType: "json",
		headers: {
			"key": invoiceUnitData[pr_business_id].fiscalator_key
		},
	})
	.done(function(result) {
		overlayPopup('Fiscalisation', result.responseMessage);
		$("#spinner").hide();
	});
}

function testTin(pr_business_id) {
	$("#spinner").show();
	$.ajax({
		method: "get",
		url: fiscalatorUrl + "/validatetin/" + invoiceUnitData[pr_business_id]['account'].business.tin,
		dataType: "json",
		headers: {
			"key": invoiceUnitData[pr_business_id].fiscalator_key
		},
	})
	.done(function(result) {
		overlayPopup('Fiscalisation', result.responseMessage);
		$("#spinner").hide();
	});
}

function fetchFiscalatorDetails(fiscalator_key) {
	$.ajax({
		method: "get",
		url: fiscalatorUrl + "/system",
		dataType: "json",
		headers: {
			"key": fiscalator_key
		},
	})
	.done(function(details) {
		fiscalatorData = details;
	});
}

function showFiscalAccountSetup(pr_business_id) {
	$("#accountSetupContainer").toggle();
}

function showMapping(pr_business_id) {
	showSection(['mappingContainer']);
	$("#mappingInvoiceUnitNameText").text(invoiceUnitData[pr_business_id].invoice_unit_name);
	fetchVatTaxRates();

	$("#spinner").show();
	$.ajax({
		method: "POST",
		url: "reservation.php?6050",
		data:{
			'method': 'ajax',
			'action': 'fetchMapping',
			'pr_business_id': pr_business_id
		},
	})
	.done(function(items) {
		items = JSON.parse(items);
		fisDebug("items:");
		fisDebug(items);
		mappedItems = transformArrayKeys(items.mappedItems, "code", "name");
		mappingItems = transformArrayKeys(items.mappingItems, "code", "name");

		$(".tabMapping").hide();
		fisDebug("invoiceUnitData");
		fisDebug(invoiceUnitData);
		if (
			invoiceUnitData &&
			invoiceUnitData[pr_business_id] &&
			invoiceUnitData[pr_business_id].account &&
			invoiceUnitData[pr_business_id].account.business &&
			invoiceUnitData[pr_business_id].account.business.integratorId
		) {
			switch (invoiceUnitData[pr_business_id].account.business.integratorId) {
				case "1":	// eTaxWare
					populateMappingPage('commodity', pr_business_id, mappedItems, mappingItems);
					populateMappingPage('units', pr_business_id, mappedItems, mappingItems);					
					populateMappingPage('taxrate', pr_business_id, mappedItems, mappingItems);
					populateMappingPage('taxcommodity', pr_business_id, mappedItems, mappingItems);
					populateMappingPage('country', pr_business_id, mappedItems, mappingItems);
					populateMappingPage('currency', pr_business_id, mappedItems, mappingItems);
					break;
				case "2":	// Tremol
					populateMappingPage('commodity', pr_business_id, mappedItems, mappingItems);
					populateMappingPage('taxrate', pr_business_id, mappedItems, mappingItems);
					break;
				case "3":	// Tevin
					populateMappingPage('commodity', pr_business_id, mappedItems, mappingItems);
					populateMappingPage('taxrate', pr_business_id, mappedItems, mappingItems);
					break;
			}
		}
		$("#spinner").hide();
	});
}

function populateMappingPage(tabName, pr_business_id, mappedItems, mappingItems) {
	var title = "";
	var tabID = "";
	switch (tabName) {
		case 'commodity':
			title = "Commodities";
			tabID = "tabMappingCommodity";
			$("#tabMappingCommodityTab").show();
			if (
				invoiceUnitData[pr_business_id].account.business.integratorId == "2" ||
				invoiceUnitData[pr_business_id].account.business.integratorId == "3"
			) {
				// Kenya uses HS codes, we use Commodity mapping for mapping HS codes
				$("#tabMappingCommodityTitle").text("HS Codes");
			}
			break;
		case 'units':
			title = "Measurement Units";
			tabID = "tabMappingUnits";
			$("#tabMappingUnitsTab").show();
			break;
		case 'taxrate':
			title = "Tax Rates";
			tabID = "tabMappingTaxRate";
			$("#tabMappingTaxRateTab").show();
			break;
		case 'taxcommodity':
			title = "Tax Commodity";
			tabID = "tabMappingTaxCommodity";
			$("#tabMappingTaxCommodityTab").show();
			break;
		case 'country':
			title = "Countries";
			tabID = "tabMappingCountry";
			$("#tabMappingCountryTab").show();
			break;
		case 'currency':
			title = "Currencies";
			tabID = "tabMappingCurrency";
			$("#tabMappingCurrencyTab").show();
			break;
		default:
			break;
	}

	var html = ``;

	if (tabName == "units") {
		// Special case: Units map against Commodity or Commodity Categories
		html += `
			<table class="uk-align-center mappingContent" width="770" border="0" cellspacing="0" cellpadding="0">
				<col width="200" />
				<col width="570" />
				<tr>
					<td>Tax Commodity:</td>
					<td title="Select Commodity">
						<select id="selectCommodity` + tabName + `" style="width: 100%"></select>
					</td>
				</tr>
				<tr>
					<td>Measurement unit:</td>
					<td title="Select Measurement Unit">
						<select id="selectUnits` + tabName + `" style="width: 100%"></select>
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<button
							class="button"
							onclick="addMapping('` + tabName + `', '` + pr_business_id + `');"
							style="width: 55px;"
						>
							Save
						</button>
					</td>
				</tr>
			</table>

			<div class="uk-text-right">
				<input class="search" type="text" placeholder=" Type to filter" onkeyup="filterList(this.value);">
			</div>

			<table class="uk-align-center" width="770" border="0" cellspacing="0" cellpadding="4" style="margin-top: 10px;">
				<tr>
					<td class="outLt" width="300">Tax Commodity</td>
					<td class="outLt" width="300">Measurement unit</td>
					<td class="outLt" width="170">&nbsp;</td>
				</tr>
		`;

		if (mappedItems[tabName] && mappedItems[tabName].tenantCodes) {
			$.each(mappedItems[tabName].tenantCodes, function(key, mapping) {
				html += `
					<tr class="searchable">
						<td class="bl br" title="Code: ` + mapping.tenantCode + `">` + mappedItems.commodity.sourceCodes[mapping.tenantCode] + `</td>
						<td class="br">
							<span title="Code: ` + mapping.providerCode + `">
							` + mappedItems.units.sourceCodes[mapping.providerCode] + `
							</span>
						</td>
						<td class="br uk-text-right">
							<button
								class="button"
								onclick="deleteMapping('` + tabName + `', '` + pr_business_id + `', '` + mapping.tenantCode + `');"
								style="width:55px;"
							>
								Delete
							</button>
						</td>
					</tr>
				`;
			});
		}
		html += `
				<tr>
					<td class="bl bb br">&nbsp;</td>
					<td class="bb br">&nbsp;</td>
					<td class="bb br">&nbsp;</td>
				</tr>
			</table>
		`;

		var select2CommodityData = [];
		if (mappedItems.commodity && mappedItems.commodity.sourceCodes) {
			Object.keys(mappedItems.commodity.sourceCodes).forEach(function(code) {
				select2CommodityData.push({
					id: code,
					text: mappedItems.commodity.sourceCodes[code]
				});
			});
		}

		var select2UnitData = [];
		if (mappedItems[tabName] && mappedItems[tabName].sourceCodes) {
			Object.keys(mappedItems.units.sourceCodes).forEach(function(code) {
				select2UnitData.push({
					id: code,
					text: mappedItems.units.sourceCodes[code]
				});
			});
		}
	} else if (tabName == "taxcommodity") {
		// Special case: Tax Commodities are tax rates mapped to commodities
		html += `
			<table class="uk-align-center mappingContent" width="770" border="0" cellspacing="0" cellpadding="0">
				<col width="200" />
				<col width="570" />
				<tr>
					<td>Tax rate:</td>
					<td title="Select Tax rate">
						<select id="selectTaxRate` + tabName + `" style="width: 100%"></select>
					</td>
				</tr>
				<tr>
					<td>Commodity:</td>
					<td title="Select Commodity">
						<select id="selectCommodity` + tabName + `" style="width: 100%"></select>
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<button
							class="button"
							onclick="addMapping('` + tabName + `', '` + pr_business_id + `');"
							style="width: 55px;"
						>
							Save
						</button>
					</td>
				</tr>
			</table>

			<div class="uk-text-right">
				<input class="search" type="text" placeholder=" Type to filter" onkeyup="filterList(this.value);">
			</div>

			<table class="uk-align-center" width="770" border="0" cellspacing="0" cellpadding="4" style="margin-top: 10px;">
				<tr>
					<td class="outLt" width="300">Tax rate</td>
					<td class="outLt" width="300">Commodity</td>
					<td class="outLt" width="170">&nbsp;</td>
				</tr>
		`;
		fisDebug("mappedItems: ");
		fisDebug(mappedItems);
		$.each(mappedItems[tabName].tenantCodes, function(key, mapping) {
			html += `
				<tr class="searchable">
					<td class="bl br" title="Code: ` + mapping.tenantCode + `">` + mappingItems.taxrate[mapping.tenantCode] + `</td>
					<td class="br">
						<span title="Code: ` + mapping.providerCode + `">
						` + mappingItems.commodity[mapping.providerCode] + `
						</span>
					</td>
					<td class="br uk-text-right">
						<button
							class="button"
							onclick="deleteMapping('` + tabName + `', '` + pr_business_id + `', '` + mapping.tenantCode + `');"
							style="width:55px;"
						>
							Delete
						</button>
					</td>
				</tr>
			`;
		});

		html += `
				<tr>
					<td class="bl bb br">&nbsp;</td>
					<td class="bb br">&nbsp;</td>
					<td class="bb br">&nbsp;</td>
				</tr>
			</table>
		`;

		var select2TaxRateData = [];
		if (mappingItems.taxrate) {
			Object.keys(mappingItems.taxrate).forEach(function(code) {
				select2TaxRateData.push({
					id: code,
					text: mappingItems.taxrate[code]
				});
			});
		}

		var select2CommodityData = [];
		if (mappingItems.commodity) {
				Object.keys(mappingItems.commodity).forEach(function(code) {
				select2CommodityData.push({
					id: code,
					text: mappingItems.commodity[code]
				});
			});
		}
	} else {
		// For everything else, normal tenant/provider mapping
		var providerNote = "";
		if (tabName == "commodity" && invoiceUnitData[pr_business_id].account.business.integratorId == "1") {
			// Efris uses units with their commodities
			providerNote = "(with units mapped)";
		}

		var addTaxrateHtml = "";
		var headingTaxrateHtml = "";
		var footerTaxrateHtml = "";

		if (tabName == "taxrate") {
			addTaxrateHtml = `
				<tr>
					<td>
						VAT
					</td>
					<td>
						<select id="selectVattaxrate">
							<option value="0">Standard VAT</option>
							<option value="1" selected>VAT-related</option>
							<option value="2">Non-VAT</option>
						</select>
					</td>
				</tr>
			`;
			headingTaxrateHtml = `<td class="outLt">VAT</td>`;
			footerTaxrateHtml = `<td class="bb br">&nbsp;</td>`;
		}
		
		html += `
			<table class="uk-align-center mappingContent" width="770" border="0" cellspacing="0" cellpadding="0">
				<col width="200" />
				<col width="570" />
				<tr>
					<td>ResRequest item:&nbsp;</td>
					<td title="Select Tenant item">
						<select id="selectTenant` + tabName + `" style="width: 100%"></select>
					</td>
				</tr>
				<tr>
					<td>Provider item ` + providerNote + `:</td>
					<td title="Select Provider item">
						<select id="selectProvider` + tabName + `" style="width: 100%"></select>
					</td>
				</tr>
				` + addTaxrateHtml + `
				<tr>
					<td colspan="2">
						<button
							class="button"
							onclick="addMapping('` + tabName + `', '` + pr_business_id + `');"
							style="width: 55px;"
						>
							Save
						</button>
					</td>
				</tr>
			</table>

			<div class="uk-text-right">
				<input class="search" type="text" placeholder=" Type to filter" onkeyup="filterList(this.value);">
			</div>

			<table class="uk-align-center" width="770" border="0" cellspacing="0" cellpadding="4" style="margin-top: 10px;">
				<tr>
					<td class="outLt" width="300">ResRequest name</td>
					<td class="outLt" width="300">Provider name</td>
					` + headingTaxrateHtml + `
					<td class="outLt" width="170"></td>
				</tr>
		`;

		if (mappedItems[tabName] && mappedItems[tabName].tenantCodes) {
			let mappingItemList = Object.keys(mappingItems[tabName]);
			$.each(mappedItems[tabName].tenantCodes, function(key, mapping) {
				var mappedTaxrateHtml = "";
				if (tabName == "taxrate") {
					if (vatTaxRates[mapping.tenantCode] == '0') {
						mappedTaxrateHtml = `<td class="mappedTaxrateTd` + mapping.tenantCode + ` br" width="100">Standard VAT</td>`;
					}
					if (vatTaxRates[mapping.tenantCode] == '1') {
						mappedTaxrateHtml = `<td class="mappedTaxrateTd` + mapping.tenantCode + ` br" width="100">VAT-related</td>`;
					}
					if (vatTaxRates[mapping.tenantCode] == '2') {
						mappedTaxrateHtml = `<td class="mappedTaxrateTd` + mapping.tenantCode + ` br" width="100">Non-VAT</td>`;
					}
				}

				if (mappingItemList.indexOf(mapping.tenantCode) >= 0) {
					html += `
							<tr class="searchable">
								<td class="bl br" title="Code: ` + mapping.tenantCode + `">` + mappingItems[tabName][mapping.tenantCode] + `</td>
								<td class="br">
									<span title="Code: ` + mapping.providerCode + `">` + mapping.providerCode + `: 
									` + mappedItems[tabName].sourceCodes[mapping.providerCode] + `
									</span>
								</td>
								` + mappedTaxrateHtml + `
								<td class="br uk-text-right">
									<button
										class="button"
										onclick="deleteMapping('` + tabName + `', '` + pr_business_id + `', '` + mapping.tenantCode + `');"
										style="width:55px;"
									>
										Delete
									</button>
								</td>
							</tr>
					`;
				}
			});
		}
		html += `
				<tr>
					<td class="bl bb br">&nbsp;</td>
					<td class="bb br">&nbsp;</td>
					` + footerTaxrateHtml + `
					<td class="bb br">&nbsp;</td>
				</tr>
		</table>
		`;
		fisDebug(tabName);
		fisDebug(mappingItems);
		var select2TenantData = [];
		if (mappingItems[tabName]) {
			let mappedItemList = mappedItems[tabName].tenantCodes.map( ({ tenantCode }) => tenantCode);
			Object.keys(mappingItems[tabName]).forEach(function(code) {
				let isMapped = (mappedItemList.indexOf(code) < 0) ? '' : '* ';
				select2TenantData.push({
					id: code,
					text: isMapped+mappingItems[tabName][code]
				});
			});
		}
		fisDebug(mappedItems);
		var select2ProviderData = [];
		if (mappedItems[tabName] && mappedItems[tabName].sourceCodes) {
			Object.keys(mappedItems[tabName].sourceCodes).forEach(function(code) {
				let tabShowCode = tabName == 'commodity' ? code+": " : '';
				select2ProviderData.push({
					id: code,
					text: tabShowCode+mappedItems[tabName].sourceCodes[code]
				});
			});
		}

		if (tabName == "commodity" && invoiceUnitData[pr_business_id].account.business.integratorId == 1) {	// for Efris only
			// Cull commodities without unit mapping
			select2ProviderDataCulled = [];
			Object.keys(select2ProviderData).forEach(function(commodityKey) {
				Object.keys(mappedItems.units.tenantCodes).forEach(function(mappedKey) {
					if (mappedItems.units.tenantCodes[mappedKey].tenantCode == select2ProviderData[commodityKey].id) {
						select2ProviderDataCulled.push({
							id: select2ProviderData[commodityKey].id,
							text: select2ProviderData[commodityKey].text
						})
					}
				});
			});
			select2ProviderData = select2ProviderDataCulled;
		}
	}

	$("#" + tabID).html(html);
	$(document).ready(function() {
		if (tabName == "taxcommodity") {
			$("#selectTaxRate" + tabName).select2({
				data: select2TaxRateData,
				sorter: data => data.sort((a, b) => a.text.localeCompare(b.text))				
			});
			$("#selectCommodity" + tabName).select2({
				data: select2CommodityData
			});
		} else if (tabName == "units") {
			$("#selectCommodity" + tabName).select2({
				data: select2CommodityData
			});
			$("#selectUnits" + tabName).select2({
				data: select2UnitData,
				sorter: data => data.sort((a, b) => a.text.localeCompare(b.text))				
			});
			$("#selectUnits" + tabName).val("UN").trigger('change');
		} else {
			fisDebug(select2TenantData);
			$("#selectTenant" + tabName).select2({
				data: select2TenantData
			});
			$("#selectProvider" + tabName).select2({
				data: select2ProviderData
			});
		}

		if (tabName == "taxrate") {
			$("#selectVattaxrate").select2();
		}
		
	});
}

function addMapping(tabName, pr_business_id) {
	$("#spinner").show();

	if (tabName == "units") {
		var data = {
			"tenantCode": $("#selectCommodity" + tabName).val(),
			"providerCode": $("#selectUnits" + tabName).val()
		}
	} else {
		var data = {
			"tenantCode": $("#selectTenant" + tabName).val(),
			"providerCode": $("#selectProvider" + tabName).val()
		}
	}

	if (tabName == "taxcommodity") {
		$.ajax({
			method: "POST",
			url: "reservation.php?6050",
			data:{
				'method': 'ajax',
				'action': 'addMappingTaxcommodity',
				'pr_business_id': pr_business_id,
				"tenantCode": $("#selectTaxRate" + tabName).val(),
				"providerCode": $("#selectCommodity" + tabName).val()
			},
		})
		.done(function(result) {
			$("#spinner").hide();
			showMapping(pr_business_id);
		});
	} else {
		$.ajax({
			method: "post",
			url: fiscalatorUrl + "/map/" + tabName,
			dataType: "json",
			headers: {
				"key": invoiceUnitData[pr_business_id].fiscalator_key
			},
			data: data
		})
		.done(function(result) {
			if (tabName == "taxrate") {
				saveVatTaxRate();
			}
			$("#spinner").hide();
			showMapping(pr_business_id);
		});
	}
}

function deleteMapping(tabName, pr_business_id, tenantCode) {
	$("#spinner").show();
	if (tabName == 'taxcommodity') {
		$.ajax({
			method: "POST",
			url: "reservation.php?6050",
			data:{
				'method': 'ajax',
				'action': 'deleteMappingTaxcommodity',
				'pr_business_id': pr_business_id,
				"tenantCode": tenantCode
			},
		})
		.done(function(result) {
			$("#spinner").hide();
			showMapping(pr_business_id);
		});
	} else {
		$.ajax({
			method: "delete",
			url: fiscalatorUrl + "/map/" + tabName + "/" + tenantCode,
			dataType: "json",
			headers: {
				"key": invoiceUnitData[pr_business_id].fiscalator_key
			},
		})
		.done(function(result) {
			$("#spinner").hide();
			showMapping(pr_business_id);
		});
	}
}

function transformArrayKeys(sourceArray, newKey, newValue) {
	// This function will recursively iterate through nested objects, and convert the arrays
	// that have values matching newKey and newValue, into key:pair objects
	if (sourceArray != undefined) {
		$.each(sourceArray, function(key, value) {
			if (Array.isArray(value)) {
				var transformedArray = [];
				var transforming = false;
				$.each(value, function(tmpKey, tmpValue) {
					if (tmpValue.hasOwnProperty(newKey) && tmpValue.hasOwnProperty(newValue)) {
						transformedArray[tmpValue[newKey]] = tmpValue[newValue];
						transforming = true;
					}
				});
				if (transforming) {
					sourceArray[key] = transformedArray;
				}
			} else {
				sourceArray[key] = transformArrayKeys(value, newKey, newValue);
			}
		});
	}
	return sourceArray;
}

function showSection(sections) {
	// Shows one or more specified sections (that has class .sectionContainer)
	// Pass array for multiple, ie. showSection(['invoiceUnitSetupContainer', 'accountSetupContainer']);
	$(".sectionContainer").hide();
	if (Array.isArray(sections)) {
		$.each(sections, function(key, value) {
			$("#" + sections[key]).show();
		});
	} else {
		$("#" + sections).show();
	}
}

function fiscaliseInvoice(fn_invoice_id) {
	$.ajax({
		method: "POST",
		url: "reservation.php?6050",
		data:{
			'method': 'ajax',
			'action': 'fiscalise',
			'fn_invoice_id': fn_invoice_id
		},
	})
	.done(function(result) {
		result = JSON.parse(result);
		var resultMessage = [];
		$.each(result.results, function(key, record) {
			resultMessage.push(record.responseMessage);
			$.each(record.data, function(key2, subRecord) {
				resultMessage.push(' * ' + subRecord.message);
			});
		});
		overlayPopup('Fiscalisation', resultMessage.join("<br>"));
	});
}

function uploadProduct(pr_business_id, product_id, product_name) {
	$.ajax({
		method: "POST",
		url: "reservation.php?6050",
		data:{
			'method': 'ajax',
			'action': 'getProductDetails',
			'product_id': product_id,
			'product_name': product_name
		},
	})
	.done(function(result) {
		result = JSON.parse(result);
		$.ajax({
			method: "post",
			url: fiscalatorUrl + "/product",
			dataType: "json",
			headers: {
				"key": invoiceUnitData[pr_business_id].fiscalator_key
			},
			data: {
				"name": result[0].name,
				"id": product_id,
				"currency": result[0].currency
			},
		})
		.done(function(resultFis) {
			overlayPopup('Fiscalisation', resultFis.responseMessage);
		});
		
	});
}

function showFiscalInfoByInvoice(invoiceId) {

	$("#overlayPopup").remove();
	overlayPopup('Fiscalisation', `<div id="fiscalOverlayContent" style="min-height: 100px;"></div>`, {}, 500);
	showHideOverlayLoadingCircle("show");

	$.ajax({
		method: "POST",
		url: "reservation.php?6050",
		data:{
			'method': 'ajax',
			'action': 'getFiscalInfoByInvoice',
			'invoiceId': invoiceId
		},
	})
	.done(function(result) {
		result = JSON.parse(result);

		var content = `
			<div style="padding: 10px;">
			<table>
			<tr><td>Invoice:</td><td>` + invoiceId + `</td></tr>
			<tr><td>Status:</td><td>` + result.status + `</td></tr>
		`;

		if (result.message) {
			content += `
				<tr><td valign="top">Message:</td><td>` + result.message + `</td></tr>
			`;	
			if( 
				result.message.toLowerCase().indexOf('command: illegal.') > 0 
				|| 
				result.message.toLowerCase().indexOf('command: ?.') > 0 
				|| 
				result.message.toLowerCase().indexOf(' 3f ') > 0 
			){
				content += `
					<tr><td valign="top">TIMS Error:</td><td>
						Possible reasons:<br>
						- There is a negative amount not linked to an invoice,<br>
						- Any existing invoices already have credit invoices linked to them,<br>
						- The invoice item amounts are less than the amount being credited.
					</td></tr>
				`;
			}
		}

		if (result.integratorData) {
			content += `
				<tr><td valign="top">Integrator Data:</td><td class="integratorData">` + result.integratorData + `</td></tr>
			`;
		}
		content += `</table></div>`;

		var buttons = {
			'a':{'label':'Close', 'callback':'', 'class':'masterButton'}
		};

		switch (result.statusCode) {
			case '0':		// unknown error
			case '3':		// rejected
			case '4':		// invoice error
				buttons.b = {'label':'Resubmit', 'callback':'resubmitFiscalation(\'' + invoiceId + '\', false)', 'class':'doNotClose'};
				break;
			case '1':		// invoice pending
				buttons.c = {'label':'Query', 'callback':'queryInvoice(\'' + invoiceId + '\')', 'class':'doNotClose'};	
				break;
			case '6':		// credit pending approval
				buttons.e = {'label':'Query Approval', 'callback':'queryCreditApproval(\'' + invoiceId + '\')', 'class':'doNotClose'};
				break;
			case '5':		// credit pending upload
			case '8':		// credit error
				buttons.f = {'label':'Resubmit', 'callback':'resubmitFiscalation(\'' + invoiceId + '\', true)', 'class':'doNotClose'};
				break;
		}

		id("overlayPopup").remove();
		overlayPopup('Fiscalisation', content, buttons, 500);
	});
}


function resubmitFiscalation(invoiceId, credit=false) {

	$("#overlayPopup").remove();
	overlayPopup('Fiscalisation', `<div id="fiscalOverlayContent" style="min-height: 100px;"></div>`, {}, 500);
	showHideOverlayLoadingCircle("show");
	var action = credit ? 'resubmitCreditForFiscalisation' : 'resubmitInvoiceForFiscalisation';

	$.ajax({
		method: "POST",
		url: "reservation.php?6050",
		data:{
			'method': 'ajax',
			'action': action,
			'invoiceId': invoiceId
		},
	})
	.done(function(result) {
		showFiscalInfoByInvoice(invoiceId)
	});
}

function invoiceHasLinkedCredit(invoiceId) {
	$("#overlayPopup").remove();
	showHideOverlayLoadingCircle("show");

	$.ajax({
		method: "POST",
		url: "reservation.php?6050",
		data:{
			'method': 'ajax',
			'action': 'callQueryCreditInvoiceLink',
			'invoiceId': invoiceId
		},
	})
	.done(function(result) {
		linkedItems = JSON.parse(result);

		if(linkedItems.length > 0) {
			showHasCreditPopup(linkedItems, invoiceId);
			return true;
		}
		else {
			return false;
		}
	});
}

function showHasCreditPopup(linkedItems, invoiceId) {
	$('#voidInvoiceOptions').css("display","none");
	linkedItemListDisplay = linkedItems.toString().replace(/,/g, '<br>');
	var content = `
	<div style="padding: 10px;">
	<table>
		<tr><td>Invoice:</td><td>` + invoiceId + `</td></tr>
		<tr><td>Status:</td><td>Cannot reverse. Invoice/Credit note link exists.</td></tr>
		<tr><td>&nbsp;</td><td>` + linkedItemListDisplay + `</td></tr>
	</table></div>`;

	var buttons = {
	'a':{'label':'Close', 'callback':'', 'class':'masterButton'}
	};
	overlayPopup('Fiscalisation', content, buttons, 500);
}

function queryInvoice(invoiceId) {

	$("#overlayPopup").remove();
	overlayPopup('Fiscalisation', `<div id="fiscalOverlayContent" style="min-height: 100px;"></div>`, {}, 500);
	showHideOverlayLoadingCircle("show");

	$.ajax({
		method: "POST",
		url: "reservation.php?6050",
		data:{
			'method': 'ajax',
			'action': 'queryInvoice',
			'invoiceId': invoiceId
		},
	})
	.done(function(result) {
		showFiscalInfoByInvoice(invoiceId)
	});
}

function queryCreditApproval(invoiceId) {

	$("#overlayPopup").remove();
	overlayPopup('Fiscalisation', `<div id="fiscalOverlayContent" style="min-height: 100px;"></div>`, {}, 500);
	showHideOverlayLoadingCircle("show");

	$.ajax({
		method: "POST",
		url: "reservation.php?6050",
		data:{
			'method': 'ajax',
			'action': 'queryCreditApproval',
			'invoiceId': invoiceId
		},
	})
	.done(function(result) {
		showFiscalInfoByInvoice(invoiceId)
	});
}

function filterList(searchString) {
	$("tr.searchable").hide();
	$("td").filter(function() {
		return $(this).text().toLowerCase().indexOf(searchString.toLowerCase()) !== -1;
	}).parent().show();
}

function fetchVatTaxRates() {
	$.ajax({
		method: "POST",
		url: "reservation.php?6050",
		data:{
			'method': 'ajax',
			'action': 'fetchVatTaxRates'
		},
	})
	.done(function(result) {
		vatTaxRates = JSON.parse(result);
		updateVatTaxRateDisplays();
	});
}

function saveVatTaxRate() {
	$.ajax({
		method: "POST",
		url: "reservation.php?6050",
		data:{
			'method': 'ajax',
			'action': 'saveVatTaxRate',
			'taxRateId': $("#selectTenanttaxrate").val(),
			'vatIndicator': $("#selectVattaxrate").children("option:selected").val()
		},
	})
	.done(function(result) {
		vatTaxRates = JSON.parse(result);
		updateVatTaxRateDisplays();
	});
}

function updateVatTaxRateDisplays() {
	Object.keys(vatTaxRates).forEach(function(taxrate) {
		var mappedTaxrateHtml = ``;
		if (vatTaxRates[taxrate] == '0') {
			mappedTaxrateHtml = `Standard VAT`;
		}
		if (vatTaxRates[taxrate] == '1') {
			mappedTaxrateHtml = `VAT-related`;
		}
		if (vatTaxRates[taxrate] == '2') {
			mappedTaxrateHtml = `Non-VAT`;
		}
		$(".mappedTaxrateTd" + taxrate).html(mappedTaxrateHtml);
	});
	
}

function fisDebug(message) {
	var host = window.location.host;
	if (host.includes("vagrant") || host.includes("jaco-test") || host.includes("rrdev")) {
		console.log(message);
	}
}