var pageRequested			= "";
var pageRequestUnitID	= "";
var pageRequestExtra = false;

// Variable used to keep track of which accounts under Banks/Cashpoints and 
// which Cost Centres and GL Codes under Extras have been edited
var editedCellIDs				= [];

function glKeyPress(event) {
	if(id("mode").value == "add" && event.keyCode == 9) {
		switch ( id("fun_job_id").value ) {
		case "278":
			addGlCode();
			break;
		case "279":
			addCostCentre();
			break;
		case "287":
			addDebtor();
			break;
		}
	}
}

function filterKeyPress(e) {
	if(!e) e = window.event;
	if(e.keyCode == "13") {
		glFilter();
	}
}

function saveCheck(page,aID,e,batch,extra) {
	var targ;
	if(e) {
		targ = getEventTarget(e);
	} else {
		targ = {
			id: ""
		};
	}

	pageRequested = page;
	pageRequestUnitID = aID;
	pageRequestExtra = extra;

	if(id("mode") && (id("mode").value == "edit" || id("mode").value == "add")) {
		// We are in add/edit mode. Now we check to see if they have clicked save or cancel
		if(targ.id === "" || (targ.id != "btnAdd" && targ.id != "btnSave" && targ.id != "btnCancel")) {
			openModal("Do you want to save your changes?",batch);
		}
	} else {
		if(!batch) {
			getPage(page,aID,extra);
		} else {
			window.close();
		}
	}
}

function getPage(page,aID,extra) {
	if(page === 0 && aID === 0) {
		// The user has hit the "Close" button ------------------------------------
		applyTrans(0);
		hideAjaxDiv();
	} else {
		applyTrans(1);
		aRequestAbort();
		centerDivOnPage("ajaxDiv");
		id("ajaxDiv").style.display = "";
		showLoad();
		var url = "reservation.php?" + page + "+" + aID;
		if(extra) {
			url += "+" + extra;
		}
		aRequestPost(url,processAJAX,"","");
	}
}

var inBatch = false;

function openModal(text,batch) {
	if(batch) {
		inBatch = true;
		applyTrans(1);
	}
	id("modalText").innerHTML = "<p><strong>" + text + "</strong></p>";
	id("glModalDiv").style.display	= "";
	id("trans").style.zIndex = "199";
	id("glModalDiv").style.zIndex = "200";
	centerDivOnPage("glModalDiv");
}

function closeModal() {
	id("glModalDiv").style.display = "none";
	id("glModalDiv").style.zIndex = "1";
	if(!inBatch) {
		id("trans").style.zIndex = "99";
	} else {
		applyTrans(0);
	}
}

function openErrorModal(text) {
	id("errorModalText").innerHTML = "<p><strong>" + text + "</strong></p>";
	id("errorModalDiv").style.display	= "";
	id("trans").style.zIndex = "199";
	id("errorModalDiv").style.zIndex = "200";
	centerDivOnPage("errorModalDiv");
}

function closeErrorModal() {
	id("errorModalDiv").style.display = "none";
	id("errorModalDiv").style.zIndex = "1";
	id("trans").style.zIndex = "99";
}

function processAJAX(result,response) {
	if ( result ) {
		wait.hide();
		id("ajaxDiv").innerHTML = response;
		centerDivOnPage("ajaxDiv");						
	}
}

function hideAjaxDiv() {
	// Clear our hidden inputs that hold Unit specific data
	id("edited").value = "";
	id("mode").value = "";
	id("ajaxDiv").style.display = "none";
	id("ajaxDiv").innerHTML = "<div class=\"ajaxLoad\">LOADING...<br /><img src=\"/resource/Resrequest/Application/public/img/ajaxload.gif\" width=\"220\" height=\"19\" alt=\"\" /></div>";
}

function glDeleteSelected() {
	var fun_job_id = id("fun_job_id").value;
	var iUnitID = id("iUnitID").value;

	// Get a list of all the checkboxes ------------------------------------------
	var inputs = document.getElementsByTagName("INPUT");
	var idsToDelete = [];

	for(var i=0;i<inputs.length;i++ ) {
		if(inputs[i].getAttribute("type") == "checkbox") {
			if(inputs[i].checked) {
				idsToDelete.push(inputs[i].getAttribute("id").replace("check",""));
			}
		}
	}

	if(idsToDelete.length > 0) {
		data = idsToDelete.join(":");
		aRequestAbort();
		wait.show();
		aRequestPost("reservation.php?" + fun_job_id + "+" + iUnitID + "+delete+" + data,processAJAX,"","");
	}
}

function cancelEdit() {
	var fun_job_id	= id("fun_job_id").value;
	var iUnitID = id("iUnitID").value;
	getPage(fun_job_id,iUnitID);
}


// [START] Main Edit function -------------------------------------------------
function glEdit(aID,e) {
	var fun_job_id	= parseInt(id("fun_job_id").value,10);
	var iUnitID = id("iUnitID").value;

	id("btnCancel").className = "button";
	id("btnSave").className = "button";

	if(id("btnAdd")) {
		id("btnAdd").setAttribute("disabled","disabled");
		id("btnAdd").className = "inLtt";
	}

	id("mode").value = "edit";

	// Check for duplicated IDs --------------------------------------------------
	if(id("edited").value.indexOf(aID) < 0) {
		id("edited").value	= id("edited").value + ":" + aID;
	}
	switch ( fun_job_id ) {
	// GL Codes -----------------------------------------------------
	case 278 :
		id(aID).setAttribute("onmouseout","");
		id("input1" + aID).setAttribute("onclick","");
		id("input2" + aID).setAttribute("onclick","");

		GLCode = createInput("input1" + aID);
		GLCode.setAttribute("id","i_input1" + aID);
		GLCode.setAttribute("value",idText("input1" + aID));
		id("input1" + aID).innerHTML = "";
		id("input1" + aID).appendChild(GLCode);
	
		GLDescription = createInput("input2" + aID);
		GLDescription.setAttribute("id","i_input2" + aID);
		GLDescription.setAttribute("value",idText("input2" + aID));
		id("input2" + aID).innerHTML = "";
		id("input2" + aID).appendChild(GLDescription);

		id("i_input1" + aID).focus();
		id("i_input1" + aID).select();
		break;
	// Cost Centres ---------------------------------------------------------------
	case 279 :
		id(aID).setAttribute("onmouseout","");
		id("cell1" + aID).setAttribute("onclick","");
		id("cell2" + aID).setAttribute("onclick","");
		id("cell3" + aID).setAttribute("onclick","");

		ccCode = createInput("cell1" + aID);
		ccCode.setAttribute("id","i_cell1" + aID);
		ccCode.setAttribute("value",idText("cell1" + aID));
		ccCode.style.width = "114px";
		id("cell1" + aID).innerHTML = "";
		id("cell1" + aID).appendChild(ccCode);

		ccName = createInput("cell2" + aID);
		ccName.setAttribute("id","i_cell2" + aID);
		ccName.setAttribute("value",idText("cell2" + aID));
		ccName.style.width = "188px";
		id("cell2" + aID).innerHTML = "";
		id("cell2" + aID).appendChild(ccName);

		ccLevelSelect = document.createElement("select");
		ccLevelSelect.setAttribute("id","i_cell3" + aID);
		ccLevelSelect.style.width = "144px";
	
		currentLevel = parseInt(id("cell3" + aID).innerHTML.replace("Level ",""),10);

		ccLevelOption1 = document.createElement("option");
		ccLevelOption1.setAttribute("value","1");
		if(currentLevel == 1) {
			ccLevelOption1.setAttribute("selected","selected");
		}
		ccLevelOption1.innerHTML = "Level 1";
	
		ccLevelOption2 = document.createElement("option");
		ccLevelOption2.setAttribute("value","2");
		if(currentLevel == 2) {
			ccLevelOption2.setAttribute("selected","selected");
		}
		ccLevelOption2.innerHTML = "Level 2";
	
		ccLevelSelect.appendChild(ccLevelOption1);
		ccLevelSelect.appendChild(ccLevelOption2);
	
		id("cell3" + aID).innerHTML = "";
		id("cell3" + aID).appendChild(ccLevelSelect);
		break;
	// Properties, Accommodation, Extra Categories and 
	// Contacts/Debtors
	case 280 :
	case 281 :
	case 288 :
		id(aID).setAttribute("onmouseout","");
		id("cell1" + aID).setAttribute("onclick","");
		id("cell2" + aID).setAttribute("onclick","");

		id("cell2" + aID).innerHTML = id("hidden" + aID).innerHTML;
		// We now have two select elements with the same ID. We need to change the
		// visible one's ID so we can get it's value when the Save button is clicked
		id("cell2" + aID).firstChild.setAttribute("id",id("cell2" + aID).firstChild.getAttribute("id").replace("cell2Select","e"));
		break;
	// Banks/Cashpoints, Extras & Rate components, Stock Locations  --------------------------------------------------
	case 282 :
	case 283 :
	case 284 :
	case 285 :
	case 4002 :
	case 4003 :
		var tag = getEventTarget(e).tagName.toString().toLowerCase();
		if(tag == "span") {
			var targ = getEventTarget(e).parentNode;
		} else {
			var targ = getEventTarget(e);
		}

		editedCellIDs.push(targ.id);

		id(aID).setAttribute("onmouseout","");
		id("cell1" + aID).setAttribute("onclick","");
		id(targ.id).setAttribute("onclick","");

		id(targ.id).innerHTML = id(targ.id + "Hidden").innerHTML;
	
		// We now have two select elements with the same ID. We need to change the
		// visible one's ID so we can get it's value when the Save button is clicked
		id(targ.id).firstChild.setAttribute("id",id(targ.id).firstChild.getAttribute("id").replace(targ.id + "Select","ed" + targ.id));
		break;
	// Meal plans -----------------------------------------------------
	case 1030 :
		id(aID).setAttribute("onmouseout","");
		id("input1" + aID).setAttribute("onclick","");

		MealCode = createInput("input1" + aID);
		MealCode.setAttribute("id","i_input1" + aID);
		MealCode.setAttribute("value",idText("input1" + aID));
		id("input1" + aID).innerHTML = "";
		id("input1" + aID).appendChild(MealCode);
	
		id("i_input1" + aID).focus();
		id("i_input1" + aID).select();
		break;
	// Tax Rates --------------------------------------------------------------
	case 286 :
		id(aID).setAttribute("onmouseout","");
		id("cell1" + aID).setAttribute("onclick","");
		id("cell2" + aID).setAttribute("onclick","");

		id("cell2" + aID).innerHTML = id("cell2" + aID + "Hidden").innerHTML;
		id("cell2" + aID).firstChild.id = "edcell2"+aID;

		id("edcell2" + aID).focus();
		break;
	// Debtors
	case 287 :
		id(aID).setAttribute("onmouseout","");
		id("input1" + aID).setAttribute("onclick","");
		id("input2" + aID).setAttribute("onclick","");
		id("input3" + aID).setAttribute("onclick","");
		id("input4Cell" + aID).setAttribute("onclick","");
		id("input5" + aID).setAttribute("onclick","");

		GLCode = createInput("input1" + aID);
		GLCode.setAttribute("id","i_input1" + aID);
		GLCode.setAttribute("value",id("input1" + aID + "Value").value);
		GLCode.style.width = "116px";
		id("input1" + aID).innerHTML = "";
		id("input1" + aID).appendChild(GLCode);
	
		GLDescription = createInput("input2" + aID);
		GLDescription.setAttribute("id","i_input2" + aID);
		GLDescription.setAttribute("value",id("input2" + aID + "Value").value);
		GLDescription.style.width = "111px";
		id("input2" + aID).innerHTML = "";
		id("input2" + aID).appendChild(GLDescription);

		id("input3" + aID).innerHTML = id("input3" + aID + "Hidden").innerHTML;
		id("input3" + aID).firstChild.id = "edinput3"+aID;

		id("input4Cell" + aID).innerHTML = id("input4" + aID + "Hidden").innerHTML.replace(/id="input4/g,"id=\"edinput4").replace(/id=input4/g,"id=edinput4");

		id("input5" + aID).innerHTML = id("input5" + aID + "Hidden").innerHTML;
		id("input5" + aID).firstChild.id = "edinput5"+aID;

		id("i_input1" + aID).focus();
		id("i_input1" + aID).select();
		break;
	case 302:
		id(aID).setAttribute("onmouseout","");
		id("desc" + aID).setAttribute("onclick","");
		id("date" + aID).setAttribute("onclick","");

		var yearDesc = createInput("text");
		yearDesc.setAttribute("id","i_desc" + aID);
		yearDesc.setAttribute("value",idText("desc" + aID));
		id("desc" + aID).innerHTML = "";
		id("desc" + aID).appendChild(yearDesc);

		var yearEnd = id("dateRaw" + aID).value.toString().split("-");

		id("date" + aID).innerHTML = '<span id="dateSelectorDate'+aID+'" class="dateSelector" idPrefix="'+aID+'" initialValueDay="'+parseInt(yearEnd[2],10)+'" initialValueMonth="'+parseInt(yearEnd[1],10)+'" initialValueYear="'+yearEnd[0]+'"></span>';
		dateSelector();

		break;
	}
}
// [ END ] Main Edit function -------------------------------------------------

// [START] Main Save function -------------------------------------------------
function glSave() {
	var fun_job_id = parseInt(id("fun_job_id").value,10);
	var iUnitID = id("iUnitID").value;
	var data = "";
	var mode = id("mode").value;
	var addCount = parseInt(id("addCount").value,10);
	var k,i;
	var page = "";
	var error = "";

	// Abort save if nothing has been added or edited
	if(mode == "") {
		openErrorModal("Unable to save until changes have been made");
		return;
	}

	switch(mode) {
	case "add":
		switch(fun_job_id) {
		// [START] GL and Debtor Codes ----------------------------------------
		case 278 :
			for(k=1;k<=addCount;k++) {
				if ( /^New code \d+/.test( id("GLnewID" + k).value ) == true || id("GLnewID" + k).value.trim() == "") {
					error = "Please enter a new code for row "+k;
					break;
				}
				if ( /^New description \d+/.test( id("descnewID" + k).value ) == true || id("descnewID" + k).value.trim() == "") {
					error = "Please enter a new description for row "+k;
					break;
				}
				
				data = data + ":" + encodeURIComponent(id("GLnewID" + k).value) + ":" + encodeURIComponent(id("descnewID" + k).value) + "_";
			}
			if (error == "") {
				id("addCount").value = "0";
			}
			break;
		// [ END ] GL and Debtor Codes ----------------------------------------

		// [START] Cost Centres ---------------------------------------------------
		case 279 :
			for(k=1;k<=addCount;k++) {
				if ( /^New Code \d+/.test( id("ccCodenewID" + k).value ) == true || id("ccCodenewID" + k).value.trim() == "") {
					error = "Please enter a new code for row "+k;
					break;
				}
				if ( /^New Name \d+/.test( id("ccNamenewID" + k).value ) == true || id("ccNamenewID" + k).value.trim() == "") {
					error = "Please enter a new name for row "+k;
					break;
				}

				data = data + ":" + encodeURIComponent(id("ccCodenewID" + k).value) + ":" + encodeURIComponent(id("ccNamenewID" + k).value) + ":" + encodeURIComponent(id("ccLevelnewID" + k).value) + "_";
			}
			if (error == "") {
				id("addCount").value = "0";
			}
			break;
		// [ END ] Cost Centres ---------------------------------------------------
		// [START] Years ----------------------------------------------------------
		case 302:
			for(k=1;k<=addCount;k++) {
				if ( /^New Name \d+/.test( id("descnewID" + k).value ) == true || id("descnewID" + k).value.trim() == "") {
					error = "Please enter a new name for row "+k;
					break;
				}
				newdate = id("newID" + k.toString() + "Year").value + "-" + selValue("newID" + k.toString() + "Month") + "-" + selValue("newID" + k.toString() + "Day");
				data = data + ":" + encodeURIComponent(id("descnewID" + k).value) + ":" + encodeURIComponent(newdate) + "_";
			}
			if (error == "") {
				id("addCount").value = "0";
			}
			break;
		// [ END ] Years ----------------------------------------------------------
		// [START] Debtors --------------------------------------------------------
		case 287 :
			for(k=1;k<=addCount;k++) {
				if ( /^New code \d+/.test( id("GLnewID" + k).value ) == true || id("GLnewID" + k).value.trim() == "") {
					error = "Please enter a new code for row "+k;
					break;
				}
				if ( /^New description \d+/.test( id("descnewID" + k).value ) == true || id("descnewID" + k).value.trim() == "") {
					error = "Please enter a new description for row "+k;
					break;
				}

				data = data + ":" + encodeURIComponent(id("GLnewID" + k).value) + ":" + encodeURIComponent(id("descnewID" + k).value) + ":" + selValue("currnewID" + k) + ":" + id("contactnewID" + k + "Id").value + ":" + selValue("exportnewID" + k) + "_";
			}
			if (error == "") {
				id("addCount").value = "0";
			}
			break;
		}
		break;
		// [ END ] Debtors --------------------------------------------------------
	case "edit":
		var editedIds = id("edited").value.split(":");
		switch(fun_job_id) {
		// General Tab ----------------------------------------------------------------
		case 277 :
			if(!checkEmail(id("fn_system_email").value) && id("fn_system_email").value != "") {
				openMessage("Enter a valid email address");
				id("fn_system_email").focus();
				return false;
			}
			var costCentreTax;
			var sourceCurrency;
			var clearDebtors;
			var glPosting;
			var debtorPosting;
			var financialSystem;
			var paymentTransactions;
			var paymentIgnorePast;
			var depositTransactions;
			var invoiceTransactions;

			var pr_bus_post_inventory_yn
			var pr_bus_post_in_po_yn
			var pr_bus_post_in_returns_yn
			var pr_bus_post_in_cos_yn
			var pr_bus_post_in_issues_yn
			var pr_bus_post_in_trfs_yn

			if(id("genCostCentreTaxYes").checked) {
				costCentreTax = "1";
			} else {
				costCentreTax = "0";
			}
			if(id("genShowSourceCurrencyYes").checked) {
				sourceCurrency = "1";
			} else {
				sourceCurrency = "0";
			}

			if(id("genClearDebtorsYes").checked) {
				clearDebtors = "1";
			} else {
				clearDebtors = "0";
			}
			if(id("glPostingPerTransaction").checked) {
				glPosting = "1";
			} else {
				glPosting = "2";
			}
			if(id("debtorPostingPerTransaction").checked) {
				debtorPosting = "1";
			} else if(id("debtorPostingPerDebtor").checked) {
				debtorPosting = "2";
			} else {
				debtorPosting = "3";
			}

			var systemOptions = id("systemOptions");
			financialSystem = systemOptions.options[systemOptions.selectedIndex].value;

			if(id("genPaymentTransactionsYes").checked) {
				paymentTransactions = "1";
			} else {
				paymentTransactions = "0";
			}

			if(id("genPaymentIgnorePastYes").checked) {
				paymentIgnorePast = "1";
			} else {
				paymentIgnorePast = "0";
			}

			if(id("genDepositGenerateYes").checked) {
				depositTransactions = "1";
			} else {
				depositTransactions = "0";
			}

			if(id("genInvoiceGenerateYes").checked) {
				invoiceTransactions = "1";
			} else {
				invoiceTransactions = "0";
			}

			pr_bus_post_inventory_yn = id("genInventoryGenerateYes").checked ? "1" : "0";

			pr_bus_post_in_po_yn = id("genInvPOGenerateYes").checked ? "1" : "0";

			pr_bus_post_in_returns_yn = id("genInvRetGenerateYes").checked ? "1" : "0";

			pr_bus_post_in_cos_yn = id("genInvCoSGenerateYes").checked ? "1" : "0";

			pr_bus_post_in_issues_yn = id("genInvStIssueGenerateYes").checked ? "1" : "0";

			pr_bus_post_in_trfs_yn = id("genInvStTfrGenerateYes").checked ? "1" : "0";

			// validate inventory transactions
			if (pr_bus_post_inventory_yn == '1'
				&& (
					   pr_bus_post_in_po_yn == '0'
					&& pr_bus_post_in_returns_yn == '0'
					&& pr_bus_post_in_cos_yn == '0'
					&& pr_bus_post_in_issues_yn == '0'
					&& pr_bus_post_in_trfs_yn == '0'
				)
			) {
				openMessage("You have selected Inventory transaction posting. <br>Please select an Inventory transaction type.");
				id("genInventoryGenerateYes").focus();
				return false;
			}

			if (pr_bus_post_inventory_yn == '1' && id("pr_bus_api_client").value == "") {
					openMessage("You have selected Inventory transaction posting. <br>Please fill in both API credential fields.");
					id("pr_bus_api_client").focus();
					return false;
			}

			if (pr_bus_post_inventory_yn == '1' && id("pr_bus_api_token").value == "") {
					openMessage("You have selected Inventory transaction posting. <br>Please fill in both API credential fields.");
					id("pr_bus_api_token").focus();
					return false;
			}

			var envArray = id("environments").value.toString().split(":");
			var envDebtorArray = [];
			for(envId in envArray) {
				var env = envArray[envId];
				var setting = "suspense";
				if(id(env+"debtorEnvCash").checked) {
					setting = "cash";
				}
				envDebtorArray.push(env + "=" + setting);
			}
			var envDebtorString = envDebtorArray.join("!");
			var genValues = [
				/*  0 */ id("genControlAccCode").options[id("genControlAccCode").selectedIndex].value,
				/*  1 */ id("genCashSales").options[id("genCashSales").selectedIndex].value,
				/*  2 */ id("genCashSalesDebtor").options[id("genCashSalesDebtor").selectedIndex].value,
				/*  3 */ id("genPostingSuspense").options[id("genPostingSuspense").selectedIndex].value,
				/*  4 */ id("genPostingSuspenseDebtor").options[id("genPostingSuspenseDebtor").selectedIndex].value,
				/*  5 */ id("genPostingSuspenseForeign").options[id("genPostingSuspenseForeign").selectedIndex].value,
				/*  6 */ id("genPostingSuspenseDebtorForeign").options[id("genPostingSuspenseDebtorForeign").selectedIndex].value,
				/*  7 */ selValue("genDefaultRevenueCentre"),
				/*  8 */ costCentreTax,
				/*  9 */ glPosting,
				/* 10 */ debtorPosting,
				/* 11 */ id("genGLPostingEnvironment").options[id("genGLPostingEnvironment").selectedIndex].value,
				/* 12 */ clearDebtors,
				/* 13 */ id("fn_system_email").value,
				/* 14 */ envDebtorString,
				/* 15 */ sourceCurrency,
				/* 16 */ financialSystem,
				/* 17 */ paymentTransactions,
				/* 18 */ paymentIgnorePast,
				/* 19 */ depositTransactions,
				/* 20 */ invoiceTransactions,
				/* 21 */ selValue("genDefaultMealPlan"),
				/* 22 */ selValue("fn_ledger_id_input_vat"),
				/* 23 */ pr_bus_post_inventory_yn,
				/* 24 */ pr_bus_post_in_po_yn,
				/* 25 */ id("pr_bus_api_url_po").value,
				/* 26 */ pr_bus_post_in_returns_yn,
				/* 27 */ id("pr_bus_api_url_returns").value,
				/* 28 */ pr_bus_post_in_cos_yn,
				/* 29 */ id("pr_bus_api_url_cos").value,
				/* 30 */ pr_bus_post_in_issues_yn,
				/* 31 */ id("pr_bus_api_url_issues").value,
				/* 32 */ pr_bus_post_in_trfs_yn,
				/* 33 */ id("pr_bus_api_url_transfers").value,
				/* 34 */ id("pr_bus_api_client").value,
				/* 35 */ id("pr_bus_api_token").value,
				/* 36 */ id("pr_bus_api_url_base").value,
			];
			data = genValues.join(":");
			break;
		// GL and Debtor Codes ----------------------------------------------------
		case 278 :
			for(i=1;i<editedIds.length;i++) {
				data = data + editedIds[i] + ":" + encodeURIComponent(id("i_input1" + editedIds[i]).value) + ":" + encodeURIComponent(id("i_input2" + editedIds[i]).value) + "_";
			}
			break;
		// Cost Centres -----------------------------------------------------------
		case 279 :
			for(i=1;i<editedIds.length;i++ ) {
				data = data + editedIds[i] + ":" + encodeURIComponent(id("i_cell1" + editedIds[i]).value) + ":" + encodeURIComponent(id("i_cell2" + editedIds[i]).value) + ":" + encodeURIComponent(id("i_cell3" + editedIds[i]).options[id("i_cell3" + editedIds[i]).selectedIndex].value) + "_";
			}
			break;
		// Properties, Accommodation and Contacts/Debtors
		case 280 :
		case 281 :
		case 288 :
			for(i=1;i<editedIds.length;i++) {
				data = data + editedIds[i] + ":" + encodeURIComponent(id("e" + editedIds[i]).options[id("e" + editedIds[i]).selectedIndex].value) + "_";
			}
			break;
		// Banks/Cashpoints, Extras and Extra Categories, Rate Components --------------------------------------------
		case 282 :
		case 283 :
		case 284 :
		case 285 :
		case 4002 :
		case 4003 :
			var cellData	= [];
			var cellNames	= [];

			for(i=1;i<editedIds.length;i++ ) {
				for(k=0;k<editedCellIDs.length;k++) {
					if(editedCellIDs[k].indexOf(editedIds[i]) > 0) {
						cellData.push(encodeURIComponent(id("ed" + editedCellIDs[k]).options[id("ed" + editedCellIDs[k]).selectedIndex].value));
						cellNames.push(editedCellIDs[k].replace(editedIds[i],""));
					}
				}
				data = data + editedIds[i] + ":" + cellNames.join("|") + ":" + cellData.join("|") + "_";
				cellNames.length	= 0;
				cellData.length		= 0;
			}
			editedCellIDs.length = 0;
			break;
		// Meal plans ----------------------------------------------------
		case 1030 :
			for(i=1;i<editedIds.length;i++) {
				data = data + editedIds[i] + ":" + encodeURIComponent(id("i_input1" + editedIds[i]).value) + "_";
			}
			break;
		// Tax Rates --------------------------------------------------------------
		case 286 :
			for(i=1;i<editedIds.length;i++) {
				data = data + editedIds[i] + ":" + selValue("edcell2" + editedIds[i]) + "_";
			}
			break;
		// Debtors
		case 287 :
			for(i=1;i<editedIds.length;i++) {
				data = data + editedIds[i] + ":" + encodeURIComponent(id("i_input1" + editedIds[i]).value) + ":" + encodeURIComponent(id("i_input2" + editedIds[i]).value) + ":" + selValue("edinput3"+editedIds[i]) + ":" + id("edinput4" + editedIds[i] + "Id").value + ":" + selValue("edinput5"+editedIds[i]) + "_";
			}
			break;		
		case 302:
			for(i=1;i<editedIds.length;i++) {
				var i_date = id(editedIds[i] + "Year").value + "-" + selValue(editedIds[i] + "Month") + "-" + selValue(editedIds[i] + "Day");
				data = data + editedIds[i] + ":" + encodeURIComponent(id("i_desc" + editedIds[i]).value) + ":" + i_date + "_";
			}
			break;
		}
		id("edited").value = "";
		break;
	}
	
	if (error == "") {
		if(id("pageNum")) {
			page = id("pageNum").value;
		}
		aRequestAbort();
		wait.show();
		aRequestPost("reservation.php?" + fun_job_id + "+" + iUnitID + "+" + mode + "+" + data + "+" + page,processAJAX,"","");

		if(pr_bus_post_inventory_yn === "1" && !$('#btnInventory'+iUnitID).hasClass('button')) {
			$('#btnInventory'+iUnitID).attr('disabled', false);
			$('#btnInventory'+iUnitID).addClass('button');
		} else if (pr_bus_post_inventory_yn === "0" && $('#btnInventory'+iUnitID).hasClass('button')) {
			$('#btnInventory'+iUnitID).attr('disabled', true);
			$('#btnInventory'+iUnitID).removeClass('button');
		}
	} else {
		openErrorModal(error);
	}

}
// [ END ] Main Save function -------------------------------------------------

// [START] GL Codes functions -------------------------------------------------
function addGlCode() {
	id("btnCancel").className = "button";
	id("mode").value = "add";
	var fun_job_id = id("fun_job_id").value;

	var addCount = parseInt(id("addCount").value,10) + 1;
	id("addCount").value = addCount;

	// Remove all the onlick attributes of the table so we can't now start
	// Editing cells.
	tbody = id("GLCodeDataTable");
	
	for ( var i = 0; i < tbody.rows.length; i++ ) {
		for ( var k = 0; k < tbody.rows[i].cells.length; k++ ) {
			tbody.rows[i].cells[k].setAttribute("onclick","");
		}
		tbody.rows[i].setAttribute("onmouseover","");
		tbody.rows[i].setAttribute("onmouseout","");
	}

	//var row		= document.createElement("tr");
	var row = tbody.insertRow(tbody.rows.length-1);
	var bCell = row.insertCell(-1); //document.createElement("td");
	var gCell = row.insertCell(-1); //document.createElement("td");
	var dCell = row.insertCell(-1); //document.createElement("td");	
	var eCell = row.insertCell(-1);

	bCell.style.width = "26px";
	gCell.style.width = "150px";
	dCell.style.width = "314px";

	bCell.className = "bl br";
	gCell.className = "br";
	dCell.className = "br";
	eCell.className = "br";

	row.style.backgroundColor = "#cfc";
	row.setAttribute("id","newID" + addCount);

	bCell.innerHTML = "&nbsp;";
	gCell.innerHTML = "<input type=\"text\" id=\"GLnewID" + addCount + "\" value=\"New code " + addCount + "\" />";
	dCell.innerHTML = "<input type=\"text\" id=\"descnewID" + addCount + "\" value=\"New description " + addCount + "\" style=\"width: 250px;\" />";
	eCell.innerHTML = "<img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" />";
//	eCell.className = "lastCell";

	//row.appendChild(bCell);
	//row.appendChild(gCell);
	//row.appendChild(dCell);
	//tbody.appendChild(row);

	// Set an event listener to check for TAB key hits ---------------------------
	if ( is_ie ) {
		id("descnewID" + addCount).attachEvent("onkeydown",glKeyPress);
	} else {
		id("descnewID" + addCount).addEventListener("keydown",glKeyPress,true);
	}
	
	// Remove the previous row's event listener ----------------------------------
	if ( addCount > 1 && id("descnewID" + (addCount - 1)) ) {
		if ( is_ie ) {
			id("descnewID" + (addCount - 1)).detachEvent("onkeydown",glKeyPress);
		} else {
			id("descnewID" + (addCount - 1)).removeEventListener("keydown",glKeyPress,true);
		}
	}

	id("glSectionContainer").scrollTop = id("glSectionContainer").scrollHeight - id("glSectionContainer").offsetHeight;

	// When adding a row by pressing the tab key, we need to add a slight delay to
	// make sure we focus on the right cell
	setTimeout("id('GLnewID" + addCount + "').select()",100);
	
	// Autosave after 10 new rows added
	if ( addCount%10 === 0 ) {
		glSave();
	}
}

function openGLCodeCopyWindow() {
	id("mode").value = "copy";

	id("ajaxDiv").style.zIndex = "90";
	
	id("glCopyDiv").style.zIndex = "101";
	id("glCopyDiv").style.display = "block";
	id("invUnitId").style.display = "block";
	
	centerDivOnPage("glCopyDiv");
}

function cancelCopyGLCode() {
	id("mode").value = "";
	id("ajaxDiv").style.zIndex = "100";
	id("glCopyDiv").style.display = "none";
}

function copyGLCode() {
	var sourceUnitID = id("invUnitId").options[id("invUnitId").selectedIndex].value;
	var targetUnitID = id("iUnitID").value;
	var fun_job_id = id("fun_job_id").value;

	id("ajaxDiv").style.zIndex = "100";
	
	id("glCopyDiv").style.zIndex = "1";
	id("glCopyDiv").style.display = "none";
	id("invUnitId").style.display = "none";

	aRequestAbort();
	wait.show();
	aRequestPost("reservation.php?" + fun_job_id + "+" + targetUnitID + "+copy+" + sourceUnitID,processAJAX,"","");
}

function importGLCode(unitID,type,job) {
	id("glUploadForm").action = "reservation.php?" + job + "+" + unitID + "+importUpload";
	id("glUploadType").value = type;
	if(type == "gl") {
		id("glUploadWhat").innerHTML = "GL codes";
	} else {
		id("glUploadWhat").innerHTML = "Debtor codes";
	}
	id("ajaxDiv").style.zIndex = "90";
	id("glUpload").style.zIndex = "101";
	id("glUpload").style.display = "block";
	centerDivOnPage("glUpload");
}

function cancelGLImport() {
	id("glUpload").style.zIndex = "1";
	id("ajaxDiv").style.zIndex = "100";
	id("glUpload").style.display = "none";
}

function importGLConfirm(records,duplicates) {
	cancelGLImport();

	if(records == 1) {
		id("glUploadRecords").innerHTML = "1 record";
	} else {
		id("glUploadRecords").innerHTML = records.toString() + " records";
	}

	id("glImportDuplicates").style.display = "none";
	if(duplicates.length > 0) {
		emptyTable("glDuplicateTable");
		for(var count=0;count<duplicates.length;count++) {
			var row = id("glDuplicateTable").insertRow(-1);

			var cell = row.insertCell(-1);
			cell.innerHTML = duplicates[count]['code'];

			var cell = row.insertCell(-1);
			cell.innerHTML = duplicates[count]['description'];
		}
		id("glImportDuplicates").style.display = "block";
	}

	id("glImportConfirm").style.zIndex = "101";
	id("glImportConfirm").style.display = "block";
	centerDivOnPage("glImportConfirm");
	
}

function cancelGLConfirm() {
	id("glImportConfirm").style.display = "none";
	id("glImportConfirm").style.zIndex = "1";
}

function importGLConfirmAction() {
	cancelGLConfirm();

	var fun_job_id = parseInt(id("fun_job_id").value,10);
	var iUnitID = id("iUnitID").value;
	var mode = "importConfirm";


	aRequestAbort();
	wait.show();
	aRequestPost("reservation.php?" + fun_job_id + "+" + iUnitID + "+" + mode + "+" + id("glUploadType").value,processAJAX,"","");
}

function emptyTable(objId) {
	var obj = id(objId);
	for(var count=obj.rows.length-1;count > -1; count--) {
		obj.deleteRow(count);
	}
}

// [ END ] GL Codes functions -------------------------------------------------


// [START] Cost Centre functions ----------------------------------------------
function addCostCentre() {
	var iUnitID = id("iUnitID").value;

	id("btnCancel").className	= "button";
	id("mode").value					= "add";

	var addCount = parseInt(id("addCount").value,10) + 1;
	id("addCount").value = addCount;

	// Remove all the onlick attributes of the table so we can't now start
	// Editing cells.
	tbody = id("CostDataTable");
	
	for ( var i = 0; i < tbody.rows.length; i++ ) {
		for ( var k = 0; k < tbody.rows[i].cells.length; k++ ) {
			tbody.rows[i].cells[k].setAttribute("onclick","");
		}
		tbody.rows[i].setAttribute("onmouseover","");
		tbody.rows[i].setAttribute("onmouseout","");
	}

	var row = tbody.insertRow(tbody.rows.length-1);
	var bCell = row.insertCell(-1);
	var cCell = row.insertCell(-1);
	var nCell = row.insertCell(-1);
	var lCell = row.insertCell(-1);
	var eCell = row.insertCell(-1);

	bCell.style.width = "26px";
	cCell.style.width = "120px";
	nCell.style.width = "194px";
	lCell.style.width = "150px";

	bCell.className = "bl br";
	cCell.className = "br";
	nCell.className = "br";
	lCell.className = "br";
	eCell.className = "br";

	row.style.backgroundColor = "#cfc";
	row.setAttribute("id","newID" + addCount);

	bCell.innerHTML = "&nbsp;";
	cCell.innerHTML = "<input type=\"text\" style=\"width:114px;\" id=\"ccCodenewID" + addCount + "\" value=\"New Code " + addCount + "\" />";
	nCell.innerHTML = "<input type=\"text\" style=\"width:188px;\" id=\"ccNamenewID" + addCount + "\" value=\"New Name " + addCount + "\" />";
	lCell.innerHTML = "<select id=\"ccLevelnewID" + addCount + "\" style=\"width: 144px;\"><option value=\"1\">Level 1</option><option value=\"2\">Level 2</option>";
	eCell.innerHTML = "<img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" />";

	// Set an event listener to check for TAB key hits ---------------------------
	if ( is_ie ) {		
		id("ccLevelnewID" + addCount).attachEvent("onkeydown",glKeyPress);
	} else {
		id("ccLevelnewID" + addCount).addEventListener("keydown",glKeyPress,true);
	}

	// Remove the previous row's event listener ----------------------------------
	if ( addCount > 1 && id("ccLevelnewID" + (addCount - 1)) ) {
		if ( is_ie ) {
			id("ccLevelnewID" + (addCount - 1)).detachEvent("onkeydown",glKeyPress);
		} else {
			id("ccLevelnewID" + (addCount - 1)).removeEventListener("keydown",glKeyPress,true);
		}
	}

	id("glSectionContainer").scrollTop = id("glSectionContainer").scrollHeight - id("glSectionContainer").offsetHeight;

	// When adding a row by pressing the tab key, we need to add a slight delay to
	// make sure we focus on the right cell
	setTimeout("id('ccCodenewID" + addCount + "').select()",100);

	// Autosave after 10 new rows added
	if ( addCount%10 === 0 ) {
		glSave();
	}
}
// [ END ] Cost Centre functions ----------------------------------------------

// [START] Year functions ----------------------------------------------
function addYear() {
	var iUnitID = id("iUnitID").value;

	id("btnCancel").className	= "button";
	id("mode").value					= "add";

	var addCount = parseInt(id("addCount").value,10) + 1;
	id("addCount").value = addCount;

	// Remove all the onlick attributes of the table so we can't now start
	// Editing cells.
	tbody = id("GLCodeDataTable");
	
	for ( var i = 0; i < tbody.rows.length; i++ ) {
		for ( var k = 0; k < tbody.rows[i].cells.length; k++ ) {
			tbody.rows[i].cells[k].setAttribute("onclick","");
		}
		tbody.rows[i].setAttribute("onmouseover","");
		tbody.rows[i].setAttribute("onmouseout","");
	}

	var row = tbody.insertRow(tbody.rows.length-1);
	var checkCell = row.insertCell(-1);
	var descCell = row.insertCell(-1);
	var dateCell = row.insertCell(-1);
	var closeCell = row.insertCell(-1);
	var eCell = row.insertCell(-1);

	checkCell.style.width = "26px";
	descCell.style.width = "238px";
	dateCell.style.width = "200px";
	closeCell.style.width = "26px";

	checkCell.className = "bl br";
	descCell.className = "br";
	dateCell.className = "br";
	closeCell.className = "br";
	eCell.className = "br";
	

	row.style.backgroundColor = "#cfc";
	row.setAttribute("id","newID" + addCount);
	
	checkCell.innerHTML = "&nbsp;";
	descCell.innerHTML = "<input type=\"text\" id=\"descnewID" + addCount + "\" value=\"New Name " + addCount + "\" />";
	var todayDate = id("today").value.toString().split("-");

	dateCell.innerHTML = '<span id="dateSelectorNewID'+addCount+'" class="dateSelector" idPrefix="newID'+addCount+'" initialValueDay="'+todayDate[2]+'" initialValueMonth="'+todayDate[1]+'" initialValueYear="'+todayDate[0]+'"></span>';
	dateSelector();

	closeCell.innerHTML = "<img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" />";
	eCell.innerHTML = "<img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" />";

	eval("id(\"newID"+addCount+"Day\").onchange = function() { select_daymonth_changed('newID" + addCount + "'); }");
	eval("id(\"newID"+addCount+"Month\").onchange = function() { select_daymonth_changed('newID" + addCount + "'); }");

	select_daymonth_changed("newID" + addCount);
	// When adding a row by pressing the tab key, we need to add a slight delay to
	// make sure we focus on the right cell
	setTimeout("id('descnewID" + addCount + "').select()",100);

	// Autosave after 10 new rows added
	if ( addCount%10 === 0 ) {
		glSave();
	}
	
	
}
// [ END ] Year functions ----------------------------------------------


// [START] Debtor functions -----------------------------------------
function addDebtor() {
	id("btnCancel").className = "button";
	id("mode").value = "add";
	var fun_job_id = id("fun_job_id").value;

	var addCount = parseInt(id("addCount").value,10) + 1;
	id("addCount").value = addCount;

	// Remove all the onlick attributes of the table so we can't now start
	// Editing cells.
	tbody = id("GLCodeDataTable");
	
	for ( var i = 0; i < tbody.rows.length; i++ ) {
		for ( var k = 0; k < tbody.rows[i].cells.length; k++ ) {
			tbody.rows[i].cells[k].setAttribute("onclick","");
		}
		tbody.rows[i].setAttribute("onmouseover","");
		tbody.rows[i].setAttribute("onmouseout","");
	}

	//var row		= document.createElement("tr");
	var row = tbody.insertRow(tbody.rows.length-1);
	var bCell = row.insertCell(-1); //document.createElement("td");
	var gCell = row.insertCell(-1); //document.createElement("td");
	var dCell = row.insertCell(-1); //document.createElement("td");	
	var cCell = row.insertCell(-1);
	var pCell = row.insertCell(-1);
	var xCell = row.insertCell(-1);
	var eCell = row.insertCell(-1);


	bCell.className = "bl br";
	bCell.style.width = "26px";

	gCell.className = "br";
	gCell.style.width = "120px";

	dCell.className = "br";
	dCell.style.width = "115px";

	cCell.className = "br";
	cCell.style.width = "100px";

	pCell.className = "br";
	pCell.style.width = "85px";

	xCell.className = "br";
	xCell.style.width = "50px";

	row.style.backgroundColor = "#cfc";
	row.setAttribute("id","newID" + addCount);

	bCell.innerHTML = "&nbsp;";
	gCell.innerHTML = "<input type=\"text\" id=\"GLnewID" + addCount + "\" value=\"New code " + addCount + "\" style=\"width:116px\" />";
	dCell.innerHTML = "<input type=\"text\" id=\"descnewID" + addCount + "\" value=\"New description " + addCount + "\" style=\"width: 111px;\" />";
	cCell.innerHTML = id("addCurrencyInput").innerHTML;
	pCell.innerHTML = id("addContactInput").innerHTML.replace(/addCount/g,addCount);
	xCell.innerHTML = id("addExportInput").innerHTML;
	eCell.innerHTML = "<img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" />";
	var cSelect = cCell.firstChild;
	cSelect.id = "currnewID" + addCount;

	var xSelect = xCell.firstChild;
	xSelect.id = "exportnewID" + addCount;
	eCell.className = "lastCell";

	//row.appendChild(bCell);
	//row.appendChild(gCell);
	//row.appendChild(dCell);
	//tbody.appendChild(row);

	// Set an event listener to check for TAB key hits ---------------------------
	if ( is_ie ) {
		id("descnewID" + addCount).attachEvent("onkeydown",glKeyPress);
	} else {
		id("descnewID" + addCount).addEventListener("keydown",glKeyPress,true);
	}
	
	// Remove the previous row's event listener ----------------------------------
	if ( addCount > 1 && id("descnewID" + (addCount - 1)) ) {
		if ( is_ie ) {
			id("descnewID" + (addCount - 1)).detachEvent("onkeydown",glKeyPress);
		} else {
			id("descnewID" + (addCount - 1)).removeEventListener("keydown",glKeyPress,true);
		}
	}

	id("glSectionContainer").scrollTop = id("glSectionContainer").scrollHeight - id("glSectionContainer").offsetHeight;

	// When adding a row by pressing the tab key, we need to add a slight delay to
	// make sure we focus on the right cell
	setTimeout("id('GLnewID" + addCount + "').select()",100);
	
	// Autosave after 10 new rows added
	if ( addCount%10 === 0 ) {
		glSave();
	}
}


// [ END ] Debtor functions -----------------------------------------

// [START] Generic functions --------------------------------------------------
function hover(eID,state) {
	if ( state > 0 ) {
		id(eID).style.backgroundColor = "#cfc";
	} else {
		id(eID).style.backgroundColor = "";
	}
}

function createInput(input_type) {
	// Crossbrowser INPUT element creation ---------------------------------------
	var DOMElement;
	if ( !input_type ) {
		input_type = "text";
	}

	if ( is_ie ) {
		DOMelement = document.createElement('<INPUT type="' + input_type +'" />');
	} else {
		DOMelement = document.createElement('input');
		DOMelement.setAttribute("type",input_type);
	}
	return DOMelement;
}

function selectAll() {
	// Selects all the checkboxes ------------------------------------------------
	var inputs = document.getElementsByTagName("INPUT");

	for ( var i = 0; i < inputs.length; i++ ) {
		if ( inputs[i].getAttribute("type") == "checkbox" && !inputs[i].getAttribute("disabled") ) {
			inputs[i].checked = true;
		}
	}
}

function clearAll() {
	// Deselects all the checkboxes ----------------------------------------------
	var inputs = document.getElementsByTagName("INPUT");

	for ( var i = 0; i < inputs.length; i++ ) {
		if ( inputs[i].getAttribute("type") == "checkbox" ) {
			inputs[i].checked = false;
		}
	}
}

function glOpenFilterDiv(description,field) {
	if(id("lastFilterDBField") && id("lastFilterDBField").value == field) {
		id("glFilterText").value = id("lastFilterText").value;
	} else {
		id("glFilterText").value = "*";
	}
	id("filterDBField").value = field;

	id("ajaxDiv").style.zIndex = "90";
	
	id("glFilterDiv").style.zIndex = "101";
	id("glFilterDiv").style.display = "block";
	id("glFilterWhat").innerHTML = description;

	centerDivOnPage("glFilterDiv");

	id("glFilterText").focus();
	id("glFilterText").select();
}

function glFilter() {
	var fun_job_id	= id("fun_job_id").value;
	var filter			= id("glFilterText").value;
	var iUnitID			= id("iUnitID").value;
	var data				= id("filterDBField").value + ":" + encodeURIComponent(filter);

	id("ajaxDiv").style.zIndex = "100";
	
	id("glFilterDiv").style.zIndex = "1";
	id("glFilterDiv").style.display = "none";

	aRequestAbort();
	wait.show();
	aRequestPost("reservation.php?" + fun_job_id + "+" + iUnitID + "+filter+" + data,processAJAX,"","");
}

function glSort(fields,sortmode) {
	var fun_job_id	= id("fun_job_id").value;
	var iUnitID			= id("iUnitID").value;
	var sortData		= "";

	var fieldArr		= fields.split(":");
	var fieldCount	= fieldArr.length;

	if ( fieldCount > 1 ) {
		for ( var i = 0; i < fieldCount; i++ ) {
			sortData = sortData + fieldArr[i] + ",";
		}
		// Remove the extraneous trailing ","
		sortData = sortData.substr(0,(sortData.length-1));
	} else {
		sortData = fieldArr[0];
	}

	var data = sortData + ":" + sortmode;

	aRequestAbort();
	wait.show();
	aRequestPost("reservation.php?" + fun_job_id + "+" + iUnitID + "+sort+" + data,processAJAX,"","");
	
}

function closeError() {
	id("errorMessages").innerHTML = "";
	id("errorMessages").style.display = "none";
}

function showLoad() {
	wait.show();
}

function select_daymonth_changed(objPrefix){
	setDayList(id(objPrefix + "Day"),id(objPrefix + "Month").options[id(objPrefix + "Month").selectedIndex].value,id(objPrefix + "Year").value);
}

// [ END ] Generic functions --------------------------------------------------

function openYear(fn_year_id) {
	var fun_job_id	= parseInt(id("fun_job_id").value,10);
	var iUnitID			= id("iUnitID").value;
	var data				= fn_year_id;
	var mode				= "open";
	aRequestAbort();
	wait.show();
	aRequestPost("reservation.php?" + fun_job_id + "+" + iUnitID + "+" + mode + "+" + data,processAJAX,"","");
}

var closeYearId = null;
function closeYear(fn_year_id,hasUnallocated) {
	closeYearId = fn_year_id;
	if(!hasUnallocated) {
		closeYearAction();
	} else {
		confirmAction = "closeYear";
		openConfirm("This year has unallocated transactions, are you sure you want to close it?");
	}
}

function closeYearAction() {
	var fun_job_id	= parseInt(id("fun_job_id").value,10);
	var iUnitID			= id("iUnitID").value;
	var data				= closeYearId;
	var mode				= "close";
	aRequestAbort();
	wait.show();
	aRequestPost("reservation.php?" + fun_job_id + "+" + iUnitID + "+" + mode + "+" + data,processAJAX,"","");
}

var confirmAction = null;
function processResponse() {
	if(confirmAction == "closeYear") {
		closeYearAction();
	}
}

function setPage(page) {
	var fun_job_id	= parseInt(id("fun_job_id").value,10);
	switch(fun_job_id) {
	case 284:
		var params;
		if(id("filterArg").value != "") {
			params = "filter+" + id("filterArg").value + "+";
		} else if(id("sortArg").value != "") {
			params = "sort+" + id("sortArg").value + "+";
		} else {
			params = "++";
		}	
		var showInactive = "";
		if(id("chkInactive").checked) {
			showInactive = "1";
		}
		saveCheck(fun_job_id,id("iUnitID").value,false,false,params + page + "+" + showInactive);
		break;
	case 288:
		var params;
		if(id("filterArg").value != "") {
			params = "filter+" + id("filterArg").value + "+";
		} else if(id("sortArg").value != "") {
			params = "sort+" + id("sortArg").value + "+";
		} else {
			params = "++";
		}	
		saveCheck(fun_job_id,id("iUnitID").value,false,false,params + page);
		break;
	}
}

function openBatchPopup(billingUnitId) {
	openPopup("reservation.php?290+" + billingUnitId + "+++++++++1",880,376);
}

function openTransactions(billingUnitId) {
	id("urlForm").target = "";
	id("url").value = "reservation.php?295+" + billingUnitId;
	id("urlForm").action = "reservation.php?295";
	id("urlForm").submit();
}

function openInventory(billingUnitId) {
	id("urlForm").target = "";
	id("url").value = "reservation.php?4004+" + billingUnitId;
	id("urlForm").action = "reservation.php?4004";
	id("urlForm").submit();
}

function openDebtors(billingUnitId) {
	id("urlForm").target = "";
	id("url").value = "reservation.php?1000+" + billingUnitId;
	id("urlForm").action = "reservation.php?1000";
	id("urlForm").submit();
}

function openInvoices(billingUnitId) {
	id("urlForm").target = "";
	id("url").value = "reservation.php?233+++++" + billingUnitId;
	id("urlForm").action = "reservation.php?233";
	id("urlForm").submit();
}

function openPayments() {
	window.location = "/reservation.php?299";
}

var debtorContactEditId;

function getDebtorContact(obj) {
	debtorContactEditId = obj.id;
	openPopup("/reservation.php?692+10",350,525);
}

function setContact() {
	var fun_job_id	= parseInt(id("fun_job_id").value,10);

	switch ( fun_job_id ) {
	// Debtors
	case 287 :
		id(debtorContactEditId + "Name").value = id("invoice_contact").value;
		id(debtorContactEditId + "Id").value = id("rv_invoice_persona_id").value;
		break;
	}	
}

function idText(objId) {
	if(id(objId).textContent) {
		return id(objId).textContent;
	} else {
		if(id(objId).innerText) {
			return id(objId).innerText;
		} else {
			return "";
		}
	}
}

function showConfigurationOptions(invoicingUnit) {
	$('#configureSystemContainer').css('display', 'flex');
	var widget = '<rr-financial-interface-setup id="financialInterfaceSetup" invoicing-unit="' + invoicingUnit + '" style="width: 579px; height: 352px"></rr-financial-interface-setup>';
	$('#configureSystemContainer').html(widget);
	$('#financialInterfaceSetup').on('closed', hideConfigurationOptions);
	$('#financialInterfaceSetup').on('optionsSaved', hideConfigurationOptions);
}

function hideConfigurationOptions() {
	$('#configureSystemContainer').css('display', 'none');
	$('#financialInterfaceSetup').off('closed');
}

function toggleInventoryDetails() {
	if($('#genInventoryGenerateYes')[0].checked) {
		$('.inventoryDetails').removeClass('collapse');
	}else {
		$('.inventoryDetails').addClass('collapse');
	};
}
