function initialisePage(){
	// Initialise header controls
	initTop();
	$('#fullPageLoader').hide();
	enableButtons(enabledButtons);
	$(".loaderCircle").hide();
	if (readOnly) {
		$('#btnPullTran').removeClass('btn-primary');
		$('#btnPullTran').addClass('btn-tran');

	}
	
	// Set details for print header
	id("user").innerHTML = FirstName + " " + LastName;
	id("server").innerHTML = Domain;
}

function pullTransactions(billingUnitId) {
	if(readOnly) {
		return false;
	}

	let tranTypes = ['check_pr_bus_post_in_po_yn', 'check_pr_bus_post_in_returns_yn', 'check_pr_bus_post_in_cos_yn', 'check_pr_bus_post_in_issues_yn', 'check_pr_bus_post_in_trfs_yn'];
	let selectedTranData = [];
	$('#fullPageLoader').show();
	$('.api_count').html("");
	$('.tran_count').html("");
	tranTypes.forEach(function(tranChecked_yn) {
		let trType = document.getElementById(tranChecked_yn);
		if (trType.checked) {
			selectedTranData.push([trType.value, tranChecked_yn]);
		}
	});
	aRequestPostEx("/reservation.php?4004+" + billingUnitId, {
		action: "pull_transactions",
		billingUnitId: billingUnitId,
		processTran: JSON.stringify(selectedTranData)
	}, (data) => {
		if(!data) {location.reload();}
		let results = JSON.parse(data);

		for (let tranTypeCode in results){
			if(results.hasOwnProperty(tranTypeCode)){
				let tranTypeResults = results[tranTypeCode];
				if (Object.keys(tranTypeResults).length > 1) {
					if (tranTypeResults['in_api']) {$('#'+tranTypeCode+'_last_date').html(tranTypeResults.in_api.lastDate);}
					$('#'+tranTypeCode+'_api_count').html(!tranTypeResults.api.count ? "0" : tranTypeResults.api.count);
					$('#'+tranTypeCode+'_tran_count').html(!tranTypeResults.fn_transactions.count ? "0" : tranTypeResults.fn_transactions.count);
				}
				if (tranTypeResults.message.length) {
					$('#'+tranTypeCode+'_message').html(tranTypeResults.message);
				}
			}
		}
		$('#fullPageLoader').hide();
	});
}
