function initialisePage(){
	dateSelector();
	// Initialise header controls
	initTop();
	enableButtons(enabledButtons);
	
	// Set details for print header
	id("user").innerHTML = FirstName + " " + LastName;
	id("server").innerHTML = Domain;
	id("genDate").innerHTML = new Date().toLocaleString();
	if ( id('filters').className == 'expand' ) {
		id("fromDay").focus();
	}
	
	// Set date fields
	populateDateFields("fromYear", _fromY, "fromMonth", _fromM, "fromDay", _fromD);
	populateDateFields("toYear", _toY, "toMonth", _toM, "toDay", _toD);
	populateDateFields("fromLedgerYear", _fromLedgerY, "fromLedgerMonth", _fromLedgerM, "fromLedgerDay", _fromLedgerD);
	populateDateFields("toLedgerYear", _toLedgerY, "toLedgerMonth", _toLedgerM, "toLedgerDay", _toLedgerD);

	if ( is_ie ) {
		window.attachEvent("onscroll",batchScroll);
	} else {
		window.addEventListener("scroll",batchScroll,true);
	}

	if(showBatch == "1") {
		toggleBatch();
	}
	invoiceRangeCheckClick();
	paymentRangeCheckClick();
	reportTypeToggle();
	toggleInventTranTypeCheck();

	toggleDateFilters();
}

function buildDate(prefix) {
	dayValue = id(prefix+"Day").options[id(prefix+"Day").selectedIndex].value;
	monthValue = id(prefix+"Month").options[id(prefix+"Month").selectedIndex].value;

	dayValue = dayValue<10?"0"+dayValue:dayValue;
	monthValue = monthValue<10?"0"+monthValue:monthValue;
	 
	resultDate = id(prefix+"Year").value+"-"+monthValue+"-"+dayValue;
      
	if(dayValue < 1) { 
		id(prefix+"Day").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(monthValue < 1) {
		id(prefix+"Month").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(id(prefix+"Year").value == "") {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;		 
	 }		 
	if(id(prefix+"Year").value.search(/^\d{4}$/) == -1) {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}

	return resultDate;
}  


function buildURL(renderOption) {
	var dateRange = id("dateRangeCreation").checked?"1":"2";

	var fromDate = buildDate("from");
	var toDate = buildDate("to");

	var fromLedgerDate = buildDate("fromLedger");
	var toLedgerDate = buildDate("toLedger");

	var reportTypeTranChecked;
	var inventTranTypeVal = [];
	$("input:checkbox[name='inventTranType']:checked").each(function(){
		if (!$(this).hasClass('collapse')) {
			inventTranTypeVal.push($(this).val());
		}
	});
	inventTranTypeVal = inventTranTypeVal.join(":");

	renderOption &= 7;
	_urlCount++;

	var showBatch = "0";
	if(id("batchDiv").style.display != "none") {
		showBatch = "1";
	}		

	if(id("invoiceRangeCheck").checked) {
		if(id("invoiceFrom").value == "") {
			id("invoiceFrom").focus();
			openMessage("If 'Invoice number range' is checked, you must fill in the From field");
			return false;
		}
		if(id("invoiceTo").value == "") {
			id("invoiceTo").focus();
			openMessage("If 'Invoice number range' is checked, you must fill in the To field");
			return false;
		}
	}

	if(id("paymentRangeCheck").checked) {
		if(id("paymentFrom").value == "") {
			id("paymentFrom").focus();
			openMessage("If 'Payment number range' is checked, you must fill in the From field");
			return false;
		}
		if(id("paymentTo").value == "") {
			id("paymentTo").focus();
			openMessage("If 'Payment number range' is checked, you must fill in the To field");
			return false;
		}
	}

	if(id("reportTypeTran").checked) {
		reportTypeTranChecked = "tran";
	} else if (id("reportTypeCode").checked) {
		reportTypeTranChecked = "code";
	} else {
		reportTypeTranChecked = "invent";
	}

	var url = [
		/*  0 */ "reservation.php?295",
		/*  1 */ selValue("billingUnitId"),
		/*  2 */ id("batchIds").value,
		/*  3 */ id("serverIds").value,
		/*	4 */ dateRange,
		/*  5 */ fromDate,
		/*  6 */ toDate,
		/*  7 */ fromLedgerDate,
		/*  8 */ toLedgerDate,
		/*  9 */ id("invoiceRangeCheck").checked?"1":"0",
		/* 10 */ selValue("invoiceDB"),
		/* 11 */ selValue("invoicePrefix"),
		/* 12 */ id("invoiceFrom").value,
		/* 13 */ id("invoiceTo").value,
		/* 14 */ id("paymentRangeCheck").checked?"1":"0",
		/* 15 */ selValue("paymentDB"),
		/* 16 */ id("paymentFrom").value,
		/* 17 */ id("paymentTo").value,
		/* 18 */ id("fn_batch_id").value,
		/* 19 */ id("allocate_items").value,
		/* 20 */ showBatch,
		/* 21 */ sort,

		/* 22 */ renderOption.toString(),
		/* 23 */ reportTypeTranChecked,
		/* 24 */ id("glCodeSetCheck").checked?"1":"0",
		/* 25 */ id("glCodeUnsetCheck").checked?"1":"0",
		/* 26 */ id("paymentLinkedToInvoice").checked?"1":"0",
		/* 27 */ id("paymentNotLinkedToInvoice").checked?"1":"0",
		/* 28 */ inventTranTypeVal,
		/* 29 */ _randomId + "_" + _urlCount.toString()
	];
	return url.join("+");
}


function generateReport(renderOption,sortOption) {
	var saveCodes = false;
	if(renderOption == "saveCodes") {
		saveCodes = true;
		renderOption = 0;
	}

	if(!saveCodes && unsavedChanges()) {
		showMessage("Save or revert changes before regenerating the report.");
		return false;
	}

	if(!renderOption) {
		wait.show();
	}
	var url = buildURL(renderOption,sortOption);
	if(url) {
		id("urlForm").target = "";
		id("url").value = url;
		id("urlForm").action = "reservation.php?" + jobId;
		id("urlForm").submit();
	}
}

function chngSort(sortBy) {
	sort = sortBy
	generateReport();
}

function openPDF() {
	var url = buildURL(1);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading PDF...",640,480,0,0,0,1,"pdfWin","opener.id('urlForm').submit();");
	}
}

function sendPDF() {
	var url = buildURL(2);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin = openPopup("/resource/Resrequest/Application/public/html/wait.htm?Loading email popup...",775,615,0,0,0,0,"pdfWin","opener.id('urlForm').submit();");
	}
}

function openCSV() {
	toggleExport();
	var url = buildURL(selValue("export_type"));
	if(url) { 
		id("urlForm").target = "_self";		
		id("url").value = url;
		id("urlForm").submit();
  }
}
function openFilter(filter,filterId){
	var selectedArray = id(filter + "Ids").value;

	url = "reservation.php?661+"
		+ filter
		+ "+"
		+ selectedArray
		+ "+"
		+ filterId;

	openPopup(url,280,360);
}

function changeBillingUnit() {
	var urlArray = [
		/*  0 */ "reservation.php?295",
		/*  1 */ selValue("billingUnitId")
	];

	var url = urlArray.join("+");

	id("urlForm").target = "";
	id("url").value = url;
	id("urlForm").action = "reservation.php?" + jobId;
	id("urlForm").submit();
}

function showTran(fn_tran_id) {
	openPopup("reservation.php?" + tranItemPopupJob + "+" + fn_tran_id,700,400);
}

function allocateBatch() {
	var checkList = document.getElementsByName("batch_check");
	var allocList = [];
	for(var count=0;count<checkList.length;count++) {
		if(checkList[count].checked) {
			allocList[allocList.length] = checkList[count].id;
		}
	}
	id("allocate_items").value = allocList.join(":");
	generateReport();
}

function openBatchPopup() {
	openPopup("reservation.php?290+" + selValue("billingUnitId"),880,376);
}

function setBatch(fn_batch_id,fn_batch_name) {
	id("fn_batch_id").value = fn_batch_id;
	id("fn_batch_name").value = fn_batch_name;
	generateReport();
}

function resetBatch() {
	id("fn_batch_id").value = "";
	id("fn_batch_name").value = "None";	
	generateReport();
}

function batchScroll() {
	if(id("batchDiv").style.display != "none") {
		id("batchDiv").style.top = window.document.body.scrollTop + 10;
		id("batchDiv").style.left = getLeft(id("dataTable")) + 10; 
	}
}

function toggleBatch() {
	if(id("batchDiv").style.display != "none") {
		id("batchDiv").style.display = "none";
		id("batchToggleTop").value = "Show Batch Maintenance";
		id("batchToggleBottom").value = "Show Batch Maintenance";
	} else {
		id("batchDiv").style.display = "";
		id("batchToggleTop").value = "Hide Batch Maintenance";
		id("batchToggleBottom").value = "Hide Batch Maintenance";
		batchScroll();
	}
}

function toggleExport(e,above) {
	if(!e) { e = window.event; }
	if(id("exportDiv").style.display != "none") {
		id("exportDiv").style.display = "none";
	} else {
		id("exportDiv").style.display = "";
		if ( above ) {
			alignDivToElement('exportDiv','exportBottomButton','left','top');
		} else {
			alignDivToElement('exportDiv','exportTopButton','left','bottom');
		}
	}
}

function showHideFilters(){
	var filters = id("filters");
	var filterBut = id("filterBut");
	
	mnuInitialise = false;
	
	if(filters.className == "collapse printCollapse") {
		filters.className = "expand";
		filterBut.value = "<< Hide Filters";
	} else {
		filters.className = "collapse printCollapse";
		filterBut.value = ">> Show Filters";
	}
}

function checkAll(name, type) {
	var checkList = document.getElementsByName(name);
	var setValue;
	if(type == "select") {
		setValue = true;
	} else {
		setValue = false;
	}
	for(var count=0; count<checkList.length; count++) {
		checkList[count].checked = setValue;
	}
}

function invoiceRangeCheckClick() {
	if(id("invoiceRangeCheck").checked) {
		if(id("invoiceFrom").value == "") {
			id("invoiceFrom").value = "1";
		}
		if(id("invoiceTo").value == "") {
			id("invoiceTo").value = "999999";
		}
		id("invoiceFrom").disabled = false;
		id("invoiceTo").disabled = false;
	} else {
		id("invoiceFrom").value = "";
		id("invoiceTo").value = "";
		id("invoiceFrom").disabled = true;
		id("invoiceTo").disabled = true;
	}
}

function paymentRangeCheckClick() {
	if(id("paymentRangeCheck").checked) {
		if(id("paymentFrom").value == "") {
			id("paymentFrom").value = "1";
		}
		if(id("paymentTo").value == "") {
			id("paymentTo").value = "999999";
		}
		id("paymentFrom").disabled = false;
		id("paymentTo").disabled = false;
	} else {
		id("paymentFrom").value = "";
		id("paymentTo").value = "";
		id("paymentFrom").disabled = true;
		id("paymentTo").disabled = true;
	}
}

function click() {
	id("divGLSearch").style.display = "none";
}

var glSearchId;
function glSearch(e,search_id) {
	if(id("divGLSearch").style.display != "") {
		id("divGLSearch").style.display = "";

		var codeObj = id(search_id + "_fn_ledger_label");
		var divTop = getTop(codeObj) + codeObj.offsetHeight; // below if it fits
		if((divTop + id("divGLSearch").offsetHeight - document.body.scrollTop) > windowHeight()) { // else above
			divTop = getTop(codeObj) - id("divGLSearch").offsetHeight;
		}
		var divLeft = getLeft(codeObj);

		id("divGLSearch").style.top = divTop;
		id("divGLSearch").style.left = divLeft;
		glSearchId = search_id;
	} else {
		id("divGLSearch").style.display = "none";
	}

	e.cancelBubble = true;
}

function glSearchSelect(fn_ledger_id,fn_ledger_label) {
	id(glSearchId + "_fn_ledger_id").value = fn_ledger_id;
	id(glSearchId + "_fn_ledger_label").value = fn_ledger_label;
}

function saveCodes() {
	var codes = buildCodes();
	if(codes === false) {
		showMessage("No changes to save");
		return false;
	}
	id("codes").value = codes;
	generateReport("saveCodes");
}

function buildCodes() {
	var items = document.getElementsByName("code_check");
	var saveItems = [];
	for(var count=0; count<items.length; count++) {
		var item = items[count];
		if(id(item.id + "_fn_ledger_id").value != id(item.id + "_fn_ledger_id_old").value) {
			var type_id = item.id.split("_");
			saveItems.push({
				'type': type_id[0],
				'id': type_id[1],
				'fn_ledger_id': id(item.id + "_fn_ledger_id").value
			});
		}
	}
	if(saveItems.length > 0) {
		return JSON.stringify(saveItems);
	} else {
		return false;
	}
}

function revertCodes() {
	var items = document.getElementsByName("code_check");
	var reverted = 0;
	for(var count=0; count<items.length; count++) {
		var item = items[count];
		if(id(item.id + "_fn_ledger_id").value != id(item.id + "_fn_ledger_id_old").value) {
			id(item.id + "_fn_ledger_label").value = id(item.id + "_fn_ledger_label_old").value;
			id(item.id + "_fn_ledger_id").value = id(item.id + "_fn_ledger_id_old").value;
			reverted++;
		}
	}
	if(reverted == 0) {
		showMessage("No changes found to revert");
	} else {
		showMessage("All changes reverted");
	}
}

function regenTran() {
	if(unsavedChanges()) {
		showMessage("Save or revert changes before regenerating transactions.");
		return false;
	}

	var transactions = buildTransactions();
	if(transactions === false) {
		showMessage("No items selected to regenerate");
		return false;
	}
	id("transactions").value = transactions;
	generateReport();
}

function buildTransactions() {
	var items = document.getElementsByName("code_check");
	var regenItems = [];
	for(var count=0; count<items.length; count++) {
		var item = items[count];
		if(item.checked) {
			regenItems.push(id(item.id + "_transactions").value);
		}
	}
	if(regenItems.length > 0) {
		return regenItems.join(":");
	} else {
		return false;
	}
}

function reportTypeToggle() {
	$('#docNo').html('Inv/Pmt No.');
	$('#docPrName').html('Payer / Inv name');
	$('#resNo').html('Res No');
	$('#resName').html('Res Name');
	if (id("reportTypeTran").checked) {
		id("glCodeRow").className = "expand";
		$('.glInvoiceRow, .glPaymentRow, .glLinkRow').removeClass("collapse printCollapse");
		$('#glInventRow').addClass("collapse printCollapse"); // Ledger Transactions
	} else if (!$("#reportTypeInvent").hasClass('collapse') && id("reportTypeInvent").checked) {
		$('#docNo').html('Doc No.');
		$('#docPrName').html('Store/Supplier');
		$('#resNo').html('Rev Cen 1');
		$('#resName').html('Rev Cen 2');
		id('glCodeRow').className = "collapse printCollapse";
		$('#glInventRow').removeClass("collapse printCollapse");
		$('.glInvoiceRow, .glPaymentRow, .glLinkRow').addClass("collapse printCollapse");
	} else {
		id("glCodeRow").className = "collapse printCollapse";
		$('.glInvoiceRow, .glPaymentRow, .glLinkRow').removeClass("collapse printCollapse");
		$('#glInventRow').addClass("collapse printCollapse");
	}
}

function showTransactionType() {
	if(unsavedChanges()) {
		showMessage("Save or revert changes before going to the \"Transaction\" type report.");
		return false;
	}
	id("reportTypeTran").checked = true;
	reportTypeToggle();
	id("glCodeSetCheck").checked = false;
	id("glCodeUnsetCheck").checked = true;
	generateReport();
}

function unsavedChanges() {
	if(buildCodes() !== false) {
		return true;
	} else {
		return false;
	}
}

function openCheckCodePopup(type, desc, rowId) {
	if(unsavedChanges()) {
		showMessage("Save or revert changes before opening the check codes popup.");
		return false;
	}

	id("checkCodePopupType").value = type;
	id("checkCodePopupDesc").value = desc;
	id("checkCodePopupTransactions").value = id(rowId + "_transactions").value;
	id("checkCodePopupForm").target = "checkCodePopup";
	var	checkCodePopup = openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading transactions...",640,480,0,0,0,1,"checkCodePopup","opener.id('checkCodePopupForm').submit();");
}

function batchFilterHasUnallocated() {
	// no batch filter applied would include unallocated
	if(id("batchIds").value === "") {
		return true;
	}

	// the string "0" also means unallocated
	var ids = id("batchIds").value.split(":");
	for(var count=0; count<ids.length; count++) {
		if(ids[count] === "0") {
			return true;
		}
	}
	return false;
}

function toggleDateFilters() {
	if(batchFilterHasUnallocated()) {
		id("dateRangeCreation").disabled = false;
		id("fromDay").disabled = false;
		id("fromMonth").disabled = false;
		id("fromYear").disabled = false;
		id("toDay").disabled = false;
		id("toMonth").disabled = false;
		id("toYear").disabled = false;
		id("dateRangeCreationRow").onmouseover = function() {};
		id("dateRangeCreationRow").onmouseout = function() {};

		id("dateRangeLedger").disabled = false;
		id("fromLedgerDay").disabled = false;
		id("fromLedgerMonth").disabled = false;
		id("fromLedgerYear").disabled = false;
		id("toLedgerDay").disabled = false;
		id("toLedgerMonth").disabled = false;
		id("toLedgerYear").disabled = false;
		id("dateRangeLedgerRow").onmouseover = function() {};
		id("dateRangeLedgerRow").onmouseout = function() {};
	} else {
		id("dateRangeCreation").disabled = true;
		id("fromDay").disabled = true;
		id("fromMonth").disabled = true;
		id("fromYear").disabled = true;
		id("toDay").disabled = true;
		id("toMonth").disabled = true;
		id("toYear").disabled = true;
		id("dateRangeCreationRow").onmouseover = function() {
			overlib("Date range filters only apply when the batch filter includes unallocated items");
		};
		id("dateRangeCreationRow").onmouseout = function() { nd(); };

		id("dateRangeLedger").disabled = true;
		id("fromLedgerDay").disabled = true;
		id("fromLedgerMonth").disabled = true;
		id("fromLedgerYear").disabled = true;
		id("toLedgerDay").disabled = true;
		id("toLedgerMonth").disabled = true;
		id("toLedgerYear").disabled = true;
		id("dateRangeLedgerRow").onmouseover = function() {
			overlib("Date range filters only apply when the batch filter includes unallocated items");
		};
		id("dateRangeLedgerRow").onmouseout = function() { nd(); };
	}
}

function onAfterFilter() {
	toggleDateFilters();
}

function toggleInventTranTypeCheck() {

	var checkboxes = document.querySelectorAll("input[type=checkbox][name=inventTranType]");
	let enabledSettings = []
	
	checkboxes.forEach(function(checkbox) {
	  checkbox.addEventListener('change', function(e) {
		if (this.checked) {
			if (this.value =='voids') {
				Array.from(checkboxes).filter(i => i.classList != "checkVoid").map(i => i.checked = false);
			}
			else {
				Array.from(checkboxes).filter(i => i.classList == "checkVoid").map(i => i.checked = false);
			}
		}
	  })
	});
	


}