var showArchives = false;

function openNotificationPopup(notificationCount) {
  var notificationCountPlural = parseInt(notificationCount) == 1 ? "" : "s";
  var notificationPopupHTML = `<div id="notificationPopup" class="notificationPopup">
      <div id="notificationPopupContent">
          <i class='material-icons'>notifications</i>
          <div id="notificationPopupContentText">You have ` + notificationCount + ` unread notification` + notificationCountPlural + `!</div>
      </div>
  </div>`;
  if (shadowName) {
    var child = document.createElement('div');
    child.innerHTML = notificationPopupHTML;
    documentRoot.appendChild(child);            // create popup, will be off screen
  } else {
    $("body").append(notificationPopupHTML);            // create popup, will be off screen
  }
  setTimeout(function() {                              // wait for 2 seconds after page is loaded
      $(id("notificationPopup")).animate({               // slide popup into view
          top: "+=100"
      }, 500, function() {
          setTimeout(function(){                      // leave visible for 3 seconds
              $("#notificationPopup", documentRootChildren).animate({       // slide popup out of view
                  top: "-=100"
              }, 500, function() {
                  $("#notificationPopup", documentRootChildren).remove();   // destroy popup
              });
          }, 3000);
      });
  }, 2000);
}

function openNotificationPanel() {
    $("#notificationPanel", documentRootChildren).remove();
    var notificationPopupsToggleIcon = notificationPopupAllowed == "1" ? "check_box" : "check_box_outline_blank";
    var notificationPopupsToggleColor = notificationPopupAllowed == "1" ? "green" : "#000";
    var notificationPopupsText = notificationPopupAllowed == "1" ? "Hide" : "Show";

    notificationPanelHTML = `<div id="notificationPanel" class="notificationPanel">
        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="colDk bb">
            <tr style="background-color: #c9252f; height:50px;">
                <td style="text-align: right; width: 30px;">
                    <i id="notificationsDropdownButton" class="material-icons white">menu</i>
                    <div id="notificationsDropdown" class="notificationsDropdownContainer">
                        <div id="notificationsDropdownPopup" onclick="notificationPopupsToggle();">` + notificationPopupsText + ` Notification popups</div>
                        <div id="notificationsDropdownArchives" onclick="notificationArchivesToggle();">Show Archived messages</div>
                        <div id="notificationsDropdownSearch" onclick="notificationSearchOpen();">Search messages</div>
                        <div onclick="notificationPanelClose();">Close</div>
                    </div>
                </td>
                <td style="color: #fff; font-size: 20px; font-weight:normal; padding-left: 15px;">Notifications</td>
                <td text-align="right" style="text-align: right;">
                    <i id="notificationsSearchButton" class="material-icons white">search</i>
                    <input type="text" id="notificationsSearchInput" placeholder="Search for keyword" onkeyup="">
                    <i id="notificationsSearchReset" class="material-icons" title="Reset the messages" onclick="notificationsReset();">refresh</i>
                </td>
                <td text-align="right" style="text-align: right; width: 30px;">
                    <i class="material-icons" style="color: white; cursor: pointer; position: relative; top: 50%; right: 5px;" onclick="notificationPanelClose();">close</i>
                </td>
            </tr>
        </table>
        <table id="notificationPanelHTMLContent" width="100%" border="0" cellspacing="0" cellpadding="0" style="margin-top:10px;">
        </table>

        <div id="notificationPanelHTMLLoader"></div>
    </div>`;

    if (shadowName) {
      var child = document.createElement('div');
      child.innerHTML = notificationPanelHTML;
      documentRoot.appendChild(child);
    } else {
      $("body").append(notificationPanelHTML);
    }

    setTimeout(function() {
        $("#notificationPanel", documentRootChildren).css("width", "600px")
    }, 1);

    $('#notificationsDropdownButton', documentRootChildren).on('click touch', function(){
      toggle('notificationsDropdown');
    });

    $('#notificationsSearchButton', documentRootChildren).on('click touch', function(){
        if ($('#notificationsSearchInput', documentRootChildren).is(":visible") || $('#notificationsSearchInput', documentRootChildren).css("display") == "none") {
            notificationSearchOpen();
        } else {
            notificationSearchClose();
        }
    });

    $(documentRoot).on('click touch', function(event) {
        if (!$(event.target).parents().addBack().is('#notificationsSearchButton')
            && !$(event.target).parents().addBack().is('#notificationsSearchInput')
            && !$(event.target).parents().addBack().is('#notificationsDropdownSearch')) {
            notificationSearchClose();
        }
        if (!$(event.target).parents().addBack().is('#notificationsDropdownButton')) {
            $('#notificationsDropdown').hide();
        }
        if (!$(event.target).parents().addBack().is('#buttonNotificationContainer')
            && !$(event.target).parents().addBack().is('#notificationsDropdownButton')
            && !$(event.target).parents().addBack().is('#notificationPanel')) {
            notificationPanelClose();
        }
    });

    $("body").addClass('disable-scroll');
    openNotifications();
}

function openNotifications(search) {
    search = search === undefined ? "" : search;
    $("#notificationPanelHTMLLoader", documentRootChildren).html(`
        <div style="padding-top:50px;">
            <div class="loaderCircle" style="margin-left: 255px;"></div>
        </div>`);

    var data = { ajaxAction: "getNotifications", search: search };
    $.post("/reservation.php?3006", data)
        .done(function( result ) {
            var notifications = JSON.parse(result);
            var notificationPanelHTMLContent = '';

            if (notifications.length == 0) {
                notificationPanelHTMLContent = `
                    <tr><td colspan="3" style="text-align: center;">
                        You have no messages
                    </td></tr>`;
                id("notificationPanelHTMLContent").innerHTML = notificationPanelHTMLContent;
                id("notificationPanelHTMLLoader").innerHTML = "";
                return;
            }

            var monthName = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];

            $.each(notifications, function(i, notification) {
                var date = new Date(notification.time);
                var dateToday = new Date();

                if (date.getDate() == dateToday.getDate() && date.getMonth() == dateToday.getMonth() && date.getFullYear() == dateToday.getFullYear()) {    // It is today, show time only
                    var formattedDate = ('0' + date.getHours()).slice(-2) + ':' + ('0' + date.getMinutes()).slice(-2);
                } else if (date.getFullYear() == dateToday.getFullYear()) {     // Same year, show day and month only
                    var formattedDate = date.getDate() + ' ' + monthName[date.getMonth()];
                } else {    // Show full date
                    var formattedDate = date.getDate() + ' ' + monthName[date.getMonth()] + ' ' + date.getFullYear();
                }
                var formattedDateHover = date.getDate() + ' ' + monthName[date.getMonth()] + ' ' + date.getFullYear() + ' ' + ('0' + date.getHours()).slice(-2) + ':' + ('0' + date.getMinutes()).slice(-2);

                var newNotificationStyle = notification.read == null ? "font-weight: bold;" : "";
                var notificationMailIcon = notification.read == null ? "email" : "mail_outline";
                var notificationAcknowlegeIconStyle = notification.acknowledged == null ? "display: none;" : "";
                var notificationArchiveIcon = notification.archived == 0 ? "archive" : "unarchive";
                var notificationArchiveTitle = notification.archived == 0 ? "Archive this message" : "Unarchive this message";
                var notificationArchiveClass = notification.archived == 0 ? "" : "notificationsGreen";
                var notificationRowClass = notification.archived == 0 ? "" : "notificationsHide";
                notificationRowClass = search == "" ? notificationRowClass : ""; // Don't hide archives if search is performed

                notificationPanelHTMLContent += `
                    <tr onclick="expandNotification('` + notification.notificationID + `');" class="notificationPanelHTMLRowLink ` + notificationRowClass + `">
                        <td id="header_` + notification.notificationID + `" class="notificationPanelHTMLRowHeader" colspan="3" style="` + newNotificationStyle + `">
                            <div style="float: right; position: relative; top:4px; margin-bottom: 13px;" title="` + formattedDateHover + `" class="tooltip">
                                ` + formattedDate + `
                            </div>
                            <div style="float: right;" title="` + notificationArchiveTitle + `" id="archiveIcon_` + notification.notificationID + `" class="tooltip archiveIcon" onclick="archiveNotification('` + notification.notificationID + `', event);" archived="` + notification.archived + `">
                                <i class="material-icons ` + notificationArchiveClass + `">` + notificationArchiveIcon + `</i>
                            </div>
                            <div style="float: right; ` + notificationAcknowlegeIconStyle + `" title="Acknowledged reading of message" id="acknowledgeIcon_` + notification.notificationID + `" class="tooltip">
                                <i class="material-icons">thumb_up</i>
                            </div>
                            <div>
                                <i class="material-icons" id="subjectIcon_` + notification.notificationID + `">` + notificationMailIcon + `</i> ` + notification.subject + `
                            </div>
                            
                        </td>
                    </tr>
                    <tr id="rowBody_` + notification.notificationID + `" class="rowBodies">
                        <td>
                            <div id="row_` + notification.notificationID + `" class="notificationMessageRows"></div>
                        </td>
                    </tr>
                    <tr>
                        <td class="notificationDivider"></td>
                    </tr>
                    `;
            });

            id("notificationPanelHTMLContent").innerHTML = notificationPanelHTMLContent;

            id("notificationPanelHTMLLoader").innerHTML = "";
            initTooltipster();
        });
}

function notificationSearch() {
    $('#notificationsSearchInput', documentRootChildren).autocomplete({
        dataType: 'json',
        ajaxSettings: {
            method: "POST"
        },
        lookup: function (query, done) {
            openNotifications(query);
        },
        minChars: 2,
        showNoSuggestionNotice: true,
        noSuggestionNotice: 'Sorry, no matching results',
        deferRequestBy: 200
    });
}

function notificationSearchOpen() {
    $('#notificationsSearchInput', documentRootChildren).val('');
    id('notificationsSearchInput').style.display = "block";
    id('notificationsSearchReset').style.display = "block";
    $('#notificationsSearchInput', documentRootChildren).focus();
    notificationSearch();
    id("notificationsDropdown").style.display = "none";
}

function notificationSearchClose() {
    if ($('#notificationsSearchInput', documentRootChildren).val() == '') {
        $('#notificationsSearchInput', documentRootChildren).val('');
        id('notificationsSearchInput').style.display = "none";
        id('notificationsSearchReset').style.display = "none";
    }
}

function notificationsReset() {
    $('#notificationsSearchInput').val('');
    notificationSearchClose();
    openNotifications();
}

function notificationPopupsToggle() {
    var notificationPopupsText = notificationPopupAllowed == "1" ? "Show" : "Hide";
    id("notificationsDropdownPopup").innerHTML = notificationPopupsText + ` Notification popups`;

    var data = { ajaxAction: "toggleNotificationsPopups" };
    $.post("/reservation.php?3006", data)
        .done(function( result ) {
            notificationPopupAllowed = result == "1" ? "1" : "0";
        });
    id("notificationsDropdown").style.display = "none";
}

function notificationPanelClose() {
    $("#notificationPanel", documentRootChildren).css("width", "0");
    setTimeout(function() {
        $("#notificationPanel", documentRootChildren).remove()
    }, 600);
    $("body").removeClass('disable-scroll');
}

function expandNotification(notificationId) {
    var rowDisplay = $("#rowBody_" + notificationId);
    if (rowDisplay.hasClass('notification-open')) {
        rowDisplay.removeClass('notification-open');
    } else {
        $(".rowBodies", documentRootChildren).removeClass('notification-open');
        $(".notificationMessageRows", documentRootChildren).html("");
        if (id("row_" + notificationId).innerHTML == "") {
            $("#rowBody_" + notificationId).addClass("notification-open");
            id("row_" + notificationId).innerHTML = `<div style="">
            <div class="loaderCircle" style="margin-left: 255px;"></div>
        </div>`;
            var data = { ajaxAction: "getNotifications", id: notificationId };
            $.post("/reservation.php?3006", data)
                .done(function (result) {
                    var message = JSON.parse(result);
                    id("row_" + notificationId).innerHTML = `
                    <div id="messageContainer">
                        <div id="notificationMessageContent_` + notificationId + `" class="notificationMessageContent"></div>
                    </div>`;
                    $("#header_" + notificationId).css("font-weight", "normal");
                    $("#subjectIcon_" + notificationId).html("mail_outline");

                    if (message[0].acknowledged == null) {
                        id("row_" + notificationId).innerHTML += `<div id="acknowledge` + notificationId + `"  class="acknowledgeNo" onclick="acknowledgeNotification('` + notificationId + `', event);" style="cursor: hand">
                        <i class="material-icons">thumb_up</i> 
                        Would you like to acknowledge that you have read this message?
                    </div>`;
                    } else {
                        id("row_" + notificationId).innerHTML += `<div id="acknowledge` + notificationId + `" class="acknowledgeYes">
                        <i class="material-icons">thumb_up</i> 
                        You have acknowledged that you have read this message
                    </div>`;
                    }

                    if (!shadow && (document.head.createShadowRoot || document.head.attachShadow)) {
                        // Shadow DOM supported
                        const shadowEl = documentRoot.querySelector("#notificationMessageContent_" + notificationId);
                        const shadow = shadowEl.attachShadow({ mode: 'open' });
                        const content = document.createElement("div");
                        content.innerHTML = message[0].notificationMessage;
                        shadow.appendChild(content);
                    } else {
                        id("notificationMessageContent_" + notificationId).innerHTML = message[0].notificationMessage;
                    }

                });
        } else {
            $(".notificationMessageRows").html("");
        }
    }
}

function acknowledgeNotification(notificationId, event) {
    event.stopPropagation();
    var data = { ajaxAction: "acknowledgeNotification", id: notificationId };
    $.post("/reservation.php?3006", data)
        .done(function( result ) {
            $("#acknowledge" + notificationId).remove();
            $("#row_" + notificationId).append(`<div id="acknowledge` + notificationId + `" class="acknowledgeYes">
                <i class="material-icons">thumb_up</i> 
                You have acknowledged that you have read this message
            </div>`);
            id("acknowledgeIcon_" + notificationId).style.display = "";
        });
}

function archiveNotification(id, event) {
    event.stopPropagation();
    action = $("#archiveIcon_" + id).attr("archived") == "1" ? "0" : "1";
    var data = { ajaxAction: "archiveNotification", id: id, action: action };
    $.post("/reservation.php?3006", data)
        .done(function( result ) {
            if (result == "1") {
                $("#archiveIcon_" + id).attr({
                    archived: "1",
                    title: "Unarchive this message"
                });
                $("#archiveIcon_" + id + " i").html("unarchive");
                $("#archiveIcon_" + id + " i").addClass("notificationsGreen");
                if (!showArchives) {
                    $("#archiveIcon_" + id).closest("tr").hide();
                    if ($("#rowBody_" + id).hasClass("notification-open")) {
                        $("#rowBody_" + id).removeClass("notification-open");
                    }
                }
            }

            if (result == "0") {
                $("#archiveIcon_" + id).attr({
                    archived: "0",
                    title: "Archive this message"
                });
                $("#archiveIcon_" + id + " i").html("archive");
                $("#archiveIcon_" + id + " i").removeClass("notificationsGreen");
            }
            initTooltipster();
        });
}

function notificationArchivesToggle() {
    showArchives = showArchives ? false : true;
    if (showArchives) {
        $("#notificationsDropdownArchives").html("Hide Archived messages");
        $(".archiveIcon").each(function( index ) {
            if ( $(this).attr("archived") == "1" ) {
                $(this).closest("tr").show();
            }
        });
    } else {
        $("#notificationsDropdownArchives").html("Show Archived messages");
        $(".archiveIcon").each(function( index ) {
            if ($(this).attr("archived") == "1") {
                $(this).closest("tr").next().removeClass("notification-open");
                $(this).closest("tr").hide();
            }
        });
    }
    id("notificationsDropdown").style.display = "none";
}
