var refreshTokenApiCall;
var tokenRefreshInProgress = false;

function getCookie(cookieName) {
    var v = document.cookie.match('(^|;) ?' + cookieName + '=([^;]*)(;|$)');
    return v ? v[2] : false;
}

function getToken() {
    return getCookie('rrq_token');
}

function refreshToken() {
    tokenRefreshInProgress = true;
    return $.ajax({
        type: "POST",
        url: '/api/v1/oauth/token/refresh',
        headers: {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
        },
        error: function (error) {
            console.log("Couldn't refresh token");
        }
    }).then(
        function () {
            tokenRefreshInProgress = false;
        }
    );
}

function queueApiCall(data, resolve, reject) {
    var apiCall;

    refreshTokenApiCall.done(function() {
        var cookie = JSON.parse(decodeURIComponent(getToken()));
        data.headers['Authorization'] = 'Bearer ' + cookie.access_token;

        apiCall = $.ajax(data); // Retry API call

        apiCall.fail(function(result) {
            reject(result);
        });
        apiCall.done(function(result) {
            resolve(result);
        });
    });

    refreshTokenApiCall.fail(function(result) {
        reject(result);
    });

    return apiCall;
}

function callApi(data, authentication = true, refreshTokens = true) {
    apiCallPromise = new Promise(function(resolve, reject) {
        if (data.headers === undefined) {
            data.headers = {};
        }

        data.headers['Content-Type'] = 'application/json';
        data.headers['Accept'] = 'application/json';

        if (authentication === true) {
            var cookie = JSON.parse(decodeURIComponent(getToken()));

            if (cookie === false) {
                reject(new Error("Token unavailable"));
            }
            data.headers['Authorization'] = 'Bearer ' + cookie.access_token;
        }

        if (tokenRefreshInProgress === false || authentication === false) {
            var apiCall = $.ajax(data); // Make API call

            apiCall.done(function(result) {
                resolve(result);
            });

            apiCall.fail(function(result) {
                if (result.status == 401) { // Unauthorized
                    if (authentication === true && refreshTokens === true) {
                        if (tokenRefreshInProgress === false) {
                            refreshTokenApiCall = refreshToken();
                        }
                        queueApiCall(data, resolve, reject);
                    }
                } else {
                    reject(result);
                }
            });
        } else {
            queueApiCall(data, resolve, reject);
        }
    });

    return apiCallPromise;
}