// This function performs all page initialise functions
function genCalendar() {}

// Get the number of rooms requested
function getValues() {
	// Check that the drag selection was on one row
	if ( startCell[0] != endCell[0] ) {
		openMessage("You must select a range on one row of the calendar","a");
		resetSelection();
		return 0;
	}
	processValues();
	return true;
}

function processValues(){
	var startYear = "";
	var endYear = "";

	var startCell				= selected_cells_ids[0];
	var startCellArray	= startCell.split(":");
	var endCell					= selected_cells_ids[selected_cells_ids.length-1];
	var endCellArray		= endCell.split(":");

	// Check if we cross year boundary on selection
	if ( years.length > 1 ) {
		// Find out the starting year of selection
		if ( parseInt(startCellArray[1],10) == 1 ) {
			startYear = years[1];
		} else {
			startYear = years[0];
		}

		// Find out the ending year of selection
		if ( parseInt(endCellArray[1],10) == 1 ) {
			endYear = years[1];
		} else {
			endYear = years[0];
		}
	} else {
		startYear	= years[0];
		endYear		= years[0];
	}

	start_date	= startYear+"/"+startCellArray[1]+"/"+startCellArray[2];
	end_date		= endYear+"/"+endCellArray[1]+"/"+endCellArray[2];

	var temp_start_date	= new Date(start_date);
	var temp_end_date		= new Date(end_date);

	// Swap dates if user dragged backwards -------------------------------------
	if ( temp_start_date > temp_end_date ) {
		var temp_date		= temp_end_date;
		temp_end_date		= temp_start_date;
		temp_start_date	= temp_date;
	}

	temp_end_date = DayAdd(temp_end_date,1);

	start_date	= temp_start_date.getFullYear() + "-" + (temp_start_date.getMonth()+1) + "-" + temp_start_date.getDate();
	end_date		= temp_end_date.getFullYear() + "-" + (temp_end_date.getMonth()+1) + "-" + temp_end_date.getDate();

	selected_data	+= startCellArray[0] + "+" + start_date + "+" + end_date;
	display_data	+= rooms + " " + startCell[4] + "s at " + startCell[3] + ",<br />From: " + start_date + " To: " + end_date + "<br /><br />";

	calendar_begin_date = get_select_date();

	var windowWidth = 620;
	var screenPosX = (screenWidth - windowWidth)/2;

	openPopup("reservation.php?31+"+selected_data+"+"+selectedStatuses+"+"+agent_id,700,500);
	selected_data = "";
}

function resetSelection() {
	for ( i = 0; i < selected_cells_array.length; i++ ) {
		var cellId				= selected_cells_ids[i];
		var cellPtr				= document.getElementById(cellId);
		var cellName			= cellPtr.getAttribute("name");
		var cellIdArray		= cellId.split(":");
		var cellNameArray	= cellName.split(":");
		var cellValue			= cellNameArray[3];
		var cellLimit			= cellNameArray[7];
		var selectedDay		= id("select_Day").options[id("select_Day").selectedIndex].value;

		var weekendday = false;
		var weekend_day = "";

		for ( var j = 0; j < weekends.length; j++ ) {
			weekend_day = "a" + weekends[j];
			if ( parseInt(cellIdArray[2],10) == parseInt(weekend_day.substr(7,2),10) ) {
				weekendday = true;
				break;
			} else {
				weekendday = false;
			}
		}

		if ( cellPtr.getAttribute("ab") == "1" ) {
			cellPtr.className = calBlocked;
		} else {
			cellPtr.className = cellPtr.getAttribute("defclass");
		}
	}
	selected_cells_array.length = 0;
	return 0;
}

function calendar_statuspop() {
	openPopup('/resource/Resrequest/Application/public/html/calendar_statuspop.htm',260,260);
}

function calendar_agentpop() {
	if ( !calendarAgentPop ) {
		openMessage("Calendar is filtered by your agency");
		nd();
		return 0;
	}

	var property_select	= id("property_select").value;
	var status					= selectedStatuses;

	var first_dash	= middledate.indexOf("-");
  var second_dash	= middledate.indexOf("-",first_dash + 1);

	var day		= middledate.substr(0,first_dash);
	var month	= middledate.substring(first_dash + 1,second_dash);
	var year	= middledate.substr(second_dash + 1,4);

	middledate = year +"-"+ month +"-"+ day;

	openPopup("reservation.php?692+23",350,525);
	return true;
}

function loadItemReport() {
	var dayValue		= id("select_Day").options[id("select_Day").selectedIndex].index;
	var monthValue	= id("select_Month").options[id("select_Month").selectedIndex].index;
	var year				= id("select_Year").value;

	if ( dayValue < 10 ) {
		dayValue = "0" + dayValue;
	}

	if ( monthValue < 10 ) {
		monthValue = "0" + monthValue;
	}

	fromDate	= year + "-" + monthValue + "-" + dayValue;
	toDate		= year + "-" + monthValue + "-" + dayValue;

	var properties	= id("property_list").value;
	var status			= id("status").value;
	var agent				= "";

	var url = "/reservation.php?201+"
						+ fromDate
						+ "+"
						+ toDate
						+ "+"
						+ properties
						+ "+"
						+ status
						+ "+++"
						+ "1"
						+ "+"
						+ "20"
						+ "+"
						+ "256";

	window.location = url;
}

function setAgentFilterTo(objId) {
	var property_select	= id("property_select").value;
	var status					= selectedStatuses;

	var first_dash = middledate.indexOf("-");
	var second_dash = middledate.indexOf("-",first_dash + 1);

	var year	= middledate.substr(0,first_dash);
	var month	= middledate.substring(first_dash + 1,second_dash);
	var day		= middledate.substr(second_dash + 1,4);

	middledate = year +"-"+ month +"-"+ day;

	window.location = "/reservation.php?29+" + middledate + "+" + property_select + "+" + status + "+++" + objId;
}
