var mainWindowPage = "payFind";
var enabledButtons = ["Back","Forward","Refresh","Print","Calendar","Internet","Home","Help","NewWindow"];
var mouseDown_flag = false;
var selected_cells_ids = [];		// Calendar array to hold array of cells selected
var startCell = {};
var endCell = [];
var calClick = "g1Cg";

function initialisePage() {
	dateSelector();
	initTop();
	enableButtons(enabledButtons);

	// get print info
	id("user").innerHTML = FirstName + " " + LastName;
	id("server").innerHTML = Domain;

	populateDateFields("fromYear", fromY, "fromMonth", fromM, "fromDay", fromD);
	
	id("param-popup-date-end-Year").disabled = true;
	id("param-popup-date-end-Month").disabled = true;
	id("param-popup-date-end-Day").disabled = true;
}

function openPropFilter() {
	var accomm = id("accommIds").value;
	openPopup("reservation.php?293+"+accomm,556,407);
}

function buildDate(prefix) {
	var day = selValue(prefix+"Day");
	if(isNaN(day)) {
		day = 0;
	}
	day = day < 10 ? "0" + day:day;

	var month = selValue(prefix+"Month");
	if(isNaN(month)) {
		month = 0;
	}
	month = month < 10 ? "0" + month:month;

	var year = id(prefix + "Year").value;

	var error = false;

	if ( day < 1 ) {
		error = "Day";
	}

	if ( month < 1 ) {
		error = "Month";
	}

	if ( year == "" || year.search(/^\d{4}$/) == -1 ) {
		error = "Year";
	}		 

	if(error !== false) {
		showMessage("Please enter a valid "+prefix+" date","Error","200px", false, false, false, prefix+error);
		return false;
	}

	return year + "-" + month + "-" + day;
}

function buildURL(renderOption) {
	fromDate = buildDate("from");
	if(!fromDate) {
		return false;
	}
	var url = [
		/*  0 */ "reservation.php?1026",
		/*  1 */ fromDate,
		/*  2 */ id("accommIds").value
	];
	return url.join("+");
}

function generateReport(renderOption) {
	url = buildURL(renderOption);
	if(url) {
		id("urlForm").target = "_self";		
		id("urlForm").action = "";
		id("url").value = url;
		id("urlForm").submit();
	}
}

/* ----------------------------------------------------------------------------
	 Called when next/previous 10 days button pressed
---------------------------------------------------------------------------- */
function dateRangeChange(action) {
	var currentDate = buildDate("from");
	if(!currentDate) {
		return false;
	}

	var targetDate = new Date(currentDate.replace(/-/g,"/"));
	var addDays = 10;
	if(action != "next") {
		addDays *= -1;
	}
	targetDate = DateAdd(targetDate,addDays,0,0);

	id("fromYear").value = targetDate.getFullYear();
	id("fromMonth").selectedIndex = targetDate.getMonth()+1;
	id("fromDay").selectedIndex = targetDate.getDate();

	generateReport();
}

function cellMouseDown(e) {
	var target = getEventTarget(e);
	var splitTargetId = target.id.split(":");

	startCell = {
		ac_accomm_type_id: splitTargetId[0],
		date: splitTargetId[1]
	};

	selected_cells_ids = [target.id];
	target.className = calClick;

	mouseDown_flag = true;

	return true;
}

function cellMouseOver(e) {
	if(!mouseDown_flag) {
		return 0;
	}

	var target = getEventTarget(e);

	if(target.id.split(":")[0] != startCell.ac_accomm_type_id) {
		resetSelection();
		mouseDown_flag = false;
		showMessage("Select on only one row within the calendar cells","Error");
		return 0;
	}

	selected_cells_ids.push(target.id);
	target.className = calClick;

	return true;
}


function cellMouseUp(e) {
	if(!mouseDown_flag) {
		return 0;
	}

	var target = getEventTarget(e);
	var splitTargetId = target.id.split(":");

	endCell = {
		ac_accomm_type_id: splitTargetId[0],
		date: splitTargetId[1]
	};

	mouseDown_flag 	= false;

	// Check that the drag selection was on one row
	if (startCell.ac_accomm_type_id != endCell.ac_accomm_type_id) {
		showMessage("Select on only one row within the calendar cells","Error");
		resetSelection();
		return 0;
	}

	openParamPopup(startCell.ac_accomm_type_id, startCell.date, endCell.date);

	return true;
}

function resetSelection() {
	for ( i = 0; i < selected_cells_ids.length; i++ ) {
		var cell = id(selected_cells_ids[i]);
		cell.className = cell.getAttribute("defclass");
	}
	return 0;
}

function openParamPopup(ac_accomm_type_id, start_date, end_date) {
	var accomm = accomms[ac_accomm_type_id];

	id("param-popup-source-id").value = ac_accomm_type_id;
	id("param-popup-source-label").innerHTML = "";
	id("param-popup-heading").onmouseover = "";
	if(accomm) {
		let label = accomm['propertyName'] + " - " + accomm['accommName'];
		id("param-popup-source-label").innerHTML = label;
		id("param-popup-heading").onmouseover = function() {
			overlib(label);
		};
	}

	id("param-popup-target-select").options.length = 0;
	id("param-popup-target-select").options.add(new Option("","",true,true));

	var propertyId = accomm['propertyId'];
	var found = false;
	for(var aid in accomms) {
		if(aid == ac_accomm_type_id || accomms[aid]['propertyId'] != propertyId) {
			continue;
		}
		if(accomms[aid]['propertyId'] != propertyId) {
			continue;
		}
		id("param-popup-target-select").options.add(new Option(accomms[aid].accommName,aid));
		found = true;
	}
	if(!found) {
		resetSelection();
		showMessage("No accommodation types available to transfer to","Error");
		return false;
	}

	id("param-popup-days").value = Math.floor(((new Date(end_date)).getTime() - (new Date(start_date)).getTime()) / 86400000) + 1;

	var start_date = start_date.split("-");
	populateDateFields("param-popup-date-start-Year", start_date[0], "param-popup-date-start-Month", start_date[1], "param-popup-date-start-Day", start_date[2]);

	paramEndDateCalculate();

	applyTrans(1);
	id("param-popup").style.display = "block";
	id("param-popup").style.left = Math.round(document.body.offsetWidth / 2 - id("param-popup").offsetWidth / 2).toString()+"px";
	id("param-popup").style.top = Math.round(document.body.scrollTop + (windowHeight() / 2) - id("param-popup").offsetHeight / 2).toString()+"px";
}

function closeParamPopup() {
	resetSelection();
	id("param-popup").style.display = "";
	applyTrans(0);
}

var params;
function processParamPopup() {
	if(selValue("param-popup-target-select") == "") {
		showMessage("Select an accommodation type to transfer to","Error", false, false, false, false, "param-popup-target-select", true);
		return false;
	}

	if(!paramEndDateCalculate()) {
		return false;
	}

	var rooms = parseInt(id("param-popup-rooms").value,10);

	if(isNaN(rooms) || rooms < 1) {
		id("param-popup-rooms").value = "";
		showMessage("Rooms must be a positive number","Error",false,false,false,false,"param-popup-rooms",true);
		return false;
	}

	wait.show();

	params = {
		ac_accomm_type_id_source: id("param-popup-source-id").value,
		ac_accomm_type_id_target: selValue("param-popup-target-select"),
		start_date: buildDate("param-popup-date-start-"),
		end_date: buildDate("param-popup-date-end-"),
		days: id("param-popup-days").value,
		rooms: rooms
	};

	$.ajax({
		type: "POST",
		contentType: "application/json; charset=utf-8",
		dataType: "json",
		data: JSON.stringify({
			action: "verify",
			params: params
		})
	})
		.done(function(all_available, textStatus, xhr) {
			wait.hide();

			if(!all_available) {
				responseFunctions = ["finaliseParamPopup"];
				cancelFunctions = [];
				openConfirm("Not all nights have this many rooms available to move. If you proceed the maximum number of rooms, up to the amount specified, will be moved for each day.<br><br>Proceed?",null,null,true);
			} else {
				finaliseParamPopup();
			}
		})
		.fail(function(xhr, textStatus, error) {
			wait.hide();
			showMessage(xhr.responseText,"Error","300px",false,false,false,false,true);
		});
	
}

function finaliseParamPopup() {
	wait.show();

	$.ajax({
		type: "POST",
		contentType: "application/json; charset=utf-8",
		dataType: "json",
		data: JSON.stringify({
			action: "finalise",
			params: params
		})
	})
		.done(function(data, textStatus, xhr) {
			if(data) { // no rooms transferred
				generateReport();
			} else {
				wait.hide();
				showMessage("No rooms found to transfer","Error","300px",false,false,false,false,true);
			}
		})
		.fail(function(xhr, textStatus, error) {
			wait.hide();
			showMessage(xhr.responseText,"Error","300px",false,false,false,false,true);
		});
}

function paramStartDateChange() {
	paramEndDateCalculate();
}

function paramDaysChange() {
	paramEndDateCalculate();
}

function paramEndDateCalculate() {
	var days = parseInt(id("param-popup-days").value,10);

	if(isNaN(days) || days < 0) {
		id("param-popup-days").value = "";
		showMessage("Nights must be a positive number","Error",false,false,false,false,"param-popup-days",true);
		return false;
	}

	var startYear = id("param-popup-date-start-Year").value;
	var startMonth = selValue("param-popup-date-start-Month");
	var startDay = selValue("param-popup-date-start-Day");

	if(isNaN(startYear) || startYear < 1) {
		showMessage("Invalid start date year","Error",false,false,false,false,"param-popup-date-start-Year",true);
		return false;
	}
	
	if(startMonth == "mm") {
		showMessage("Invalid start date month","Error",false,false,false,false,"param-popup-date-start-Month",true);
		return false;
	}
		
	if(startDay == "0") {
		showMessage("Invalid start date day","Error",false,false,false,false,"param-popup-date-start-Day",true);
		return false;
	}

	var startDate = new Date(startYear + "/" + startMonth + "/" + startDay);
	var endDate = DayAdd(startDate,days-1);

	var endYear = endDate.getFullYear();
	var endMonth = endDate.getMonth() + 1;
	var endDay = endDate.getDate();

	populateDateFields("param-popup-date-end-Year", endYear, "param-popup-date-end-Month", endMonth, "param-popup-date-end-Day", endDay);

	return true;
}

function loadOccupancyCalendar() {
	window.location = "reservation.php?29+" + fromY + "-" + fromM + "-" + fromD + "+" + propertyIds.join(":");
}
