var enabledButtons		= ["Back","Forward","Refresh","Print","Calendar","Internet","Home","Help","NewWindow"];

function initialisePage() {

	initTop();
	if (publicPage) {
		var serverSelect =  document.getElementById('serverSelect');
		if (typeof(serverSelect) != 'undefined' && serverSelect != null) {
			id("serverSelect").disabled = true;
		}
	} else {
		enableButtons(enabledButtons);
	}
	
	id("loginResId").focus();
}

function loginAction(title,message) {
	wait.show();
	(function(resId,email,title,message) {
		aRequestPost("",function(result, response) {
			if(result) {
				id("divFolio").innerHTML = response;
				resetChosenCurrency();
				showDiv("divFolio");
				var folioChecks = document.getElementsByName("folioCheck");
				if(folioChecks.length > 0) {
					var folioIds = Object.keys(folios);
					if(folioIds.length > 0) {
						for(var count=0; count<folioIds.length; count++) {
							if(id(folioIds[count])) {
								id(folioIds[count]).checked = true;
							}
						}
					}
					folioClick();
				}
				wait.hide();
				if(message) {
					showMessage(message,title);
				}
			}
		},['action','resId','email'], ['login',resId,email]);
	})(id("loginResId").value, id("loginEmail").value,title,message)
}

function loginRetry() {
	showDiv("divLogin");
	id("loginResId").focus();
}

function checkAll(e, toggle) {
	var folios = document.getElementsByName("folioCheck");
	var first = true;
	var rf_currency_id;

	for(var count=0; count < folios.length; count++) {
		var fn_folio_id = folios[count].id;
		if(first) {
			rf_currency_id = id(fn_folio_id + "_rf_currency_id").value;
			first = false;
		}
		if(toggle == "select" && id(fn_folio_id + "_rf_currency_id").value == rf_currency_id) {
			folios[count].checked = true;
		} else {
			folios[count].checked = false;
		}
	}
	folioClick();
}

var chosen_currency_id;
var chosen_currency_symbol;
var chosen_currency_exchanges;

function resetChosenCurrency() {
	chosen_currency_id = false;
	chosen_currency_symbol = false;
	chosen_currency_exchanges = [];
}

function folioClick(e, fn_folio_id) {
	if(e) {
		e.cancelBubble = true;
	}
	if(fn_folio_id && !id(fn_folio_id).disabled) {
		id(fn_folio_id).checked = !id(fn_folio_id).checked;
	}
	var folios = document.getElementsByName("folioCheck");
	var folioIds = [];

	var total = 0;
	var found = false;
	var rf_currency_id;
	var rf_currency_symbol;

	id("payGatewayButtonDiv").onmouseover = function() { nd(); };
	$('#paymentPlanSelection').prop('disabled', false);

	for(var count=0; count < folios.length; count++) {
		if(folios[count].checked) {
			var fn_folio_id = folios[count].id;
			folioIds.push(fn_folio_id);
			if(!found) {
				rf_currency_id = id(fn_folio_id + "_rf_currency_id").value;
				rf_currency_symbol = id(fn_folio_id + "_rf_currency_symbol").value;
			}
			found = true;
			$('#paymentPlanSelection').prop('disabled', 'disabled');
		}
	}

	if(found) {
		var exchanges = JSON.parse(id("exchange_rates").value);
		if(chosen_currency_id === false) {
			chosen_currency_id = rf_currency_id;
			chosen_currency_symbol = rf_currency_symbol;
			chosen_currency_exchanges = [];
			chosen_currency_exchanges[rf_currency_id] = 1;
			for(var count=0; count < exchanges.length; count++) {
				if(exchanges[count]['rf_exch_curr_from_id'] == chosen_currency_id) {
					chosen_currency_exchanges[exchanges[count]['rf_exch_curr_to_id']] = exchanges[count]['rf_exch_rate'];
				}
			}
		}
		for(var count=0; count < folios.length; count++) {
			var fn_folio_id = folios[count].id;
			if($.inArray(id(fn_folio_id + "_rf_currency_id").value, Object.keys(chosen_currency_exchanges)) === -1) {
				folioCheckToggle(fn_folio_id,false);
			} else {
				folioCheckToggle(fn_folio_id,true);
			}
			if(folios[count].checked) {
				var amount = parseFloat(id(fn_folio_id + "_fn_folio_amt_outstanding").value);
				var exchange_rate;
				var converted_amount;
				if(id(fn_folio_id + "_rf_currency_id").value == chosen_currency_id) {
					exchange_rate = 1;
				} else {
					exchange_rate = parseFloat(chosen_currency_exchanges[id(fn_folio_id + "_rf_currency_id").value]);

				}
				converted_amount = amount / exchange_rate;
				id(fn_folio_id + "_exchange").innerHTML = exchange_rate.toFixed(6);
				id(fn_folio_id + "_converted").innerHTML = converted_amount.toFixed(2) + " " + chosen_currency_symbol;
				total += converted_amount;
			} else {
				id(fn_folio_id + "_exchange").innerHTML = "";
				id(fn_folio_id + "_converted").innerHTML = "";
			}
		}
		id("total_amount").innerHTML = total.toFixed(2);
		id("total_currency").innerHTML = chosen_currency_symbol;
		(function(ajaxFolios,ajaxCurrency,ajaxAmount,ajaxPaymentReference) {
			var payGatewayButton = id("payGatewayButton");
			var payGatewayButtonDiv = id("payGatewayButtonDiv");
			payGatewayButton.disabled = true;
			payGatewayButtonDiv.onmouseover = function() { 
				overlib("Checking whether a payment gateway is available. Please wait...");
				payGatewayButtonDiv.overlibActive = true;
			};
			payGatewayButtonDiv.onmouseout = function() {
				nd();
				payGatewayButtonDiv.overlibActive = false;
			};
			aRequestPost("", function(success,response) {
				if(success) {
					updatePayGatewayButton(true,response != "" && parseInt(ajaxAmount,10) > 0);
					document.getElementById("paymentGatewayDiv").innerHTML = response;
				}
			}, ['action','folios','rf_currency_id','amount','rv_reservation_id'], ['payment_gateway_popup',JSON.stringify(ajaxFolios),ajaxCurrency,ajaxAmount,ajaxPaymentReference]);
		})(folioIds,chosen_currency_id,id("total_amount").innerHTML,id("rv_reservation_id").value);
	} else {
		resetChosenCurrency();
		for(var count=0; count < folios.length; count++) {
			var fn_folio_id = folios[count].id;
			folioCheckToggle(fn_folio_id,true);
			id(fn_folio_id + "_exchange").innerHTML = "";
			id(fn_folio_id + "_converted").innerHTML = "";
		}
		id("total_amount").innerHTML = "0.00";
		id("total_currency").innerHTML = "";
		updatePayGatewayButton(false);
	}
}

function folioCheckToggle(fn_folio_id,enable) {
	var row = id(fn_folio_id + "_overlib_div").parentNode.parentNode.parentNode;
	if(!enable) {
		id(fn_folio_id).disabled = true;
		id(fn_folio_id + "_overlib_div").style.display = "";
		row.onmouseover = function() {
			overlib("There is no exchange rate stored to convert this folio's currency to " + chosen_currency_symbol);
		};
		row.onmouseout = function() { nd(); };
		row.className = "";
		$.each(row.cells,function(index,cell) {
			$(cell).addClass("txtg");
		});
	} else {
		id(fn_folio_id + "_overlib_div").style.display = "none";
		row.onmouseover = function() { this.style.backgroundColor = '#cfc';};
		row.onmouseout = function() { this.style.backgroundColor = '';};
		row.className = "imgLink";
		$.each(row.cells,function(index,cell) {
			$(cell).removeClass("txtg");
		});
		id(fn_folio_id).disabled = false;
	}
}

function updatePayGatewayButton(hasFolio, hasGateway) {
	id("payGatewayButton").disabled = true;
	var payGatewayButtonDiv = id("payGatewayButtonDiv");
	payGatewayButtonDiv.style.display = "";
	payGatewayButtonDiv.onmouseout = function() {
		nd();
		payGatewayButtonDiv.overlibActive = false;
	};
	if(!hasFolio) {
		id("payGatewayButtonDiv").onmouseover = function() { overlib("Select at least one folio to make payment"); };
	} else if(!hasGateway) {
		id("payGatewayButtonDiv").onmouseover = function() { overlib("No valid payment gateway found for this combination of currency and invoicing unit."); };
	} else {
		id("payGatewayButton").disabled = false;
		payGatewayButtonDiv.style.display = "none";
		payGatewayButtonDiv.onmouseout = function() {};
		payGatewayButtonDiv.onmouseover = function() {};
		if(payGatewayButtonDiv.overlibActive) {
			nd();
			payGatewayButtonDiv.overlibActive = false;
		}
	}
}

function payNow() {
	openPaymentGatewayPopup();
}

function processPayment(action,data) {
	if(action == "cancel") {
		closePaymentGatewayPopup();
		return;
	}

	if(action == "payNow") {
		var folios = document.getElementsByName("folioCheck");
		var folioAmounts = {};
		for(var count=0; count < folios.length; count++) {
			if(folios[count].checked) {
				var fn_folio_id = folios[count].id
				folioAmounts[fn_folio_id] = id(fn_folio_id + "_fn_folio_amt_outstanding").value;
			}
		}
		id("folios").value = JSON.stringify(folioAmounts);
		id(folioForm.submit());
		return;
	}
}

function findAction() {
	wait.show();
	(function(resId,resName,voucherRef,invoiceId) {
		aRequestPost("",function(result, response) {
			if(result) {
				var data = JSON.parse(response);
				if(data.action == "render") {
					id("divFind").innerHTML = data.output;
					showDiv("divFind");
				}
				if(data.action == "login") {
					id("loginResId").value = data.resId;
					loginAction();
				}
				wait.hide();
			}
		},['action','resId','resName','voucherRef','invoiceId'], ['find',resId,resName,voucherRef,invoiceId]);
	})(id("loginResId").value, id("loginResName").value, id("loginVoucherRef").value, id("loginInvoiceId").value);
}

function findClick(rv_reservation_id) {
	id("loginResId").value = rv_reservation_id;
	loginAction();
}

function showDiv(divId) {
	id("divLogin").className = "collapse printCollapse";
	id("divFolio").className = "collapse printCollapse";
	id("divFind").className = "collapse printCollapse";
	id("divReceipt").className = "collapse printCollapse";

	id(divId).className = "expand";
}

function fieldKeyUp(e) {
	if(e.keyCode == 13) {
		if(userStatusId < 2) {
			loginAction();
		} else {
			findAction();
		}
	}
}

function showFolio(fn_folio_id) {
	openPopup("reservation.php?642+++"+fn_folio_id,640,518);
}

function changePaymentPlanAmounts() {
	var percentage = parseInt($("#paymentPlanSelection").val());
	$(".fn_folio_id").each(function(index) {
		var folioId = $(this).val();
		var fullAmount = parseInt($("#" + folioId + "_fn_folio_amount").val());
		var newFullAmount = ( fullAmount / 100 ) * percentage;
		var percentageText = " (" + percentage.toFixed(0) + "%)";
		$("#" + folioId + "_payable_cell").attr("title", "");
		if (
			newFullAmount != fullAmount &&				// not currently on 100%
			$(this).attr("fullPaymentRequired") == "1"
		) {
			newFullAmount = fullAmount;
			percentageText = " (100%)";
			$("#" + folioId + "_payable_cell").attr("title", "This folio can only be paid in full");
		}

		$("#" + folioId + "_fn_folio_amount_display").text(newFullAmount.toFixed(2));
		var outstanding = newFullAmount - parseInt($("#" + folioId + "_fn_folio_amt_paid").val());
		if (outstanding < 0) {
			outstanding = 0;
		}
		$("#" + folioId + "_fn_folio_amt_outstanding_display").text(outstanding.toFixed(2));
		$("#" + folioId + "_fn_folio_amt_outstanding").val(outstanding.toFixed(2));
		$("#" + folioId + "_percentage").text(percentageText);
	  });
}
