function openProfile() {
	applyTrans(1);
	id("divProfile").style.zIndex = "100";
	id("divProfile").style.display = "block";
	centerDivOnPage("divProfile");
}

function closeProfile() {
	applyTrans(0);
	id("divProfile").style.zIndex = "1";
	id("divProfile").style.display = "none";
}

function openProfileEdit() {
	if(id("divProfile").style.display == "none") {
		applyTrans(2);
  } else if(!id("trans")) {
		applyTrans(1);
		id("trans").style.zIndex = 199;
  } else {
		id("trans").style.zIndex = 199;
	}
	id("divProfileEdit").style.zIndex = "200";
	id("divProfileEdit").style.display = "block";
	centerDivOnPage("divProfileEdit");
	id("pf_option_name_edit").focus();	
}

function closeProfileEdit() {
	if(id("divProfile").style.display == "none") {
		applyTrans(0);
  } else if(!id("trans")) {
		applyTrans(0);
		id("trans").style.zIndex = "";
	} else {
		id("trans").style.zIndex = "";
	}
	id("divProfileEdit").style.zIndex = "1";
	id("divProfileEdit").style.display = "none";
}

function saveProfile(saveAs) {
	if(!saveAs && id("pf_can_save").value != "1") {
		if(id('profile_name').value == 'Custom') {
			saveProfileAs();
			return false;
		}
		else {
			openMessage("You do not have access to save this profile. Use 'save profile as...' to create a new one");
			return false;
		}
	}

	var url = false;
	var jobId = id("pf_job_id").value;
	//if(!saveAs || (saveAs && id("pf_option_id_edit").value == "")) {
	url = buildURL(0, false);
	//}  else {
	//	url = "reservation.php?" + jobId;
	//}
	if(url || (saveAs && id("pf_option_id_edit").value != "")) {
		aRequestReset();
		
		if(!saveAs) {
			var sNames	= ["pf_action","pf_option_id","url"];
			var sValues	= ["save",id("pf_option_id").value,url];
		} else {
			if(id("pf_option_name_edit").value.trim() == "") {
				id("pf_option_name_edit").focus();
				openMessage("You must specify a name for this profile.");
				return false;
			}
			if(id("pf_option_favourite_yn_edit").checked && id("pf_option_title_edit").value == "") {
				id("pf_option_title_edit").focus();
				openMessage("You must provide a title for a profile set as a favourite");
				return false;
			}
			if(id("pf_option_id_edit").value == "") {
				var action = "saveAs";
			} else {
				var action = "saveDetail";
			}
			
			var sNames	= ["pf_action","pf_option_id","url","pf_option_name","pf_option_note", "pf_level_ind", "pf_option_default_yn", "pf_option_favourite_yn","pf_option_title"];
			var sValues	= [action,id("pf_option_id_edit").value,url,id("pf_option_name_edit").value,id("pf_option_note_edit").value,selValue("pf_level_ind_edit"),id("pf_option_default_yn_edit").checked?"1":"0",id("pf_option_favourite_yn_edit").checked?"1":"0",id("pf_option_title_edit").value];
		}
		aRequestPost("reservation.php?"+jobId, saveProfileDone, sNames, sValues);
	}
}

function saveProfileDone(sStatus,sData) {
	if(sStatus) {
		var dataArray = sData.split("|");
		var action = decodeURIComponent(dataArray[0]);
		if(action == "error") {
			openMessage(decodeURIComponent(dataArray[1]));
			return false;
		}
		id("divProfile").innerHTML = decodeURIComponent(dataArray[1]);
		if(action == "saveAs") {
			id("pf_option_id").value = decodeURIComponent(dataArray[2]);
			id("profile_name").value = decodeURIComponent(dataArray[3]);
			id("pf_can_save").value = "1";
		}
		if(action == "saveDetail") {
			if(id("pf_option_id").value == decodeURIComponent(dataArray[2])) {
				id("profile_name").value = decodeURIComponent(dataArray[3]);
				id("pf_can_save").value = "1";
			}
		}
		closeProfileEdit();
		openMessage("Profile saved");
	}
}

function saveProfileAs() {
	editProfile();
}

function saveProfileEdit() {
	saveProfile(true);
}


function loadProfile(pf_option_id) {
	id("urlForm").target = "_self";
	id("url").value = "";
	id("pf_option_id").value = pf_option_id;
	id("urlForm").submit();
}


function editProfile(pf_option_id,pf_option_name,pf_option_note,pf_option_default_yn,pf_level_ind,pf_option_favourite_yn,pf_option_title) {
	if(pf_option_id) {
		id("pf_option_id_edit").value = pf_option_id;
		id("pf_option_name_edit").value = decodeURIComponent(pf_option_name);
		id("pf_option_note_edit").value = decodeURIComponent(pf_option_note);
		for(var count=0; count<id("pf_level_ind_edit").options.length; count++) {
			if(id("pf_level_ind_edit").options[count].value == pf_level_ind) {
				id("pf_level_ind_edit").selectedIndex = count;
			}
		}
		id("pf_level_ind_edit").disabled = true;
		if(pf_option_default_yn == "1") {
			id("pf_option_default_yn_edit").checked = true;
		} else {
			id("pf_option_default_yn_edit").checked = false;
		}
		if(pf_option_favourite_yn == "1") {
			id("pf_option_favourite_yn_edit").checked = true;
		} else {
			id("pf_option_favourite_yn_edit").checked = false;
		}
		id("pf_option_title_edit").value = decodeURIComponent(pf_option_title);
	} else {
		id("pf_option_id_edit").value = "";
		id("pf_option_name_edit").value = "";
		id("pf_option_note_edit").value = "";
		id("pf_level_ind_edit").disabled = false;
		id("pf_level_ind_edit").selectedIndex = id("pf_level_ind_edit").options.length-1; //user level
		id("pf_option_default_yn_edit").checked = false;
		id("pf_option_favourite_yn_edit").checked = false;
		id("pf_option_title_edit").value = "";
	}

	openProfileEdit();
}


var confirmAction;
var confirmValue;
function deleteProfile(pf_option_id,confirmed) {
	if(!confirmed) {
		confirmAction = "deleteProfile";
		confirmValue = pf_option_id;
		openConfirm("Are you sure you want to delete this report profile?");
	} else {
		aRequestReset();
		dNames = ["pf_action","pf_option_id"];
		dValues = ["delete",pf_option_id];
		var jobId = id("pf_job_id").value;
		
		// Another Firefox timing issue...
		//setTimeout("aRequestPost('reservation.php?' + jobId, deleteProfileDone, dNames, dValues)",100);
		aRequestPost('reservation.php?' + jobId, deleteProfileDone, dNames, dValues);
	}
}

function deleteProfileProcessResponse() {
	if(confirmAction == "deleteProfile") {
		deleteProfile(confirmValue,true);
		confirmAction = "";
		confirmValue = "";
	}
}
responseFunctions.push("deleteProfileProcessResponse");

function deleteProfileDone(dStatus,dData) {
	if(dStatus) {
		var dataArray = dData.split("|");
		var pf_option_id = decodeURIComponent(dataArray[2]);
		var action = decodeURIComponent(dataArray[0]);
		id("divProfile").innerHTML = decodeURIComponent(dataArray[1]);
		if(id("pf_option_id").value == pf_option_id) {
			id("pf_option_id").value = "";
			id("profile_name").value = "None";	
		}
	}
}

