function initialisePage(){
	dateSelector();
	initTop();
	enableButtons(enabledButtons);

	id("user").innerHTML = FirstName + " " + LastName;
	id("server").innerHTML = Domain;
	id("genDate").innerHTML = genDateVal;

	populateDateFields("fromPaidYear", fromPaidY, "fromPaidMonth", fromPaidM, "fromPaidDay", fromPaidD);
	populateDateFields("toPaidYear", toPaidY, "toPaidMonth", toPaidM, "toPaidDay", toPaidD);
	populateDateFields("fromRecordYear", fromRecordY, "fromRecordMonth", fromRecordM, "fromRecordDay", fromRecordD);
	populateDateFields("toRecordYear", toRecordY, "toRecordMonth", toRecordM, "toRecordDay", toRecordD);
	if(id('reportBody').className == "") {
		var filters = id("filters");
		var filterBut = id("filterBut");  
		filters.className = "collapse printCollapse";
		filterBut.value = ">> Show Filters";
	}

	levelChange();
}

function buildDate(prefix) {
	dayValue = id(prefix+"Day").options[id(prefix+"Day").selectedIndex].value;
	monthValue = id(prefix+"Month").options[id(prefix+"Month").selectedIndex].value;

	dayValue = dayValue<10?"0"+dayValue:dayValue;
	monthValue = monthValue<10?"0"+monthValue:monthValue;
	 
	resultDate = id(prefix+"Year").value+"-"+monthValue+"-"+dayValue;
      
	if(dayValue < 1) { 
		id(prefix+"Day").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(monthValue < 1) {
		id(prefix+"Month").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(id(prefix+"Year").value == "") {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;		 
	 }		 
	if(id(prefix+"Year").value.search(/^\d{4}$/) == -1) {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}

	return resultDate;
}  

function buildURL(renderOption) {
	renderOption &= 7;
	if(id("datePaid").checked) {
		dateOption = "1";
	} else {
		dateOption = "2";
	}
	if(!buildDate("fromPaid") || !buildDate("toPaid") || !buildDate("fromRecord") || !buildDate("toRecord")) {
		return false;
	}
	fromPaidDate = buildDate("fromPaid");
	toPaidDate = buildDate("toPaid");
	fromRecordDate = buildDate("fromRecord");
	toRecordDate = buildDate("toRecord");

	_urlCount++;	
	url = new Array("reservation.php?261",
		dateOption,												//  1
		fromPaidDate,											//  2
		toPaidDate,												//  3
		fromRecordDate,											//  4
		toRecordDate,											//  5
		id("bankIds").value,									//  6
		id("recordId").value,									//  7
		id("currenciesIds").value,								//  8
		id("mthdpayIds").value,									//  9
		selValue("level1") + ":" + selValue("level2"),			// 10
		renderOption,											// 11
		_randomId + "_" + _urlCount.toString()		
	);
	return url.join("+");
}

function generateReport(renderOption) {
	url = buildURL(renderOption);
	if(url) {
		id("urlForm").target = "_self";		
		id("urlForm").action = "";
		id("url").value = url;
		id("urlForm").submit();
	}
}

function openPDF() {
	var url = buildURL(1);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading PDF...",640,480,0,0,0,1,"pdfWin","opener.id('urlForm').submit();");
	}
}

function sendPDF() {
	var url = buildURL(2);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin = openPopup("/resource/Resrequest/Application/public/html/wait.htm?Loading email popup...",775,615,0,0,0,0,"pdfWin","opener.id('urlForm').submit();");
	}
}

function openCSV() {
	var url = buildURL(4);
	if(url) { 
		id("urlForm").target = "_self";		
		id("url").value = url;
		id("urlForm").submit();
  }
}
function openFilter(filter){
	var selectedArray = id(filter + "Ids").value;
	url = "reservation.php?661+"
		+ filter
		+ "+"
		+ selectedArray;    
         
	openPopup(url,280,360);                          
}

function showHideFilters(){
	var filters = id("filters");
	var filterBut = id("filterBut");  
	if(filters.className != "collapse printCollapse"){
		filters.className = "collapse printCollapse";
		filterBut.value = ">> Show Filters";
	} else {
		filters.className = "expand";
		filterBut.value = "<< Hide Filters";
	}
}

function select_daymonth_changed(){
	setDayList(id("fromPaidDay"),id("fromPaidMonth").options[id("fromPaidMonth").selectedIndex].value,id("fromPaidYear").value);
	setDayList(id("toPaidDay"),id("toPaidMonth").options[id("toPaidMonth").selectedIndex].value,id("toPaidYear").value);
	setDayList(id("fromRecordDay"),id("fromRecordMonth").options[id("fromRecordMonth").selectedIndex].value,id("fromRecordYear").value);
	setDayList(id("toRecordDay"),id("toRecordMonth").options[id("toRecordMonth").selectedIndex].value,id("toRecordYear").value);
}

function openSearch(num) {
   if (num == "1")
   {
      num = "15";
   }
   if (num == "2")
   {
      num = "16";
   }
   openPopup("reservation.php?692+"+num,350,520);
}

function openPaymentsReceived(oLevel1,oLevel2,oValue1,oValue2) {
	if(allowDrillDown == "0") {
		openMessage("Please select only 1 bank / cash point to enable drill down to the payments received report.");
		return;
	}

	if(!buildDate("fromPaid") || !buildDate("toPaid") || !buildDate("fromRecord") || !buildDate("toRecord")) {
		return false;
	}

	fromPaidDate = buildDate("fromPaid");
	toPaidDate = buildDate("toPaid");
	fromRecordDate = buildDate("fromRecord");
	toRecordDate = buildDate("toRecord");
	bankId = id("bankIds").value;
	currencyId = "";
	methodId = "";
	recordUserId = "";

	if(id("datePaid").checked) {
		dateOption = "0";
	} else {
		dateOption = "1";
	}

	switch(oLevel1) {
		case "creditDate":
			fromPaidDate = oValue1;
			toPaidDate = oValue1;
			break;
		case "recordDate":
			fromRecordDate = oValue1;
			toRecordDate = oValue1;
			dateOption = "1";
			break;
		case "bank":
			bankId = oValue1;
			break;
		case "currency":
			currencyId = oValue1;
			break;
		case "method":
			methodId = oValue1;
			break;
		case "user":
			recordUserId = oValue1;
			break;
	}
	switch(oLevel2) {
		case "creditDate":
			fromPaidDate = oValue2;
			toPaidDate = oValue2;
			break;
		case "recordDate":
			fromRecordDate = oValue2;
			toRecordDate = oValue2;
			dateOption = "1";
			break;
		case "bank":
			bankId = oValue2;
			break;
		case "currency":
			currencyId = oValue2;
			break;
		case "method":
			methodId = oValue2;
			break;
		case "user":
			recordUserId = oValue2;
			break;
	}



	var url = [
		/*  0 */ "/reservation.php?654",
		/*  1 */ fromPaidDate,
		/*  2 */ toPaidDate,
		/*  3 */ '', //payer id
		/*  4 */ '', // notes
		/*  5 */ '', // adv search show
		/*  6 */ fromRecordDate,
		/*  7 */ toRecordDate,
		/*  8 */ recordUserId,
		/*  9 */ '', // pay ref
		/* 10 */ currencyId, // currency id
		/* 11 */ methodId, // method of payment
		/* 12 */ '', // page nrs
		/* 13 */ dateOption, // date range?
		/* 14 */ '',
		/* 15 */ '', // order flag
		/* 16 */ '', // order type
		/* 17 */ '', // notes b
		/* 18 */ bankId, // bank id / cash point
		/* 19 */ '', // voucher reference
		/* 20 */ '', // folio check
		/* 21 */ '', // invoice check
		/* 22 */ 0, // render option
		/* 23 */ _randomId + "_" + _urlCount.toString()
	];

	window.location = url.join("+");
}

function openReservation(resId) {
	Set_Cookie("finTabName","Payment");
	
	window.location = "/reservation.php?647+"+resId;
}

function levelChange() {
	if(selValue("level1") == "all") {
		id("level2").selectedIndex = 0;
		id("level2").disabled = true;
	} else {
		id("level2").disabled = false;
	} 
}
