function checkAmtAll(obj){
	var inputs = document.getElementsByTagName("INPUT");
	if(obj.checked){
		state = true;
	} else {
		state = false;
	}
	
	for ( var i = 0; i < inputs.length; i++ ) {
		if ( inputs[i].getAttribute("type") == "checkbox" && inputs[i].name=="checkAmt" && inputs[i].id.substring(0,3) == obj.id.substring(8,11) &&inputs[i].checked != state) {
			inputs[i].checked = state;
		}
	}
}

function editAmt(obj){
	if (id("btnSave").disabled){
		return;
	}
	
	var rateID = id("rateID").value;
	var rateCompGroups = id("compGroupIDs").value.split(",");
	
	if (obj){
		if(obj.value=="<none>"){
			obj.value = "";
		}
	}
	
	id("btnCancel").className = "button";
	id("btnSave").className = "button";
	id("mode").value = "edit";	
}

function saveAmt(){
	if (id("btnSave").disabled){
		return;
	}
	
	var rateID = id("rateID").value;
	var data = "";
	var mode = id("mode").value;
	var rateCompGroups = id("compGroupIDs").value.split(",");
	var maxCapacity = id("maxCapacity").value;
	
	if (validateAmounts() == 1){
		return;
	}
	
	for (i=0;i<=maxCapacity;i++) {
		data = data + i + "|";
		for (var j=0; j<rateCompGroups.length; j++) {
			data = data + rateCompGroups[j] + ":" + escape(id("amt" + rateCompGroups[j] + "_" + i).value) + "|";
		}
		data = data + "_";
	}
	
	$.post("reservation.php?407" + "+" + rateID + "+" + mode, {data: data},
	function(data, status){
		processAmountAJAX((status == "success" ? true : false), data);
	});
}

function applyFormula(){
	if (id("btnSave").disabled){
		return;
	}
	
	editAmt();
	var objCheckBoxes = document.forms["amounts"].elements["checkAmt"];
	var formula = id("formula").value;
	if (!formula)
		return;
	if(!objCheckBoxes)
		return;
	var countCheckBoxes = objCheckBoxes.length;
	for (i=0;i<countCheckBoxes;i++) {
		if (objCheckBoxes[i].checked){
			if (formula == "=none" || formula == "=<none>") {
				id("amt"+objCheckBoxes[i].id).value = "";
			}

			var re = new RegExp('([+*-/=]*)(\\d+(\\.\\d+)*)(%*)');
			var m = re.exec(formula);
			if (m == null) {
				//alert("No match");
			} else {
				for (j = 0; j < m.length; j++) {
					var formulaResult = 0;
					switch(m[j]){
						case "+":
							if (m[j+3] == "%"){
								formulaResult = parseFloat(id("amt"+objCheckBoxes[i].id).value)+parseFloat(id("amt"+objCheckBoxes[i].id).value)*(parseFloat(m[j+1]/100));
								id("amt"+objCheckBoxes[i].id).value = formulaResult.toFixed(2);
							} else {
								formulaResult = parseFloat(id("amt"+objCheckBoxes[i].id).value)+parseFloat(m[j+1]);
								id("amt"+objCheckBoxes[i].id).value = formulaResult.toFixed(2);
							}
							break;
						case "-":
							if (m[j+3] == "%"){
								formulaResult = parseFloat(id("amt"+objCheckBoxes[i].id).value)-parseFloat(id("amt"+objCheckBoxes[i].id).value)*(parseFloat(m[j+1]/100));
								id("amt"+objCheckBoxes[i].id).value = formulaResult.toFixed(2);
							} else {
								formulaResult = parseFloat(id("amt"+objCheckBoxes[i].id).value)-parseFloat(m[j+1]);
								id("amt"+objCheckBoxes[i].id).value = formulaResult.toFixed(2);
							}
							break;							
						case "*":
							formulaResult = parseFloat(id("amt"+objCheckBoxes[i].id).value)*parseFloat(m[j+1]);
							id("amt"+objCheckBoxes[i].id).value = formulaResult.toFixed(2);
							break;									
						case "/":
							formulaResult = parseFloat(id("amt"+objCheckBoxes[i].id).value)/parseFloat(m[j+1]);
							id("amt"+objCheckBoxes[i].id).value = formulaResult.toFixed(2);
							break;			
						case "=":
							formulaResult = parseFloat(m[j+1]);
							id("amt"+objCheckBoxes[i].id).value = formulaResult.toFixed(2);
							break;									
					}
				}
			}
		}
	}
}

function setAssumptions(){
	if (id("btnSave").disabled){
		return;
	}
	
	editAmt();		
	$("input").each(function(index) {
		if ($(this).prop("id").substring(0, 3) == "amt") //check logic there
		{
			ident = $(this).prop("id").substring(3, $(this).prop("id").length);
			identArr = ident.split("_");
			// If there's a fixed amt, use that
			if ($(this).val() == 0 || $(this).css("background-color").toString().toLowerCase().replace(/\s/g,"") == "rgb(255,0,0)" || $(this).val() == "<none>"){
				if (parseFloat(id("fixed"+ident).value) != 0){
					$(this).val(parseFloat(id("fixed"+ident).value));
					$(this).css("background-color", "rgb(255, 255, 0)");
				}
			}
			// Get previous average
			if ($(this).val() == 0 && identArr[1] != "0" || $(this).val() == "<none>" && identArr[1] != "0"){
				if ((parseInt(identArr[1])-1) == "0"){
					prevqty = 1;
				} else {
					prevqty = parseInt(identArr[1])-1;
				}	
				if (parseFloat(id("amt"+identArr[0]+"_"+(parseInt(identArr[1])-1)).value) > 0){
					$(this).val((parseFloat(id("amt"+identArr[0]+"_"+(parseInt(identArr[1])-1)).value) / prevqty)*identArr[1]);
					$(this).css("background-color", "rgb(255, 255, 0)");
				}

			}
			
		}
	});		
}

function clearAssumptions(){
	$("input").each(function(index) {
		if ($(this).prop("id").substring(0, 3) == "amt") //check logic there
		{
			if ($(this).css("background-color").toString().toLowerCase().replace(/\s/g,"") == "rgb(255,255,0)"){
				$(this).val("0.00");
				$(this).css("background-color", "rgb(255, 255, 255)");
			}			
		}
	});	
}

function validateAmounts(){
	errors = false;

	// If waive values flag is set, do not validateAmounts
	if (id("rtWaive").value == "1"){
		return;
	}
	
	
	$("input").each(function(index) {
	  if ($(this).prop("id").substring(0, 3) == "amt") //check logic there
	{
	   ident = $(this).prop("id").substring(3, $(this).prop("id").length); 
	   
		if (id("fixed"+ident).value != 0){
			
			if (parseFloat(id("amt"+ident).value) != parseFloat(id("fixed"+ident).value)){
				id("amt"+ident).style.backgroundColor = "rgb(255, 0, 0)";
				errors = true;
			} else {
				id("amt"+ident).style.backgroundColor = "";
			}
		}
	   
	}
	});	

	if (errors){
		openMessage("One or more of the amounts entered do not match the fixed component specification.");
		return 1;
	} else {
		return 0;
	}	
}
