function addComp(compID) {
	if (id("btnSave").disabled){
		return;
	}
	
	var savedCompCount = parseInt(id("savedCompCount").value);
	var maxCompCount = parseInt(id("maxCompCount").value);
	var addCount = parseInt(id("addCount").value,10);

	if (savedCompCount + addCount >= maxCompCount){
		return;
	}	

	addCount = addCount + 1;
	id("addCount").value = addCount;	
	
	id("btnCancel").className = "button";
	id("mode").value = "add";
	
	// Remove all the onlick attributes of the table so we can't now start
	// Editing cells.
	tbody = id("compTable");
	
	for ( var i = 0; i < tbody.rows.length; i++ ) {
		for ( var k = 0; k < tbody.rows[i].cells.length; k++ ) {
			tbody.rows[i].cells[k].setAttribute("onclick","");
		}
		tbody.rows[i].setAttribute("onmouseover","");
		tbody.rows[i].setAttribute("onmouseout","");
	}

	var row = tbody.insertRow(-1);
	var aCell = row.insertCell(-1);
	var bCell = row.insertCell(-1);
	var cCell = row.insertCell(-1);
	var jCell = row.insertCell(-1);
	var dCell = row.insertCell(-1);
	var eCell = row.insertCell(-1);
	var fCell = row.insertCell(-1);
	var gCell = row.insertCell(-1);
	var hCell = row.insertCell(-1);
	var iCell = row.insertCell(-1);
	
	row.style.backgroundColor = "#cfc";
	row.setAttribute("id","newID" + addCount);
	aCell.innerHTML = "<td>&nbsp;</td>";

	bCell.innerHTML = id("hiddenNewComp").innerHTML;
	var newid = bCell.firstChild.getAttribute("id").replace("newCompTemp","selComp")+addCount;
	bCell.firstChild.setAttribute("id",newid);	

	$("#"+newid).addClass("newCompSelect");
	
	//JQuery
	$("#"+newid).bind("change", function(){
		checkCompExists();
		setSepDefault(this, addCount);
		setOptDefault(this, addCount);
		setDefDefault(this, addCount);
		setCommDefault(this, addCount);
		setFreqDefault(this, addCount);
		setFreqFactDefault(this, addCount);
		setTaxRateDefault(this, addCount);
		setTaxGroupDefault(this, addCount);
	});

	cCell.innerHTML = "<select id=\"selOptyn" + addCount + "\" onclick=\"toggleDefOpt(this)\"><option value=\"0\">No</option><option value=\"1\">Yes</option>";
	jCell.innerHTML = "<select id=\"selOptDefyn" + addCount + "\" ><option value=\"0\">No</option><option value=\"1\">Yes</option>";	
	dCell.innerHTML = id("hiddenNewComm").innerHTML;
	dCell.firstChild.setAttribute("id",dCell.firstChild.getAttribute("id").replace("newCommTemp","selComm")+addCount);			
	eCell.innerHTML = "<select id=\"selFreq" + addCount + "\" onclick=\"selectFreqType(this)\"><option value=\"1\">Per Night</option><option value=\"2\">Per Stay</option>";	
	fCell.innerHTML = "<select id=\"selFreqFact" + addCount + "\" ><option value=\"0\">0</option><option value=\"1\">1</option><option value=\"2\">2</option><option value=\"3\">3</option><option value=\"4\">4</option><option value=\"5\">5</option><option value=\"6\">6</option><option value=\"7\">7</option><option value=\"8\">8</option><option value=\"9\">9</option><option value=\"10\">10</option>";	
	gCell.innerHTML = "<select id=\"selSep" + addCount + "\" ><option value=\"0\">No</option><option value=\"1\">Yes</option>";
	gCell.className = "lastCell";
	
	hCell.innerHTML = id("hiddenNewTaxRate").innerHTML;
	hCell.firstChild.setAttribute("id",hCell.firstChild.getAttribute("id").replace("newTaxRateTemp","selTaxRate")+addCount);
	hCell.firstChild.selectedIndex = 1;
	
	iCell.innerHTML = id("hiddenNewTaxGroup").innerHTML;
	iCell.firstChild.setAttribute("id",iCell.firstChild.getAttribute("id").replace("newTaxGroupTemp","selTaxGroup")+addCount);			

	id("rtSectionContainerComps").scrollTop = id("rtSectionContainerComps").scrollHeight - id("rtSectionContainerComps").offsetHeight;

	if (compID.length > 0) {
		setComp(id("selComp"+addCount), addCount, compID);
	}

	checkCompExists();
	setSepDefault(id("selComp"+addCount), addCount);

	setOptDefault(id("selComp"+addCount), addCount);
	setDefDefault(id("selComp"+addCount), addCount);
	setCommDefault(id("selComp"+addCount), addCount);
	setFreqDefault(id("selComp"+addCount), addCount);
	setFreqFactDefault(id("selComp"+addCount), addCount);
	setTaxRateDefault(id("selComp"+addCount), addCount);
	setTaxGroupDefault(id("selComp"+addCount), addCount);
}

function editComp(aID,e){
	if (id("btnSave").disabled){
		return;
	}

	var sepSelectedOpt = "";
	var optynSelectedOpt = "";
	var commSelectedOpt = "";
	var freqSelectedOpt = "";
	
	id("mode").value = "edit";	

	id("btnCancel").className = "button";
	id("btnSave").className = "button";

	if(id("btnAdd")) {
		id("btnAdd").setAttribute("disabled","disabled");
		id("btnAdd").className = "button buttonDisabled";
	}	

	if(id("edited").value.indexOf(aID) < 0) {
		id("edited").value	= id("edited").value + ":" + aID;
	}		

	id("cell1" + aID).setAttribute("onclick","");
	id("cell2" + aID).setAttribute("onclick","");
	id("cell9" + aID).setAttribute("onclick","");		
	id("cell3" + aID).setAttribute("onclick","");
	id("cell4" + aID).setAttribute("onclick","");
	id("cell5" + aID).setAttribute("onclick","");	
	id("cell6" + aID).setAttribute("onclick","");	
	id("cell7" + aID).setAttribute("onclick","");	
	id("cell8" + aID).setAttribute("onclick","");	

	id("cell1" + aID).innerHTML = id("hiddenComp" + aID).innerHTML;
	id("cell1" + aID).firstChild.setAttribute("id",id("cell1" + aID).firstChild.getAttribute("id").replace("cell1CompTemp","selComp"));
	switch(id("cell2" + aID).innerHTML){
		case "&nbsp;Yes":
			optynSelectedOpt = "1";
			break;
		case "&nbsp;No":
			optynSelectedOpt = "0";
			break;
	}	
	id("cell2" + aID).innerHTML = "<select id=\"selOptyn" + aID + "\" onclick=\"toggleDefOpt(this)\"><option value=\"0\">No</option><option value=\"1\">Yes</option>";
	id("selOptyn" + aID).value = optynSelectedOpt;	

	switch(id("cell9" + aID).innerHTML){
		case "&nbsp;Yes":
			optdefynSelectedOpt = "1";
			break;
		case "&nbsp;No":
			optdefynSelectedOpt = "0";
			break;
	}	
	id("cell9" + aID).innerHTML = "<select id=\"selOptDefyn" + aID + "\"><option value=\"0\">No</option><option value=\"1\">Yes</option>";
	id("selOptDefyn" + aID).value = optdefynSelectedOpt;	
	if (optdefynSelectedOpt == "0"){
		id("selOptDefyn" + aID).disabled = true;
	}
	if (id("selOptyn" + aID).value == "1"){
		id("selOptDefyn" + aID).disabled = false;
	}
	
	id("cell3" + aID).innerHTML = id("hiddenComm" + aID).innerHTML;
	id("cell3" + aID).firstChild.setAttribute("id",id("cell3" + aID).firstChild.getAttribute("id").replace("cell3CommTemp","selComm"));	

	switch(id("cell4" + aID).innerHTML){
		case "&nbsp;Per Stay":
			freqSelectedOpt = "2";
			break;
		case "&nbsp;Per Night":
			freqSelectedOpt = "1";
			break;
	}		
	id("cell4" + aID).innerHTML = "<select id=\"selFreq" + aID + "\" onclick=\"selectFreqType(this)\"><option value=\"1\">Per Night</option><option value=\"2\">Per Stay</option>";	
	id("selFreq" + aID).value = freqSelectedOpt;	
	
	freqFactSelectedOpt = id("cell5" + aID).innerHTML;
	id("cell5" + aID).innerHTML = "<select id=\"selFreqFact" + aID + "\"><option value=\"0\">0</option><option value=\"1\">1</option><option value=\"2\">2</option><option value=\"3\">3</option><option value=\"4\">4</option><option value=\"5\">5</option><option value=\"6\">6</option><option value=\"7\">7</option><option value=\"8\">8</option><option value=\"9\">9</option><option value=\"10\">10</option>";	
	id("selFreqFact" + aID).value = freqFactSelectedOpt.substring(6, freqFactSelectedOpt.length);		// Bit of a hack
	if (freqSelectedOpt == "2"){
		id("selFreqFact" + aID).disabled = true;
	}
	
	switch(id("cell6" + aID).innerHTML){
		case "&nbsp;No":
			sepSelectedOpt = "0";
			break;
		case "&nbsp;Yes":
			sepSelectedOpt = "1";
			break;			
	}
	id("cell6" + aID).innerHTML = "<select id=\"selSep" + aID + "\"><option value=\"1\">Yes</option><option value=\"0\">No</option>";
	id("selSep" + aID).value = sepSelectedOpt;

	id("cell7" + aID).innerHTML = id("hiddenTaxRate" + aID).innerHTML;
	id("cell7" + aID).firstChild.setAttribute("id",id("cell7" + aID).firstChild.getAttribute("id").replace("cell7TaxRateTemp","selTaxRate"));	

	id("cell8" + aID).innerHTML = id("hiddenTaxGroup" + aID).innerHTML;
	id("cell8" + aID).firstChild.setAttribute("id",id("cell8" + aID).firstChild.getAttribute("id").replace("cell8TaxGroupTemp","selTaxGroup"));	
		
}

function saveComp(){
	if (id("btnSave").disabled){
		return;
	}
	
	var rateID = id("rateID").value;
	var data = "";
	var mode = id("mode").value;
	var addCount = parseInt(id("addCount").value,10);
	var editedIds = id("edited").value.split(":");

	switch(mode) {
	case "add":
        var idsToAdd = new Array();
		for(k=1;k<=addCount;k++) {
            if (jQuery.inArray(selValue("selComp" + k),idsToAdd) != -1){
                openMessage("Cannot add the same component more than once","a",100);
                return false;
            }
            idsToAdd.push(selValue("selComp" + k));
			data = data + escape(selValue("selComp" + k)) + ":"
			+ escape(selValue("selOptyn" + k)) + ":"
			+ escape(selValue("selOptDefyn" + k)) + ":"
			+ escape(selValue("selComm" + k)) + ":"
			+ escape(selValue("selFreq" + k)) + ":"
			+ escape(selValue("selFreqFact" + k)) + ":"
			+ escape(selValue("selSep" + k)) + ":"
			+ escape(selValue("selTaxRate" + k)) + ":"
			+ escape(selValue("selTaxGroup" + k))
			+ "_";
		}
		id("addCount").value = "0";
		break;
	
	case "edit":
		for(i=1;i<editedIds.length;i++) {

			if (!id("selFreqFact" + editedIds[i]).disabled){
				var selFreqFactValue = escape(selValue("selFreqFact" + editedIds[i]));
			} else {
				var selFreqFactValue = "";
			}

			data = data + editedIds[i] + ":" 
			+ escape(selValue("selComp" + editedIds[i])) + ":"
			+ escape(selValue("selOptyn" + editedIds[i])) + ":"
			+ escape(selValue("selOptDefyn" + editedIds[i])) + ":"
			+ escape(selValue("selComm" + editedIds[i])) + ":"
			+ escape(selValue("selFreq" + editedIds[i])) + ":"
			+ selFreqFactValue + ":"
			+ escape(selValue("selSep" + editedIds[i])) + ":"
			+ escape(selValue("selTaxRate" + editedIds[i])) + ":"
			+ escape(selValue("selTaxGroup" + editedIds[i]))
			+ "_";
		}
		break;
	}

	aRequestAbort();
	aRequestPost("reservation.php?405" + "+" + rateID + "+" + mode + "+" + data,processCompAJAX,"","");		
	
}

function selectTaxType(control){
	switch(control.id.substring(6, 10)){
		case "Rate":
			if (control.value != 0){
				id("selTaxGroup"+control.id.substring(10, control.id.length)).value = 0;
			} else {
				//control.style.backgroundColor = "red";
				id("selTaxGroup"+control.id.substring(10, control.id.length)).selectedIndex = 1;
			}
			break;
		case "Grou":
			if (control.value != 0){
				id("selTaxRate"+control.id.substring(11, control.id.length)).value = 0;
			} else {
				//control.style.backgroundColor = "red";
				id("selTaxRate"+control.id.substring(11, control.id.length)).selectedIndex = 1;
			}
			break;
	}	
}

function selectAllComp(){
	var inputs = document.getElementsByTagName("input");
	
	for ( var i = 0; i < inputs.length; i++ ) {
		if ( inputs[i].getAttribute("type") == "checkbox" && inputs[i].id.substring(0,5) == "check" && inputs[i].checked == false) {
			inputs[i].checked = true;
		}
	}
}

function clearAllComp(){
	var inputs = document.getElementsByTagName("input");
	
	for ( var i = 0; i < inputs.length; i++ ) {
		if ( inputs[i].getAttribute("type") == "checkbox" && inputs[i].id.substring(0,5) == "check" && inputs[i].checked == true) {
			inputs[i].checked = false;
		}
	}
}

function delComp(){
	if (id("btnSave").disabled){
		return;
	}
	
	confirmType = "del";
	openConfirm("Are you sure you want to delete this component?");
}

function checkCompExists(){
	var errors = false;

	$("select.newCompSelect").each(function(index1){
		var obj = $(this);
		obj.css("background-color", "#FFFFFF");
		var id=obj.prop("id");
		var thisvalue=obj.prop("selectedIndex");
		$("select.newCompSelect").each(function(index2){
			var check_id = $(this).prop("id");
			if (id != check_id)
			{
				var checkvalue = $(this).prop("selectedIndex");
				if (checkvalue == thisvalue){
					obj.css("background-color", "#FF0000");
					errors = true;
				}
			}
		})
	});
	
	if (errors){
		id("btnSave").disabled = true;
	} else {
		id("btnSave").disabled = false;
	}

}

function setComp(obj, i, compID){
	id("selComp"+i).value = compID;
}

function setSepDefault(obj, i){
	compSepDefs = id("compSepDefaults").value.split(":");
	id("selSep"+i).selectedIndex = compSepDefs[obj.selectedIndex];
}

function setOptDefault(obj, i){
	compOptDefs = id("compOptDefaults").value.split(":");
	id("selOptyn"+i).selectedIndex = compOptDefs[obj.selectedIndex];
}

function setDefDefault(obj, i){
	compDefDefs = id("compDefDefaults").value.split(":");
	id("selOptDefyn"+i).selectedIndex = compDefDefs[obj.selectedIndex];
	if (compDefDefs[obj.selectedIndex] == 1) {
		id("selOptDefyn"+i).disabled = false;
		id("selOptyn"+i).selectedIndex = 1;
	} else {
		id("selOptDefyn"+i).disabled = true;
	}
}

function setCommDefault(obj, i){
	compCommDefs = id("compCommDefaults").value.split(":");
	id("selComm"+i).selectedIndex = compCommDefs[obj.selectedIndex];
}

function setFreqDefault(obj, i){
	compFreqDefs = id("compFreqDefaults").value.split(":");
	id("selFreq"+i).selectedIndex = compFreqDefs[obj.selectedIndex];
}

function setFreqFactDefault(obj, i){
	compFreqFactDefs = id("compFreqFactDefaults").value.split(":");
    var sel = id("selFreqFact"+i);
    var val = compFreqFactDefs[obj.selectedIndex];
    for(var i = 0, j = sel.options.length; i < j; ++i) {
        if(sel.options[i].innerHTML === val) {
           sel.selectedIndex = i;
           break;
        }
    }

}

function setTaxRateDefault(obj, i){
	compTaxRateDefs = id("compTaxRateDefaults").value.split(":");
	id("selTaxRate"+i).value = compTaxRateDefs[obj.selectedIndex];
	if (compTaxRateDefs[obj.selectedIndex] == "") {
		id("selTaxRate"+i)[1].selected = true;
	}
}

function setTaxGroupDefault(obj, i){
	compTaxGroupDefs = id("compTaxGroupDefaults").value.split(":");
	id("selTaxGroup"+i).value = compTaxGroupDefs[obj.selectedIndex];
	if (compTaxGroupDefs[obj.selectedIndex] == "") {
		id("selTaxGroup"+i).value = "0"
		id("selTaxGroup"+i)[0].selected = true;
	} else {
		id("selTaxRate"+i).value = "0";
		id("selTaxRate"+i)[0].selected = true;
	}
}


//TODO: Realtime checking of commission dropdown
function selectCommType(obj) {
	/*
	errors = false;
	
	$("input").each(function(index) {
		if ($(this).prop("id").substring(0, 5) == "cell3") { //check logic there
			ident = $(this).prop("id").substring(5, $(this).prop("id").length);
		}
	});		
	
	$("td").each(function(index) {
		if ($(this).prop("id").substring(0, 5) == "cell3") { //check logic there
		}
	});
	*/
}

function selectFreqType(obj){
	ident = obj.id.substring(7,obj.id.length);
	if (obj.value == "2"){
		id("selFreqFact"+ident).disabled = true;
	} else {
		id("selFreqFact"+ident).disabled = false;
	}
}

function toggleDefOpt(obj){
	ident = obj.id.substring(8,obj.id.length);
	if (obj.value == 1){
		id("selOptDefyn"+ident).disabled = false;
	} else {
		id("selOptDefyn"+ident).value = 0;
		id("selOptDefyn"+ident).disabled = true;
	}

}

function openFilterAddComponents(filter){
	var selectedArrayComps = [];
	$(".newCompSelect").each(function(index, value) { 
	    selectedArrayComps.push( $(this).val() );
	});
	$(".compSelect").each(function(index, value) { 
	    selectedArrayComps.push( $(this).val() );
	});
	var selectedArray = selectedArrayComps.join(":");
	selectedArray = $.grep([selectedArray, $('#savedRateEditComponentsIds').val()], Boolean).join(":");

	url = "reservation.php?661+"
		+ filter
		+ "+"
		+ selectedArray;
	openPopup(url,280,360);
}

function onAfterFilter() {
	if ($('#rateEditComponentsIds').length > 0) {
		var existingCompsArray = [];
		var deleteCompIDsArray = [];

		$(".newCompSelect").each(function(index, value) { 
			existingCompsArray.push( $(this).val() );
		});

		var newCompsArray = $("#rateEditComponentsIds").val().split(":");

		$.each( newCompsArray, function( key, value ) {
			if ($.inArray(value, existingCompsArray) !== -1) {
			  // Already exists, do nothing
			} else {
				addComp(value);
			}
		});
	}
}