function editCompsplit(iID) {
	id("btnCancel").className = "button";
	id("btnSave").className = "button";

	if(id("btnAdd")) {
		id("btnAdd").setAttribute("disabled","disabled");
		id("btnAdd").className = "inLtt";
	}

	id("mode").value = "edit";

	if (iID.substring(0, 4) != "opt_"){
		calcRowTotal(iID);
	}
	validateOnEdit();
}

function editSequence() {
	id("btnCancel").className = "button";
	id("btnSave").className = "button";

	if(id("btnAdd")) {
		id("btnAdd").setAttribute("disabled","disabled");
		id("btnAdd").className = "inLtt";
	}

	id("mode").value = "edit";
}

function markForSaving() {
	id("mode").value = "edit";
}

var comGroupNumberReady = 1;

function pollComm(id) {
	if (comGroupNumberReady == 1) {
		updateCommGroup(id);
	} else {
		setTimeout(pollComm(id), 100);
	}

}


function updateCommGroupSave($inputs) {
	if (id("btnSave").disabled){
		return;
	}

	if (!$inputs.length) {
        saveCompsplitFinal();
        return;
    }

    var $input = $inputs.eq(0);
    var rateGroupID = $input.attr('id').substring(5);

   	var fun_job_id = id("fun_job_id").value;
	var rateID = id("rateID").value;
	var mode = "updateComm";
	var commYN = id("comm_"+rateGroupID).checked?"1":"0";

	var URL = "reservation.php?" + fun_job_id + "+" + rateID + "+" + mode + "+" + rateGroupID + "+" + commYN;

    $.post(URL, {}, function (result) {
    }).always(function () {
        updateCommGroupSave($inputs.slice(1))
    });
}

function updateCommGroupSaveBatch($inputs) {
	if (id("btnSave").disabled){
		return;
	}

	commsData = [];

	$.each($inputs, function( index, value ) {
		var rateGroupID = value.id.substring(5);
		var commYN = id("comm_"+rateGroupID).checked?"1":"0";
		commsData.push({rateGroupID:rateGroupID, commYN:commYN});
	});

   	var fun_job_id = id("fun_job_id").value;
	var rateID = id("rateID").value;
	var mode = "updateCommBatch";
	var URL = "reservation.php?" + fun_job_id + "+" + rateID + "+" + mode + "+" + JSON.stringify(commsData) + "+";

    $.post(URL, {}, function (result) {
    }).always(function () {
        saveCompsplitFinal();
        return;
    });
}

function saveCompsplit() {
	$("#btnSave").css("background-color","#fff");
	$("#btnSave").html("<img src='/resource/Resrequest/Application/public/img/wait16.gif'>");
	updateCommGroupSaveBatch($("#compGroupCommissionableHeadersRow input[type=checkbox]"));
}

function saveCompsplitFinal(){

	if (validateOnSave() == 1){
		return;
	}

	if (id("btnSave").disabled){
		return;
	}
	
	var rateID = id("rateID").value;
	var data = "";
	var mode = id("mode").value;
	var rateCompIDs = id("rateCompIDs").value.split(",");
	var rateOptCompIDs = id("rateOptCompIDs").value.split(",");
	var rateGroupIDs = id("rateGroupIDs").value.split(",");

	for(i=0;i<rateCompIDs.length;i++) {
		data = data + rateCompIDs[i] + ":";
		for (var j=0; j<rateGroupIDs.length; j++) {
			data = data + rateGroupIDs[j] + "|" + escape(id("iamt_" + rateGroupIDs[j] + "_" + rateCompIDs[i]).value) + "|"
			+ escape(id("iperc_" + rateGroupIDs[j] + "_" + rateCompIDs[i]).value) + "|"
			+ escape(id("comm_"+rateGroupIDs[j]).checked?"1":"0") + "|"
			+ escape(id("seq_"+rateGroupIDs[j]).value) + ":"
		}
		data = data + "_";
	}
	
	for(i=0;i<rateOptCompIDs.length;i++) {
		if (rateOptCompIDs[i] != ""){
			data = data + rateOptCompIDs[i] + ":";
			for (var j=0; j<rateGroupIDs.length; j++) {	
				data = data + rateGroupIDs[j] + "|" + escape(id("opt_iamt_" + rateGroupIDs[j] + "_" + rateOptCompIDs[i]).value) + "|"
				+ escape(id("opt_iperc_" + rateGroupIDs[j] + "_" + rateOptCompIDs[i]).value) + "|"
				+ escape(id("comm_"+rateGroupIDs[j]).checked?"1":"0") + "|"
				+ escape(id("seq_"+rateGroupIDs[j]).value) + ":"
			}
			data = data + "_";
		}
	}	

	aRequestAbort();
	aRequestPost("reservation.php?406" + "+" + rateID + "+" + mode + "+" + data,processCompSplitAJAX,"","");
}

function addGroup(){
	if (id("btnSave").disabled){
		return;
	}
	
	var fun_job_id = id("fun_job_id").value;
	var rateID = id("rateID").value;
	var mode = "add";
	
	data = id("unusedRateGroups").value;
	
	aRequestAbort();
	aRequestPost("reservation.php?" + fun_job_id + "+" + rateID + "+" + mode + "+" + data,processAJAX,"","");
}

function delGroup(rateGroupID){
	if (id("btnSave").disabled){
		return;
	}
	
	var fun_job_id = id("fun_job_id").value;
	var rateID = id("rateID").value;
	var mode = "delete";
	
	data = rateGroupID;

	aRequestAbort();
	aRequestPost("reservation.php?" + fun_job_id + "+" + rateID + "+" + mode + "+" + data,processAJAX,"","");
}

function nextCommGroup() {
	comGroupNumberReady = 1;
}

function updateCommGroup(rateGroupID){
	if (id("btnSave").disabled){
		return;
	}

	comGroupNumberReady = 0;
	
	var fun_job_id = id("fun_job_id").value;
	var rateID = id("rateID").value;
	var mode = "updateComm";
	var commYN = id("comm_"+rateGroupID).checked?"1":"0";
	data = rateGroupID;

	aRequestAbort();
	aRequestPost("reservation.php?" + fun_job_id + "+" + rateID + "+" + mode + "+" + data + "+" + commYN,nextCommGroup,"","");
}

function calcRowTotal(iID){
	var vars = iID.split("_");
	var totalAmt = 0;
	var totalPerc = 0;
	var rateCompIDs = id("rateCompIDs").value.split(",");

	for (var i=0; i<rateCompIDs.length; i++) {	
		totalAmt = totalAmt + parseFloat(id("iamt_" + vars[1] + "_" + rateCompIDs[i]).value);
		totalPerc = totalPerc + parseFloat(id("iperc_" + vars[1] + "_" + rateCompIDs[i]).value);
	}
	
	if (isNaN(totalAmt)){
		id("totalAmt_"+ vars[1]).value = "0.00";
	} else {
		id("totalAmt_"+ vars[1]).value = totalAmt.toFixed(2);
	}

	if (isNaN(totalPerc)){
		id("totalPerc_"+ vars[1]).value = "0.00";
	} else {
		id("totalPerc_"+ vars[1]).value = totalPerc.toFixed(2);
	}	
	
}

// Realtime validation
function validateOnEdit(){
	errors = false;
	$('#rtSectionContainerCompSplits input').each(function(index) {
		
		if ($(this).prop("id").substring(0, 4) == "iamt"){
			ident = $(this).prop("id").substring(4, $(this).prop("id").length);
			amtvalue = $(this).val();
			percvalue = $("#iperc"+ident).val();
			if (amtvalue > 0 && percvalue > 0){
				$(this).css("background-color","red");
				$("#iperc"+ident).css("background-color","red");
				errors = true;
			} else {
				$(this).css("background-color","");
				$("#iperc"+ident).css("background-color","");
			}
		}

		if ($(this).prop("id").substring(0, 9) == "totalPerc"){
			ident = $(this).prop("id").substring(9, $(this).prop("id").length);
			totalpercvalue = $(this).val();
			if (totalpercvalue > 100 || (totalpercvalue < 100 && totalpercvalue > 0)){
				$(this).css("background-color","red");
				errors = true;
			} else {
				$(this).css("background-color","");
			}
		}

	});

	if (errors){
		id("btnSave").disabled = true;
	} else {
		id("btnSave").disabled = false;
	}	
}

// On-save Validation
function validateOnSave(){
	var errors = false;
	var rateGroupIDs = id("rateGroupIDs").value.split(",");
	

	if (id("orideEnabled").value == 1){
	
		for (var j=0; j<rateGroupIDs.length; j++) {
			if (id("totalAmt_"+rateGroupIDs[j]).value != 0 && id("totalPerc_"+rateGroupIDs[j]).value != 100){
				errors = true;
			}
		}
	}

	if (errors){
		openMessage("One or more of the Rate Groups do not have a percentage-based component split. This is required for a rate override to be calculated correctly.");
		return 1;
	} else {
		return 0;
	}		
}

