var enabledFunctions = new Array ("Back","Forward","Refresh","Print","Calendar","Internet","Home","Help","NewWindow");
var enabledButtons = new Array("Back","Forward","Refresh","Print","Calendar","Internet","Home","Help","NewWindow");

function initialisePage(){
	dateSelector();
	initTop();
	enableButtons(enabledButtons);

	populateDateFields("fromYear", fromY, "fromMonth", fromM, "fromDay", fromD);
	populateDateFields("toYear", toY, "toMonth", toM, "toDay", toD);

	id("allocationNumber").value = allocationNumber;
}

function processForm(){
	url = buildURL(0,0);
	if(url) {
		id("urlForm").target = "_self";		
		id("url").value = url;
		id("urlForm").submit();
	} else {
		return false;
	}
}

function buildURL(renderOption) {
	renderOption &= 7;

	if ( renderOption == 0 ) {
		var filterStatus = "";
	} else {
		var filterStatus = id('filters').className;
	}

	var showHideButtonText = id('filterBut').value;

	if ( !buildDate("from") || !buildDate("to") ) {
		return false;
	}

	fromDate = buildDate("from");
	toDate = buildDate("to");	

	if ( fromDate > toDate ) {
		id("toDay").focus();
		openMessage("Please enter a To date that is greater than or equal to the From date","a",120);
		return false;
	}

	var jobId = id("jobId").value;

	_urlCount++;

	var url = new Array("reservation.php?" + jobId,
											fromDate,									// 1
											toDate,										// 2
											id("agentIds").value,						// 3
											id("propertiesIds").value,					// 4
											id("accommIds").value,						// 5
											id("consultantIds").value,					// 6
											renderOption,								// 7
											filterStatus,								// 8
											showHideButtonText,							// 9
											id("allocationNumber").value,				// 10
											id("includeExpiredAllocations").checked,	// 11
											id("orderBy").value,						// 12
											_randomId + "_" + _urlCount.toString()		// 13
										);
	return url.join("+");
}

function generateReport(renderOption,sortOption) {
	var url = buildURL(renderOption,sortOption);
	
	if ( url ) {
		id("urlForm").target = "";
		id("url").value = url
		id("urlForm").submit();
	}
}

function buildDate(prefix) {
	dayValue = id(prefix+"Day").options[id(prefix+"Day").selectedIndex].value;
	monthValue = id(prefix+"Month").options[id(prefix+"Month").selectedIndex].value;

	dayValue = dayValue<10?"0"+dayValue:dayValue;
	monthValue = monthValue<10?"0"+monthValue:monthValue;
	 
	resultDate = id(prefix+"Year").value+"-"+monthValue+"-"+dayValue;
      
	if(dayValue < 1) { 
		id(prefix+"Day").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(monthValue < 1) {
		id(prefix+"Month").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(id(prefix+"Year").value == "") {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;		 
	 }		 
	if(id(prefix+"Year").value.search(/^\d{4}$/) == -1) {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}

	return resultDate;
}

function showHideFilters(){
  var filters 		= id("filters");
  var filterBut 	= id("filterBut");
	
	mnuInitialise = false;
	
  if ( filters.className == "collapse printCollapse" ) {
    filters.className = "expand";
    filterBut.value 	= "<< Hide Filters";
  } else {
    filters.className = "collapse printCollapse";
    filterBut.value 	= ">> Show Filters";
  }
}

function setPage(num) {
	id("currentPage").value = parseInt(id("currentPage").value,10) + num;
	processForm();
}

function gotoPage(num) {
	id("currentPage").value = num.toString();
	processForm();
}

function openPDF(){
	url = buildURL(1);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading PDF...",640,480,0,0,0,1,"pdfWin","opener.id('urlForm').submit();");
	}
}

function sendPDF(){
	url = buildURL(2);
	if(url) {  
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Loading email popup...",775,615,0,0,0,0,"pdfWin","opener.id('urlForm').submit();");
	}
}

function openCSV() {
	var url = buildURL(4);
	if(url) { 
		id("urlForm").target = "_self";		
		id("url").value = url;
		id("urlForm").submit();
  }
} 

function printReport(){
   window.print();
}

function showHide(above) {
	if(id("showHideForm").style.display == "none") {
		screenW = parseInt(document.body.clientWidth,10);
		screenH = parseInt(document.body.clientHeight,10);
		
		id("showHideForm").style.display = "";
		
		clickX = event.x+window.document.body.scrollLeft;
		clickY = event.y+window.document.body.scrollTop;
		
		newX = clickX - id("showHideForm").offsetWidth;
		newY = clickY+4;
		
		if(event.y > (screenH / 2)) {
			newY = clickY - id("showHideForm").offsetHeight-4;			
		}
		
		id("showHideForm").style.left = newX;
		id("showHideForm").style.top = newY;
		id("toDay").style.visibility = "hidden";
		id("toMonth").style.visibility = "hidden";		
	} else {
		id("showHideForm").style.display = "none";
		id("toDay").style.visibility = "";
		id("toMonth").style.visibility = "";
	}
}

function setOrder(i,o) {
	id("orderBy").value = i + ":" + o;
	processForm();
}

function mouseOverRes(obj) {
	var rows = obj.parentNode.rows;
	var res_id = obj.rv_reservation_ix;
	for ( count = 0; count < rows.length; count++ ) {
		if ( rows[count].rv_reservation_ix == res_id ) {
			rows[count].style.backgroundColor = '#ccffcc';
		}
	}
}

function mouseOutRes(obj) {
	var rows = obj.parentNode.rows;
	var res_id = obj.rv_reservation_ix;

	for ( count = 0; count < rows.length; count++ ) {
		if ( rows[count].rv_reservation_ix == res_id ) {
			rows[count].style.backgroundColor = "";
		}
	}
}

function dayChange() {
	setDayList(id("fromDay"),id("fromMonth").options[id("fromMonth").selectedIndex].value,id("fromYear").value);
	setDayList(id("toDay"),id("toMonth").options[id("toMonth").selectedIndex].value,id("toYear").value);
}

/////////////////////////////////////////////////////////////
// Sets a day dropdown depending on the month/year combo   //
/////////////////////////////////////////////////////////////
function setDayList(dayObject,month,year) {
	daysTmp = getMonthDays(month,year);

  day = dayObject.selectedIndex;  
	dayObject.options.length = 0;
  dayObject.options[0] = new Option("",0);

	for ( i = 1; i < daysTmp + 1; i++ ) {
		dayObject.options[i] = new Option((i<10?"0"+i.toString():i),i);
	}
  if ( day > daysTmp ) {
		day = daysTmp;
	}
  dayObject.selectedIndex = day;
}
