function itinScroll() {
	id("roomRowDiv").scrollTop = id("itinrows").scrollTop;
	id("colRows").scrollLeft = id("itinrows").scrollLeft;
}

function colScroll() {
	id("itinrows").scrollLeft = id("colRows").scrollLeft;
}

// Report: Rooming ------------------------------------------------------------
function initialisePage(){
	dateSelector();
	initTop();
	enableButtons(enabledButtons);

	// get print info ------------------------------------------------------------
	id("user").innerHTML = FirstName + " " + LastName;
	id("server").innerHTML = Domain;
	id("genDate").innerHTML = genDateVal;

	dateTypeChange();
   
	if ( reportType != "" ) {
		if ( reportType == "summary" ) {
			var buttonList = ["repRoomingCalendar","repPaxSumm","resChart","repRoomSumm","res","summExtras","roomList","resNote","agent","rateType","nation","guest","guestNote","internal","guestMemo","extra","extraService","extraReference","extraNote","extraInt","travel","travelNote","travelInt"];
		} else if ( reportType == "daySheet" ) {
			var buttonList = ["repRoomingCalendar","repPax","resSum","repRoom","repRequests","repExtDet","res","roomList","resNote","agent","rateType","nation","guest","guestNote","internal","guestMemo","extra","extraService","extraReference","extraNote","extraInt","travel","travelNote","travelInt"];
		}

		var buttonCurrent = 8;

		for ( count = 0; count < buttonList.length; count++ ) {
			areaSet = document.getElementsByName(buttonList[count]+"Area");

			if ( id(buttonList[count]+"Check").checked == true ) {
				for ( count2 = 0; count2 < areaSet.length; count2++ ) {
					areaSet[count2].className = "expand";
				}
			} else {
				for ( count2 = 0; count2 < areaSet.length; count2++ ) {
					areaSet[count2].className = "collapse printCollapse";
				}
			}
			buttonCurrent *= 2;
		}

		id("showHideForm").style.display = "none";

		/* Extra notes and Travel notes to show by default ------------------------
		if ( noExtraNotes == "collapse printCollapse" ) {
			id("extraCheck").checked = false;
			checkToggle('extra');
		}

		if ( noTravelNotes == "collapse printCollapse" ) {
			id("travelCheck").checked = false;
			checkToggle('trav');
		}
		-------------------------------------------------------------------------- */
	}

	// Rooming -------------------------------------------------------------------
	id("colRows").style.overflowX = "scroll";
	id("colRows").style.width = "672px";
	id("colRows").onscroll = colScroll;

	id("itinrows").onscroll = itinScroll;
}

function toggleOptions() {
	if ( id("advancedForm").className == "collapse printCollapse" ) {
		id("advancedForm").className = "colLt";		
		id("advancedTag").value = ">>  More";
	} else {
		id("advancedForm").className = "collapse printCollapse";
		id("advancedTag").value = "<<  More";
	}
}

function showHideFilters() {
	var filters 		= id("filters");
	var filterBut 	= id("filterBut");

	mnuInitialise = false;

	if ( filters.className == "collapse printCollapse" ) {
		filters.className = "expand";
		filterBut.value 	= "<< Hide Filters";
	} else {
		filters.className = "collapse printCollapse";
		filterBut.value 	= ">> Show Filters";
	}
}

function toggle(section) {
	switch(section) {
		case "ShowHide":
			if ( id("showHideForm").style.display == "none" ) {
				id("showHideForm").style.display = "";
				id("showHideForm").style.top	= (windowHeight()-id("showHideForm").offsetHeight)/2 + document.body.scrollTop + "px";
				id("showHideForm").style.left = (windowWidth()-400)/2 + "px";
			}				
			break;

		case "resGuest":
			var roomArray = [];

			// This is the prefix for the guest names eg id=arrRS1 ---------------------
			var prefix = ["arr","stay","dep"];

			// This is the prefix for the res details eg id=rArrRS1 --------------------
			var rPrefix = new ["rArr","rStay","rDep"];

			roomArray = roomIds.split(",");

			if ( id("guestTog").checked === true ) {
				for ( rid = 0; rid < roomArray.length - 1; rid++ ) {
					for ( p = 0; p < prefix.length; p++ ) {
						id(prefix[p]+roomArray[rid]).style.display = "inline";
						id(rPrefix[p]+roomArray[rid]).style.display = "none";
					}
				}
			} else {
				for ( rid = 0; rid < roomArray.length - 1; rid++ ) {
					for ( p = 0; p < prefix.length; p++ ) {
						id(prefix[p]+roomArray[rid]).style.display = "none";
						id(rPrefix[p]+roomArray[rid]).style.display = "inline";
					}
				}
			}
			break;

		default:
			if ( id(section).className.toString().match(/collapse printCollapse/) ) {
				id(section).className = "expand printExpand";
			} else {
				id(section).className = "collapse printCollapse";
			}
			break;
	}
}

function selClrAll(action){
	var checkBoxes = document.getElementsByName("showHideInput");
	var expandList = ["resNotes","extraNotes","travNotes"];

	if ( action == "select" ) {
		for ( i = 0; i < checkBoxes.length; i++ ) {
			if ( checkBoxes[i].type == "checkbox" ) {
				checkBoxes[i].checked = true;
			}
		}

		for ( count = 0; count < expandList.length; count++ ) {
			if ( id(expandList[count] + "Toggle").className == "collapse printCollapse" ) {
				id(expandList[count] + "Toggle").className = "expand";
			}
		}
	} else {
		for ( i = 0; i < checkBoxes.length; i++ ) {
			if ( checkBoxes[i].type == "checkbox" ) {
				checkBoxes[i].checked = false;
			}
		}

		for ( count = 0; count < expandList.length; count++ ) {
			if ( id(expandList[count] + "Toggle").className == "expand" ) {
				id(expandList[count] + "Toggle").className = "collapse printCollapse";
			}
		}
	}
}

function hideShowHide() {
	id("showHideForm").style.display = "none";
}

function applyShowHide() { 
	if ( reportType == "summary" ) {
		var buttonList = ["repRoomingCalendar","repPaxSumm","resChart","repRoomSumm","summExtras","res","roomList","resNote","agent","rateType","nation","guest","guestNote","internal","guestMemo","extra","extraService","extraReference","extraNote","extraInt","travel","travelService","travelReference","travelNote","travelInt"];
	} else if ( reportType == "daySheet" ) {
		var buttonList = ["repRoomingCalendar","repPax","resSum","repRoom","repRequests","repExtDet","res","roomList","resNote","agent","rateType","nation","guest","guestNote","internal","guestMemo","extra","extraService","extraReference","extraNote","extraInt","travel","travelService","travelReference","travelNote","travelInt"];
		var hideList = ["repPax","resSum","repRoom","repRequests","repExtDet"];

		dayHeadSet = document.getElementsByName("dayHeadArea");
		hideClass = 0;

		for ( count = 0; count < hideList.length; count++ ) {
			if ( id(hideList[count] + "Check").checked ) {
				hideClass ++;
			}
		}

		if ( hideClass == 0 ) {
			for ( count2 = 0; count2 < dayHeadSet.length; count2++ ) {
				dayHeadSet[count2].className = "collapse printCollapse";
			}
		} else {
			for ( count2 = 0; count2 < dayHeadSet.length; count2++ ) {
				dayHeadSet[count2].className = "";
			}
		}
	}

	for ( count = 0; count < buttonList.length; count++ ) { 
		if ( buttonList[count] != "" ) {
			areaSet = document.getElementsByName(buttonList[count] + "Area");
						
			for ( count2 = 0; count2 < areaSet.length; count2++ ) {
				if ( id(buttonList[count] + "Check").checked ) {
					areaSet[count2].className = "expand";
				} else {					
					areaSet[count2].className = "collapse printCollapse";
				}
			}
		}
	}
	hideShowHide();
}

function buildDate(prefix) {
	dayValue		= id(prefix+"Day").options[id(prefix + "Day").selectedIndex].value;
	monthValue	= id(prefix+"Month").options[id(prefix + "Month").selectedIndex].value;

	dayValue		= dayValue < 10 ? "0" + dayValue : dayValue;
	monthValue	= monthValue < 10 ? "0" + monthValue : monthValue;

	resultDate = id(prefix + "Year").value + "-" + monthValue + "-" + dayValue;

	if ( dayValue < 1 ) {
		id(prefix + "Day").focus();
		openMessage("Please enter a valid " + prefix + " date","a",100);
		return;
	}

	if ( monthValue < 1 ) {
		id(prefix + "Month").focus();
		openMessage("Please enter a valid " + prefix + " date","a",100);
		return;
	}

	if ( id(prefix+"Year").value === "" ) {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid " + prefix + " date","a",100);
		return;		 
	}

	if ( id(prefix+"Year").value.search(/^\d{4}$/) == -1 || id(prefix+"Year").value < 1970 ) {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid " + prefix + " date","a",100);
		return;
	}

	return resultDate;
}

function buildButtonOption(reportType) {
	var buttonList;
	var buttonOption = 0;
	var buttonCurrentValue = 8;

	if ( reportType == "summary" ) {
		buttonList = ["repRoomingCalendar","repPaxSumm","resChart","repRoomSumm","summExtras","","res","roomList","resNote","agent","nation","guest","guestNote","internal","guestMemo","extra","extraNote","extraInt","travel","travelNote","travelInt","rateType","extraService","extraReference","travelService","travelReference"];
	} else if ( reportType == "daySheet" ) {
		buttonList = ["repRoomingCalendar","repPax","resSum","repRoom","repRequests","repExtDet","res","roomList","resNote","agent","nation","guest","guestNote","internal","guestMemo","extra","extraNote","extraInt","travel","travelNote","travelInt","rateType","extraService","extraReference","travelService","travelReference"];
	}

	for ( count = 0; count < buttonList.length; count++ ) {
		if ( id(buttonList[count]+"Check") ) {
			checkTest = id(buttonList[count]+"Check").checked;
		} else {
			buttonCurrentValue *= 2;
			continue;
		}
		if ( checkTest ) {
			buttonOption += buttonCurrentValue;
		}
		buttonCurrentValue *= 2;
	}
	return buttonOption;
}

function buildURL(renderOption,type) {
	var filterStatus;
	var showHideButtonText = id("filterBut").value;

	if ( renderOption === 0 ) {
		filterStatus = "";
	} else {
		filterStatus = id("filters").className;
	}

	renderOption &= 7;
	renderOption += buildButtonOption(type);

	_urlCount++;

	if ( id("checkByDate").checked ) {
		if ( !buildDate("by") ) {
			return false;
		}
	} else {
		if ( !buildDate("from") || !buildDate("to") ) {
			return false;
		}
	}

	if ( id("checkByDate").checked ) {
		fromDate	= buildDate("by");
		toDate		= buildDate("by");
	} else {
		fromDate	= buildDate("from");
		toDate		= buildDate("to");
	}

	if ( fromDate > toDate ) {
		openMessage("Please enter a To date that is greater than or equal to the From date","a",120);
		return false;
	}

	url = ["reservation.php?742",
		fromDate,																// 1
		toDate,																	// 2
		id("propertyId").value,									// 3
    filterStatus,														// 4
    type,																		// 5
		renderOption,														// 6
		_randomId + "_" + _urlCount.toString(),	// 7
		showHideButtonText											// 8
	];
	return url.join("+");
}

function generateReport(renderOption,type) {
	url = buildURL(renderOption,type);
	if ( url ) {
		id("urlForm").target	= "_self";		
		id("url").value				= url;
		id("urlForm").submit();
	}
}

function dateTypeChange() {
	if ( id("checkByDate").checked ) {
		id("select_by_day").style.visibility		= "";
		id("select_by_date_range").style.visibility	= "hidden";
		
		id("byDay").style.visibility				= "";
		id("byMonth").style.visibility				= "";
		id("byYear").style.visibility				= "";
		id("fromDay").style.visibility				= "hidden";
		id("fromMonth").style.visibility			= "hidden";
		id("fromYear").style.visibility				= "hidden";
		//id("fromDateLabel").style.visibility		= "hidden";
		id("toDay").style.visibility				= "hidden";
		id("toMonth").style.visibility				= "hidden";
		id("toYear").style.visibility				= "hidden";
		//id("toDateLabel").style.visibility		= "hidden";

		populateDateFields("byYear", _fromYear, "byMonth", _fromMonth, "byDay", _fromDay);
	} else {
		id("select_by_date_range").style.visibility	= "";
		id("select_by_day").style.visibility		= "hidden";
		
		id("byDay").style.visibility				= "hidden";
		id("byMonth").style.visibility				= "hidden";
		id("byYear").style.visibility				= "hidden";
		id("fromDay").style.visibility				= "";
		id("fromMonth").style.visibility			= "";
		id("fromYear").style.visibility				= "";
		id("toDay").style.visibility				= "";
		id("toMonth").style.visibility				= "";
		id("toYear").style.visibility				= "";

		populateDateFields("fromYear", _fromYear, "fromMonth", _fromMonth, "fromDay", _fromDay);
		populateDateFields("toYear", _toYear, "toMonth", _toMonth, "toDay", _toDay);
	}
}

function select_daymonth_changed() {
	setDayList(id("fromDay"),id("fromMonth").options[id("fromMonth").selectedIndex].value,id("fromYear").value);
	setDayList(id("toDay"),id("toMonth").options[id("toMonth").selectedIndex].value,id("toYear").value);
	setDayList(id("byDay"),id("byMonth").options[id("byMonth").selectedIndex].value,id("byYear").value);
}

function openPDF() {
	var url = buildURL(1,reportType);
	if ( url ) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading PDF...",640,480,0,0,0,1,"pdfWin","opener.id('urlForm').submit();");
	}
}

function sendPDF() {
	var url = buildURL(2,reportType);
	if ( url ) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin = openPopup("/resource/Resrequest/Application/public/html/wait.htm?Loading email popup...", 775,615,0,0,0,0,"pdfWin","opener.id('urlForm').submit();");
	}
}

function openCSV() {
	var url = buildURL(4,reportType);
	if(url) { 
		id("urlForm").target = "_self";
		id("url").value = url;
		id("urlForm").submit();
	}
}

function printReport() {
	window.print();
}

function checkToggle(section) {
	if ( window.id(section+"NotesToggle").className != "collapse printCollapse" ) {
		window.id(section+"NotesToggle").className = "collapse printCollapse";
	} else {
		window.id(section+"NotesToggle").className = 'expand';
	}
}

function resGuestToggle() {
	var resList = document.getElementsByName("resName");
	alert(resList.className);  
}

var fullSize = false;

function resizeGrid() {
	var itinrows = id("itinrows");

	if ( fullSize ) {
		itinrows.style.width	= "687px";
		itinrows.style.height	= "264px";

		id("itinCol").style.width			= "687px";
		id("roomRowDiv").style.height	= parseInt(itinrows.style.height.toString(),10) - 17;

		id("colRows").style.width			= parseInt(itinrows.style.width,10) - 15;
		id("colRows").style.overflowX	= "scroll";

		document.body.style.overflowY	= "scroll";
		id("sizeButton").className		= "button bMax";
		fullSize = false;
	} else {
		document.body.style.overflowY	= "hidden";
		id("itinrows").style.width		= document.body.clientWidth - parseInt(id("roomRowDiv").offsetWidth,10);
		id("itinCol").style.width			= document.body.clientWidth - parseInt(id("roomRowDiv").offsetWidth,10);
		id("itinrows").style.height		= document.body.clientHeight - parseInt(id("colRows").offsetHeight,10);
		id("roomRowDiv").style.height	= document.body.clientHeight - parseInt(id("colRows").offsetHeight,10);
		id("colRows").style.width			= parseInt(id("itinrows").style.width,10) - 15;
		document.body.scrollTop				= id("dataTable").offsetTop;
		id("sizeButton").className		= "button bMin";
		fullSize = true;
	}
}