function initialisePage(){
	dateSelector();
	initTop();
	enableButtons(enabledButtons);

	id("user").innerHTML = FirstName + " " + LastName;
	id("server").innerHTML = Domain;
	id("genDate").innerHTML = genDateVal;

	id("fromMonth").selectedIndex = fromM;
	id("toMonth").selectedIndex = toM;

	checkShow(id("rateOverrideCheck"),"rateOverrideTable");
	checkShow(id("amountOverrideCheck"),"amountOverrideTable");
}

function checkDate(prefix) {
	if(selValue(prefix + "Month") == "mm") {
		id(prefix+"Month").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;		 
	}

	if ( id(prefix+"Year").value == "" ) {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;		 
	}		 

	if ( id(prefix+"Year").value.search(/^\d{4}$/) == -1 ) {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}

	return true;
}

function buildURL(renderOption) {
	var testFromDate;
	var testToDate;
	var testFromMonth;
	var testToMonth;

	if(!checkDate("from") || !checkDate("to")) {
		return false;
	}

	testFromMonth = selValue("fromMonth");
	
	if(testFromMonth.length == 1) { testFromMonth = "0" + testFromMonth; }
	
	testToMonth = selValue("toMonth");
	
	if(testToMonth.length == 1) { testToMonth = "0" + testToMonth; }
	
	testFromDate = id("fromYear").value + "-" + testFromMonth + "-01";
	testToDate = id("toYear").value + "-" + testToMonth + "-01";

	if(testToDate < testFromDate) {
    id("toMonth").focus();
		openMessage("Please enter a To date that is greater than or equal to the From date","a",120);
		return false;
	}

	
	if(renderOption == 0) {
		var filterStatus = "";
	} else {
		var filterStatus = id('filters').className;
	}
		
	var showHideButtonText = id('filterBut').value;

	renderOption &= 7;
	_urlCount++;

	var rateOverride = "0";
	if(id("rateOverrideCheck").checked) {
		rateOverride = "1";
	}
	if(id("rateOverrideExcludeRes").checked) {
		rateOverride += ":excludeRes";
	}
	if(id("rateOverrideIncludeRes").checked) {
		rateOverride += ":includeRes";
	}
	if(id("rateOverrideExcludeItem").checked) {
		rateOverride += ":excludeItem";
	}
	if(id("rateOverrideIncludeItem").checked) {
		rateOverride += ":includeItem";
	}
	if(id("rateOverrideAgentGranted").checked) {
		rateOverride += ":1";
	} else {
		rateOverride += ":0";
	}
	if(id("rateOverrideAgentDenied").checked) {
		rateOverride += ":1";
	} else {
		rateOverride += ":0";
	}

	var amountOverride = "0";
	if(id("amountOverrideCheck").checked) {
		amountOverride = "1";
	}
	if(id("amountOverrideExcludeRes").checked) {
		amountOverride += ":excludeRes";
	}
	if(id("amountOverrideIncludeRes").checked) {
		amountOverride += ":includeRes";
	}
	if(id("amountOverrideExcludeItem").checked) {
		amountOverride += ":excludeItem";
	}
	if(id("amountOverrideIncludeItem").checked) {
		amountOverride += ":includeItem";
	}

	var showRevenueOption = 0;
	if(id("showRevenue").checked) { showRevenueOption = 1; }

	var showRoomConfig = 0;
	if(id("showRoomConfig").checked) { showRoomConfig = 1; }

	var excludeExpired = 0;
	if(id("excludeExpired").checked) { excludeExpired = 1; }

	var url = [
		/*  0 */ "reservation.php?246",
		/*  1 */ id("fromYear").value + "-" + selValue("fromMonth"),
		/*  2 */ id("toYear").value + "-" + selValue("toMonth"),
		/*  3 */ "", //id("propertiesIds").value,
		/*  4 */ id("accommIds").value,
		/*  5 */ (id("agentNameRadio").checked?"name":"country"),
		/*  6 */ id("agentIds").value,
		/*  7 */ id("agentCountryIds").value,
		/*  8 */ id("statusAllocIds").value,
		/*  9 */ id("consultantIds").value,
		/* 10 */ id("originatorIds").value,
		/* 11 */ id("sourceIds").value,
		/* 12 */ id("nationalityIds").value,
		/* 13 */ id("rateIds").value,
		/* 14 */ rateOverride,
		/* 15 */ amountOverride,
		/* 16 */ showRevenueOption,
		/* 17 */ showRoomConfig,
		/* 18 */ selValue("groupBy"),
		/* 19 */ sortBy,
		/* 20 */ renderOption,
		/* 21 */ _randomId + "_" + _urlCount.toString(),
		/* 22 */ filterStatus,
		/* 23 */ showHideButtonText,
		/* 24 */ excludeExpired
	];
	return url.join("+");
}

function generateReport(renderOption) {
	url = buildURL(renderOption);
	if(url) {
		id("urlForm").target = "_self";		
		id("urlForm").action = "";
		id("url").value = url;
		id("urlForm").submit();
	}
}

function openPDF() {
	url = buildURL(1);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		id("urlForm").action = "";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading PDF...",640,480,0,0,0,1,"pdfWin","opener.id('urlForm').submit();");
	}
}

function sendPDF() {
	url = buildURL(2);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		id("urlForm").action = "";
		pdfWin = openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading PDF...",775,615,0,0,0,1,"pdfWin","opener.id('urlForm').submit();");
	}
}

function openDetailPopup(urlArgs) {
	url = "reservation.php?247+" + urlArgs;
	if(url) {
		id("url").value = url;
		id("urlForm").action = "reservation.php?247";
		id("urlForm").target = "detailWin";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading details...",660,400,0,0,0,1,"detailWin","opener.id('urlForm').submit();");
	}	
}


function newSort(num) {
	sortBy = num;
	generateReport(0);
}

function dataScroll(div) {
	var currX;

	currX = id(div).scrollLeft;

	if(div != "mainScrollDiv") { id("mainScrollDiv").scrollLeft = currX; }
	if(div != "headerScrollDiv") { id("headerScrollDiv").scrollLeft = currX; }
	if(div != "revenueScrollDiv") { id("revenueScrollDiv").scrollLeft = currX; }
}

function showHideFilters(){
  var filters 		= id("filters");
  var filterBut 	= id("filterBut");
	
	mnuInitialise = false;
	
  if ( filters.className == "collapse printCollapse" ) {
    filters.className = "expand";
    filterBut.value 	= "<< Hide Filters";
  } else {
    filters.className = "collapse printCollapse";
    filterBut.value 	= ">> Show Filters";
  }
}

function rowOn(rowNum) {
	id("groupRow"+rowNum.toString()).style.backgroundColor = '#CCFFCC';
}

function rowOff(rowNum) {
	id("groupRow"+rowNum.toString()).style.backgroundColor = '';
}

function colOn(colNum) {
	id("groupCol"+colNum.toString()).style.backgroundColor = '#CCFFCC';
	id("revenueCol"+colNum.toString()).style.backgroundColor = '#CCFFCC';
}

function colOff(colNum) {
	id("groupCol"+colNum.toString()).style.backgroundColor = '';
	id("revenueCol"+colNum.toString()).style.backgroundColor = '';
}

function showTotalRoomNightsOverlib() {
	overlib("<span class='txtb'><span class='txtu txtb'>Formula:</span> All active rooms &times; number of days in the month</span><br><br><span class='txts'>A room is excluded in any results for a period prior to the creation of the room (e.g. if a new room is added in Jan 2005 it does not affect the potential bednight calculations for Dec 2004)<br>Note: prior to June 2005 the room creation date has not been stored this means that rooms on file prior to June 2005 will carry a creation date of 0 and will thus qualify for inclusion in reports for all periods<br>A room night or block is discounted if either the accommodation type or the room itself is inactive on that day/night<br>A room becomes available on its date of creation<br>A room becomes unavailable on the date that it, or its parent accommodation type, becomes inactive<br>A room becomes unavailable on the day that a block starts<br>A room becomes available ON the day that the block ends</span>",WIDTH,500);
}

function showBlockedRoomNightsOverlib() {
	overlib("<span class='txtb'><span class='txtu txtb'>Formula:</span> Number of active blocked rooms &times; blocked nights</span><br><br><span class='txts'>A room is excluded in any results for a period prior to the creation of the room (e.g. if a new room is added in Jan 2005 it does not affect the potential bednight calculations for Dec 2004)<br>Note: prior to June 2005 the room creation date has not been stored this means that rooms on file prior to June 2005 will carry a creation date of 0 and will thus qualify for inclusion in reports for all periods<br>A room night or block is discounted if either the accommodation type or the room itself is inactive on that day/night<br>A room becomes available on its date of creation<br>A room becomes unavailable on the date that it, or its parent accommodation type, becomes inactive<br>A room becomes unavailable on the day that a block starts<br>A room becomes available ON the day that the block ends</span>",WIDTH,500);
}

function showPotentialBedNightsOverlib() {
	overlib("<span class='txtb'><span class='txtu txtb'>Formula:</span> (Total room nights &minus; Blocked room nights) &times; room capacity</span>",WIDTH,380);
}

function showPercentOccupancyOverlib() {
	overlib("<span class='txtb'><span class='txtu txtb'>Formula:</span> Total occupied &divide; Potential bed nights &times; 100</span>",WIDTH,290);
}

function openPropFilter() {
	var accomm = id("accommIds").value;
	openPopup("reservation.php?293+"+accomm,556,407);
}

function checkShow(checkbox,obj) {
	if(checkbox.checked) {
		id(obj).style.display = "";
	} else {
		id(obj).style.display = "none";
	}
}
