function initialisePage() {
    dateSelector();
    initTop();
    enableButtons(enabledButtons);

    populateDateFields("eventFromYear", _eventFromY, "eventFromMonth", _eventFromM, "eventFromDay", _eventFromD);
    populateDateFields("eventToYear", _eventToY, "eventToMonth", _eventToM, "eventToDay", _eventToD);
    populateDateFields("birthToYear", _birthToY, "birthToMonth", _birthToM, "birthToDay", _birthToD);
    populateDateFields("birthFromYear", _birthFromY, "birthFromMonth", _birthFromM, "birthFromDay", _birthFromD);
    populateDateFields("travelToYear", _travelToY, "travelToMonth", _travelToM, "travelToDay", _travelToD);
    populateDateFields("travelFromYear", _travelFromY, "travelFromMonth", _travelFromM, "travelFromDay", _travelFromD);
    populateDateFields("annToYear", _annToY, "annToMonth", _annToM, "annToDay", _annToD);
    populateDateFields("annFromYear", _annFromY, "annFromMonth", _annFromM, "annFromDay", _annFromD);
    populateDateFields("contactCreatedToYear", _contactCreatedToY, "contactCreatedToMonth", _contactCreatedToM, "contactCreatedToDay", _contactCreatedToD);
    populateDateFields("contactCreatedFromYear", _contactCreatedFromY, "contactCreatedFromMonth", _contactCreatedFromM, "contactCreatedFromDay", _contactCreatedFromD);
    populateDateFields("emailEditedToYear", _emailEditedToY, "emailEditedToMonth", _emailEditedToM, "emailEditedToDay", _emailEditedToD);
    populateDateFields("emailEditedFromYear", _emailEditedFromY, "emailEditedFromMonth", _emailEditedFromM, "emailEditedFromDay", _emailEditedFromD);

    id("scrollDiv").style.overflowX = "scroll";
    id("scrollDiv").style.width = "755px";
    id("emptyDiv").style.width = id("mainDiv").scrollWidth;
    id("scrollDiv").style.height = "20px";
    id("scrollDiv").onscroll = scrollTop;
    id("mainDiv").onscroll = scrollBottom;

    dateTypeChange("birth");
    dateTypeChange("ann");
    dateTypeChange('travel');
    dateTypeChange("contactCreated");
    dateTypeChange("emailEdited");
    enableCustomDate();
    colRegenerate();
    salesColRegenerate();
    agentColRegenerate();
    eventColRegenerate();

    showRadioClick();
}

function showHide(section) {
    if ( id("show" + section).checked === false ) {
        id(section + "Options").style.display = "none";
    } else {
        id(section + "Options").style.display = "";
    }
}

function showHideTables(tableId) {
    switch(tableId) {
        case "profileTable":
            var buttonCaption = "Sales profile";
            break;
        case "historyTable":
            var buttonCaption = "CRM Events";
            break;
        case "agentTable":
            var buttonCaption = "Agent Details";
            break;
        case "guestTable":
            var buttonCaption = "Guest Details";
            break;
        case "displayTable":
            var buttonCaption = "Result display";
            break;
        default:
            var buttonCaption = "Contact Details";
            break;

    }
    var buttonId = tableId+"Bt";
    if(id(tableId).className == "") {
        id(tableId).className = "collapse";
        id(buttonId).value = buttonCaption+" >>";		// For <input> element
        id(buttonId).innerHTML = buttonCaption+" >>";	// For <button> element

    } else {
        id(tableId).className = "";
        id(buttonId).value = buttonCaption+" <<";
        id(buttonId).innerHTML = buttonCaption+" <<";
    }
}

function onlyUnique(value, index, self) {
    return self.indexOf(value) === index;
}

function openFilter(filter){

    var selectedArray = id(filter + "Ids").value;

    url = "reservation.php?661+"
        + filter
        + "+"
        + selectedArray;

    if (!id('filterUrlForm')){
        // Create new filterUrlForm
        var filterUrlForm=document.createElement("form");
        filterUrlForm.setAttribute('id', 'filterUrlForm');
        filterUrlForm.setAttribute('method', 'POST');
        filterUrlForm.setAttribute('action', 'reservation.php?661');
        filterUrlForm.setAttribute('target', 'filterPop');
        document.body.appendChild(filterUrlForm);

        var filterUrl=document.createElement("input");
        filterUrl.setAttribute('type', 'hidden');
        filterUrl.setAttribute('id', 'filterUrl');
        filterUrl.setAttribute('name', 'filterUrl');
        filterUrlForm.appendChild(filterUrl);
    }

    id("filterUrl").value = url;

    filterPop=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading filter...",280,360,0,0,0,1,"filterPop","opener.id('filterUrlForm').submit();");

}

function openObjectFilter(objType, filter) {
    var selectedArray = id(objType+"_"+filter + "Ids").value;

    url = "reservation.php?661+"
        + objType
        + "+"
        + selectedArray
        + "+"
        + objType+"_"+filter
    ;

    openPopup(url,280,360);
}
function buildDate(prefix) {
    dayValue = id(prefix+"Day").options[id(prefix+"Day").selectedIndex].value;
    monthValue = id(prefix+"Month").options[id(prefix+"Month").selectedIndex].value;

    dayValue = dayValue<10?"0"+dayValue:dayValue;
    monthValue = monthValue<10?"0"+monthValue:monthValue;

    resultDate = id(prefix+"Year").value+"-"+monthValue+"-"+dayValue;

    if(dayValue < 1) {
        id(prefix+"Day").focus();
        openMessage("Please enter a valid "+prefix+" day","a",100);
        return false;
    }
    if(monthValue < 1) {
        id(prefix+"Month").focus();
        openMessage("Please enter a valid "+prefix+" month","a",100);
        return false;
    }

    if(prefix == "eventFrom" || prefix == "eventTo") {
        if(id(prefix+"Year").value == "") {
            id(prefix+"Year").focus();
            openMessage("Please enter a valid "+prefix+" year","a",100);
            return false;
        }
        if(id(prefix+"Year").value.search(/^\d{4}$/) == -1) {
            id(prefix+"Year").focus();
            openMessage("Please enter a valid "+prefix+" year","a",100);
            return false;
        }
    }

    return resultDate;
}

function buildOptions(bName) {
    var list = document.getElementsByName(bName +"Check");
    var chosen = [];
    for(var count = 0; count < list.length; count++) {
        if(list[count].checked) {
            chosen.push(list[count].id.toString().replace(bName,""));
        }
    }
    return chosen.join(":");
}

function getDateType() {
    if(id("dateTypeToday").checked) {
        return "1";
    }
    if(id("dateTypeDayCount").checked) {
        return "2";
    }
    return "3";
}


function buildCols(coltype) {
    var cols = [];
    for(var count=0; count<colData.length; count++) {
        var cWidth = colData[count].width;
        var cSort = colData[count].sort;
        var cDirection = colData[count].direction;
        var cLabel = colData[count].label;
        var cHeader = colData[count].header;
        var cAlign = colData[count].align;
        var cObjType = colData[count].objType;
        var cGuestId = colData[count].rc_obj_sales_ix;
        var cSplit = colData[count].split;
        var cId = colData[count].id;

        if(colData[count].active == "1") {
            cWidth = id("col_width_" + colData[count].id).value;
            cSort = selValue("col_sort_" + colData[count].id);
            cDirection = selValue("col_sort_direction_" + colData[count].id);
            cLabel = id("col_label_" + colData[count].id).value;
            cHeader = id("col_header_" + colData[count].id).value;
            cAlign = selValue("col_align_" + colData[count].id);
            cObjType = id("col_objType_" + colData[count].id).value;
            if(cObjType == 10 || cObjType == 11) {
                cSplit = id("col_split_" + colData[count].id).checked?"1":"";
            }
        }

        cLabel = cLabel.replace(":"," ");

        var col = [
            colData[count].active,
            colData[count].order,
            cSort,
            cWidth,
            cLabel,
            cHeader,
            cAlign,
            cObjType,
            cGuestId,
            cSplit,
            cDirection,
            cId
        ]

        cols[cols.length] = col.join(",");     //cSort, cDirection,

    }
    return cols.join(":");
}

function buildSalesCols() {
    var cols = [];
    for(var count=0; count<salesColData.length; count++) {
        var cWidth = salesColData[count].width;
        var cSort = salesColData[count].sort;
        var cDirection = salesColData[count].direction;
        var cLabel = salesColData[count].label;
        var cHeader = salesColData[count].header;
        var cAlign = salesColData[count].align;
        var cObjType = salesColData[count].objType;
        var cGuestId = salesColData[count].rc_obj_sales_ix;
        var cSplit = salesColData[count].split;

        if(salesColData[count].active == "1") {
            cWidth = id("salesCol_width_" + salesColData[count].id).value;
            cSort = selValue("salesCol_sort_" + salesColData[count].id);
            cDirection = selValue("salesCol_sort_direction_" + salesColData[count].id);
            cLabel = id("salesCol_label_" + salesColData[count].id).value;
            cHeader = id("salesCol_header_" + salesColData[count].id).value;
            cAlign = selValue("salesCol_align_" + salesColData[count].id);
            cObjType = id("salesCol_objType_" + salesColData[count].id).value;
            if(cObjType == 3 || cObjType == 4 || cObjType == 5) {
                cSplit = id("salesCol_split_" + salesColData[count].id).checked?"1":"";
            }
        }
        var col = [
            salesColData[count].active,
            salesColData[count].order,
            cSort,
            cWidth,
            cLabel,
            cHeader,
            cAlign,
            cObjType,
            cGuestId,
            cSplit,
            cDirection
        ]
        cols[cols.length] = col.join(",");     //cSort, cDirection,
    }
    return cols.join(":");
}

function buildAgentCols() {
    var cols = [];
    for(var count=0; count<agentColData.length; count++) {
        var cWidth = agentColData[count].width;
        var cSort = agentColData[count].sort;
        var cDirection = agentColData[count].direction;
        var cLabel = agentColData[count].label;
        var cHeader = agentColData[count].header;
        var cAlign = agentColData[count].align;
        var cObjType = agentColData[count].objType;
        var cAgentId = agentColData[count].pr_agent_id;
        var cSplit = agentColData[count].split;
        var cId = agentColData[count].id;

        if(agentColData[count].active == "1") {
            cWidth = id("agentCol_width_" + agentColData[count].id).value;
            cSort = selValue("agentCol_sort_" + agentColData[count].id);
            cDirection = selValue("agentCol_sort_direction_" + agentColData[count].id);
            cLabel = id("agentCol_label_" + agentColData[count].id).value;
            cHeader = id("agentCol_header_" + agentColData[count].id).value;
            cAlign = selValue("agentCol_align_" + agentColData[count].id);
            cObjType = id("agentCol_objType_" + agentColData[count].id).value;
            if(cObjType == 3 || cObjType == 4 || cObjType == 5) {
                cSplit = id("agentCol_split_" + agentColData[count].id).checked?"1":"";
            }
        }
        var col = [
            agentColData[count].active,
            agentColData[count].order,
            cSort,
            cWidth,
            cLabel,
            cHeader,
            cAlign,
            cObjType,
            cAgentId,
            cSplit,
            cDirection,
            cId
        ]
        cols[cols.length] = col.join(",");     //cSort, cDirection,
    }
    return cols.join(":");
}

function buildEventCols() {
    var cols = [];
    for(var count=0; count<eventColData.length; count++) {
        var cWidth = eventColData[count].width;
        var cSort = eventColData[count].sort;
        var cLabel = eventColData[count].label;
        var cHeader = eventColData[count].header;
        var cAlign = eventColData[count].align;
        var cObjType = eventColData[count].objType;
        var cGuestId = eventColData[count].rc_obj_sales_ix;
        var cSplit = eventColData[count].split;

        if(eventColData[count].active == "1") {
            cWidth = id("eventCol_width_" + eventColData[count].id).value;
            cSort = selValue("eventCol_sort_" + eventColData[count].id);
            cLabel = id("eventCol_label_" + eventColData[count].id).value;
            cHeader = id("eventCol_header_" + eventColData[count].id).value;
            cAlign = selValue("eventCol_align_" + eventColData[count].id);
            cObjType = id("eventCol_objType_" + eventColData[count].id).value;
            if(cObjType == 3 || cObjType == 4 || cObjType == 5) {
                cSplit = id("eventCol_split_" + eventColData[count].id).checked?"1":"";
            }
        }
        var col = [
            eventColData[count].active,
            eventColData[count].order,
            cSort,
            cWidth,
            cLabel,
            cHeader,
            cAlign,
            cObjType,
            cGuestId,
            cSplit
        ]
        cols[cols.length] = col.join(",");     //cSort, cDirection,
    }
    return cols.join(":");
}

function buildProfile() {
    var objs = [];

    if(id("eventOriginIds").value != "") {
        objs[objs.length] = "RS1-"+id("eventOriginIds").value;
    }
    if(id("internalRepSalesIds").value != "") {
        objs[objs.length] = "RS2-"+id("internalRepSalesIds").value;
    }
    if(id("propertiesExtraIds").value != "") {
        objs[objs.length] = "RS3-"+id("propertiesExtraIds").value;
    }

    var objName = document.getElementsByName('sales_profile[]');
    for(var count=0; count<objName.length; count++) {
        if(objName[count].value != "") {
            var str = objName[count].id;
            newStr = str.split('_') ;
            newStr = newStr[1];
            strRep = newStr.replace("Ids","");
            strRep = strRep+"-"+objName[count].value;
            objs[objs.length] = strRep;
        }
    }
    return objs.join("_");
}


function buildURL(renderOption) {
    //renderOption &= 7;
    _urlCount++;

    var eventType = "";
    if(id("eventType_noEvent").checked) {
        eventType = 1;
    } else if(id("eventType_noDate").checked) {
        eventType = 2;
    } else if(id("eventType_opt").checked) {
        eventType = 3;
    } else if(id("eventType_upto").checked) {
        eventType = 4;
    } else if(id("eventType_custom").checked) {
        eventType = 5;
    }

    var dateType = id("eventQuick").value;
    //var dayCount = id("dayCount").value;
    var fromDate = "";
    var toDaye = "";
    if(eventType == 5) {
        var fromDate = buildDate("eventFrom");
        if(!fromDate) { return false; }
        var toDate = buildDate("eventTo");
        if(!toDate) { return false; }
        if(buildDate("eventFrom") > buildDate("eventTo") ) {
            id("eventTo").focus();
            openMessage("Please enter a To date that is greater than or equal to the From date","a", 120);
            return false;
        }
    }

    var travelDateType = id("travelQuick").value;

    var travelFromDate = "";
    var travelToDate = "";
    if(id("travelQuick").value != "") {
        var travelFromDate = buildDate("travelFrom");
        if(!travelFromDate) { return false; }
        var travelToDate = buildDate("travelTo");
        if(!travelToDate) { return false; }
        if(buildDate("travelFrom") > buildDate("travelTo") ) {
            id("travelTo").focus();
            openMessage("Please enter a To date that is greater than or equal to the From date","a",120);
            return false;
        }
    }


    if(id("birthQuick").value != "") {
        if(buildDate("birthFrom") > buildDate("birthTo") ) {
            id("birthToDay").focus();
            openMessage("Please enter a Birth to date that is greater than or equal to the Birth from date","a",120);
            return false;
        }
        var birthFromDate = buildDate("birthFrom");
        var birthToDate = buildDate("birthTo");
    } else {
        var birthFromDate = "";
        var birthToDate = "";
    }

    if(id("contactCreatedQuick").value != "") {
        if(buildDate("contactCreatedFrom") > buildDate("contactCreatedTo") ) {
            id("contactCreatedToDay").focus();
            openMessage("Please enter a Created to date that is greater than or equal to the Created from date","a",120);
            return false;
        }
        var contactCreatedFromDate = buildDate("contactCreatedFrom");
        var contactCreatedToDate = buildDate("contactCreatedTo");
        if (contactCreatedFromDate == false || contactCreatedToDate == false){
            return false;
        }
    } else {
        var contactCreatedFromDate = "";
        var contactCreatedToDate = "";
    }

    if(id("emailEditedQuick").value != "") {
        if(buildDate("emailEditedFrom") > buildDate("emailEditedTo") ) {
            id("emailEditedToDay").focus();
            openMessage("Please enter a Edited to date that is greater than or equal to the Edited from date","a",120);
            return false;
        }
        var emailEditedFromDate = buildDate("emailEditedFrom");
        var emailEditedToDate = buildDate("emailEditedTo");
        if (emailEditedFromDate == false || emailEditedToDate == false){
            return false;
        }
    } else {
        var emailEditedFromDate = "";
        var emailEditedToDate = "";
    }

    if(id("annQuick").value != "") {
        if(buildDate("annFrom") > buildDate("annTo") ) {
            id("annToDay").focus();
            openMessage("Please enter a Annivarsary to date that is greater than or equal to the Annivarsary from date","a",120);
            return false;
        }
        var annFromDate = buildDate("annFrom");
        var annToDate = buildDate("annTo");
    } else {
        var annFromDate = "";
        var annToDate = "";
    }

    var custemProfile = buildProfile();
    var contactDetailsCols = buildCols();
    var salesProfileCols = buildSalesCols();
    var agentCols = buildAgentCols();
    var eventCols = buildEventCols();

    var url = [
        /*  0 */ "reservation.php?394",
        /*  1 */ id("contactRoleIds").value,
        /*  2 */ "2",
        /*  3 */ id("contactType").value,
        /*  4 */ id("contactNameIds").value,
        /*  5 */ id("cont_name").value,
        /*  6 */ id("email").value,
        /*  7 */ id("postSub").value,
        /*  8 */ id("physSub").value,
        /* 9 */ id("postCountryIds").value,
        /* 10 */ id("physCountryIds").value,
        /* 11 */ id("postZip").value,
        /* 12 */ id("physZip").value,
        /* 13 */ id("inactive_contact").value,
        /* 14 */ id("birthQuick").value,
        /* 15 */ birthFromDate,
        /* 16 */ birthToDate,
        /* 17 */  id("annQuick").value,
        /* 18 */ annFromDate,
        /* 19 */ annToDate,
        /* 20 */ custemProfile,
        /* 21 */ eventType,
        /* 22 */ id("eventQuick").value,
        /* 23 */ fromDate,
        /* 24 */ toDate,
        /* 25 */ id("eventActionIds").value,
        /* 26 */ id("event_tagIds").value,
        /* 27 */ id("eventIds").value,
        /* 28 */ id("internalRepIds").value,
        /* 29 */ id("clientRepIds").value,
        /* 30 */ id("event_completed").value,
        /* 31 */ contactDetailsCols,
        /* 32 */ salesProfileCols,
        /* 33 */ eventCols,
        /* 34 */ id("pageNum").value,
        /* 35 */ renderOption,
        /* 36 */ _randomId + "_" + _urlCount.toString(),
        /* 37 */ agentCols,
        /* 38 */ (id("agentNameRadio").checked?"name":"country"),
        /* 39 */ id("agentIds").value,
        /* 40 */ id("agentCountryIds").value,
        /* 41 */ getShowRadio(),
        /* 42 */ id("travelQuick").value,
        /* 43 */ travelFromDate,
        /* 44 */ travelToDate,
        /* 45 */ id("accommIds").value,
        /* 46 */ id("address_search_type").value,
        /* 47 */ id("contactCreatedQuick").value,
        /* 48 */ contactCreatedFromDate,
        /* 49 */ contactCreatedToDate,
        /* 50 */ id("emailEditedQuick").value,
        /* 51 */ emailEditedFromDate,
        /* 52 */ emailEditedToDate
    ];

    return url.join("+");
}

function generateReport() {
    url = buildURL();

    if(url) {
        id("urlForm").target = "_self";
        id("url").value = url;
        id("urlForm").submit();
    }
}

function ShowFrom(pnum){
    pgNum = pnum;
    id("pageNum").value = pnum;
    generateReport();
}

function openCSV() {
    url = buildURL(4);
    if(url) {
        id("urlForm").target = "_self";
        id("url").value = url;
        id("urlForm").submit();
    }
}

function openXmlCSV() {
    url = buildURL(15);
    if(url) {
        id("urlForm").target = "_self";
        id("url").value = url;
        id("urlForm").submit();
    }
}

function openPDF(){
    url = buildURL(1);
    if(url) {
        id("url").value = url;
        id("urlForm").target = "pdfWin";
        pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading PDF...",640,480,0,0,0,1,"pdfWin","opener.id('urlForm').submit();");
    }
}

function sendPDF(){
    url = buildURL(2);
    if(url) {
        id("url").value = url;
        id("urlForm").target = "pdfWin";
        pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Loading email popup...",775,615,0,0,0,0,"pdfWin","opener.id('urlForm').submit();");
    }
}

function sendCSV(){
    url = buildURL(5);
    if(url) {
        id("url").value = url;
        id("urlForm").target = "pdfWin";
        pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Loading email popup...",595,424,0,0,0,0,"pdfWin","opener.id('urlForm').submit();");
    }
}

function editGuest(guestId) {
    openPopup("reservation.php?212+"+guestId+"++++1", 970, 640);
}

function select_daymonth_changed(flag){
    setDayList(id(flag+"FromDay"),id(flag+"FromMonth").options[id(flag+"FromMonth").selectedIndex].value,id(flag+"FromYear").value);
    setDayList(id(flag+"ToDay"),id(flag+"ToMonth").options[id(flag+"ToMonth").selectedIndex].value,id(flag+"ToYear").value);
}

function showHideFilters(){
    var filters = id("filters");
    var filterBut = id("filterBut");

    mnuInitialise = false;

    if( filters.className == "collapse printCollapse" ) {
        filters.className = "expand";
        filterBut.value 	= "<< Hide Filters";
    } else {
        filters.className = "collapse printCollapse";
        filterBut.value 	= ">> Show Filters";
    }
}

// function dateTypeChange() {
// /*if (!id("dateTypeRange").checked ) {
// id("fromYear").value = "";
// id("fromMonth").selectedIndex = 0;
// id("fromDay").selectedIndex = 0;
// id("toYear").value = "";
// id("toMonth").selectedIndex = 0;
// id("toDay").selectedIndex = 0;
// } else { */
// id("fromDay").selectedIndex = _fromD;
// id("fromMonth").selectedIndex = _fromM;
// id("fromYear").value = _fromY;
// id("toDay").selectedIndex = _toD;
// id("toMonth").selectedIndex = _toM;
// id("toYear").value = _toY;
//}
// return true;
// }

function dateTypeChange(flag) {
    var dateOpt = id(flag+"Quick").value;
    var cur_date = new Date();	//get current day-time stamp
    id(flag+"FromYear").disabled = "disabled";
    id(flag+"FromMonth").disabled = "disabled";
    id(flag+"FromDay").disabled = "disabled";
    id(flag+"ToYear").disabled = "disabled";
    id(flag+"ToMonth").disabled = "disabled";
    id(flag+"ToDay").disabled = "disabled";

    id(flag+"FromCal").disabled = "disabled";
    id(flag+"ToCal").disabled = "disabled";

    switch(dateOpt) {
        case '1':
            populateDateFields(flag+"FromYear", cur_date.getYear()< 1000?cur_date.getYear()+1900:cur_date.getYear(), flag+"FromMonth", cur_date.getMonth()+1, flag+"FromDay", cur_date.getDate());
            populateDateFields(flag+"ToYear", cur_date.getYear()< 1000?cur_date.getYear()+1900:cur_date.getYear(), flag+"ToMonth", cur_date.getMonth()+1, flag+"ToDay", cur_date.getDate());
            break;
        case '2':
            var newToDate = new Date();
            var newFromDate = new Date();
            newFromDate.setDate(cur_date.getDate() - (cur_date.getDay()-1));
            newToDate.setDate(cur_date.getDate() + (7 - cur_date.getDay()));

            populateDateFields(flag+"FromYear", newFromDate.getYear()< 1000?newFromDate.getYear()+1900:newFromDate.getYear(), flag+"FromMonth", newFromDate.getMonth()+1, flag+"FromDay", newFromDate.getDate());
            populateDateFields(flag+"ToYear", newToDate.getYear()< 1000?newToDate.getYear()+1900:newToDate.getYear(), flag+"ToMonth", newToDate.getMonth()+1, flag+"ToDay", newToDate.getDate());
            break;
        case '3':
            var newToDate = new Date(cur_date.getFullYear(), cur_date.getMonth()+1, 0);
            var newFromDate = new Date();

            populateDateFields(flag+"FromYear", newFromDate.getYear()< 1000?newFromDate.getYear()+1900:newFromDate.getYear(), flag+"FromMonth", newFromDate.getMonth()+1, flag+"FromDay", 1);
            populateDateFields(flag+"ToYear", newToDate.getYear()< 1000?newToDate.getYear()+1900:newToDate.getYear(), flag+"ToMonth", newToDate.getMonth()+1, flag+"ToDay", newToDate.getDate());
            break;
        case '4':
            var newToDate = new Date(cur_date.getFullYear(), cur_date.getMonth()+1, 0);
            var newFromDate = new Date();

            populateDateFields(flag+"FromYear", cur_date.getYear()< 1000?cur_date.getYear()+1900:cur_date.getYear(), flag+"FromMonth", 1, flag+"FromDay", 1);
            populateDateFields(flag+"ToYear", cur_date.getYear()< 1000?cur_date.getYear()+1900:cur_date.getYear(), flag+"ToMonth", 12, flag+"ToDay", 31);
            break;
        case '5':
        case '6':
        case '7':
        case '8':
            if(eval("_"+flag+"FromY") != "") {
                fromYearValue = eval("_"+flag+"FromY");
            } else {
                fromYearValue = cur_date.getYear()< 1000?cur_date.getYear()+1900:cur_date.getYear();
            }
            if(eval("_"+flag+"FromM")>0) {
                fromMonthValue = eval("_"+flag+"FromM");
            } else {
                fromMonthValue = cur_date.getMonth()+1;
            }
            if(eval("_"+flag+"FromD") > 0) {
                fromDayValue = eval("_"+flag+"FromD");
            } else {
                fromDayValue = cur_date.getDate();
            }

            populateDateFields(flag+"FromYear", fromYearValue, flag+"FromMonth", fromMonthValue, flag+"FromDay", fromDayValue);

            if(eval("_"+flag+"ToY") != "") {
                toYearValue = eval("_"+flag+"ToY");
            } else {
                toYearValue = cur_date.getYear()< 1000?cur_date.getYear()+1900:cur_date.getYear();
            }
            if(eval("_"+flag+"ToM")>0) {
                toMonthValue = eval("_"+flag+"ToM");
            } else {
                toMonthValue = cur_date.getMonth()+1;
            }
            if(eval("_"+flag+"ToD") > 0) {
                toDayValue = eval("_"+flag+"ToD");
            } else {
                toDayValue = cur_date.getDate();
            }

            populateDateFields(flag+"ToYear", toYearValue, flag+"ToMonth", toMonthValue, flag+"ToDay", toDayValue);

            id(flag+"FromYear").disabled = "";
            id(flag+"FromMonth").disabled = "";
            id(flag+"FromDay").disabled = "";
            id(flag+"ToYear").disabled = "";
            id(flag+"ToMonth").disabled = "";
            id(flag+"ToDay").disabled = "";
            id(flag+"FromCal").disabled = "";
            id(flag+"ToCal").disabled = "";
            break;
        default:
            populateDateFields(flag+"FromYear", "", flag+"FromMonth", 0, flag+"FromDay", 0);
            populateDateFields(flag+"ToYear", "", flag+"ToMonth", 0, flag+"ToDay", 0);
            break;
    }

    return true;
}

function enableCustomDate() {
    var flag = "event";
    var cur_date = new Date();	//get current day-time stamp
    if(id('eventType_custom').checked) {
        if(eval("_"+flag+"FromY") != "") {
            fromYearValue = eval("_"+flag+"FromY");
        } else {
            fromYearValue = cur_date.getYear()< 1000?cur_date.getYear()+1900:cur_date.getYear();
        }
        if(eval("_"+flag+"FromM")>0) {
            fromMonthValue = eval("_"+flag+"FromM");
        } else {
            fromMonthValue = cur_date.getMonth()+1;
        }
        if(eval("_"+flag+"FromD") > 0) {
            fromDayValue = eval("_"+flag+"FromD");
        } else {
            fromDayValue = cur_date.getDate();
        }

        populateDateFields(flag+"FromYear", fromYearValue, flag+"FromMonth", fromMonthValue, flag+"FromDay", fromDayValue);

        if(eval("_"+flag+"ToY") != "") {
            toYearValue = eval("_"+flag+"ToY");
        } else {
            toYearValue = cur_date.getYear()< 1000?cur_date.getYear()+1900:cur_date.getYear();
        }
        if(eval("_"+flag+"ToM")>0) {
            toMonthValue = eval("_"+flag+"ToM");
        } else {
            toMonthValue = cur_date.getMonth()+1;
        }
        if(eval("_"+flag+"ToD") > 0) {
            toDayValue = eval("_"+flag+"ToD");
        } else {
            toDayValue = cur_date.getDate();
        }

        populateDateFields(flag+"ToYear", toYearValue, flag+"ToMonth", toMonthValue, flag+"ToDay", toDayValue);

        id(flag+"FromYear").disabled = "";
        id(flag+"FromMonth").disabled = "";
        id(flag+"FromDay").disabled = "";
        id(flag+"ToYear").disabled = "";
        id(flag+"ToMonth").disabled = "";
        id(flag+"ToDay").disabled = "";
        id(flag+"FromCal").disabled = "";
        id(flag+"ToCal").disabled = "";
    } else {
        populateDateFields(flag+"FromYear", "", flag+"FromMonth", 0, flag+"FromDay", 0);
        populateDateFields(flag+"ToYear", "", flag+"ToMonth", 0, flag+"ToDay", 0);

        id(flag+"FromYear").disabled = "disabled";
        id(flag+"FromMonth").disabled = "disabled";
        id(flag+"FromDay").disabled = "disabled";
        id(flag+"ToYear").disabled = "disabled";
        id(flag+"ToMonth").disabled = "disabled";
        id(flag+"ToDay").disabled = "disabled";

        id(flag+"FromCal").disabled = "disabled";
        id(flag+"ToCal").disabled = "disabled";
    }
}

function toggleCollapse(objId) {
    if(id(objId).className == "") {
        id(objId).className = "collapse printCollapse";
    } else {
        id(objId).className = "";
    }
}

function setExtrasIds() {
    list = document.getElementsByName("extraIds");
    last = [];
    if(list.length > 0) {
        for(count=0; count<list.length; count++) {
            tmp = list[count].value.toString().split(":");
            for(count2=0;count2<tmp.length; count2++) {
                last[last.length] = tmp[count2];
            }
        }
        id("extrasIds").value = last.join(":");
    } else {
        id("extrasIds").value = "";
    }
}

function removeExtraIds(rCatId) {
    id("extra_"+rCatId).parentNode.removeChild(id("extra_"+rCatId));
    id("extraIds_"+rCatId).parentNode.removeChild(id("extraIds_"+rCatId));
    if(document.getElementsByName("extraIds").length === 0) {
        id("extraAll").className = "";
    } else {
        id("extraAll").className = "collapse";
    }
}

function openPropFilter() {
    var accomm = id("accommIds").value;
    openPopup("reservation.php?293+"+accomm,556,407);
}

function openOptReqFilter() {
    var accomm = id("accommIds").value;
    openPopup("reservation.php?661+components+"+accomm,556,407);
}

function printReport() {
    window.print();
}

function openOffice() {
    url = buildURL(7);
    if(url) {
        id("urlForm").target = "_self";
        id("url").value = url;
        id("urlForm").submit();
    }
}

function showExportMenu(e, flag) {
    if ( !e ) {
        e = window.event;
    }
    stopBubble(e);

    var posx = 0;
    var posy = 0;

    if (e.pageX || e.pageY) 	{
        posx = e.pageX;
        posy = e.pageY;
    } else if (e.clientX || e.clientY) 	{
        posx = e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
        posy = e.clientY + document.body.scrollTop + document.documentElement.scrollTop;
    }

    if(flag == 1) {
        posy = posy-60;
    }

    id("exportOptionDiv").style.display	= "";
    id("exportOptionDiv").style.left = posx;
    id("exportOptionDiv").style.top = posy;
}

function closeOptDiv() {
    id('exportOptionDiv').style.display = "none";
}

function scrollTop(){
    id("mainDiv").scrollLeft = id("scrollDiv").scrollLeft;
}

function scrollBottom() {
    id("scrollDiv").scrollLeft = id("mainDiv").scrollLeft;
}

//New functions for report builder
function emptyTable(objId) {
    var obj = id(objId);
    for(var count=obj.rows.length-1;count > -1; count--) {
        obj.deleteRow(count);
    }
}

var colRowSelected = false;

function colRow(cObjId,cId,cLabel,cSelected) {
    var row = id(cObjId).insertRow(-1);
    row.tableName = cObjId;
    row.colId = cId;
    row.onmouseover = function() {
        this.style.backgroundColor = "#cfc";
    }
    row.onmouseout = function() {
        if(colRowSelected == this) {
            this.style.backgroundColor = "#31ff63";
        } else {
            this.style.backgroundColor = "";
        }
    }

    row.onclick = function(e,force) {
        if(colRowSelected != this || (colRowSelected == this && force) ) {
            if(colRowSelected) {
                colRowSelected.style.backgroundColor = "";
                colRowSelected.firstChild.style.fontWeight = "";
            }
            colRowSelected = this;
            this.firstChild.style.fontWeight = "bold";
            if(this.style.backgroundColor == "") {
                this.style.backgroundColor = "#31ff63";
            }
            if(this.tableName == "tblInactiveCol") {
                id("btnColAdd").disabled = false;
                id("btnColRemove").disabled = true;
                id("btnColUp").disabled = true;
                id("btnColDown").disabled = true;
            } else {
                id("btnColAdd").disabled = true;
                id("btnColRemove").disabled = false;
                id("btnColUp").disabled = false;
                id("btnColDown").disabled = false;
            }
        } else {
            colRowSelected = false;
            this.firstChild.style.fontWeight = "";
            id("btnColAdd").disabled = true;
            id("btnColRemove").disabled = true;
            id("btnColUp").disabled = true;
            id("btnColDown").disabled = true;
        }
    }

    // name
    var cell = row.insertCell(-1);
    cell.innerHTML = cLabel;
    cell.className = "imgLink";
    if(colData[cId-1].disable === 1) {
        cell.style.backgroundColor = "#999";
    }
    cell.style.width = "98px";
    if(cObjId === "tblInactiveCol") {
        cell.style.whiteSpace = "nowrap";
    }

    if(cObjId === "tblActiveCol") {
        // label
        cell = row.insertCell(-1);
        //cell.style.width = "95px";
        cell.innerHTML = "<input type=\"text\" id=\"col_label_" + cId + "\" style=\"width:97px;\" value=\""+colData[cId-1].label+"\"/><input type=\"hidden\" id=\"col_objType_" + cId + "\" value=\""+colData[cId-1].objType+"\"/><input type=\"hidden\" id=\"col_rf_obj_guest_ix_" + cId + "\" value=\""+colData[cId-1].rf_obj_guest_ix+"\"/>";

        //split
        if(parseInt(colData[cId-1].objType) === 10 || parseInt(colData[cId-1].objType) === 11) {
            var splitChecked = "";
            if(parseInt(colData[cId-1].split) === 1) {
                splitChecked = "checked";
            }
            cell = row.insertCell(-1);
            //cell.style.width = "30px";
            cell.innerHTML = "<input type=\"checkbox\" id=\"col_split_" + cId + "\" name=\"splitCheck\"  value=\""+colData[cId-1].split+"\" "+splitChecked+"/>";
        } else {
            cell = row.insertCell(-1);
        }

        // width
        cell = row.insertCell(-1);
        //cell.style.width = "30px";
        cell.innerHTML = "<input type=\"text\" id=\"col_width_" + cId + "\" style=\"width:28px;\" value=\""+colData[cId-1].width+"\"/>";

        //sort
        cell = row.insertCell(-1);
        //cell.style.width = "80px";
        if (parseInt(colData[cId-1].sortable) === 1){
            colSortDisabled = "";
        } else {
            colSortDisabled = "disabled";
        }
        cell.innerHTML = "<select id=\"col_sort_" + cId + "\" style=\"width:35px;\" " + colSortDisabled + ">"+colSortOptions+"</select><select id=\"col_sort_direction_" + cId + "\" style=\"width:43px;\" " + colSortDisabled + "><option value=\"a\">Ascending</option><option value=\"d\">Descending</option></select>";

        if(colData[cId-1].sort != "") {
            id("col_sort_" + cId).selectedIndex = parseInt(colData[cId-1].sort,10);
        }

        if(colData[cId-1].direction == "d") {
            id("col_sort_direction_" + cId).selectedIndex = 1;
        }

        //Group Header
        cell = row.insertCell(-1);
        cell.innerHTML = "<input type=\"text\" id=\"col_header_" + cId + "\" style=\"width:85px\" value=\""+colData[cId-1].header+"\"/>";

        //Align
        cell = row.insertCell(-1);
        cell.innerHTML = "<select id=\"col_align_" + cId + "\" style=\"width:48px\"><option value=\"l\">Left</option><option value=\"c\">Centre</option><option value=\"r\">Right</option></select>";

        var align = colData[cId-1].align;
        if(align == "c") {
            id("col_align_"+cId).selectedIndex = 1;
        }
        if(align == "r") {
            id("col_align_"+cId).selectedIndex = 2;
        }
    }

    if(cSelected) {
        colRowSelected = row;
        row.onclick(false,true);
    }

}

var colSortOptions = "";
function colRegenerate() {
    if(colRowSelected != false) {
        var colRowSelectedId = colRowSelected.colId;
    }
    emptyTable("tblInactiveCol");
    emptyTable("tblActiveCol");

    var colSort = [];
    var sortCount = 1;
    colSortOptions = "<option value=\"\"></option>";
    for(var count=0; count < colData.length; count++) {
        colSortOptions += "<option value=\"" + sortCount.toString() + "\">" + sortCount.toString() + "</option>";
        sortCount++;
    }
    for(var count=0; count < colData.length; count++) {
        if(parseInt(colData[count].active) !== 1) {
            var selected = false;
            if(parseInt(colData[count].id) === parseInt(colRowSelectedId)) {
                selected = true;
            }
            colRow("tblInactiveCol", parseInt(colData[count].id), colData[count].name, selected);
        } else {
            colSort[parseInt(colData[count].order)] = count;
        }
    }

    for(var count=1; count < colSort.length; count++) {
        var selected = false;
        if(parseInt(colData[colSort[count]].id) === parseInt(colRowSelectedId)) {
            selected = true;
        }
        colRow("tblActiveCol", parseInt(colData[colSort[count]].id), colData[colSort[count]].name, selected);
    }
}

function colOrderArray() {
    var colOrder = [];
    for(var count=0; count < colData.length; count++) {
        if(parseInt(colData[count].active) === 1) {
            colOrder[parseInt(colData[count].order)] = count;
        } else {
            colData[count].order = 0;
        }
    }

    var newColOrder = [];

    for(var count=1; count < colOrder.length; count++) {
        var key = parseInt(colOrder[count]);
        if(colData[key]) {
            newColOrder[newColOrder.length] = key;
        }
    }
    return newColOrder;
}

function colNormaliseOrder() {
    var colOrder = colOrderArray();

    var orderCount = 1;
    for(var count=0; count < colOrder.length; count++) {
        colData[colOrder[count]].order = orderCount;
        orderCount++;
    }
}

function colAdd() {
    if(!colRowSelected) { return false; }

    var maxOrder = 0;
    for(var count=0; count < colData.length; count++) {
        if(colData[count].order > maxOrder) maxOrder = parseInt(colData[count].order);
    }
    maxOrder++;
    for(var count=0; count < colData.length; count++) {
        if(parseInt(colRowSelected.colId) === parseInt(colData[count].id)) {
            colData[count].active = 1;
            colData[count].order = maxOrder;
        }
    }

    colNormaliseOrder();
    colRegenerate();
}

function colRemove() {
    if(!colRowSelected) { return false; }

    for(var count=0; count < colData.length; count++) {
        if(parseInt(colRowSelected.colId) === parseInt(colData[count].id)) {
            colData[count].active = 0;
        }
    }
    colNormaliseOrder();
    colRegenerate();
}

function colSwapOrder(key1, key2) {
    var temp = parseInt(colData[key1].order);
    colData[key1].order = parseInt(colData[key2].order);
    colData[key2].order = temp;
}

function colMove(direction) {
    if(!colRowSelected) { return false; }

    var colOrder = colOrderArray();
    var colFirst = colOrder[0];

    for(var count=0; count < colOrder.length; count++) {
        var key = colOrder[count];
        if(parseInt(colRowSelected.colId) === parseInt(colData[key].id)) {
            if(!direction) {
                if(count != 0) {
                    colSwapOrder(key,colOrder[count-1]);
                }
            } else {
                if(count < colOrder.length-1) {
                    colSwapOrder(key,colOrder[count+1]);
                }
            }
        }
    }

    colNormaliseOrder();
    colRegenerate();
}

function colUp() {
    colMove();
}

function colDown() {
    colMove(true);
}

//New functions for note section of report builder

var salesColRowSelected = false;

function salesColRow(cObjId,cId,cLabel,cSelected) {
    var row = id(cObjId).insertRow(-1);
    row.tableName = cObjId;
    row.colId = cId;
    row.onmouseover = function() {
        this.style.backgroundColor = "#cfc";
    }
    row.onmouseout = function() {
        if(salesColRowSelected == this) {
            this.style.backgroundColor = "#31ff63";
        } else {
            this.style.backgroundColor = "";
        }
    }
    row.onclick = function(e,force) {
        if(salesColRowSelected != this || (salesColRowSelected == this && force) ) {
            if(salesColRowSelected) {
                salesColRowSelected.style.backgroundColor = "";
                salesColRowSelected.firstChild.style.fontWeight = "";
            }
            salesColRowSelected = this;
            this.firstChild.style.fontWeight = "bold";
            if(this.style.backgroundColor == "") {
                this.style.backgroundColor = "#31ff63";
            }
            if(this.tableName === "tblInactiveSalesCol") {
                id("btnSalesColAdd").disabled = false;
                id("btnSalesColRemove").disabled = true;
                id("btnSalesColUp").disabled = true;
                id("btnSalesColDown").disabled = true;
            } else {
                id("btnSalesColAdd").disabled = true;
                id("btnSalesColRemove").disabled = false;
                id("btnSalesColUp").disabled = false;
                id("btnSalesColDown").disabled = false;
            }
        } else {
            salesColRowSelected = false;
            this.firstChild.style.fontWeight = "";
            id("btnSalesColAdd").disabled = true;
            id("btnSalesColRemove").disabled = true;
            id("btnSalesColUp").disabled = true;
            id("btnSalesColDown").disabled = true;
        }
    }

    // name
    var cell = row.insertCell(-1);
    cell.innerHTML = cLabel;
    cell.className = "imgLink";
    if(salesColData[cId-1] && parseInt(salesColData[cId-1].disable) === 1) {
        cell.style.backgroundColor = "#999";
    }
    cell.style.width = "98px";
    if(cObjId === "tblInactiveSalesCol") {
        cell.style.whiteSpace = "nowrap";
    }

    if(cObjId === "tblActiveSalesCol" && salesColData[cId-1]) {

        var visibility = (typeof salesColData[cId-1].sortable === "undefined" || salesColData[cId-1].sortable === "" || salesColData[cId-1].sortable === "0") ? "visibility: hidden;" : "";

        // label
        cell = row.insertCell(-1);
        //cell.style.width = "105px";
        cell.innerHTML = "<input type=\"text\" id=\"salesCol_label_" + cId + "\" style=\"width:97px;\" value=\""+salesColData[cId-1].label+"\"/><input type=\"hidden\" id=\"salesCol_objType_" + cId + "\" value=\""+salesColData[cId-1].objType + "\"/><input type=\"hidden\" id=\"salesCol_rc_obj_sales_ix_" + cId + "\" value=\""+ salesColData[cId-1].rc_obj_sales_ix + "\"/>";

        //split
        if(parseInt(salesColData[cId-1].objType) === 3 || parseInt(salesColData[cId-1].objType) === 4 || parseInt(salesColData[cId-1].objType) === 5) {
            var splitChecked = "";
            if(parseInt(salesColData[cId-1].split) === 1) {
                splitChecked = "checked";
            }
            cell = row.insertCell(-1);
            //cell.style.width = "40px";
            cell.innerHTML = "<input type=\"checkbox\" id=\"salesCol_split_" + cId + "\" name=\"splitCheck\"  value=\""+ salesColData[cId-1].split +"\" "+splitChecked+"/>";
        } else {
            cell = row.insertCell(-1);
        }

        // width
        cell = row.insertCell(-1);
        //cell.style.width = "40px";
        cell.innerHTML = "<input type=\"text\" id=\"salesCol_width_" + cId + "\" style=\"width:28px;\" value=\""+salesColData[cId-1].width+"\"/>";

        //sort
        cell = row.insertCell(-1);
        //cell.style.width = "65px";
        cell.innerHTML = "<select id=\"salesCol_sort_" + cId + "\" style=\"width:35px; " + visibility + " \" disabled >"+salesColSortOptions+"</select>" + "<select id=\"salesCol_sort_direction_" + cId + "\" style=\"width:43px;" + visibility + "\" disabled><option value=\"a\">Ascending</option><option value=\"d\">Descending</option></select>";

        if(salesColData[cId-1].sort != "") {
            id("salesCol_sort_" + cId).selectedIndex = parseInt(salesColData[cId-1].sort,10);
        }

        if(salesColData[cId-1].direction == "d") {
            id("salesCol_sort_direction_" + cId).selectedIndex = 1;
        }

        //Group Header
        cell = row.insertCell(-1);
        //cell.style.width = "100px";
        cell.innerHTML = "<input type=\"text\" id=\"salesCol_header_" + cId + "\" style=\"width:85px\" value=\""+salesColData[cId-1].header+"\"/>";

        //Align
        cell = row.insertCell(-1);
        //cell.style.width = "45px";
        cell.innerHTML = "<select id=\"salesCol_align_" + cId + "\" style=\"width:48px\"><option value=\"l\">Left</option><option value=\"c\">Centre</option><option value=\"r\">Right</option></select>";

        var align = salesColData[cId-1].align;
        if(align == "c") {
            id("salesCol_align_"+cId).selectedIndex = 1;
        }
        if(align == "r") {
            id("salesCol_align_"+cId).selectedIndex = 2;
        }
    }

    if(cSelected) {
        salesColRowSelected = row;
        row.onclick(false,true);
    }

}

var salesColSortOptions = "";
function salesColRegenerate() {
    if(salesColRowSelected != false) {
        var salesColRowSelectedId = salesColRowSelected.colId;
    }
    emptyTable("tblInactiveSalesCol");
    emptyTable("tblActiveSalesCol");

    var salesColSort = [];
    var sortCount = 1;
    salesColSortOptions = "<option value=\"\"></option>";
    for(var count=0; count < salesColData.length; count++) {
        salesColSortOptions += "<option value=\"" + sortCount.toString() + "\">" + sortCount.toString() + "</option>";
        sortCount++;
    }
    for(var count=0; count < salesColData.length; count++) {
        if(parseInt(salesColData[count].active) !== 1) {
            var selected = false;
            if(parseInt(salesColData[count].id) === parseInt(salesColRowSelectedId)) {
                selected = true;
            }
            salesColRow("tblInactiveSalesCol", parseInt(salesColData[count].id), salesColData[count].name, selected);
        } else {
            salesColSort[parseInt(salesColData[count].order)] = count;
        }
    }

    var salesColSortUnique = salesColSort.filter(onlyUnique);
    for(var count=1; count < salesColSort.length; count++) {
        var selected = false;
        if(parseInt(salesColData[salesColSort[count]].id) === parseInt(salesColRowSelectedId)) {
            selected = true;
        }
        salesColRow("tblActiveSalesCol", parseInt(salesColData[salesColSort[count]].id), salesColData[salesColSort[count]].name, selected);
    }
}

function salesColOrderArray() {
    var salesColOrder = [];
    for(var count=0; count < salesColData.length; count++) {
        if(parseInt(salesColData[count].active) === 1) {
            salesColOrder[parseInt(salesColData[count].order)] = count;
        } else {
            salesColData[count].order = 0;
        }
    }

    var newColOrder = [];
    for(var count=1; count < salesColOrder.length; count++) {
        var key = salesColOrder[count];
        if(salesColData[key]) {
            newColOrder[newColOrder.length] = key;
        }
    }
    return newColOrder;
}

function salesColNormaliseOrder() {
    var salesColOrder = salesColOrderArray();

    var salesOrderCount = 1;
    for(var count=0; count < salesColOrder.length; count++) {
        salesColData[salesColOrder[count]].order = salesOrderCount;
        salesOrderCount++;
    }
}

function salesColAdd() {
    if(!salesColRowSelected) { return false; }

    var maxOrder = 0;
    for(var count=0; count < salesColData.length; count++) {
        if(parseInt(salesColData[count].order) > maxOrder) maxOrder = parseInt(salesColData[count].order);
    }
    maxOrder++;
    for(var count=0; count < salesColData.length; count++) {
        if(parseInt(salesColRowSelected.colId) === parseInt(salesColData[count].id)) {
            salesColData[count].active = 1;
            salesColData[count].order = maxOrder;
        }
    }

    salesColNormaliseOrder();
    salesColRegenerate();
}

function salesColRemove() {
    if(!salesColRowSelected) { return false; }

    for(var count=0; count < salesColData.length; count++) {
        if(parseInt(salesColRowSelected.colId) === parseInt(salesColData[count].id)) {
            salesColData[count].active = 0;
        }
    }
    salesColNormaliseOrder();
    salesColRegenerate();
}

function salesColSwapOrder(key1, key2) {
    var temp = parseInt(salesColData[key1].order);
    salesColData[key1].order = parseInt(salesColData[key2].order);
    salesColData[key2].order = temp;
}

function salesColMove(direction) {
    if(!salesColRowSelected) { return false; }

    var colOrder = salesColOrderArray();
    var colFirst = colOrder[0];

    for(var count=0; count < colOrder.length; count++) {
        var key = colOrder[count];
        if(parseInt(salesColRowSelected.colId) === parseInt(salesColData[key].id)) {
            if(!direction) {
                if(count !== 0) {
                    salesColSwapOrder(key,colOrder[count-1]);
                }
            } else {
                if(count < colOrder.length-1) {
                    salesColSwapOrder(key,colOrder[count+1]);
                }
            }
        }
    }

    salesColNormaliseOrder();
    salesColRegenerate();
}

function salesColUp() {
    salesColMove();
}

function salesColDown() {
    salesColMove(true);
}

var agentColRowSelected = false;

function agentColRow(cObjId,cId,cLabel,cSelected) {
    var row = id(cObjId).insertRow(-1);
    row.tableName = cObjId;
    row.colId = cId;
    row.onmouseover = function() {
        this.style.backgroundColor = "#cfc";
    }
    row.onmouseout = function() {
        if(agentColRowSelected == this) {
            this.style.backgroundColor = "#31ff63";
        } else {
            this.style.backgroundColor = "";
        }
    }
    row.onclick = function(e,force) {
        if(agentColRowSelected != this || (agentColRowSelected == this && force) ) {
            if(agentColRowSelected) {
                agentColRowSelected.style.backgroundColor = "";
                agentColRowSelected.firstChild.style.fontWeight = "";
            }
            agentColRowSelected = this;
            this.firstChild.style.fontWeight = "bold";
            if(this.style.backgroundColor == "") {
                this.style.backgroundColor = "#31ff63";
            }
            if(this.tableName === "tblInactiveAgentCol") {
                id("btnAgentColAdd").disabled = false;
                id("btnAgentColRemove").disabled = true;
                id("btnAgentColUp").disabled = true;
                id("btnAgentColDown").disabled = true;
            } else {
                id("btnAgentColAdd").disabled = true;
                id("btnAgentColRemove").disabled = false;
                id("btnAgentColUp").disabled = false;
                id("btnAgentColDown").disabled = false;
            }
        } else {
            agentColRowSelected = false;
            this.firstChild.style.fontWeight = "";
            id("btnAgentColAdd").disabled = true;
            id("btnAgentColRemove").disabled = true;
            id("btnAgentColUp").disabled = true;
            id("btnAgentColDown").disabled = true;
        }
    }

    // name
    var cell = row.insertCell(-1);
    cell.innerHTML = cLabel;
    cell.className = "imgLink";

    if(agentColData[cId-1] && parseInt(agentColData[cId-1].disable) === 1) {
        cell.style.backgroundColor = "#999";
    }
    cell.style.width = "98px";
    if(cObjId === "tblInactiveAgentCol") {
        cell.style.whiteSpace = "nowrap";
    }

    if(cObjId === "tblActiveAgentCol" && agentColData[cId-1]) {

        var visibility = (typeof agentColData[cId-1].sortable === "undefined" || agentColData[cId-1].sortable === "" || agentColData[cId-1].sortable === "0") ? "visibility: hidden;" : "";

        // label
        cell = row.insertCell(-1);
        //cell.style.width = "105px";
        cell.innerHTML = "<input type=\"text\" id=\"agentCol_label_" + cId + "\" style=\"width:97px;\" value=\""+agentColData[cId-1].label+"\"/><input type=\"hidden\" id=\"agentCol_objType_" + cId + "\" value=\""+agentColData[cId-1].objType+"\"/><input type=\"hidden\" id=\"agentCol_rc_obj_sales_ix_" + cId + "\" value=\""+agentColData[cId-1].rc_obj_sales_ix+"\"/>";

        //split
        if(parseInt(agentColData[cId-1].objType) === 3 || parseInt(agentColData[cId-1].objType) === 4  || parseInt(agentColData[cId-1].objType) === 5) {
            var splitChecked = "";
            if(parseInt(agentColData[cId-1].split) === 1) {
                splitChecked = "checked";
            }
            cell = row.insertCell(-1);
            //cell.style.width = "40px";
            cell.innerHTML = "<input type=\"checkbox\" id=\"agentCol_split_" + cId + "\" name=\"splitCheck\"  value=\""+agentColData[cId-1].split+"\" "+splitChecked+"/>";
        } else {
            cell = row.insertCell(-1);
        }

        // width
        cell = row.insertCell(-1);
        //cell.style.width = "40px";
        cell.innerHTML = "<input type=\"text\" id=\"agentCol_width_" + cId + "\" style=\"width:28px;\" value=\""+agentColData[cId-1].width+"\"/>";

        //sort
        cell = row.insertCell(-1);
        //cell.style.width = "65px";
        if (parseInt(agentColData[cId-1].sortable) === 1){
            agentColSortDisabled = "";
        } else {
            agentColSortDisabled = "disabled";
        }
        cell.innerHTML = "<select id=\"agentCol_sort_" + cId + "\" style=\"width:35px; " + visibility + "\" " + agentColSortDisabled + ">"+agentColSortOptions+"</select><select id=\"agentCol_sort_direction_" + cId + "\" style=\"width:43px;" + visibility + " \" " + agentColSortDisabled + "><option value=\"a\">Ascending</option><option value=\"d\">Descending</option></select>";

        if(agentColData[cId-1].sort != "") {
            id("agentCol_sort_" + cId).selectedIndex = parseInt(agentColData[cId-1].sort,10);
        }

        if(agentColData[cId-1].direction == "d") {
            id("agentCol_sort_direction_" + cId).selectedIndex = 1;
        }

        //Group Header
        cell = row.insertCell(-1);
        //cell.style.width = "100px";
        cell.innerHTML = "<input type=\"text\" id=\"agentCol_header_" + cId + "\" style=\"width:85px\" value=\""+agentColData[cId-1].header+"\"/>";

        //Align
        cell = row.insertCell(-1);
        //cell.style.width = "45px";
        cell.innerHTML = "<select id=\"agentCol_align_" + cId + "\" style=\"width:48px\"><option value=\"l\">Left</option><option value=\"c\">Centre</option><option value=\"r\">Right</option></select>";

        var align = agentColData[cId-1].align;
        if(align == "c") {
            id("agentCol_align_"+cId).selectedIndex = 1;
        }
        if(align == "r") {
            id("agentCol_align_"+cId).selectedIndex = 2;
        }
    }

    if(cSelected) {
        agentColRowSelected = row;
        row.onclick(false,true);
    }

}

var agentColSortOptions = "";
function agentColRegenerate() {
    if(agentColRowSelected != false) {
        var agentColRowSelectedId = agentColRowSelected.colId;
    }
    emptyTable("tblInactiveAgentCol");
    emptyTable("tblActiveAgentCol");

    var agentColSort = [];
    var sortCount = 1;
    agentColSortOptions = "<option value=\"\"></option>";
    for(var count=0; count < agentColData.length; count++) {
        agentColSortOptions += "<option value=\"" + sortCount.toString() + "\">" + sortCount.toString() + "</option>";
        sortCount++;
    }
    for(var count=0; count < agentColData.length; count++) {
        if(parseInt(agentColData[count].active) !== 1) {
            var selected = false;
            if(parseInt(agentColData[count].id) === parseInt(agentColRowSelectedId)) {
                selected = true;
            }
            agentColRow("tblInactiveAgentCol", parseInt(agentColData[count].id), agentColData[count].name, selected);
        } else {
            agentColSort[agentColData[count].order] = count;
        }
    }

    for(var count=1; count < agentColSort.length; count++) {
        var selected = false;
        if(parseInt(agentColData[agentColSort[count]].id) === parseInt(agentColRowSelectedId)) {
            selected = true;
        }
        agentColRow("tblActiveAgentCol", parseInt(agentColData[agentColSort[count]].id), agentColData[agentColSort[count]].name, selected);
    }
}

function agentColOrderArray() {
    var agentColOrder = [];
    for(var count=0; count < agentColData.length; count++) {
        if(parseInt(agentColData[count].active) === 1) {
            agentColOrder[agentColData[count].order] = count;
        } else {
            agentColData[count].order = 0;
        }
    }

    var newColOrder = [];

    for(var count=1; count < agentColOrder.length; count++) {
        var key = parseInt(agentColOrder[count]);
        if(agentColData[key]) {
            newColOrder[newColOrder.length] = key;
        }
    }
    return newColOrder;
}

function agentColNormaliseOrder() {
    var agentColOrder = agentColOrderArray();

    var agentOrderCount = 1;
    for(var count=0; count < agentColOrder.length; count++) {
        agentColData[parseInt(agentColOrder[count])].order = agentOrderCount;
        agentOrderCount++;
    }
}

function agentColAdd() {
    if(!agentColRowSelected) { return false; }
    var maxOrder = 0;
    for(var count=0; count < agentColData.length; count++) {
        if(parseInt(agentColData[count].order) > maxOrder) maxOrder = parseInt(agentColData[count].order);
    }
    maxOrder++;
    for(var count=0; count < agentColData.length; count++) {
        if(parseInt(agentColRowSelected.colId) === parseInt(agentColData[count].id)) {
            agentColData[count].active = 1;
            agentColData[count].order = maxOrder;
        }
    }

    agentColNormaliseOrder();
    agentColRegenerate();
}

function agentColRemove() {
    if(!agentColRowSelected) { return false; }

    for(var count=0; count < agentColData.length; count++) {
        if(parseInt(agentColRowSelected.colId) === parseInt(agentColData[count].id)) {
            agentColData[count].active = 0;
        }
    }
    agentColNormaliseOrder();
    agentColRegenerate();
}

function agentColSwapOrder(key1, key2) {
    var temp = parseInt(agentColData[key1].order);
    agentColData[key1].order = parseInt(agentColData[key2].order);
    agentColData[key2].order = temp;
}

function agentColMove(direction) {
    if(!agentColRowSelected) { return false; }

    var colOrder = agentColOrderArray();
    var colFirst = colOrder[0];

    for(var count=0; count < colOrder.length; count++) {
        var key = parseInt(colOrder[count]);
        if(parseInt(agentColRowSelected.colId) === parseInt(agentColData[key].id)) {
            if(!direction) {
                if(count !== 0) {
                    agentColSwapOrder(key,colOrder[count-1]);
                }
            } else {
                if(count < colOrder.length-1) {
                    agentColSwapOrder(key,colOrder[count+1]);
                }
            }
        }
    }

    agentColNormaliseOrder();
    agentColRegenerate();
}

function agentColUp() {
    agentColMove();
}

function agentColDown() {
    agentColMove(true);
}

var eventColRowSelected = false;

function eventColRow(cObjId,cId,cLabel,cSelected) {
    var row = id(cObjId).insertRow(-1);
    row.tableName = cObjId;
    row.colId = cId;
    row.onmouseover = function() {
        this.style.backgroundColor = "#cfc";
    }
    row.onmouseout = function() {
        if(eventColRowSelected == this) {
            this.style.backgroundColor = "#31ff63";
        } else {
            this.style.backgroundColor = "";
        }
    }
    row.onclick = function(e,force) {
        if(eventColRowSelected != this || (eventColRowSelected == this && force) ) {
            if(eventColRowSelected) {
                eventColRowSelected.style.backgroundColor = "";
                eventColRowSelected.firstChild.style.fontWeight = "";
            }
            eventColRowSelected = this;
            this.firstChild.style.fontWeight = "bold";
            if(this.style.backgroundColor == "") {
                this.style.backgroundColor = "#31ff63";
            }
            if(this.tableName == "tblInactiveEventCol") {
                id("btnEventColAdd").disabled = false;
                id("btnEventColRemove").disabled = true;
                id("btnEventColUp").disabled = true;
                id("btnEventColDown").disabled = true;
            } else {
                id("btnEventColAdd").disabled = true;
                id("btnEventColRemove").disabled = false;
                id("btnEventColUp").disabled = false;
                id("btnEventColDown").disabled = false;
            }
        } else {
            eventColRowSelected = false;
            this.firstChild.style.fontWeight = "";
            id("btnEventColAdd").disabled = true;
            id("btnEventColRemove").disabled = true;
            id("btnEventColUp").disabled = true;
            id("btnEventColDown").disabled = true;
        }
    }

    // name
    var cell = row.insertCell(-1);
    cell.innerHTML = cLabel;
    cell.className = "imgLink";
    if(eventColData[cId-1] && parseInt(eventColData[cId-1].disable) === 1) {
        cell.style.backgroundColor = "#999";
    }
    cell.style.width = "98px";
    if(cObjId === "tblInactiveEventCol") {
        cell.style.whiteSpace = "nowrap";
    }

    if(cObjId === "tblActiveEventCol" && eventColData[cId-1]) {

        var visibility = (typeof eventColData[cId-1].sortable === "undefined" || eventColData[cId-1].sortable === "" || eventColData[cId-1].sortable === "0") ? "visibility: hidden;" : "";

        // label
        cell = row.insertCell(-1);
        //cell.style.width = "105px";
        cell.innerHTML = "<input type=\"text\" id=\"eventCol_label_" + cId + "\" style=\"width:97px;\" value=\""+eventColData[cId-1].label+"\"/><input type=\"hidden\" id=\"eventCol_objType_" + cId + "\" value=\""+eventColData[cId-1].objType+"\"/><input type=\"hidden\" id=\"eventCol_rc_obj_sales_ix_" + cId + "\" value=\""+eventColData[cId-1].rc_obj_sales_ix+"\"/>";

        //split
        if(parseInt(eventColData[cId-1].objType) === 3 || parseInt(eventColData[cId-1].objType) === 4 || parseInt(eventColData[cId-1].objType) === 5) {
            var splitChecked = "";
            if(parseInt(eventColData[cId-1].split) === 1) {
                splitChecked = "checked";
            }
            cell = row.insertCell(-1);
            //cell.style.width = "40px";
            cell.innerHTML = "<input type=\"checkbox\" id=\"eventCol_split_" + cId + "\" name=\"splitCheck\"  value=\""+eventColData[cId-1].split+"\" "+splitChecked+"/>";
        } else {
            cell = row.insertCell(-1);
        }

        // width
        cell = row.insertCell(-1);
        //cell.style.width = "40px";
        cell.innerHTML = "<input type=\"text\" id=\"eventCol_width_" + cId + "\" style=\"width:28px;\" value=\""+eventColData[cId-1].width+"\"/>";

        //sort
        cell = row.insertCell(-1);
        //cell.style.width = "65px";
        cell.innerHTML = "<select id=\"eventCol_sort_" + cId + "\" style=\"width:35px;  " + visibility + " \" disabled>"+eventColSortOptions+"</select><select id=\"eventCol_sort_direction_" + cId + "\" style=\"width:43px; "+ visibility + "\" disabled><option value=\"a\">Ascending</option><option value=\"d\">Descending</option></select>";

        if(eventColData[cId-1].sort != "") {
            id("eventCol_sort_" + cId).selectedIndex = parseInt(eventColData[cId-1].sort,10);
        }

        if(eventColData[cId-1].direction == "d") {
            id("eventCol_sort_direction_" + cId).selectedIndex = 1;
        }

        //Group Header
        cell = row.insertCell(-1);
        //cell.style.width = "100px";
        cell.innerHTML = "<input type=\"text\" id=\"eventCol_header_" + cId + "\" style=\"width:85px\" value=\""+eventColData[cId-1].header+"\"/>";

        //Align
        cell = row.insertCell(-1);
        //cell.style.width = "45px";
        cell.innerHTML = "<select id=\"eventCol_align_" + cId + "\" style=\"width:48px\"><option value=\"l\">Left</option><option value=\"c\">Centre</option><option value=\"r\">Right</option></select>";

        var align = eventColData[cId-1].align;
        if(align == "c") {
            id("eventCol_align_"+cId).selectedIndex = 1;
        }
        if(align == "r") {
            id("eventCol_align_"+cId).selectedIndex = 2;
        }
    }

    if(cSelected) {
        eventColRowSelected = row;
        row.onclick(false,true);
    }

}

var eventColSortOptions = "";
function eventColRegenerate() {
    if(eventColRowSelected != false) {
        var eventColRowSelectedId = eventColRowSelected.colId;
    }
    emptyTable("tblInactiveEventCol");
    emptyTable("tblActiveEventCol");

    var eventColSort = [];
    var sortCount = 1;
    eventColSortOptions = "<option value=\"\"></option>";
    for(var count=0; count < eventColData.length; count++) {
        eventColSortOptions += "<option value=\"" + sortCount.toString() + "\">" + sortCount.toString() + "</option>";
        sortCount++;
    }
    for(var count=0; count < eventColData.length; count++) {
        if(parseInt(eventColData[count].active) !== 1) {
            var selected = false;
            if(parseInt(eventColData[count].id) === parseInt(eventColRowSelectedId)) {
                selected = true;
            }
            eventColRow("tblInactiveEventCol",parseInt(eventColData[count].id), eventColData[count].name,selected);
        } else {
            eventColSort[parseInt(eventColData[count].order)] = count;
        }
    }

    for(var count=1; count < eventColSort.length; count++) {
        var selected = false;
        if(parseInt(eventColData[eventColSort[count]].id) === parseInt(eventColRowSelectedId)) {
            selected = true;
        }
        eventColRow("tblActiveEventCol",parseInt(eventColData[eventColSort[count]].id),eventColData[eventColSort[count]].name,selected);
    }
}

function eventColOrderArray() {
    var eventColOrder = [];
    for(var count=0; count < eventColData.length; count++) {
        if(parseInt(eventColData[count].active) === 1) {
            eventColOrder[parseInt(eventColData[count].order)] = count;
        } else {
            eventColData[count].order = 0;
        }
    }

    var newColOrder = [];

    for(var count=1; count < eventColOrder.length; count++) {
        var key = eventColOrder[count];
        if(eventColData[key]) {
            newColOrder[newColOrder.length] = key;
        }
    }
    return newColOrder;
}

function eventColNormaliseOrder() {
    var eventColOrder = eventColOrderArray();

    var eventOrderCount = 1;
    for(var count=0; count < eventColOrder.length; count++) {
        eventColData[eventColOrder[count]].order = eventOrderCount;
        eventOrderCount++;
    }
}

function eventColAdd() {
    if(!eventColRowSelected) { return false; }
    var maxOrder = 0;
    for(var count=0; count < eventColData.length; count++) {
        if(eventColData[count].order > maxOrder) maxOrder = parseInt(eventColData[count].order);
    }
    maxOrder++;
    for(var count=0; count < eventColData.length; count++) {
        if(parseInt(eventColRowSelected.colId) === parseInt(eventColData[count].id)) {
            eventColData[count].active = 1;
            eventColData[count].order = maxOrder;
        }
    }

    eventColNormaliseOrder();
    eventColRegenerate();
}

function eventColRemove() {
    if(!eventColRowSelected) { return false; }

    for(var count=0; count < eventColData.length; count++) {
        if(parseInt(eventColRowSelected.colId) === parseInt(eventColData[count].id)) {
            eventColData[count].active = 0;
        }
    }
    eventColNormaliseOrder();
    eventColRegenerate();
}

function eventColSwapOrder(key1, key2) {
    var temp = eventColData[key1].order;
    eventColData[key1].order = eventColData[key2].order;
    eventColData[key2].order = temp;
}

function eventColMove(direction) {
    if(!eventColRowSelected) { return false; }

    var colOrder = eventColOrderArray();
    var colFirst = colOrder[0];

    for(var count=0; count < colOrder.length; count++) {
        var key = colOrder[count];
        if(parseInt(eventColRowSelected.colId) === parseInt(eventColData[key].id)) {
            if(!direction) {
                if(count !== 0) {
                    eventColSwapOrder(key,colOrder[count-1]);
                }
            } else {
                if(count < colOrder.length-1) {
                    eventColSwapOrder(key,colOrder[count+1]);
                }
            }
        }
    }

    eventColNormaliseOrder();
    eventColRegenerate();
}

function eventColUp() {
    eventColMove();
}

function eventColDown() {
    eventColMove(true);
}

var dateObj = "";

function openCal(obj,e) {
    dateObj = obj;
    screenPosX = getClickPosition(e,'x');
    screenPosY = getClickPosition(e,'y');
    openPopup('/resource/Resrequest/Application/public/html/calendar.htm',300,185,screenPosX,screenPosY);
}

function chartSelectAll(chkName,mode) {
    var checkboxes = document.getElementsByName(chkName + "Check");
    var count = checkboxes.length;
    for ( var i = 0; i < count; i++ ) {
        if ( mode == 1 ) {
            checkboxes[i].checked = true;
        } else {
            checkboxes[i].checked = false;
        }
    }
}

function addAgent(val1, val2){
    if(val2==true){
        contacts.push(val1);
    }
    else{
        for(var i=0;i<contacts.length;i++){
            if(contacts[i]==val1){
                contacts[i]='';
            }
        }
    }
}

function sendEmailToContact() {
    chkName = 'persona';
    var contacts = new Array();
    var checkboxes = document.getElementsByName(chkName + "Check");
    var count = checkboxes.length;
    var chk = 0;
    for ( var i = 0; i < count; i++ ) {
        if ( checkboxes[i].checked == true ) {
            chk = 1;
            contacts.push(checkboxes[i].value);
        }
    }

    if(chk==0){
        openMessage("Tick at least one contact to send email, then click send email");
    }

    if(chk==1) {
        contactList	=	contacts.join("-");
        url = buildURL(12);
        url	=	url+ "+" + contactList;
        if(url) {
            id("url").value = url;
            id("urlForm").target = "pdfWin";
            pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Loading email popup...",595,424,0,0,0,0,"pdfWin","opener.id('urlForm').submit();");
        }
    }
}

function addEvent(pr_persona_id) {
    openPopup("reservation.php?389++"+pr_persona_id,400,250);
}

function addEventToContact() {
    var contacts = new Array();
    chkName = 'persona';
    var checkboxes = document.getElementsByName(chkName + "Check");
    var count = checkboxes.length;
    var chk = 0;
    for ( var i = 0; i < count; i++ ) {
        if ( checkboxes[i].checked == true ) {
            chk = 1;
            contacts.push(checkboxes[i].value);
        }
    }

    if(chk==0){
        openMessage("Tick at least one contact to add event.");
    }

    if(chk==1) {
        contactList	=	contacts.join(":");
        openPopup("reservation.php?389++"+contactList,400,250);
    }
}



function showRadioClick() {
    if(id("showAll").checked) {
        id("showAgentFilters").className = "collapse printCollapse";
    } else {
        id("showAgentFilters").className = "expand";
    }
}

function getShowRadio() {
    if(id("showAgents").checked) {
        return "agents";
    }
    if(id("showAgentContacts").checked) {
        return "agentContacts";
    }
    return "all";
}
