function initialisePage() {
	var enabledButtons = ["Back","Forward","Refresh","Print","Calendar","Internet","Home","Help","NewWindow"];
	dateSelector();
	initTop();
	enableButtons(enabledButtons);
	
	// Set details for print header
	id("user").innerHTML = FirstName + " " + LastName;
	id("server").innerHTML = Domain;

	if ( id('filters').className == 'expand' ) {
		id("fromDay").focus();
	}
	
	// Set date fields
	populateDateFields("fromYear", _fromY, "fromMonth", _fromM, "fromDay", _fromD);
	populateDateFields("toYear", _toY, "toMonth", _toM, "toDay", _toD);
	populateDateFields("fromLedgerYear", _fromLedgerY, "fromLedgerMonth", _fromLedgerM, "fromLedgerDay", _fromLedgerD);
	populateDateFields("toLedgerYear", _toLedgerY, "toLedgerMonth", _toLedgerM, "toLedgerDay", _toLedgerD);

	toggleDateFilters();
}

function changeBillingUnit() {
	var urlArray = [
		/*  0 */ "reservation.php?295",
		/*  1 */ selValue("billingUnitId")
	];

	var url = urlArray.join("+");

	id("urlForm").target = "";
	id("url").value = url;
	id("urlForm").action = "reservation.php?" + jobId;
	id("urlForm").submit();
}

function buildDate(prefix) {
	dayValue = id(prefix+"Day").options[id(prefix+"Day").selectedIndex].value;
	monthValue = id(prefix+"Month").options[id(prefix+"Month").selectedIndex].value;

	dayValue = dayValue<10?"0"+dayValue:dayValue;
	monthValue = monthValue<10?"0"+monthValue:monthValue;
	 
	resultDate = id(prefix+"Year").value+"-"+monthValue+"-"+dayValue;
      
	if(dayValue < 1) { 
		id(prefix+"Day").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(monthValue < 1) {
		id(prefix+"Month").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(id(prefix+"Year").value == "") {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;		 
	 }		 
	if(id(prefix+"Year").value.search(/^\d{4}$/) == -1) {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}

	return resultDate;
}  


function buildURL(renderOption) {
	var dateRange = id("dateRangeCreation").checked?"1":"2";

	var fromDate = buildDate("from");
	var toDate = buildDate("to");

	var fromLedgerDate = buildDate("fromLedger");
	var toLedgerDate = buildDate("toLedger");

	renderOption &= 7;
	_urlCount++;

	var url = [
		/*  0 */ "reservation.php?" + jobId,
		/*  1 */ selValue("billingUnitId"),
		/*  2 */ id("batchIds").value,
		/*  3 */ id("serverIds").value,
		/*	4 */ dateRange,
		/*  5 */ fromDate,
		/*  6 */ toDate,
		/*  7 */ fromLedgerDate,
		/*  8 */ toLedgerDate,
		/*  9 */ id("invoiceRangeCheck").checked?"1":"0",
		/* 10 */ selValue("invoiceDB"),
		/* 11 */ selValue("invoicePrefix"),
		/* 12 */ id("invoiceFrom").value,
		/* 13 */ id("invoiceTo").value,
		/* 14 */ id("paymentRangeCheck").checked?"1":"0",
		/* 15 */ selValue("paymentDB"),
		/* 16 */ id("paymentFrom").value,
		/* 17 */ id("paymentTo").value,
		/* 18 */ renderOption.toString(),
		/* 19 */ _randomId + "_" + _urlCount.toString()
	];
	return url.join("+");
}

function generateReport() {
	url = buildURL();
	if(url) {
		id("urlForm").target = "_self";
		id("url").value = url;
		wait.show();
		id("urlForm").submit();
	}
}

function openCSV() {
	url = buildURL(4);
	if(url) {
		id("urlForm").target = "_self";
		id("url").value = url;
		id("urlForm").submit();
	}
}

function openPDF(){
	url = buildURL(1);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading PDF...",640,480,0,0,0,1,"pdfWin","opener.id('urlForm').submit();");
	}
}

function sendPDF(){
	url = buildURL(2);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Loading email popup...",775,615,0,0,0,0,"pdfWin","opener.id('urlForm').submit();");
	}
}

function showHideFilters(){
	var filters = id("filters");
	var filterBut = id("filterBut");
	
	mnuInitialise = false;
	
	if(filters.className == "collapse printCollapse") {
		filters.className = "expand";
		filterBut.value = "<< Hide Filters";
	} else {
		filters.className = "collapse printCollapse";
		filterBut.value = ">> Show Filters";
	}
}

function openFilter(filter,filterId){
	var selectedArray = id(filter + "Ids").value;

	url = "reservation.php?661+"
		+ filter
		+ "+"
		+ selectedArray
		+ "+"
		+ filterId;

	openPopup(url,280,360);
}

function setDebtorCash() {
	var items = document.getElementsByName("debtorCheck");

	for(count=0; count<items.length; count++) {
		var item = items[count];
		if(item.checked) {
			var pr_persona_id = item.id.toString().replace("Check","");
			id(pr_persona_id+"Code").value = cashDebtorCode;
		}		
	}
}

function setDebtorContactId() {
	var items = document.getElementsByName("debtorCheck");

	for(count=0; count<items.length; count++) {
		var item = items[count];
		if(item.checked) {
			var pr_persona_id = item.id.toString().replace("Check","");
			id(pr_persona_id+"Code").value = pr_persona_id;
		}		
	}
}

function setDebtorExisting() {
	var items = document.getElementsByName("debtorCheck");

	for(count=0; count<items.length; count++) {
		var item = items[count];
		if(item.checked) {
			var pr_persona_id = item.id.toString().replace("Check","");
			id(pr_persona_id+"Code").value = id(pr_persona_id+"Existing").value;
		}		
	}
}

function setAll(state) {
	var items = document.getElementsByName("debtorCheck");

	for(count=0; count<items.length; count++) {
		var item = items[count];
		item.checked = state;
	}
}

function buildDebtorCodes() {
	var items = document.getElementsByName("debtorCheck");

	var serialized = "a:" + items.length.toString() + ":{";
	for(count=0; count<items.length; count++) {
		var item = items[count];

		var pr_persona_id = item.id.toString().replace("Check","");
		serialized += "s:" + pr_persona_id.length + ":\"" + pr_persona_id + "\";";

		serialized += "a:3:{";

		serialized += "s:10:\"debtorCode\";";
		var code = id(pr_persona_id+"Code").value;
		serialized += "s:" + code.length + ":\"" + code + "\";";

		serialized += "s:10:\"currencyId\";";
		var currency = id(pr_persona_id+"CurrencyId").value;
		serialized += "s:" + currency.length + ":\"" + currency + "\";";

		serialized += "s:12:\"transactions\";";
		var transactions = id(pr_persona_id+"Transactions").value;
		serialized += "s:" + transactions.length + ":\"" + transactions + "\";";

		serialized += "}";
	}
	serialized += "}";
	return serialized;
}

function updateDebtorCodes() {
	id("debtorCodes").value = buildDebtorCodes();
	generateReport();
}

var debtorSearchPersona;
function debtorSearch(e,pr_persona_id) {
	if(id("divDebtorSearch").style.display != "" || pr_persona_id != debtorSearchPersona) {
		var codeObj = id(pr_persona_id + "Code");
		var divTop = getTop(codeObj) + codeObj.offsetHeight;
		var divLeft = getLeft(codeObj);

		id("divDebtorSearch").style.top = divTop;
		id("divDebtorSearch").style.left = divLeft;
		id("divDebtorSearch").style.display = "";
		debtorSearchPersona = pr_persona_id;
	} else {
		id("divDebtorSearch").style.display = "none";
	}

	e.cancelBubble = true;
}

function debtorSearchSelect(code) {
	id(debtorSearchPersona + "Code").value = code;
}

var currencySearchPersona;
function currencySearch(e,pr_persona_id) {
	if(id("divCurrencySearch").style.display != "" || pr_persona_id != currencySearchPersona) {
		var nameObj = id(pr_persona_id + "CurrencyName");
		var divTop = getTop(nameObj) + nameObj.offsetHeight;
		var divLeft = getLeft(nameObj);

		id("divCurrencySearch").style.top = divTop;
		id("divCurrencySearch").style.left = divLeft;
		id("divCurrencySearch").style.display = "";
		currencySearchPersona = pr_persona_id;
	} else {
		id("divCurrencySearch").style.display = "none";
	}

	e.cancelBubble = true;
}

function currencySearchSelect(code,name) {
	id(currencySearchPersona + "CurrencyName").value = name;
	id(currencySearchPersona + "CurrencyId").value = code;
}

function click() {
	id("divDebtorSearch").style.display = "none";
	id("divCurrencySearch").style.display = "none";
}

function invoiceRangeCheckClick() {
	if(id("invoiceRangeCheck").checked) {
		if(id("invoiceFrom").value == "") {
			id("invoiceFrom").value = "1";
		}
		if(id("invoiceTo").value == "") {
			id("invoiceTo").value = "999999";
		}
		id("invoiceFrom").disabled = false;
		id("invoiceTo").disabled = false;
	} else {
		id("invoiceFrom").value = "";
		id("invoiceTo").value = "";
		id("invoiceFrom").disabled = true;
		id("invoiceTo").disabled = true;
	}
}

function paymentRangeCheckClick() {
	if(id("paymentRangeCheck").checked) {
		if(id("paymentFrom").value == "") {
			id("paymentFrom").value = "1";
		}
		if(id("paymentTo").value == "") {
			id("paymentTo").value = "999999";
		}
		id("paymentFrom").disabled = false;
		id("paymentTo").disabled = false;
	} else {
		id("paymentFrom").value = "";
		id("paymentTo").value = "";
		id("paymentFrom").disabled = true;
		id("paymentTo").disabled = true;
	}
}

function batchFilterHasUnallocated() {
	// no batch filter applied would include unallocated
	if(id("batchIds").value === "") {
		return true;
	}

	// the string "0" also means unallocated
	var ids = id("batchIds").value.split(":");
	for(var count=0; count<ids.length; count++) {
		if(ids[count] === "0") {
			return true;
		}
	}
	return false;
}

function toggleDateFilters() {
	if(batchFilterHasUnallocated()) {
		id("dateRangeCreation").disabled = false;
		id("fromDay").disabled = false;
		id("fromMonth").disabled = false;
		id("fromYear").disabled = false;
		id("toDay").disabled = false;
		id("toMonth").disabled = false;
		id("toYear").disabled = false;
		id("dateRangeCreationRow").onmouseover = function() {};
		id("dateRangeCreationRow").onmouseout = function() {};

		id("dateRangeLedger").disabled = false;
		id("fromLedgerDay").disabled = false;
		id("fromLedgerMonth").disabled = false;
		id("fromLedgerYear").disabled = false;
		id("toLedgerDay").disabled = false;
		id("toLedgerMonth").disabled = false;
		id("toLedgerYear").disabled = false;
		id("dateRangeLedgerRow").onmouseover = function() {};
		id("dateRangeLedgerRow").onmouseout = function() {};
	} else {
		id("dateRangeCreation").disabled = true;
		id("fromDay").disabled = true;
		id("fromMonth").disabled = true;
		id("fromYear").disabled = true;
		id("toDay").disabled = true;
		id("toMonth").disabled = true;
		id("toYear").disabled = true;
		id("dateRangeCreationRow").onmouseover = function() {
			overlib("Date range filters only apply when the batch filter includes unallocated items");
		};
		id("dateRangeCreationRow").onmouseout = function() { nd(); };

		id("dateRangeLedger").disabled = true;
		id("fromLedgerDay").disabled = true;
		id("fromLedgerMonth").disabled = true;
		id("fromLedgerYear").disabled = true;
		id("toLedgerDay").disabled = true;
		id("toLedgerMonth").disabled = true;
		id("toLedgerYear").disabled = true;
		id("dateRangeLedgerRow").onmouseover = function() {
			overlib("Date range filters only apply when the batch filter includes unallocated items");
		};
		id("dateRangeLedgerRow").onmouseout = function() { nd(); };
	}
}

function onAfterFilter() {
	toggleDateFilters();
}
