function initialisePage(){
	dateSelector();
	initTop();
	enableButtons(enabledButtons);
	levelChange();

	// get print info
	id("user").innerHTML = FirstName + " " + LastName;
	id("server").innerHTML = Domain;
	id("genDate").innerHTML = genDateVal;	
	
	populateDateFields("invFromYear", invFromY, "invFromMonth", invFromM, "invFromDay", invFromD);
	populateDateFields("invToYear", invToY, "invToMonth", invToM, "invToDay", invToD);
	populateDateFields("payToYear", payToY, "payToMonth", payToM, "payToDay", payToD);
	populateDateFields("trvlFromYear", trvlFromY, "trvlFromMonth", trvlFromM, "trvlFromDay", trvlFromD);
	populateDateFields("trvlToYear", trvlToY, "trvlToMonth", trvlToM, "trvlToDay", trvlToD);

	folioDetailColRegenerate();
	folioAmountsColRegenerate();
	toggleUnInvOpt();
	showBal();
	toggleBalance();
	changeDisplayCurr();
}

function generateReport(renderOption,sortOption) {
	var url = buildURL(renderOption,sortOption);
	if(url) {
		id("urlForm").target = "";
		id("url").value = url
		id("urlForm").action = "reservation.php?" + jobId;
		id("urlForm").submit();
	}
}

function buildDate(prefix) {
	dayValue = id(prefix+"Day").options[id(prefix+"Day").selectedIndex].value;
	monthValue = id(prefix+"Month").options[id(prefix+"Month").selectedIndex].value;

	dayValue = dayValue<10?"0"+dayValue:dayValue;
	monthValue = monthValue<10?"0"+monthValue:monthValue;
	 
	resultDate = id(prefix+"Year").value+"-"+monthValue+"-"+dayValue;
      
	if(dayValue < 1) { 
		id(prefix+"Day").focus();
		openMessage("Enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(monthValue < 1) {
		id(prefix+"Month").focus();
		openMessage("Enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(id(prefix+"Year").value == "") {
		id(prefix+"Year").focus();
		openMessage("Enter a valid "+prefix+" date","a",100);
		return false;		 
	 }		 
	if(id(prefix+"Year").value.search(/^\d{4}$/) == -1) {
		id(prefix+"Year").focus();
		openMessage("Enter a valid "+prefix+" date","a",100);
		return false;
	}

	return resultDate;
}  

function buildURL(renderOption) {
	groups = new Array();
	for(var count=0; count<groupCount; count++) {
		groups.push(selValue("groupBy" + count.toString()));
	}	
	
	invoiceStatus = 0;
	if(id("showInvoiced").checked) {
		invoiceStatus += 1;
	}
	if(id("showUninvoiced").checked) {
		invoiceStatus += 2;
	}

	if(id("agentNameRadio").checked) {
		agentFilterType = "1";
	} else {
		agentFilterType = "2";
	}

	if(id("invDateRangeOptCustomDate").checked) {
		if(!buildDate("invFrom") || !buildDate("invTo") ) {
			return false;
		}
	}
	
	if(id("payDateRangeOptCustomDate").checked) {
		if(!buildDate("payTo") ) {
			return false;
		}
	}
	
	if(id("trvlDateRangeOptCustomDate").checked) {
		if(!buildDate("trvlFrom") || !buildDate("trvlTo") ) {
			return false;
		}
	}	
	
	if(id("invDateRangeOptAll").checked) {
		invFromDate = "all";
		invToDate = "all";
	} else if (id("invDateRangeOptToday").checked) {
		invFromDate = "today";
		invToDate = "today";
	} else {
		invFromDate = buildDate("invFrom");
		invToDate = buildDate("invTo");
	}
	
	if(id("payDateRangeOptToday").checked) {
		payToDate = "today";
	} else {
		payToDate = buildDate("payTo");
	}
	
	if(id("trvlDateRangeOptAll").checked) {
		trvlFromDate = "all";
		trvlToDate = "all";
	} else {
		trvlFromDate = buildDate("trvlFrom");
		trvlToDate = buildDate("trvlTo");
	}	

	if(invToDate < invFromDate) {
		openMessage("Invalid invoice date range","a",120);
		return false;		
	}	
	
	if(payToDate < payFromDate) {
		openMessage("Invalid payment date range","a",120);
		return false;		
	}	
	
	if(trvlToDate < trvlFromDate) {
		openMessage("Invalid travel date range","a",120);
		return false;		
	}	

	if(id("checkOutstandingLimit").checked) {
		if(isNaN(parseInt(id("outstandingLimit").value,10))) {
			id("outstandingLimit").focus();
			openMessage("Enter a value limit for the outstanding amount");
			return false;
		}
	}
	if(id("checkOverpaidLimit").checked) {
		if(isNaN(parseInt(id("overpaidLimit").value,10))) {
			id("overpaidLimit").focus();
			openMessage("Enter a value limit for the overpaid amount");
			return false;
		}
	}
	
	
	var folioDetailCols = buildFolioDetailCols();
	var folioAmountsCols = buildFolioAmountsCols();
	
	var url = [
		/*  0 */ "reservation.php?" + jobId,
		/*  1 */ invFromDate,
		/*  2 */ invToDate,
		/*  3 */ id("folioContactIds").value,
		/*  4 */ agentFilterType,
		/*  5 */ id("agentIds").value,
		/*  6 */ id("agentCountryIds").value,
		/*  7 */ id("originatorIds").value,
		/*  8 */ id("sourceIds").value,
		/*  9 */ id("createdByIds").value,
		/* 10 */ id("nationalityIds").value,		
		/* 11 */ id("rateIds").value,
		/* 12 */ id("statusIds").value,
		/* 13 */ id("paymentPlanIds").value,
		/* 14 */ invoiceStatus,
		/* 15 */ "",
		/* 16 */ "",		
		/* 17 */ id("folioCurrencyIds").value,
		/* 18 */ "",
		/* 19 */ "",
		/* 20 */ groups.join(":"),
		/* 21 */ folioDetailCols,
		/* 22 */ folioAmountsCols,
		/* 23 */ "",
		/* 24 */ trvlFromDate,
		/* 25 */ trvlToDate,
		/* 26 */ selValue("pr_business_id"),
		/* 27 */ id("checkOutstanding").checked?"1":"0",
		/* 28 */ id("checkOutstandingLimit").checked?"1":"0",
		/* 29 */ id("outstandingLimit").value,
		/* 30 */ id("checkOverpaid").checked?"1":"0",
		/* 31 */ id("checkOverpaidLimit").checked?"1":"0",
		/* 32 */ id("overpaidLimit").value,
		/* 33 */ id("checkPaid").checked?"1":"0",
		/* 34 */ ,
		/* 35 */ selValue("outstandingLimitType"),
		/* 36 */ selValue("overpaidLimitType"),
		/* 37 */ id("checkBalance").checked?"1":"0",
		/* 38 */ id("checkUnInvChargeable").checked?"1":"0",
		/* 39 */ id("checkUnInvPaid").checked?"1":"0",
		/* 40 */ renderOption,
		/* 41 */ id("serverIds").value,
		/* 42 */ selValue("display_currency"),
		/* 43 */ id("checkNonzero").checked?"1":"0",
		/* 44 */ payToDate	
	];
	return url.join("+");
}

function invDateTypeChange() {
	if (!id("invDateRangeOptCustomDate").checked ) {
		id("invFromDay").selectedIndex = 0;
		id("invFromMonth").selectedIndex = 0;
		id("invFromYear").value = "";

		id("invToDay").selectedIndex = 0;
		id("invToMonth").selectedIndex = 0;
		id("invToYear").value = "";
	} else {
		id("invFromDay").selectedIndex = invFromD;
		id("invFromMonth").selectedIndex = invFromM;
		id("invFromYear").value = invFromY;
		id("invToDay").selectedIndex = invToD;
		id("invToMonth").selectedIndex = invToM;
		id("invToYear").value = invToY;		
		
	}
	return true;
}

function payDateTypeChange() {
	if (!id("payDateRangeOptCustomDate").checked ) {

		id("payToDay").selectedIndex = 0;
		id("payToMonth").selectedIndex = 0;
		id("payToYear").value = "";
	} else {
		id("payToDay").selectedIndex = payToD;
		id("payToMonth").selectedIndex = payToM;
		id("payToYear").value = payToY;		
	}
	return true;
}

function trvlDateTypeChange() {
	if (!id("trvlDateRangeOptCustomDate").checked ) {
		id("trvlFromDay").selectedIndex = 0;
		id("trvlFromMonth").selectedIndex = 0;
		id("trvlFromYear").value = "";

		id("trvlToDay").selectedIndex = 0;
		id("trvlToMonth").selectedIndex = 0;
		id("trvlToYear").value = "";
	} else {
		id("trvlFromDay").selectedIndex = trvlFromD;
		id("trvlFromMonth").selectedIndex = trvlFromM;
		id("trvlFromYear").value = trvlFromY;
		id("trvlToDay").selectedIndex = trvlToD;
		id("trvlToMonth").selectedIndex = trvlToM;
		id("trvlToYear").value = trvlToY;		
		
	}
	return true;
}

function emptyTable(objId) {
	var obj = id(objId);
	for(var count=obj.rows.length-1;count > -1; count--) {
		obj.deleteRow(count);
	}
}

/*  [START] Folio Details Report Builder Functions */

function buildFolioDetailCols() {
	var cols = [];
	for(var count=0; count<folioDetailColData.length; count++) {
		var cWidth = folioDetailColData[count].width;
		var cSort = folioDetailColData[count].sort;
		var cLabel = folioDetailColData[count].label;
		var cHeader = folioDetailColData[count].header;
		var cAlign = folioDetailColData[count].align;
		var cObjType = folioDetailColData[count].objType;
		var cGuestId = folioDetailColData[count].rf_obj_trip_ix;
		var cSplit = folioDetailColData[count].split;
		
		if(folioDetailColData[count].active == "1") {
			cWidth = id("folioDetailCol_width_" + folioDetailColData[count].id).value;
			cSort = selValue("folioDetailCol_sort_" + folioDetailColData[count].id);
			cLabel = id("folioDetailCol_label_" + folioDetailColData[count].id).value;
			cHeader = id("folioDetailCol_header_" + folioDetailColData[count].id).value;
			cAlign = selValue("folioDetailCol_align_" + folioDetailColData[count].id);
			cObjType = id("folioDetailCol_objType_" + folioDetailColData[count].id).value;
			if(cObjType == 3 || cObjType == 4 || cObjType == 5) {
				cSplit = id("folioDetailCol_split_" + folioDetailColData[count].id).checked?"1":"";
			}
		}
		var col = [
			folioDetailColData[count].active,
			folioDetailColData[count].order,
			cSort,
			cWidth,
			cLabel,
			cHeader,
			cAlign,
			cObjType,
			cGuestId,
			cSplit
		]
		cols[cols.length] = col.join(",");     //cSort, cDirection,
	}
	return cols.join(":");
}


var folioDetailColRowSelected = false;

function folioDetailColRow(cObjId,cId,cLabel,cSelected) {
	var row = id(cObjId).insertRow(-1);
	row.tableName = cObjId;
	row.colId = cId;
	row.onmouseover = function() {
		this.style.backgroundColor = "#cfc";
	}
	row.onmouseout = function() {
		if(folioDetailColRowSelected == this) {
			this.style.backgroundColor = "#31ff63";
		} else {
			this.style.backgroundColor = "";
		}
	}
	row.onclick = function(e,force) {
		if(folioDetailColRowSelected != this || (folioDetailColRowSelected == this && force) ) {
			if(folioDetailColRowSelected) {
				folioDetailColRowSelected.style.backgroundColor = "";
				folioDetailColRowSelected.firstChild.style.fontWeight = "";
			}
			folioDetailColRowSelected = this;
			this.firstChild.style.fontWeight = "bold";
			if(this.style.backgroundColor == "") {
				this.style.backgroundColor = "#31ff63";
			}
			if(this.tableName == "tblInactiveFolioDetailCol") {
				id("btnFolioDetailColAdd").disabled = false;
				id("btnFolioDetailColRemove").disabled = true;
				id("btnFolioDetailColUp").disabled = true;
				id("btnFolioDetailColDown").disabled = true;
			} else {
				id("btnFolioDetailColAdd").disabled = true;
				id("btnFolioDetailColRemove").disabled = false;
				id("btnFolioDetailColUp").disabled = false;
				id("btnFolioDetailColDown").disabled = false;
			}
		} else {
			folioDetailColRowSelected = false;
			this.firstChild.style.fontWeight = "";
			id("btnFolioDetailColAdd").disabled = true;
			id("btnFolioDetailColRemove").disabled = true;
			id("btnFolioDetailColUp").disabled = true;
			id("btnFolioDetailColDown").disabled = true;
		}
	}

	// name
	var cell = row.insertCell(-1);
	cell.innerHTML = cLabel;
	cell.className = "imgLink";
	if(folioDetailColData[cId-1].disable == '1') {
		cell.style.backgroundColor = "#999";
	}
	cell.style.width = "100%";
	if(cObjId == "tblInactiveFolioDetailCol") {
		cell.style.whiteSpace = "nowrap";
	}

	if(cObjId == "tblActiveFolioDetailCol") {
		// label
		cell = row.insertCell(-1);
		//cell.style.width = "105px";
		cell.innerHTML = "<input type=\"text\" id=\"folioDetailCol_label_" + cId + "\" style=\"width:95px;\" value=\""+folioDetailColData[cId-1].label+"\"/><input type=\"hidden\" id=\"folioDetailCol_objType_" + cId + "\" value=\""+folioDetailColData[cId-1].objType+"\"/><input type=\"hidden\" id=\"folioDetailCol_rf_obj_trip_ix_" + cId + "\" value=\""+folioDetailColData[cId-1].rf_obj_trip_ix+"\"/>";
	
		//split
		if(folioDetailColData[cId-1].objType=='3' || folioDetailColData[cId-1].objType=='4' || folioDetailColData[cId-1].objType=='5') {
			var splitChecked = "";
			if(folioDetailColData[cId-1].split == 1) {
				splitChecked = "checked";
			}
			cell = row.insertCell(-1);
			//cell.style.width = "40px";
			cell.innerHTML = "<input type=\"checkbox\" id=\"folioDetailCol_split_" + cId + "\" name=\"splitCheck\"  value=\""+folioDetailColData[cId-1].split+"\" "+splitChecked+"/>";
		} else {
			cell = row.insertCell(-1);
		}

	// width
		cell = row.insertCell(-1);
		//cell.style.width = "40px";
		cell.innerHTML = "<input type=\"text\" id=\"folioDetailCol_width_" + cId + "\" style=\"width:28px;\" value=\""+folioDetailColData[cId-1].width+"\"/>";
		
		//sort
		cell = row.insertCell(-1);
		//cell.style.width = "65px";
		cell.innerHTML = "<select id=\"folioDetailCol_sort_" + cId + "\" style=\"width:35px;\">"+folioDetailColSortOptions+"</select><select id=\"folioDetailCol_sort_direction_" + cId + "\" style=\"width:43px;\"><option value=\"a\">Ascending</option><option value=\"d\">Descending</option></select>";

		if(folioDetailColData[cId-1].sort != "") {
			id("folioDetailCol_sort_" + cId).selectedIndex = parseInt(folioDetailColData[cId-1].sort,10);
		}

		if(folioDetailColData[cId-1].direction == "d") {
			id("folioDetailCol_sort_direction_" + cId).selectedIndex = 1;
		}
		
		//Group Header
		cell = row.insertCell(-1);
		//cell.style.width = "100px";
		cell.innerHTML = "<input type=\"text\" id=\"folioDetailCol_header_" + cId + "\" style=\"width:90px\" value=\""+folioDetailColData[cId-1].header+"\"/>";

		//Align
		cell = row.insertCell(-1);
		//cell.style.width = "45px";
		cell.innerHTML = "<select id=\"folioDetailCol_align_" + cId + "\" style=\"width:48px\"><option value=\"l\">Left</option><option value=\"c\">Centre</option><option value=\"r\">Right</option></select>";

		var align = folioDetailColData[cId-1].align;
		if(align == "c") {
			id("folioDetailCol_align_"+cId).selectedIndex = 1;
		} 
		if(align == "r") {
			id("folioDetailCol_align_"+cId).selectedIndex = 2;
		}
	}
	
	if(cSelected) {
		folioDetailColRowSelected = row;
		row.onclick(false,true);
	}
	
}

var folioDetailColSortOptions = "";
function folioDetailColRegenerate() {
	if(folioDetailColRowSelected != false) {
		var folioDetailColRowSelectedId = folioDetailColRowSelected.colId;
	}
	emptyTable("tblInactiveFolioDetailCol");
	emptyTable("tblActiveFolioDetailCol");

	var folioDetailColSort = [];
	var sortCount = 1;
	folioDetailColSortOptions = "<option value=\"\"></option>";
	for(var count=0; count < folioDetailColData.length; count++) {
		folioDetailColSortOptions += "<option value=\"" + sortCount.toString() + "\">" + sortCount.toString() + "</option>";
		sortCount++;
	}
	for(var count=0; count < folioDetailColData.length; count++) {
		if(folioDetailColData[count].active != "1") {
			var selected = false;
			if(folioDetailColData[count].id == folioDetailColRowSelectedId) {
				selected = true;
			}
			folioDetailColRow("tblInactiveFolioDetailCol",folioDetailColData[count].id,folioDetailColData[count].name,selected);
		} else {
			folioDetailColSort[folioDetailColData[count].order] = count;
		}
	}

	for(var count=1; count < folioDetailColSort.length; count++) {
		var selected = false;
		if(folioDetailColData[folioDetailColSort[count]].id == folioDetailColRowSelectedId) {
			selected = true;
		}
		folioDetailColRow("tblActiveFolioDetailCol",folioDetailColData[folioDetailColSort[count]].id,folioDetailColData[folioDetailColSort[count]].name,selected);
	}
}

function folioDetailColOrderArray() {
	var folioDetailColOrder = [];
	for(var count=0; count < folioDetailColData.length; count++) {
		if(folioDetailColData[count].active == "1") {
			folioDetailColOrder[folioDetailColData[count].order] = count;
		} else {
			folioDetailColData[count].order = 0;
		}
	}

	var newColOrder = [];

	for(var count=1; count < folioDetailColOrder.length; count++) {
		var key = folioDetailColOrder[count];
		if(folioDetailColData[key]) {
			newColOrder[newColOrder.length] = key;
		}
	}
	return newColOrder;
}

function folioDetailColNormaliseOrder() {
	var folioDetailColOrder = folioDetailColOrderArray();

	var folioDetailOrderCount = 1;
	for(var count=0; count < folioDetailColOrder.length; count++) {
		folioDetailColData[folioDetailColOrder[count]].order = folioDetailOrderCount;
		folioDetailOrderCount++;
	}
}

function folioDetailColAdd() {
	if(!folioDetailColRowSelected) { return false; }

	var maxOrder = 0;
	for(var count=0; count < folioDetailColData.length; count++) {
		if(parseInt(folioDetailColData[count].order) > parseInt(maxOrder)) { 
			maxOrder = parseInt(folioDetailColData[count].order);
		}
	}
	maxOrder++;
	
	for(var count=0; count < folioDetailColData.length; count++) {
		if(folioDetailColRowSelected.colId == folioDetailColData[count].id) {
			folioDetailColData[count].active = "1";
			folioDetailColData[count].order = maxOrder;
		}
	}	

	folioDetailColNormaliseOrder();
	folioDetailColRegenerate();
}

function folioDetailColRemove() {
	if(!folioDetailColRowSelected) { return false; }

	for(var count=0; count < folioDetailColData.length; count++) {
		if(folioDetailColRowSelected.colId == folioDetailColData[count].id) {
			folioDetailColData[count].active = "0";
		}
	}	
	folioDetailColNormaliseOrder();
	folioDetailColRegenerate();
}

function folioDetailColSwapOrder(key1, key2) {
	var temp = folioDetailColData[key1].order;
	folioDetailColData[key1].order = folioDetailColData[key2].order;
	folioDetailColData[key2].order = temp;
}

function folioDetailColMove(direction) {
	if(!folioDetailColRowSelected) { return false; }

	var colOrder = folioDetailColOrderArray();
	var colFirst = colOrder[0];
	
	for(var count=0; count < colOrder.length; count++) {
		var key = colOrder[count];
		if(folioDetailColRowSelected.colId == folioDetailColData[key].id) {
			if(!direction) {
				if(count != 0) {
					folioDetailColSwapOrder(key,colOrder[count-1]);
				}
			} else {
				if(count < colOrder.length-1) {
					folioDetailColSwapOrder(key,colOrder[count+1]);
				}
			}
		}
	}

	folioDetailColNormaliseOrder();
	folioDetailColRegenerate();
}

function folioDetailColUp() {
	folioDetailColMove();
}

function folioDetailColDown() {
	folioDetailColMove(true);
}

/*  [END] Folio Details Report Builder Functions */

/*  [START] Folio Amounts Report Builder Functions */

function buildFolioAmountsCols() {
	var cols = [];
	for(var count=0; count<folioAmountsColData.length; count++) {
		var cWidth = folioAmountsColData[count].width;
		var cSort = folioAmountsColData[count].sort;
		var cLabel = folioAmountsColData[count].label;
		var cHeader = folioAmountsColData[count].header;
		var cAlign = folioAmountsColData[count].align;
		var cObjType = folioAmountsColData[count].objType;
		var cGuestId = folioAmountsColData[count].rf_obj_trip_ix;
		var cSplit = folioAmountsColData[count].split;
		
		if(folioAmountsColData[count].active == "1") {
			cWidth = id("folioAmountsCol_width_" + folioAmountsColData[count].id).value;
			cSort = selValue("folioAmountsCol_sort_" + folioAmountsColData[count].id);
			cLabel = id("folioAmountsCol_label_" + folioAmountsColData[count].id).value;
			cHeader = id("folioAmountsCol_header_" + folioAmountsColData[count].id).value;
			cAlign = selValue("folioAmountsCol_align_" + folioAmountsColData[count].id);
			cObjType = id("folioAmountsCol_objType_" + folioAmountsColData[count].id).value;
			if(cObjType == 3 || cObjType == 4 || cObjType == 5) {
				cSplit = id("folioAmountsCol_split_" + folioAmountsColData[count].id).checked?"1":"";
			}
		}
		var col = [
			folioAmountsColData[count].active,
			folioAmountsColData[count].order,
			cSort,
			cWidth,
			cLabel,
			cHeader,
			cAlign,
			cObjType,
			cGuestId,
			cSplit
		]
		cols[cols.length] = col.join(",");     //cSort, cDirection,
	}
	return cols.join(":");
}


var folioAmountsColRowSelected = false;

function folioAmountsColRow(cObjId,cId,cLabel,cSelected) {
	var row = id(cObjId).insertRow(-1);
	row.tableName = cObjId;
	row.colId = cId;
	row.onmouseover = function() {
		this.style.backgroundColor = "#cfc";
	}
	row.onmouseout = function() {
		if(folioAmountsColRowSelected == this) {
			this.style.backgroundColor = "#31ff63";
		} else {
			this.style.backgroundColor = "";
		}
	}
	row.onclick = function(e,force) {
		if(folioAmountsColRowSelected != this || (folioAmountsColRowSelected == this && force) ) {
			if(folioAmountsColRowSelected) {
				folioAmountsColRowSelected.style.backgroundColor = "";
				folioAmountsColRowSelected.firstChild.style.fontWeight = "";
			}
			folioAmountsColRowSelected = this;
			this.firstChild.style.fontWeight = "bold";
			if(this.style.backgroundColor == "") {
				this.style.backgroundColor = "#31ff63";
			}
			if(this.tableName == "tblInactiveFolioAmountsCol") {
				id("btnFolioAmountsColAdd").disabled = false;
				id("btnFolioAmountsColRemove").disabled = true;
				id("btnFolioAmountsColUp").disabled = true;
				id("btnFolioAmountsColDown").disabled = true;
			} else {
				id("btnFolioAmountsColAdd").disabled = true;
				id("btnFolioAmountsColRemove").disabled = false;
				id("btnFolioAmountsColUp").disabled = false;
				id("btnFolioAmountsColDown").disabled = false;
			}
		} else {
			folioAmountsColRowSelected = false;
			this.firstChild.style.fontWeight = "";
			id("btnFolioAmountsColAdd").disabled = true;
			id("btnFolioAmountsColRemove").disabled = true;
			id("btnFolioAmountsColUp").disabled = true;
			id("btnFolioAmountsColDown").disabled = true;
		}
	}

	// name
	var cell = row.insertCell(-1);
	cell.innerHTML = cLabel;
	cell.className = "imgLink";
	if(folioAmountsColData[cId-1].disable == '1') {
		cell.style.backgroundColor = "#999";
	}
	cell.style.width = "98px";
	if(cObjId == "tblInactiveFolioAmountsCol") {
		cell.style.whiteSpace = "nowrap";
	}

	if(cObjId == "tblActiveFolioAmountsCol") {
		// label
		cell = row.insertCell(-1);
		//cell.style.width = "105px";
		cell.innerHTML = "<input type=\"text\" id=\"folioAmountsCol_label_" + cId + "\" style=\"width:97px;\" value=\""+folioAmountsColData[cId-1].label+"\"/><input type=\"hidden\" id=\"folioAmountsCol_objType_" + cId + "\" value=\""+folioAmountsColData[cId-1].objType+"\"/><input type=\"hidden\" id=\"folioAmountsCol_rf_obj_trip_ix_" + cId + "\" value=\""+folioAmountsColData[cId-1].rf_obj_trip_ix+"\"/>";
	
		//split
		if(folioAmountsColData[cId-1].objType=='3' || folioAmountsColData[cId-1].objType=='4' || folioAmountsColData[cId-1].objType=='5') {
			var splitChecked = "";
			if(folioAmountsColData[cId-1].split == 1) {
				splitChecked = "checked";
			}
			cell = row.insertCell(-1);
			//cell.style.width = "40px";
			cell.innerHTML = "<input type=\"checkbox\" id=\"folioAmountsCol_split_" + cId + "\" name=\"splitCheck\"  value=\""+folioAmountsColData[cId-1].split+"\" "+splitChecked+"/>";
		} else {
			cell = row.insertCell(-1);
		}

	// width
		cell = row.insertCell(-1);
		//cell.style.width = "40px";
		cell.innerHTML = "<input type=\"text\" id=\"folioAmountsCol_width_" + cId + "\" style=\"width:28px;\" value=\""+folioAmountsColData[cId-1].width+"\"/>";
		
		//sort
		cell = row.insertCell(-1);
		//cell.style.width = "65px";
		cell.innerHTML = "<select id=\"folioAmountsCol_sort_" + cId + "\" style=\"width:35px;\">"+folioAmountsColSortOptions+"</select><select id=\"folioAmountsCol_sort_direction_" + cId + "\" style=\"width:43px;\"><option value=\"a\">Ascending</option><option value=\"d\">Descending</option></select>";

		if(folioAmountsColData[cId-1].sort != "") {
			id("folioAmountsCol_sort_" + cId).selectedIndex = parseInt(folioAmountsColData[cId-1].sort,10);
		}

		if(folioAmountsColData[cId-1].direction == "d") {
			id("folioAmountsCol_sort_direction_" + cId).selectedIndex = 1;
		}
		
		//Group Header
		cell = row.insertCell(-1);
		//cell.style.width = "100px";
		cell.innerHTML = "<input type=\"text\" id=\"folioAmountsCol_header_" + cId + "\" style=\"width:90px\" value=\""+folioAmountsColData[cId-1].header+"\"/>";

		//Align
		cell = row.insertCell(-1);
		//cell.style.width = "45px";
		cell.innerHTML = "<select id=\"folioAmountsCol_align_" + cId + "\" style=\"width:48px\"><option value=\"l\">Left</option><option value=\"c\">Centre</option><option value=\"r\">Right</option></select>";

		var align = folioAmountsColData[cId-1].align;
		if(align == "c") {
			id("folioAmountsCol_align_"+cId).selectedIndex = 1;
		} 
		if(align == "r") {
			id("folioAmountsCol_align_"+cId).selectedIndex = 2;
		}
	}
	
	if(cSelected) {
		folioAmountsColRowSelected = row;
		row.onclick(false,true);
	}
	
}

var folioAmountsColSortOptions = "";
function folioAmountsColRegenerate() {
	if(folioAmountsColRowSelected != false) {
		var folioAmountsColRowSelectedId = folioAmountsColRowSelected.colId;
	}
	emptyTable("tblInactiveFolioAmountsCol");
	emptyTable("tblActiveFolioAmountsCol");

	var folioAmountsColSort = [];
	var sortCount = 1;
	folioAmountsColSortOptions = "<option value=\"\"></option>";
	for(var count=0; count < folioAmountsColData.length; count++) {
		folioAmountsColSortOptions += "<option value=\"" + sortCount.toString() + "\">" + sortCount.toString() + "</option>";
		sortCount++;
	}
	for(var count=0; count < folioAmountsColData.length; count++) {
		if(folioAmountsColData[count].active != "1") {
			var selected = false;
			if(folioAmountsColData[count].id == folioAmountsColRowSelectedId) {
				selected = true;
			}
			folioAmountsColRow("tblInactiveFolioAmountsCol",folioAmountsColData[count].id,folioAmountsColData[count].name,selected);
		} else {
			folioAmountsColSort[folioAmountsColData[count].order] = count;
		}
	}

	for(var count=1; count < folioAmountsColSort.length; count++) {
		var selected = false;
		if(folioAmountsColData[folioAmountsColSort[count]].id == folioAmountsColRowSelectedId) {
			selected = true;
		}
		folioAmountsColRow("tblActiveFolioAmountsCol",folioAmountsColData[folioAmountsColSort[count]].id,folioAmountsColData[folioAmountsColSort[count]].name,selected);
	}
}

function folioAmountsColOrderArray() {
	var folioAmountsColOrder = [];
	for(var count=0; count < folioAmountsColData.length; count++) {
		if(folioAmountsColData[count].active == "1") {
			folioAmountsColOrder[folioAmountsColData[count].order] = count;
		} else {
			folioAmountsColData[count].order = 0;
		}
	}

	var newColOrder = [];

	for(var count=1; count < folioAmountsColOrder.length; count++) {
		var key = folioAmountsColOrder[count];
		if(folioAmountsColData[key]) {
			newColOrder[newColOrder.length] = key;
		}
	}
	return newColOrder;
}

function folioAmountsColNormaliseOrder() {
	var folioAmountsColOrder = folioAmountsColOrderArray();

	var folioAmountsOrderCount = 1;
	for(var count=0; count < folioAmountsColOrder.length; count++) {
		folioAmountsColData[folioAmountsColOrder[count]].order = folioAmountsOrderCount;
		folioAmountsOrderCount++;
	}
}

function folioAmountsColAdd() {
	if(!folioAmountsColRowSelected) { return false; }

	var maxOrder = 0;
	for(var count=0; count < folioAmountsColData.length; count++) {
		if(parseInt(folioAmountsColData[count].order) > parseInt(maxOrder)) { 
			maxOrder = parseInt(folioAmountsColData[count].order);
		}
	}
	maxOrder++;
	
	for(var count=0; count < folioAmountsColData.length; count++) {
		if(folioAmountsColRowSelected.colId == folioAmountsColData[count].id) {
			folioAmountsColData[count].active = "1";
			folioAmountsColData[count].order = maxOrder;
		}
	}	

	folioAmountsColNormaliseOrder();
	folioAmountsColRegenerate();
}

function folioAmountsColRemove() {
	if(!folioAmountsColRowSelected) { return false; }

	for(var count=0; count < folioAmountsColData.length; count++) {
		if(folioAmountsColRowSelected.colId == folioAmountsColData[count].id) {
			folioAmountsColData[count].active = "0";
		}
	}	
	folioAmountsColNormaliseOrder();
	folioAmountsColRegenerate();
}

function folioAmountsColSwapOrder(key1, key2) {
	var temp = folioAmountsColData[key1].order;
	folioAmountsColData[key1].order = folioAmountsColData[key2].order;
	folioAmountsColData[key2].order = temp;
}

function folioAmountsColMove(direction) {
	if(!folioAmountsColRowSelected) { return false; }

	var colOrder = folioAmountsColOrderArray();
	var colFirst = colOrder[0];
	
	for(var count=0; count < colOrder.length; count++) {
		var key = colOrder[count];
		if(folioAmountsColRowSelected.colId == folioAmountsColData[key].id) {
			if(!direction) {
				if(count != 0) {
					folioAmountsColSwapOrder(key,colOrder[count-1]);
				}
			} else {
				if(count < colOrder.length-1) {
					folioAmountsColSwapOrder(key,colOrder[count+1]);
				}
			}
		}
	}

	folioAmountsColNormaliseOrder();
	folioAmountsColRegenerate();
}

function folioAmountsColUp() {
	folioAmountsColMove();
}

function folioAmountsColDown() {
	folioAmountsColMove(true);
}

/*  [END] Folio Amounts Report Builder Functions */

function showBal() {
	if(id("checkBalance").checked) {
		id("balOptions").className = "outDk";  	
	} else {
		id("balOptions").className = "collapse printCollapse";
	}
}

function toggleBalance() {
	if(id("checkOutstanding").checked) {
		id("rowOutstanding").className = "";
	} else {
		id("rowOutstanding").className = "collapse";
	}
	if(id("checkOverpaid").checked) {
		id("rowOverpaid").className = "";
	} else {
		id("rowOverpaid").className = "collapse";
	}
}

function toggleUnInvOpt() {
	if(id("showUninvoiced").checked) {
		id("unInvoiceOptions").className = "outDk";  	
	} else {
		id("unInvoiceOptions").className = "collapse printCollapse";
	}
}

function showHideFilters() {
	var filters = id("filters");
	var filterBut = id("filterBut");

	mnuInitialise = false;

	if(filters.className == "collapse printCollapse") {
		filters.className = "expand";
		filterBut.value 	= "<< Hide Filters";
	} else {
		filters.className = "collapse printCollapse";
		filterBut.value 	= ">> Show Filters";
	}
}

function showExportMenu(e, flag) {
	if ( !e ) {
		e = window.event;
	}
	stopBubble(e);

	var posx = 0;
	var posy = 0;
	if (e.pageX || e.pageY) 	{
		posx = e.pageX;
		posy = e.pageY;
	} else if (e.clientX || e.clientY) 	{
		posx = e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
		posy = e.clientY + document.body.scrollTop + document.documentElement.scrollTop;
	}
	
	if(flag == 1) {
		posy = posy-60;
	}

	id("exportOptionDiv").style.display	= "";
	id("exportOptionDiv").style.left = posx+"px";
	id("exportOptionDiv").style.top = posy+"px";
}

function closeOptDiv() {
	id('exportOptionDiv').style.display = "none";
}

function printReport() {
	window.print();
}

function select_daymonth_changed(){
	setDayList(id("invFromDay"),id("invFromMonth").options[id("invFromMonth").selectedIndex].value,id("invFromYear").value);
	setDayList(id("invToDay"),id("invToMonth").options[id("invToMonth").selectedIndex].value,id("invToYear").value);
}

function select_travel_daymonth_changed(){
	setDayList(id("trvlFromDay"),id("trvlFromMonth").options[id("trvlFromMonth").selectedIndex].value,id("trvlFromYear").value);
	setDayList(id("trvlToDay"),id("trvlToMonth").options[id("trvlToMonth").selectedIndex].value,id("trvlToYear").value);
}

function rowOn(row) {
	row.style.backgroundColor = '#CCFFCC';
}

function rowOff(row) {
	row.style.backgroundColor = '';
}

function changeDisplayCurr(){
	if (id("showUninvoiced").checked){
		id("display_currency").selectedIndex = 0;
		id("display_currency").disabled = true;
	} else {
		id("display_currency").disabled = false;
	}
}

function sendCSV(){
	url = buildURL(5);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Loading email popup...",595,424,0,0,0,0,"pdfWin","opener.id('urlForm').submit();");
	}
}

function levelChange() {
	var count;
	for(count=0; count<groupCount; count++) {
		if(selValue("groupBy"+count.toString()) == "all") {
			break;
		}
	}
	if (id("groupBy"+count.toString())){
		id("groupBy"+count.toString()).disabled = false;
		count++;
	}
	for(;count<groupCount;count++) {
		id("groupBy"+count.toString()).selectedIndex = 0;
		id("groupBy"+count.toString()).disabled = true;
	}
}