function initialisePage(){
	dateSelector();
	initTop();
	enableButtons(enabledButtons);

	// get print info
	id("user").innerHTML = FirstName + " " + LastName;
	id("server").innerHTML = Domain;
	id("genDate").innerHTML = genDateVal;	

	populateDateFields("fromYear", fromY, "fromMonth", fromM, "fromDay", fromD);
	populateDateFields("toYear", toY, "toMonth", toM, "toDay", toD);

	id("dataTable").style.width = dataWidth;
	
	colRegenerate();
}

function openFilter(filter, alias){
	if (typeof(alias) == 'undefined'){
		alias = filter;
	}
	var selectedArray = id(alias + "Ids").value;
	url = "reservation.php?661+"
		+ filter
		+ "+"
		+ selectedArray
		+ "+"
		+ alias;    
         
	openPopup(url,280,360);                          
}

function generateReport(renderOption,sortOption) {
	var url = buildURL(renderOption,sortOption);
	if(url) {
		id("urlForm").target = "";
		id("url").value = url
		id("urlForm").action = "reservation.php?" + jobId;
		id("urlForm").submit();
	}
}

function printReport() {
	window.print();
}


function buildDate(prefix) {
	dayValue = id(prefix+"Day").options[id(prefix+"Day").selectedIndex].value;
	monthValue = id(prefix+"Month").options[id(prefix+"Month").selectedIndex].value;

	dayValue = dayValue<10?"0"+dayValue:dayValue;
	monthValue = monthValue<10?"0"+monthValue:monthValue;
	 
	resultDate = id(prefix+"Year").value+"-"+monthValue+"-"+dayValue;
      
	if(dayValue < 1) { 
		id(prefix+"Day").focus();
		openMessage("Enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(monthValue < 1) {
		id(prefix+"Month").focus();
		openMessage("Enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(id(prefix+"Year").value == "") {
		id(prefix+"Year").focus();
		openMessage("Enter a valid "+prefix+" date","a",100);
		return false;		 
	 }		 
	if(id(prefix+"Year").value.search(/^\d{4}$/) == -1) {
		id(prefix+"Year").focus();
		openMessage("Enter a valid "+prefix+" date","a",100);
		return false;
	}

	return resultDate;
}  

function buildCols() {
	var cols = [];
	for(var count=0; count<colData.length; count++) {
		var cSort = colData[count].sort;
		var cDirection = colData[count].direction;
		var cWidth = colData[count].width;
		var cLabel = colData[count].label;
		var cHeader = colData[count].header;
		var cAlign = colData[count].align;
		var cId = colData[count].id;
		if(colData[count].active == "1") {
			cSort = selValue("col_sort_" + cId);
			cDirection = selValue("col_sort_direction_" + cId);
			cWidth = id("col_width_" + cId).value;
			cLabel = id("col_label_" + cId).value;
			cHeader = id("col_header_" + cId).value;
			cAlign = selValue("col_align_" + cId);
		}
		var col = [
			colData[count].active,
			colData[count].order,
			cSort,
			cDirection,
			cWidth,
			cLabel,
			cHeader,
			cAlign,
			cId
		]
		cols[cols.length] = col.join(",");
	}
	return cols.join(":");
}

function buildURL(renderOption) {
	var dateType;
	if(id("dateTypeToday").checked) {
		dateType = "today";
	}
	if(id("dateTypeTodayDays").checked) {
		dateType = "today_days";
	}
	if(id("dateTypeYesterday").checked) {
		dateType = "yesterday";
	}
	if(id("dateTypeCustom").checked) {
		dateType = "custom";
	}
	var dateTypeDays = id("dateTypeDays").value;
	var dateFrom = buildDate("from");
	var dateTo = buildDate("to");

	var cols = buildCols();
	
	var url = [
		/*  0 */ "reservation.php?" + jobId,
		/*  1 */ dateType,
		/*  2 */ dateTypeDays,
		/*  3 */ dateFrom,
		/*  4 */ dateTo,
		/*  5 */ id("statusIds").value,
		/*  6 */ id("accommIds").value,
		/*  7 */ id("displayUpgrade").checked?"1":"0",
		/*  8 */ id("displayNoShow").checked?"1":"0",
		/*  9 */ id("displayCheckOut").checked?"1":"0",
		/* 10 */ cols,
		/* 11 */ id("displayMissingGuestNames").checked?"1":"0",
		/* 12 */ renderOption
	];
	return url.join("+");
}

function openCSV() {
	url = buildURL(4);
	if(url) {
		id("urlForm").target = "_self";
		id("url").value = url;
		id("urlForm").submit();
	}
}

function openPropFilter() {
	var accomm = id("accommIds").value;
	openPopup("reservation.php?293+"+accomm,556,407);
}

function showHideFilters() {
	var filters = id("filters");
	var filterBut = id("filterBut");

	mnuInitialise = false;

	if(filters.className == "collapse printCollapse") {
		filters.className = "expand";
		filterBut.value 	= "<< Hide Filters";
	} else {
		filters.className = "collapse printCollapse";
		filterBut.value 	= ">> Show Filters";
	}
}

function select_daymonth_changed(){
	setDayList(id("fromDay"),id("fromMonth").options[id("fromMonth").selectedIndex].value,id("fromYear").value);
	setDayList(id("toDay"),id("toMonth").options[id("toMonth").selectedIndex].value,id("toYear").value);
}

function openCal(obj,e) {
	dateObj = obj;
	screenPosX = getClickPosition(e,'x');
	screenPosY = getClickPosition(e,'y');
	openPopup('/resource/Resrequest/Application/public/html/calendar.htm',300,185,screenPosX,screenPosY);
}

function emptyTable(objId) {
	var obj = id(objId);
	for(var count=obj.rows.length-1;count > -1; count--) {
		obj.deleteRow(count);
	}
}

var colRowSelected = false;

function colRow(cObjId,cId,cLabel,cSelected) {
	var row = id(cObjId).insertRow(-1);
	row.tableName = cObjId;
	row.colId = cId;
	row.onmouseover = function() {
		this.style.backgroundColor = "#cfc";
	}
	row.onmouseout = function() {
		if(colRowSelected == this) {
			this.style.backgroundColor = "#31ff63";
		} else {
			this.style.backgroundColor = "";
		}
	}
	row.onclick = function(e,force) {
		if(colRowSelected != this || (colRowSelected == this && force) ) {
			if(colRowSelected) {
				colRowSelected.style.backgroundColor = "";
				colRowSelected.firstChild.style.fontWeight = "";
			}
			colRowSelected = this;
			this.firstChild.style.fontWeight = "bold";
			if(this.style.backgroundColor == "") {
				this.style.backgroundColor = "#31ff63";
			}
			if(this.tableName == "tblInactiveCol") {
				id("btnColAdd").disabled = false;
				id("btnColRemove").disabled = true;
				id("btnColUp").disabled = true;
				id("btnColDown").disabled = true;
			} else {
				id("btnColAdd").disabled = true;
				id("btnColRemove").disabled = false;
				id("btnColUp").disabled = false;
				id("btnColDown").disabled = false;
			}
		} else {
			colRowSelected = false;
			this.firstChild.style.fontWeight = "";
			id("btnColAdd").disabled = true;
			id("btnColRemove").disabled = true;
			id("btnColUp").disabled = true;
			id("btnColDown").disabled = true;
		}
	}

	// name
	var cell = row.insertCell(-1);
	cell.innerHTML = cLabel;
	cell.className = "imgLink";
	cell.style.width = "100px";
	if(cObjId == "tblInactiveCol") {
		cell.style.whiteSpace = "nowrap";
	}


	var cIdIndex;
	for(var count=0; count < colData.length; count++) {
		if(colData[count].id == cId) {
			cIdIndex = count;
		}
	}	
	if(cObjId == "tblActiveCol") {
		// label
		cell = row.insertCell(-1);
		cell.style.width = "100px";
		cell.innerHTML = "<input type=\"text\" id=\"col_label_" + cId + "\" style=\"width:98px;\" value=\""+colData[cIdIndex].label+"\"/>";

		// width
		cell = row.insertCell(-1);
		cell.style.width = "40px";
		cell.innerHTML = "<input type=\"text\" id=\"col_width_" + cId + "\" style=\"width:38px;\" value=\""+colData[cIdIndex].width+"\"/>";

		cell = row.insertCell(-1);
		cell.style.width = "80px";
		cell.innerHTML = "<select id=\"col_sort_" + cId + "\" style=\"width:40px;\">"+colSortOptions+"</select><select id=\"col_sort_direction_" + cId + "\" style=\"width:38px;\"><option value=\"a\">Ascending</option><option value=\"d\">Descending</option></select>";

		if(colData[cIdIndex].sort != "") {
			id("col_sort_" + cId).selectedIndex = parseInt(colData[cIdIndex].sort,10);
		}

		if(colData[cIdIndex].direction == "d") {
			id("col_sort_direction_" + cId).selectedIndex = 1;
		}

		cell = row.insertCell(-1);
		cell.innerHTML = "<input type=\"text\" id=\"col_header_" + cId + "\" style=\"width:100px\" value=\""+colData[cIdIndex].header+"\"/>";

		cell = row.insertCell(-1);
		cell.innerHTML = "<select id=\"col_align_" + cId + "\" style=\"width:44px\"><option value=\"l\">Left</option><option value=\"c\">Centre</option><option value=\"r\">Right</option></select>";

		var align = colData[cIdIndex].align;
		if(align == "c") {
			id("col_align_"+cId).selectedIndex = 1;
		} 
		if(align == "r") {
			id("col_align_"+cId).selectedIndex = 2;
		} 
	}
	
	if(cSelected) {
		colRowSelected = row;
		row.onclick(false,true);
	}
	
}

var colSortOptions = "";
function colRegenerate() {
	if(colRowSelected != false) {
		var colRowSelectedId = colRowSelected.colId;
	}
	emptyTable("tblInactiveCol");
	emptyTable("tblActiveCol");

	var colSort = [];
	var sortCount = 1;
	colSortOptions = "<option value=\"\"></option>";
	for(var count=0; count < colData.length; count++) {
		colSortOptions += "<option value=\"" + sortCount.toString() + "\">" + sortCount.toString() + "</option>";
		sortCount++;
	}
	for(var count=0; count < colData.length; count++) {
		if(colData[count].active != "1") {
			var selected = false;
			if(colData[count].id == colRowSelectedId) {
				selected = true;
			}
			colRow("tblInactiveCol",colData[count].id,colData[count].name,selected);
		} else {
			colSort[colData[count].order] = count;
		}
	}

	for(var count=1; count < colSort.length; count++) {
		var selected = false;
		if(colData[colSort[count]].id == colRowSelectedId) {
			selected = true;
		}
		colRow("tblActiveCol",colData[colSort[count]].id,colData[colSort[count]].name,selected);
	}
}

function colOrderArray() {
	var colOrder = [];
	for(var count=0; count < colData.length; count++) {
		if(colData[count].active == "1") {
			colOrder[colData[count].order] = count;
		} else {
			colData[count].order = 0;
		}
	}

	var newColOrder = [];

	for(var count=1; count < colOrder.length; count++) {
		var key = colOrder[count];
		if(colData[key]) {
			newColOrder[newColOrder.length] = key;
		}
	}
	return newColOrder;
}

function colNormaliseOrder() {
	var colOrder = colOrderArray();

	var orderCount = 1;
	for(var count=0; count < colOrder.length; count++) {
		colData[colOrder[count]].order = orderCount;
		orderCount++;
	}
}

function colAdd() {
	if(!colRowSelected) { return false; }

	var maxOrder = 0;
	for(var count=0; count < colData.length; count++) {
		if(parseInt(colData[count].order,10) > parseInt(maxOrder,10)) maxOrder = colData[count].order;	
	}
	maxOrder++;
	for(var count=0; count < colData.length; count++) {
		if(colRowSelected.colId == colData[count].id) {
			colData[count].active = "1";
			colData[count].order = maxOrder;
		}
	}	

	colNormaliseOrder();
	colRegenerate();
}

function colRemove() {
	if(!colRowSelected) { return false; }

	for(var count=0; count < colData.length; count++) {
		if(colRowSelected.colId == colData[count].id) {
			colData[count].active = "0";
		}
	}	
	colNormaliseOrder();
	colRegenerate();
}

function colSwapOrder(key1, key2) {
	var temp = colData[key1].order;
	colData[key1].order = colData[key2].order;
	colData[key2].order = temp;
}

function colMove(direction) {
	if(!colRowSelected) { return false; }

	var colOrder = colOrderArray();
	var colFirst = colOrder[0];
	
	for(var count=0; count < colOrder.length; count++) {
		var key = colOrder[count];
		if(colRowSelected.colId == colData[key].id) {
			if(!direction) {
				if(count != 0) {
					colSwapOrder(key,colOrder[count-1]);
				}
			} else {
				if(count < colOrder.length-1) {
					colSwapOrder(key,colOrder[count+1]);
				}
			}
		}
	}

	colNormaliseOrder();
	colRegenerate();
}

function colUp() {
	colMove();
}

function colDown() {
	colMove(true);
}
