function initialisePage() {
	var enabledButtons = ["Back","Forward","Refresh","Print","Calendar","Internet","Home","Help","NewWindow"];
	dateSelector();
	initTop();
	enableButtons(enabledButtons);
	
	// Set details for print header
	id("user").innerHTML = FirstName + " " + LastName;
	id("server").innerHTML = Domain;
	
	if(id('filters').className == 'expand') {
		id("fromDay").focus();
	}
	
	// Set date fields
	populateDateFields("fromYear", _fromY, "fromMonth", _fromM, "fromDay", _fromD);
	populateDateFields("toYear", _toY, "toMonth", _toM, "toDay", _toD);

	id("genDate").innerHTML = genDateVal;
  
	if ( id("extraText") && id("extraCatText") ) {
		var extraText = id("extraCatText").value + id("extraText").value;
	}    
  
	id("dataTable").style.width = dataWidth;
  
	//Display Category or Extras
	if ( id("extraFilterTypeCategory").checked === true ) { 
		id("extraHead").innerHTML = "Category:";
		id("extraList").innerHTML = "!extraCategoryNames!";
	} else {
		id("extraHead").innerHTML = "Extras:";    
		id("extraList").innerHTML = extraText;
	}    

	colRegenerate();
}

function buildDate(prefix) {
	dayValue = id(prefix+"Day").options[id(prefix+"Day").selectedIndex].value;
	monthValue = id(prefix+"Month").options[id(prefix+"Month").selectedIndex].value;

	dayValue = dayValue<10?"0"+dayValue:dayValue;
	monthValue = monthValue<10?"0"+monthValue:monthValue;
	 
	resultDate = id(prefix+"Year").value+"-"+monthValue+"-"+dayValue;
      
	if(dayValue < 1) { 
		id(prefix+"Day").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(monthValue < 1) {
		id(prefix+"Month").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(id(prefix+"Year").value == "") {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;		 
	 }		 
	if(id(prefix+"Year").value.search(/^\d{4}$/) == -1) {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}

	return resultDate;
}  

function buildCols() {
	var cols = [];
	for(var count=0; count<colData.length; count++) {
		var cSort = colData[count].sort;
		var cDirection = colData[count].direction;
		var cWidth = colData[count].width;
		var cLabel = colData[count].label;
		var cHeader = colData[count].header;
		var cAlign = colData[count].align;
		var cId = colData[count].id;
		if(colData[count].active == "1") {
			cSort = selValue("col_sort_" + cId);
			cDirection = selValue("col_sort_direction_" + cId);
			cWidth = id("col_width_" + cId).value;
			cLabel = id("col_label_" + cId).value;
			cHeader = id("col_header_" + cId).value;
			cAlign = selValue("col_align_" + cId);
		}
		var col = [
			colData[count].active,
			colData[count].order,
			cSort,
			cDirection,
			cWidth,
			cLabel,
			cHeader,
			cAlign,
			cId
		]
		cols[cols.length] = col.join(",");
	}
	return cols.join(":");
}


function buildURL(renderOption) {
	renderOption &= 7;
	
	_urlCount++;   

	var fromDate = buildDate("from");
	if(!fromDate) { return false; }
	var toDate = buildDate("to");
	if(!toDate) { return false; }
	if(buildDate("from") > buildDate("to") ) {
		id("toDay").focus();
		openMessage("Please enter a To date that is greater than or equal to the From date","a",120);
		return false;
	}

	var cols = buildCols();

	setExtrasIds();

	var url = ["reservation.php?306",
		/*  1 */ fromDate,
		/*  2 */ toDate,
		/*  3 */ id("statusIds").value,
		/*  4 */ id("propertiesExtraIds").value,
		/*  5 */ id("extraFilterTypeCategory").checked?"1":"2",
		/*  6 */ id("extrasIds").value,
		/*  7 */ id("extraCategoryIds").value,
		/*  8 */ cols,
		/*  9 */ id("page").value,
		/* 10 */ renderOption,
		/* 11 */ _randomId + "_" + _urlCount.toString(),
		/* 12 */ id("extraSupplierIds").value,
		/* 13 */ id("reference").value,
		/* 14 */ id("showTotals").checked ? "1":"0"
	];
    
	return url.join("+");		
}

function generateReport() {
	url = buildURL();
	if(url) {
		id("urlForm").target = "_self";
		id("url").value = url;
		id("urlForm").submit();
	}
}

function openCSV() {
	url = buildURL(4);
	if(url) {
		id("urlForm").target = "_self";
		id("url").value = url;
		id("urlForm").submit();
	}
}

function openPDF(){
	url = buildURL(1);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading PDF...",640,480,0,0,0,1,"pdfWin","opener.id('urlForm').submit();");
	}
}

function sendPDF(){
	url = buildURL(2);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin = openPopup("/resource/Resrequest/Application/public/html/wait.htm?Loading email popup...",775,615,0,0,0,0,"pdfWin","opener.id('urlForm').submit();");
	}
}

function setPage(page) {
	id("page").value = page;
	generateReport();
}

function printReport(){
	window.print();
}

//Open Filter Popups
function openFilter(filter){
	var selectedArray = id(filter + "Ids").value;

	url = "reservation.php?661+"
		+ filter
		+ "+"
		+ selectedArray;

	openPopup(url,280,360);
}

function openExtrasCat(filter){
	var selectedArray = id(filter + "Ids").value;

	url = "reservation.php?753+"
		+ filter
		+ "+"
		+ selectedArray;

	openPopup(url,290,400);
}

function dayChange() {
	setDayList(id("fromDay"),id("fromMonth").options[id("fromMonth").selectedIndex].value,id("fromYear").value);
	setDayList(id("toDay"),id("toMonth").options[id("toMonth").selectedIndex].value,id("toYear").value);
}



function showHideFilters(){
  var filters 		= id("filters");
  var filterBut 	= id("filterBut");
	
	mnuInitialise = false;
	
  if ( filters.className == "collapse printCollapse" ) {
    filters.className = "expand";
    filterBut.value 	= "<< Hide Filters";
  } else {
    filters.className = "collapse printCollapse";
    filterBut.value 	= ">> Show Filters";
  }
}

var dateObj = "";

function openCal(obj,e) {
   dateObj = obj;
   screenPosX = getClickPosition(e,'x');
   screenPosY = getClickPosition(e,'y');
   openPopup('/resource/Resrequest/Application/public/html/calendar.htm',300,185,screenPosX,screenPosY);
}

function setExtrasIds() {
	list = document.getElementsByName("extraIds");
	last = [];
	if(list.length > 0) {
		for(count=0; count<list.length; count++) {
			tmp = list[count].value.toString().split(":");
			for(count2=0;count2<tmp.length; count2++) {
				last[last.length] = tmp[count2];
			}
		}
		id("extrasIds").value = last.join(":");
	} else {
		id("extrasIds").value = "";
	}	
}

function removeExtraIds(rCatId) {
	id("extra_"+rCatId).removeNode(true);
	id("extraIds_"+rCatId).removeNode(true);
	if(document.getElementsByName("extraIds").length === 0) {
		id("extraAll").className = "";
	} else {
		id("extraAll").className = "collapse";
	}
}


function correctSort(obj) {
	updateValue = selValue(obj.id);
	if(updateValue != "") {
		for(var count=0; count< colCount; count++) {
			if("selColSortPosition"+ count.toString() != obj.id && selValue("selColSortPosition"+ count.toString()) == updateValue) {
				id("selColSortPosition"+ count.toString()).selectedIndex = 0;
			}
		}
	}
}

function correctOrder(obj) {
	// Find used numbers + conflicts (if any)
	var orderUsed = [];
	orderUsed.length = colCount+1;
	var conflict = -1;
	for(var count=0; count< colCount; count++) {
		orderUsed[selValue("selColOrder" + count.toString())] = true;
		if("selColOrder" + count.toString() != obj.id && selValue("selColOrder" + count.toString()) == selValue(obj.id)) {
			conflict = count;
		}
	}	
	if(conflict > -1) {
		for(var count=1; count<orderUsed.length; count++) {
			if(!orderUsed[count]) {
				id("selColOrder" + conflict.toString()).selectedIndex = count-1;
				break;
			}
		}
	}
}

function emptyTable(objId) {
	var obj = id(objId);
	for(var count=obj.rows.length-1;count > -1; count--) {
		obj.deleteRow(count);
	}
}

var colRowSelected = false;

function colRow(cObjId,cId,cLabel,cSelected) {
	var row = id(cObjId).insertRow(-1);
	row.tableName = cObjId;
	row.colId = cId;
	row.onmouseover = function() {
		this.style.backgroundColor = "#cfc";
	}
	row.onmouseout = function() {
		if(colRowSelected == this) {
			this.style.backgroundColor = "#31ff63";
		} else {
			this.style.backgroundColor = "";
		}
	}
	row.onclick = function(e,force) {
		if(colRowSelected != this || (colRowSelected == this && force) ) {
			if(colRowSelected) {
				colRowSelected.style.backgroundColor = "";
				colRowSelected.firstChild.style.fontWeight = "";
			}
			colRowSelected = this;
			this.firstChild.style.fontWeight = "bold";
			if(this.style.backgroundColor == "") {
				this.style.backgroundColor = "#31ff63";
			}
			if(this.tableName == "tblInactiveCol") {
				id("btnColAdd").disabled = false;
				id("btnColRemove").disabled = true;
				id("btnColUp").disabled = true;
				id("btnColDown").disabled = true;
			} else {
				id("btnColAdd").disabled = true;
				id("btnColRemove").disabled = false;
				id("btnColUp").disabled = false;
				id("btnColDown").disabled = false;
			}
		} else {
			colRowSelected = false;
			this.firstChild.style.fontWeight = "";
			id("btnColAdd").disabled = true;
			id("btnColRemove").disabled = true;
			id("btnColUp").disabled = true;
			id("btnColDown").disabled = true;
		}
	}

	// name
	var cell = row.insertCell(-1);
	cell.innerHTML = cLabel;
	cell.className = "imgLink";
	cell.style.width = "100px";
	if(cObjId == "tblInactiveCol") {
		cell.style.whiteSpace = "nowrap";
	}


	var cIdIndex;
	for(var count=0; count < colData.length; count++) {
		if(colData[count].id == cId) {
			cIdIndex = count;
		}
	}	
	if(cObjId == "tblActiveCol") {
		// label
		cell = row.insertCell(-1);
		cell.style.width = "100px";
		cell.innerHTML = "<input type=\"text\" id=\"col_label_" + cId + "\" style=\"width:98px;\" value=\""+colData[cIdIndex].label+"\"/>";

		// width
		cell = row.insertCell(-1);
		cell.style.width = "40px";
		cell.innerHTML = "<input type=\"text\" id=\"col_width_" + cId + "\" style=\"width:38px;\" value=\""+colData[cIdIndex].width+"\"/>";

		cell = row.insertCell(-1);
		cell.style.width = "80px";
		cell.innerHTML = "<select id=\"col_sort_" + cId + "\" style=\"width:40px;\">"+colSortOptions+"</select><select id=\"col_sort_direction_" + cId + "\" style=\"width:38px;\"><option value=\"a\">Ascending</option><option value=\"d\">Descending</option></select>";

		if(colData[cIdIndex].sort != "") {
			id("col_sort_" + cId).selectedIndex = parseInt(colData[cIdIndex].sort,10);
		}

		if(colData[cIdIndex].direction == "d") {
			id("col_sort_direction_" + cId).selectedIndex = 1;
		}

		cell = row.insertCell(-1);
		cell.innerHTML = "<input type=\"text\" id=\"col_header_" + cId + "\" style=\"width:100px\" value=\""+colData[cIdIndex].header+"\"/>";

		cell = row.insertCell(-1);
		cell.innerHTML = "<select id=\"col_align_" + cId + "\" style=\"width:44px\"><option value=\"l\">Left</option><option value=\"c\">Centre</option><option value=\"r\">Right</option></select>";

		var align = colData[cIdIndex].align;
		if(align == "c") {
			id("col_align_"+cId).selectedIndex = 1;
		} 
		if(align == "r") {
			id("col_align_"+cId).selectedIndex = 2;
		} 
	}
	
	if(cSelected) {
		colRowSelected = row;
		row.onclick(false,true);
	}
	
}

var colSortOptions = "";
function colRegenerate() {
	if(colRowSelected != false) {
		var colRowSelectedId = colRowSelected.colId;
	}
	emptyTable("tblInactiveCol");
	emptyTable("tblActiveCol");

	var colSort = [];
	var sortCount = 1;
	colSortOptions = "<option value=\"\"></option>";
	for(var count=0; count < colData.length; count++) {
		colSortOptions += "<option value=\"" + sortCount.toString() + "\">" + sortCount.toString() + "</option>";
		sortCount++;
	}
	for(var count=0; count < colData.length; count++) {
		if(colData[count].active != "1") {
			var selected = false;
			if(colData[count].id == colRowSelectedId) {
				selected = true;
			}
			colRow("tblInactiveCol",colData[count].id,colData[count].name,selected);
		} else {
			colSort[colData[count].order] = count;
		}
	}

	for(var count=1; count < colSort.length; count++) {
		var selected = false;
		if(colData[colSort[count]].id == colRowSelectedId) {
			selected = true;
		}
		colRow("tblActiveCol",colData[colSort[count]].id,colData[colSort[count]].name,selected);
	}
}

function colOrderArray() {
	var colOrder = [];
	for(var count=0; count < colData.length; count++) {
		if(colData[count].active == "1") {
			colOrder[colData[count].order] = count;
		} else {
			colData[count].order = 0;
		}
	}

	var newColOrder = [];

	for(var count=1; count < colOrder.length; count++) {
		var key = colOrder[count];
		if(colData[key]) {
			newColOrder[newColOrder.length] = key;
		}
	}
	return newColOrder;
}

function colNormaliseOrder() {
	var colOrder = colOrderArray();

	var orderCount = 1;
	for(var count=0; count < colOrder.length; count++) {
		colData[colOrder[count]].order = orderCount;
		orderCount++;
	}
}

function colAdd() {
	if(!colRowSelected) { return false; }

	var maxOrder = 0;
	for(var count=0; count < colData.length; count++) {
		if(parseInt(colData[count].order,10) > parseInt(maxOrder,10)) maxOrder = colData[count].order;	
	}
	maxOrder++;
	for(var count=0; count < colData.length; count++) {
		if(colRowSelected.colId == colData[count].id) {
			colData[count].active = "1";
			colData[count].order = maxOrder;
		}
	}	

	colNormaliseOrder();
	colRegenerate();
}

function colRemove() {
	if(!colRowSelected) { return false; }

	for(var count=0; count < colData.length; count++) {
		if(colRowSelected.colId == colData[count].id) {
			colData[count].active = "0";
		}
	}	
	colNormaliseOrder();
	colRegenerate();
}

function colSwapOrder(key1, key2) {
	var temp = colData[key1].order;
	colData[key1].order = colData[key2].order;
	colData[key2].order = temp;
}

function colMove(direction) {
	if(!colRowSelected) { return false; }

	var colOrder = colOrderArray();
	var colFirst = colOrder[0];
	
	for(var count=0; count < colOrder.length; count++) {
		var key = colOrder[count];
		if(colRowSelected.colId == colData[key].id) {
			if(!direction) {
				if(count != 0) {
					colSwapOrder(key,colOrder[count-1]);
				}
			} else {
				if(count < colOrder.length-1) {
					colSwapOrder(key,colOrder[count+1]);
				}
			}
		}
	}

	colNormaliseOrder();
	colRegenerate();
}

function colUp() {
	colMove();
}

function colDown() {
	colMove(true);
}
