function initialisePage(){
	// Initialise header controls
	initTop();
	enableButtons(enabledButtons);
	dateSelector();
	// Set details for print header
	id("user").innerHTML = FirstName + " " + LastName;
	id("server").innerHTML = Domain;
	
  // Bug #5484 : START --------------------------------------------------------
	// When generating a report, do not display the filters by default.
	/* --------------------------------------------------------------------------
	This check is due to IE returning an error if the div containing a field
	that you're trying to set focus on is hiden or not visible
	-------------------------------------------------------------------------- */
	if(id('filters').className != 'collapse printCollapse') {
		id("fromDay").focus();
	}
	// Bug #5484 : END ----------------------------------------------------------
	
	// Set date fields
	populateDateFields("fromYear", _fromY, "fromMonth", _fromM, "fromDay", _fromD);
	populateDateFields("toYear", _toY, "toMonth", _toM, "toDay", _toD);
	populateDateFields("fromTravelYear", _fromTravelY, "fromTravelMonth", _fromTravelM, "fromTravelDay", _fromTravelD);
	populateDateFields("toTravelYear", _toTravelY, "toTravelMonth", _toTravelM, "toTravelDay", _toTravelD);
	populateDateFields("fromModifyYear", _fromModifyY, "fromModifyMonth", _fromModifyM, "fromModifyDay", _fromModifyD);
	populateDateFields("toModifyYear", _toModifyY, "toModifyMonth", _toModifyM, "toModifyDay", _toModifyD);

	id("genDate").innerHTML = genDateVal;

	costChangeClick();
}

function genReport(){
	id("page").value = "1";
	id("sort").value = "";
	url = buildURL();
	if(url) {
		id("urlForm").target = "_self";		
		id("url").value = url;
		id("urlForm").submit();
	}
}

function printReport(){
	window.print();
}

function setPage(page) {
	id("page").value = page;
	url = buildURL();
	if(url) {
		id("urlForm").target = "_self";		
		id("url").value = url;
		id("urlForm").submit();
	}
}

function chngSort(field,direction) {
	id("sort").value = field + "," + direction;
	url = buildURL();
	if(url) {
		id("urlForm").target = "_self";		
		id("url").value = url;
		id("urlForm").submit();
	}
}

function buildDate(prefix) {
	dayValue = id(prefix+"Day").options[id(prefix+"Day").selectedIndex].value;
	monthValue = id(prefix+"Month").options[id(prefix+"Month").selectedIndex].value;

	dayValue = dayValue<10?"0"+dayValue:dayValue;
	monthValue = monthValue<10?"0"+monthValue:monthValue;
	 
	resultDate = id(prefix+"Year").value+"-"+monthValue+"-"+dayValue;
      
	if(dayValue < 1) { 
		id(prefix+"Day").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(monthValue < 1) {
		id(prefix+"Month").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(id(prefix+"Year").value == "") {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;		 
	 }		 
	if(id(prefix+"Year").value.search(/^\d{4}$/) == -1) {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}

	return resultDate;
}  


function buildURL(renderOption){
	renderOption &= 7;	   
	_urlCount++;

	var reportFilters = id("filters");

	if(renderOption == 0) {
		var reportFilterStatus = "";
	} else {
		var reportFilterStatus = reportFilters.className;
	}

	var filterButton = id("filterBut");
	var filterButtonText = filterButton.value;
	
	if(id("serviceDateOption").checked) {
		dateOption = "1";
	} else if(id("travelDateOption").checked) {
		dateOption = "2";
	} else {
		dateOption = "3";
	}
	
	if(!buildDate("from") || !buildDate("to") ) {
		return false;
	}
	
	if(buildDate("from") > buildDate("to") ) {
		id("toDay").focus();
		openMessage("Please enter a service To date that is greater than or equal to the From date","a",120);
		return false;
	}
	
	fromDate = buildDate("from");
	toDate = buildDate("to");

	if(!buildDate("fromTravel") || !buildDate("toTravel") ) {
		return false;
	}
	
	if(buildDate("fromTravel") > buildDate("toTravel") ) {
		id("toTravelDay").focus();
		openMessage("Please enter a travel To date that is greater than or equal to the From date","a",120);
		return false;
	}
	
	fromTravelDate = buildDate("fromTravel");
	toTravelDate = buildDate("toTravel");

	if(!buildDate("fromModify") || !buildDate("toModify") ) {
		return false;
	}
	
	if(buildDate("fromModify") > buildDate("toModify") ) {
		id("toModifyDay").focus();
		openMessage("Please enter a modify To date that is greater than or equal to the From date","a",120);
		return false;
	}
	
	fromModifyDate = buildDate("fromModify");
	toModifyDate = buildDate("toModify");
	
	if(id("costDecreaseOnlyOption").checked) {
		costChange = "1";
	} else if(id("costDecreaseMinimumOption").checked) {
		costChange = "2";
	} else if(id("costIncreaseOnlyOption").checked) {
		costChange = "3";
	} else if(id("costIncreaseMinimumOption").checked) {
		costChange = "4";
	} else if(id("costIncreaseDecreaseOption").checked) {
		costChange = "5";
	}
	
	if(id("showAuditCheck").checked) {
		showAudit = "1";
	} else {
		showAudit = "0";
	}
	
	setExtrasIds();

	url = new Array("reservation.php?260",
									dateOption,																//  1
									fromDate,																	//  2
									toDate,																		//  3
									fromTravelDate,														//  4
									toTravelDate,															//  5
									costChange,																//  6
									id("costDecreaseMinimum").value,					//  7
									id("costIncreaseMinimum").value,					//  8
									showAudit,																//  9
									renderOption,															// 10
									reportFilterStatus,												// 11
									_randomId + "_" + _urlCount.toString(),		// 12
									filterButtonText,													// 13
									id("propertiesExtraIds").value,							// Property filter, 14
									id("extrasIds").value,									// Extras filter, 15
									id("extraCategoryIds").value,							// Extra Categories filter, 16
									(id("extraFilterTypeCategory").checked ? "1" : "2"),	// Extra filter type, 17
									id("consultantIds").value,								// Consultant filter, 18
									(id("showDeletedExtrasCheck").checked ? "1" : "0"),		// Show deleted Extras, 19
									(id("showEditedAfterPaymentCheck").checked ? "1" : "0"),		// Show edited-after-payment, 20
									fromModifyDate,														//  21
									toModifyDate															//  22
									);

		
	return url.join("+");
}

function openPDF(){
	url = buildURL(1);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading PDF...",640,480,0,0,0,1,"pdfWin","opener.id('urlForm').submit();");
	}
		
}

function openCSV(){
	url = buildURL(4);
	if(url) {
		id("urlForm").target = "_self";		
		id("url").value = url;
		id("urlForm").submit();
	}
}

function emailPDF(){
	url = buildURL(2);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Loading email popup...",595,424,0,0,0,0,"pdfWin","opener.id('urlForm').submit();");
	}
}

function showHideFilters(){
  var filters 		= id("filters");
  var filterBut 	= id("filterBut");
	
	mnuInitialise = false;
	
  if ( filters.className == "collapse printCollapse" ) {
    filters.className = "expand";
    filterBut.value 	= "<< Hide Filters";
  } else {
    filters.className = "collapse printCollapse";
    filterBut.value 	= ">> Show Filters";
  }
}

function select_daymonth_changed(){
	setDayList(id("fromDay"),id("fromMonth").options[id("fromMonth").selectedIndex].value,id("fromYear").value);
	setDayList(id("toDay"),id("toMonth").options[id("toMonth").selectedIndex].value,id("toYear").value);
	setDayList(id("fromTravelDay"),id("fromTravelMonth").options[id("fromTravelMonth").selectedIndex].value,id("fromTravelYear").value);
	setDayList(id("toTravelDay"),id("toTravelMonth").options[id("toTravelMonth").selectedIndex].value,id("toTravelYear").value);
	setDayList(id("fromModifyDay"),id("fromModifyMonth").options[id("fromModifyMonth").selectedIndex].value,id("fromModifyYear").value);
	setDayList(id("toModifyDay"),id("toModifyMonth").options[id("toModifyMonth").selectedIndex].value,id("toModifyYear").value);
}

function costChangeClick() {
	if(id("costDecreaseMinimumOption").checked) {
		id("costDecreaseMinimumRow").className = "";
	} else {
		id("costDecreaseMinimumRow").className = "collapse";
	}
	if(id("costIncreaseMinimumOption").checked) {
		id("costIncreaseMinimumRow").className = "";
	} else {
		id("costIncreaseMinimumRow").className = "collapse";
	}

}

function toggleAudit(parentId) {
	if(id("auditHeader" + parentId)) {
		if(id("auditHeader" + parentId).className == "collapse") {
			id("toggleImage" + parentId).src = "/resource/Resrequest/Application/public/img/property_expanded.gif";
			count = 0;
			while(id("auditRow" + count.toString() + parentId)) {
				id("auditRow" + count.toString() + parentId).className = "expand";
				count++;
			}
			id("auditHeader" + parentId).className = "expand";
			// This is an IE bug workaround - the row span needs to be 'reset'
			tmpSpan = id("auditHeader0" + parentId).rowSpan;
			id("auditHeader0" + parentId).rowSpan = 1;
			id("auditHeader1" + parentId).rowSpan = 1;
			id("auditHeader2" + parentId).rowSpan = 1;
			id("auditHeader0" + parentId).rowSpan = tmpSpan;
			id("auditHeader1" + parentId).rowSpan = tmpSpan;
			id("auditHeader2" + parentId).rowSpan = tmpSpan;
		} else {
			id("toggleImage" + parentId).src = "/resource/Resrequest/Application/public/img/property_collapsed.gif";
			count = 0;
			while(id("auditRow" + count.toString() + parentId)) {
				id("auditRow" + count.toString() + parentId).className = "collapse";
				count++;
			}
			id("auditHeader" + parentId).className = "collapse";
		}
	}
	event.cancelBubble = true;
}

//Open Filter Popups
function openFilter(filter){
  var selectedArray = id(filter + "Ids").value;
     
  url = "/reservation.php?661+"
    + filter
    + "+"
    + selectedArray;

  openPopup(url,280,360);
}

function openExtrasCat(filter){
  var selectedArray = id(filter + "Ids").value;

  url = "/reservation.php?753+"
    + filter
    + "+"
    + selectedArray;

  openPopup(url,290,400);
}

function setExtrasIds() {
  list = document.getElementsByName("extraIds");
  last = [];
  if(list.length > 0) {
    for(count=0; count<list.length; count++) {
      tmp = list[count].value.toString().split(":");
      for(count2=0;count2<tmp.length; count2++) {
        last[last.length] = tmp[count2];
      }
    }
    id("extrasIds").value = last.join(":");
  } else {
    id("extrasIds").value = "";
  } 
}

function removeExtraIds(rCatId) {
  id("extra_"+rCatId).parentNode.removeChild(id("extra_"+rCatId));
  id("extraIds_"+rCatId).parentNode.removeChild(id("extraIds_"+rCatId));
  if(document.getElementsByName("extraIds").length === 0) {
    id("extraAll").className = "";
  } else {
    id("extraAll").className = "collapse";
  }
}