function initialisePage() {
	dateSelector();
	initTop();
	enableButtons(enabledButtons);

	populateDateFields("travelFromYear", _travelFromY, "travelFromMonth", _travelFromM, "travelFromDay", _travelFromD);
	populateDateFields("travelToYear", _travelToY, "travelToMonth", _travelToM, "travelToDay", _travelToD);
    populateDateFields("birthToYear", _birthToY, "birthToMonth", _birthToM, "birthToDay", _birthToD);
    populateDateFields("birthFromYear", _birthFromY, "birthFromMonth", _birthFromM, "birthFromDay", _birthFromD);
	populateDateFields("annToYear", _annToY, "annToMonth", _annToM, "annToDay", _annToD);
	populateDateFields("annFromYear", _annFromY, "annFromMonth", _annFromM, "annFromDay", _annFromD);
    populateDateFields("contactCreatedToYear", _contactCreatedToY, "contactCreatedToMonth", _contactCreatedToM, "contactCreatedToDay", _contactCreatedToD);
    populateDateFields("contactCreatedFromYear", _contactCreatedFromY, "contactCreatedFromMonth", _contactCreatedFromM, "contactCreatedFromDay", _contactCreatedFromD);
    populateDateFields("emailEditedToYear", _emailEditedToY, "emailEditedToMonth", _emailEditedToM, "emailEditedToDay", _emailEditedToD);
    populateDateFields("emailEditedFromYear", _emailEditedFromY, "emailEditedFromMonth", _emailEditedFromM, "emailEditedFromDay", _emailEditedFromD);

	id("visitFrom").selectedIndex = _visitF;
	id("visitTo").selectedIndex = _visitT;
	id("recentTrips").value = _recentTrips;

	id("adultsChildrenFilter").value = _adultsChildrenFilter;

	dateTypeChange("birth");
	dateTypeChange("ann");
	dateTypeChange("travel");
    dateTypeChange("contactCreated");
    dateTypeChange("emailEdited");
	colRegenerate();
	travelColRegenerate();
	exportOptionToggle();
}
// TODO: When this report is upgraded to the new central report functionality,
// this function should be combined with the one in the filter component
function openObjectFilter(objType, filter, job){
	if (typeof(alias) == 'undefined' || alias == ''){
		alias = filter;
	}

	var selectedArray = id(objType+"_"+filter + "Ids").value;
	url = "reservation.php?661"
		/*  1 */ + "+" + objType
		/*  2 */ + "+" + selectedArray
		/*  3 */ + "+" + objType+"_"+filter
		/*  4 */ + "+"
		/*  5 */ + "+" + alias;    

	if(!job) {
		job = "661";
	}
	if (!id('filterUrlForm')){
		// Create new filterUrlForm
		var filterUrlForm=document.createElement("form");
		filterUrlForm.setAttribute('id', 'filterUrlForm');
		filterUrlForm.setAttribute('method', 'POST');
		filterUrlForm.setAttribute('action', 'reservation.php?'+job);
		filterUrlForm.setAttribute('target', 'filterPop');
		document.body.appendChild(filterUrlForm);
		
		var filterUrl=document.createElement("input");	
		filterUrl.setAttribute('type', 'hidden');
		filterUrl.setAttribute('id', 'filterUrl');
		filterUrl.setAttribute('name', 'filterUrl');
		filterUrlForm.appendChild(filterUrl);
	}

	id("filterUrl").value = url;
	
	filterPop=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading filter...",280,360,0,0,0,1,"filterPop","opener.id('filterUrlForm').submit();");
}

function buildDate(prefix) {
	dayValue = id(prefix+"Day").options[id(prefix+"Day").selectedIndex].value;
	monthValue = id(prefix+"Month").options[id(prefix+"Month").selectedIndex].value;

	dayValue = dayValue<10?"0"+dayValue:dayValue;
	monthValue = monthValue<10?"0"+monthValue:monthValue;
	 

	switch(prefix){
		case "birthTo":
			fieldName = "birthday TO"
			break;
		case "birthFrom":
			fieldName = "birthday FROM"
			break;
		case "annTo":
			fieldName = "anniversary TO"
			break;
		case "annFrom":
			fieldName = "anniversary FROM"
			break;			
		default:
			fieldName = prefix;
	}
	
	if(dayValue < 1) { 

		switch(prefix){
			case "birthTo":
				dayValue = 31;
				break;
			case "birthFrom":
				dayValue = 1;
				break;
			case "annTo":
				dayValue = 31;
				break;
			case "annFrom":
				dayValue = 1;
				break;				
			default:
				id(prefix+"Day").focus();
				openMessage("Please enter a valid "+fieldName+" day","a",100);
				return false;
		}		
	}
	if(monthValue < 1) {
		id(prefix+"Month").focus();
		openMessage("Please enter a valid "+fieldName+" month","a",100);
		return false;
	}

	if(prefix == "travelFrom" || prefix == "travelTo") {
		if(id(prefix+"Year").value == "") {
			id(prefix+"Year").focus();
			openMessage("Please enter a valid "+fieldName+" year","a",100);
			return false;		 
		 }		 
		if(id(prefix+"Year").value.search(/^\d{4}$/) == -1) {
			id(prefix+"Year").focus();
			openMessage("Please enter a valid "+fieldName+" year","a",100);
			return false;
		}
	}

	resultDate = id(prefix+"Year").value+"-"+monthValue+"-"+dayValue;
	
	return resultDate;
}  

function buildOptions(bName) {
	var list = document.getElementsByName(bName +"Check");
	var chosen = [];
	for(var count = 0; count < list.length; count++) {
		if(list[count].checked) {
			chosen.push(list[count].id.toString().replace(bName,""));
		}
	}
	return chosen.join(":");
}

function getDateType() {
	if(id("dateTypeToday").checked) {
		return "1";
	}
	if(id("dateTypeDayCount").checked) {
		return "2";
	}
	return "3";
}


function buildCols(coltype) {
	var cols = [];
	for(var count=0; count<colData.length; count++) {
		var cWidth = colData[count].width;
		var cSort = colData[count].sort;
		var cLabel = colData[count].label;
		var cHeader = colData[count].header;
		var cAlign = colData[count].align;
		var cObjType = colData[count].objType;
		var cGuestId = colData[count].rf_obj_guest_ix;
		var cSplit = colData[count].split;
		var cDisable = "";
		var cDirection = colData[count].direction;
		
		if(colData[count].active == "1") {
			cWidth = id("col_width_" + colData[count].id).value;
			cSort = selValue("col_sort_" + colData[count].id);
			cLabel = id("col_label_" + colData[count].id).value;
			cHeader = id("col_header_" + colData[count].id).value;
			cAlign = selValue("col_align_" + colData[count].id);
			cObjType = id("col_objType_" + colData[count].id).value;
			if(cObjType == 3 || cObjType == 4 || cObjType == 5) {
				cSplit = id("col_split_" + colData[count].id).checked?"1":"";
			}
			cDisable = "";
			cDirection = selValue("col_sort_direction_" + colData[count].id);
		}
		
		cLabel = cLabel.replace(":"," ");
		
		var col = [
			colData[count].active,
			colData[count].order,
			cSort,
			cWidth,
			cLabel,
			cHeader,
			cAlign,
			cObjType,
			cGuestId,
			cSplit,
			cDisable,
			cDirection
		]
		
		cols[cols.length] = col.join(",");     //cSort, cDirection,
		
	}
	return cols.join(":");
}

function buildTravelCols() {
	var cols = [];
	for(var count=0; count<travelColData.length; count++) {
		var cWidth = travelColData[count].width;
		var cSort = travelColData[count].sort;
		var cLabel = travelColData[count].label;
		var cHeader = travelColData[count].header;
		var cAlign = travelColData[count].align;
		var cObjType = travelColData[count].objType;
		var cGuestId = travelColData[count].rf_obj_trip_ix;
		var cSplit = travelColData[count].split;
		var cDisable = "";
		var cDirection = travelColData[count].direction;
		
		if(travelColData[count].active == "1") {
			cWidth = id("travelCol_width_" + travelColData[count].id).value;
			cSort = selValue("travelCol_sort_" + travelColData[count].id);
			cLabel = id("travelCol_label_" + travelColData[count].id).value;
			cHeader = id("travelCol_header_" + travelColData[count].id).value;
			cAlign = selValue("travelCol_align_" + travelColData[count].id);
			cObjType = id("travelCol_objType_" + travelColData[count].id).value;
			if(cObjType == 3 || cObjType == 4 || cObjType == 5) {
				cSplit = id("travelCol_split_" + travelColData[count].id).checked?"1":"";
			}
			cDisable = "";
			cDirection = selValue("travelCol_sort_direction_" + travelColData[count].id);
		}
		var col = [
			travelColData[count].active,
			travelColData[count].order,
			cSort,
			cWidth,
			cLabel,
			cHeader,
			cAlign,
			cObjType,
			cGuestId,
			cSplit,
			cDisable,
			cDirection
		]
		cols[cols.length] = col.join(",");     //cSort, cDirection,
	}
	return cols.join(":");
}

function buildProfile() {
	var objs = [];
	var objName = document.getElementsByName('guest_profile[]');
	for(var count=0; count<objName.length; count++) {
		if(objName[count].value != "") {
			var str = objName[count].id;
			newStr = str.split('_') ;
			newStr = newStr[1];
			strRep = newStr.replace("Ids","");
			strRep = strRep+"-"+objName[count].value;
			objs[objs.length] = strRep;
		}
	}
	return objs.join("_");
}

function buildTripsheet() {
	var trips = [];
	var objName = document.getElementsByName('guest_tripsheet[]');
	for(var count=0; count<objName.length; count++) {
		if(objName[count].value != "") {
			var str = objName[count].id;
			newStr = str.split('_') ;
			newStr = newStr[1];
			strRep = newStr.replace("Ids","");
			strRep = strRep+"-"+objName[count].value;
			trips[trips.length] = strRep;
		}
	}
	return trips.join("_");
}


function buildURL(renderOption) {
	renderOption &= 15;
	_urlCount++;

	var dateType = id("travelQuick").value;
	//var dayCount = id("dayCount").value;
	var fromDate = "";
	var toDaye = "";
	if(id("travelQuick").value != "") { 
		var fromDate = buildDate("travelFrom");
		if(!fromDate) { return false; }
		var toDate = buildDate("travelTo");
		if(!toDate) { return false; }
		if(buildDate("travelFrom") > buildDate("travelTo") ) {
			id("travelTo").focus();
			openMessage("Please enter a To date that is greater than or equal to the From date","a",120);
			return false;
		}
	}

    if(id("birthQuick").value != "") {
        if(buildDate("birthFrom") > buildDate("birthTo") ) {
            id("birthToDay").focus();
            openMessage("Please enter a Birth to date that is greater than or equal to the Birth from date","a",120);
            return false;
        }
        var birthFromDate = buildDate("birthFrom");
        var birthToDate = buildDate("birthTo");
        if (birthFromDate == false || birthToDate == false){
            return false;
        }
    } else {
        var birthFromDate = "";
        var birthToDate = "";
    }

    if(id("contactCreatedQuick").value != "") {
        if(buildDate("contactCreatedFrom") > buildDate("contactCreatedTo") ) {
            id("contactCreatedToDay").focus();
            openMessage("Please enter a Created to date that is greater than or equal to the Created from date","a",120);
            return false;
        }
        var contactCreatedFromDate = buildDate("contactCreatedFrom");
        var contactCreatedToDate = buildDate("contactCreatedTo");
        if (contactCreatedFromDate == false || contactCreatedToDate == false){
            return false;
        }
    } else {
        var contactCreatedFromDate = "";
        var contactCreatedToDate = "";
    }

    if(id("emailEditedQuick").value != "") {
        if(buildDate("emailEditedFrom") > buildDate("emailEditedTo") ) {
            id("emailEditedToDay").focus();
            openMessage("Please enter a Edited to date that is greater than or equal to the Edited from date","a",120);
            return false;
        }
        var emailEditedFromDate = buildDate("emailEditedFrom");
        var emailEditedToDate = buildDate("emailEditedTo");
        if (emailEditedFromDate == false || emailEditedToDate == false){
            return false;
        }
    } else {
        var emailEditedFromDate = "";
        var emailEditedToDate = "";
    }

	if(id("annQuick").value != "") {
		if(buildDate("annFrom") > buildDate("annTo") ) {
			id("annToDay").focus();
			openMessage("Please enter a Annivarsary to date that is greater than or equal to the Annivarsary from date","a",120);
			return false;
		}
		var annFromDate = buildDate("annFrom");
		var annToDate = buildDate("annTo");
		if (annFromDate == false || annToDate == false){
			return false;
		}		
	} else {
		var annFromDate = "";
		var annToDate = "";
	}
	
	if(parseInt(id("visitFrom").value) > parseInt(id("visitTo").value)) {
		openMessage("Please enter a number of visits value less than "+id("visitFrom").value,"a",120);
		return false;
	}

	var custemProfile = buildProfile();
	var custemTripsheet = buildTripsheet();
	var guestDetailsCols = buildCols();
	var travelHistoryCols = buildTravelCols();
	
	var incInactiveOption = (id("incInactiveYes").checked) ? "1" : "0";
	
    var reservationLink = "0";
    if (id("resLink").checked) {
        reservationLink = "1";
    }
    if (id("resNotLinked").checked) {
        reservationLink = "2";
    }
	
	var url = [
		/*  0 */ "reservation.php?336",
		/*  1 */ id("firstname").value,
		/*  2 */ id("lastname").value,
		/*  3 */ id("titleIds").value,
		/*  4 */ id("suffixIds").value,
		/*  5 */ id("guestRoleIds").value,
		/*  6 */ id("email").value, 
		/*  7 */ id("telephone").value,
		/*  8 */ id("postSub").value,
		/*  9 */ id("physSub").value,
		/* 10 */ id("postCountryIds").value,
		/* 11 */ id("physCountryIds").value,
		/* 12 */ id("postZip").value,
		/* 13 */ id("physZip").value,
		/* 14 */ id("agentRelationshipIds").value,
		/* 15 */ id("guestTypeIds").value,
		/* 16 */ id("genderIds").value,
		/* 17 */ id("identity").value,
		/* 18 */ id("nationalityIds").value,
		/* 19 */ id("birthQuick").value,
		/* 20 */ birthFromDate,
		/* 21 */ birthToDate,
		/* 22 */  id("annQuick").value, 
		/* 23 */ annFromDate,
		/* 24 */ annToDate,
		/* 25 */ custemProfile,
		/* 26 */ id("accommIds").value,
		/* 27 */ id("statusIds").value,
		/* 28 */ id("travelQuick").value,
		/* 29 */ fromDate,
		/* 30 */ toDate,
		/* 31 */ id("visitFrom").value,
		/* 32 */ id("visitTo").value,
		/* 33 */ custemTripsheet,
		/* 34 */ guestDetailsCols,
		/* 35 */ travelHistoryCols,
		/* 36 */ id("recentTrips").value,
		/* 37 */ id("resNum").value,
		/* 38 */ id("resName").value,
		/* 39 */ reservationLink,
		/* 40 */ "",
		/* 41 */ id("pageNum").value,
		/* 42 */ renderOption,
		/* 43 */ _randomId + "_" + _urlCount.toString(),
		/* 44 */ id("allTravelHist").checked?"1":"0",
		/* 45 */ id("exportHorizontal").checked?"1":"0"	,
		/* 46 */ incInactiveOption,
		/* 47 */ id("adultsChildrenFilter").value,
		/* 48 */ id("exportRepeat").checked?"1":"0",
		/* 49 */ id("agentIds").value,
        /* 50 */ id("contactCreatedQuick").value,
        /* 51 */ contactCreatedFromDate,
        /* 52 */ contactCreatedToDate,
        /* 53 */ id("emailEditedQuick").value,
        /* 54 */ emailEditedFromDate,
        /* 55 */ emailEditedToDate,
        /* 56 */ id("nationalityGuestIds").value
	];
	
	return url.join("+");
}

function generateReport() {
	url = buildURL();
		
	if(url) {
		id("urlForm").target = "_self";
		id("url").value = url;
		id("urlForm").submit();
	}
}

function ShowFrom(pnum){
	pgNum = pnum;
	id("pageNum").value = pnum;
	generateReport();
}

function openCSV() {
	url = buildURL(4);
	if(url) {
		id("urlForm").target = "_self";
		id("url").value = url;
		id("urlForm").submit();
	}
}

function openXmlCSV() {
    url = buildURL(15);
    if(url) {
        id("urlForm").target = "_self";
        id("url").value = url;
        id("urlForm").submit();
    }
}

function openPDF(){
	url = buildURL(1);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading PDF...",640,480,0,0,0,1,"pdfWin","opener.id('urlForm').submit();");
	}
}

function sendPDF(){
	url = buildURL(2);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin = openPopup("/resource/Resrequest/Application/public/html/wait.htm?Loading email popup...",775,615,0,0,0,0,"pdfWin","opener.id('urlForm').submit();");
	}
}

function sendCSV(){
	url = buildURL(5);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Loading email popup...",595,424,0,0,0,0,"pdfWin","opener.id('urlForm').submit();");
	}
}

function editGuest(guestId) {
	openPopup("reservation.php?212+"+guestId+"++++1", 970, 640);
}

function select_daymonth_changed(flag){
	setDayList(id(flag+"FromDay"),id(flag+"FromMonth").options[id(flag+"FromMonth").selectedIndex].value,id(flag+"FromYear").value);
	setDayList(id(flag+"ToDay"),id(flag+"ToMonth").options[id(flag+"ToMonth").selectedIndex].value,id(flag+"ToYear").value);
}

function showHideFilters(){
	var filters = id("filters");
	var filterBut = id("filterBut");
	
	mnuInitialise = false;
	
	if( filters.className == "collapse printCollapse" ) {
		filters.className = "expand";
		filterBut.value 	= "<< Hide Filters";
	} else {
		filters.className = "collapse printCollapse";
		filterBut.value 	= ">> Show Filters";
	}
}

function dateTypeChange() {
	/*if (!id("dateTypeRange").checked ) {
		id("fromYear").value = "";
		id("fromMonth").selectedIndex = 0;
		id("fromDay").selectedIndex = 0;
		id("toYear").value = "";
		id("toMonth").selectedIndex = 0;
		id("toDay").selectedIndex = 0;
	} else { */
		populateDateFields("fromYear", _fromY, "fromMonth", _fromM, "fromDay", _fromD);
		populateDateFields("toYear", _toY, "toMonth", _toM, "toDay", _toD);
	//}
	return true;
}

function dateTypeChange(flag) {
	var dateOpt = id(flag+"Quick").value;
	var cur_date = new Date();	//get current day-time stamp
	id(flag+"FromYear").disabled = "disabled";
	id(flag+"FromMonth").disabled = "disabled";
	id(flag+"FromDay").disabled = "disabled";
	id(flag+"ToYear").disabled = "disabled";
	id(flag+"ToMonth").disabled = "disabled";
	id(flag+"ToDay").disabled = "disabled";
	
	
	switch(dateOpt) {
		case '1':
			populateDateFields(flag+"FromYear", cur_date.getYear()< 1000?cur_date.getYear()+1900:cur_date.getYear(), flag+"FromMonth", cur_date.getMonth()+1, flag+"FromDay", cur_date.getDate());
			populateDateFields(flag+"ToYear", cur_date.getYear()< 1000?cur_date.getYear()+1900:cur_date.getYear(), flag+"ToMonth", cur_date.getMonth()+1, flag+"ToDay", cur_date.getDate());
			break;
		case '2':
			var newToDate = new Date();
			var newFromDate = new Date();
			newFromDate.setDate(cur_date.getDate() - (cur_date.getDay()-1));
			newToDate.setDate(cur_date.getDate() + (7 - cur_date.getDay()));
			populateDateFields(flag+"FromYear", newFromDate.getYear()< 1000?newFromDate.getYear()+1900:newFromDate.getYear(), flag+"FromMonth", newFromDate.getMonth()+1, flag+"FromDay", newFromDate.getDate());
			populateDateFields(flag+"ToYear", newToDate.getYear()< 1000?newToDate.getYear()+1900:newToDate.getYear(), flag+"ToMonth", newToDate.getMonth()+1, flag+"ToDay", newToDate.getDate());
			break;
		case '3':
			var newToDate = new Date(cur_date.getFullYear(), cur_date.getMonth()+1, 0);
			var newFromDate = new Date();
			populateDateFields(flag+"FromYear", newFromDate.getYear()< 1000?newFromDate.getYear()+1900:newFromDate.getYear(), flag+"FromMonth", newFromDate.getMonth()+1, flag+"FromDay", 1);
			populateDateFields(flag+"ToYear", newToDate.getYear()< 1000?newToDate.getYear()+1900:newToDate.getYear(), flag+"ToMonth", newToDate.getMonth()+1, flag+"ToDay", newToDate.getDate());
			break;
		case '4':
			var newToDate = new Date(cur_date.getFullYear(), cur_date.getMonth()+1, 0);
			var newFromDate = new Date();
			populateDateFields(flag+"FromYear", cur_date.getYear()< 1000?cur_date.getYear()+1900:cur_date.getYear(), flag+"FromMonth", 1, flag+"FromDay", 1);
			populateDateFields(flag+"ToYear", cur_date.getYear()< 1000?cur_date.getYear()+1900:cur_date.getYear(), flag+"ToMonth", 12, flag+"ToDay", 31);
			break;
		case '5':
		case '6':
		case '7':
		case '8':
			if(eval("_"+flag+"FromY") != "") {
				FromYearValue = eval("_"+flag+"FromY");
			} else {
				FromYearValue = cur_date.getYear()< 1000?cur_date.getYear()+1900:cur_date.getYear();
			}
			if(eval("_"+flag+"FromM")>0) {
				FromMonthValue = eval("_"+flag+"FromM");
			} else {
				FromMonthValue = cur_date.getMonth()+1;
			}
			if(eval("_"+flag+"FromD") > 0) {
				FromDayValue = eval("_"+flag+"FromD");
			} else {
				FromDayValue = cur_date.getDate();
			}
			populateDateFields(flag+"FromYear", FromYearValue, flag+"FromMonth", FromMonthValue, flag+"FromDay", FromDayValue);

			if(eval("_"+flag+"ToY") != "") {
				ToYearValue = eval("_"+flag+"ToY");
			} else {
				ToYearValue = cur_date.getYear()< 1000?cur_date.getYear()+1900:cur_date.getYear();
			}
			if(eval("_"+flag+"ToM")>0) {
				ToMonthValue = eval("_"+flag+"ToM");
			} else {
				ToMonthValue = cur_date.getMonth()+1;
			}
			if(eval("_"+flag+"ToD") > 0) {
				ToDayValue = eval("_"+flag+"ToD");
			} else {
				ToDayValue = cur_date.getDate();
			}
			populateDateFields(flag+"ToYear", ToYearValue, flag+"ToMonth", ToMonthValue, flag+"ToDay", ToDayValue);
			
			id(flag+"FromYear").disabled = "";
			id(flag+"FromMonth").disabled = "";
			id(flag+"FromDay").disabled = "";
			id(flag+"ToYear").disabled = "";
			id(flag+"ToMonth").disabled = "";
			id(flag+"ToDay").disabled = "";
			//id(flag+"FromCal").disabled = "";
			//id(flag+"ToCal").disabled = "";
			break;
		default:
			populateDateFields(flag+"FromYear", "", flag+"FromMonth", 0, flag+"FromDay", 0);
			populateDateFields(flag+"ToYear", "", flag+"ToMonth", 0, flag+"ToDay", 0);
			break;
	}

	return true;
}

function toggleCollapse(objId) {
	if(id(objId).className == "") {
		id(objId).className = "collapse printCollapse";
	} else {
		id(objId).className = "";
	}
}

function setExtrasIds() {
	list = document.getElementsByName("extraIds");
	last = [];
	if(list.length > 0) {
		for(count=0; count<list.length; count++) {
			tmp = list[count].value.toString().split(":");
			for(count2=0;count2<tmp.length; count2++) {
				last[last.length] = tmp[count2];
			}
		}
		id("extrasIds").value = last.join(":");
	} else {
		id("extrasIds").value = "";
	}	
}

function removeExtraIds(rCatId) {
	id("extra_"+rCatId).parentNode.removeChild(id("extra_"+rCatId));
	id("extraIds_"+rCatId).parentNode.removeChild(id("extraIds_"+rCatId));
	if(document.getElementsByName("extraIds").length === 0) {
		id("extraAll").className = "";
	} else {
		id("extraAll").className = "collapse";
	}
}

function openPropFilter() {
	var accomm = id("accommIds").value;
	openPopup("reservation.php?293+"+accomm,556,407);
}

function openOptReqFilter() {
	var accomm = id("accommIds").value;
	openPopup("reservation.php?661+components+"+accomm,556,407);
}

function printReport() {
	window.print();
}

function openOffice() {
	url = buildURL(7);
	if(url) {
		id("urlForm").target = "_self";
		id("url").value = url;
		id("urlForm").submit();
	}
}

function showExportMenu(e, flag) {
	if ( !e ) {
		e = window.event;
	}
	stopBubble(e);

	var posx = 0;
	var posy = 0;
	
	if (e.pageX || e.pageY) 	{
		posx = e.pageX;
		posy = e.pageY;
	} else if (e.clientX || e.clientY) 	{
		posx = e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
		posy = e.clientY + document.body.scrollTop + document.documentElement.scrollTop;
	}
	
	if(flag == 1) {
		posy = posy-60;
	}

	id("exportOptionDiv").style.display	= "";
	id("exportOptionDiv").style.left = posx;
	id("exportOptionDiv").style.top = posy;
}

function closeOptDiv() {
	id('exportOptionDiv').style.display = "none";
}



//New functions for report builder
function emptyTable(objId) {
	var obj = id(objId);
	for(var count=obj.rows.length-1;count > -1; count--) {
		obj.deleteRow(count);
	}
}

var colRowSelected = false;

function colRow(cObjId,cId,cLabel,cSelected) {
	var row = id(cObjId).insertRow(-1);
	row.tableName = cObjId;
	row.colId = cId;
	row.onmouseover = function() {
		this.style.backgroundColor = "#cfc";
	}
	row.onmouseout = function() {
		if(colRowSelected == this) {
			this.style.backgroundColor = "#31ff63";
		} else {
			this.style.backgroundColor = "";
		}
	}
	
	row.onclick = function(e,force) {
		if(colRowSelected != this || (colRowSelected == this && force) ) {
			if(colRowSelected) {
				colRowSelected.style.backgroundColor = "";
				colRowSelected.firstChild.style.fontWeight = "";
			}
			colRowSelected = this;
			this.firstChild.style.fontWeight = "bold";
			if(this.style.backgroundColor == "") {
				this.style.backgroundColor = "#31ff63";
			}
			if(this.tableName == "tblInactiveCol") {
				id("btnColAdd").disabled = false;
				id("btnColRemove").disabled = true;
				id("btnColUp").disabled = true;
				id("btnColDown").disabled = true;
			} else {
				id("btnColAdd").disabled = true;
				id("btnColRemove").disabled = false;
				id("btnColUp").disabled = false;
				id("btnColDown").disabled = false;
			}
		} else {
			colRowSelected = false;
			this.firstChild.style.fontWeight = "";
			id("btnColAdd").disabled = true;
			id("btnColRemove").disabled = true;
			id("btnColUp").disabled = true;
			id("btnColDown").disabled = true;
		}
	}
	
	// name
	var cell = row.insertCell(-1);
	cell.innerHTML = cLabel;
	cell.title = cLabel;
	cell.className = "imgLink tooltip";
	if(colData[cId-1].disable == '1') {
		cell.style.backgroundColor = "#999";
	}
	cell.style.width = "98px";
	if(cObjId == "tblInactiveCol") {
		cell.style.whiteSpace = "nowrap";
	}

	if(cObjId == "tblActiveCol") {
		// label
		cell = row.insertCell(-1);
		//cell.style.width = "95px";
		cell.innerHTML = "<input type=\"text\" id=\"col_label_" + cId + "\" style=\"width:97px;\" value=\""+colData[cId-1].label+"\"/><input type=\"hidden\" id=\"col_objType_" + cId + "\" value=\""+colData[cId-1].objType+"\"/><input type=\"hidden\" id=\"col_rf_obj_guest_ix_" + cId + "\" value=\""+colData[cId-1].rf_obj_guest_ix+"\"/>";
		
		//split
		if(colData[cId-1].objType=='3' || colData[cId-1].objType=='4' || colData[cId-1].objType=='5') {
			var splitChecked = "";
			if(colData[cId-1].split == 1) {
				splitChecked = "checked";
			}
			cell = row.insertCell(-1);
			//cell.style.width = "30px";
			cell.innerHTML = "<input type=\"checkbox\" id=\"col_split_" + cId + "\" name=\"splitCheck\"  value=\""+colData[cId-1].split+"\" "+splitChecked+"/>";
		} else {
			cell = row.insertCell(-1);
		}

		// width
		cell = row.insertCell(-1);
		//cell.style.width = "30px";
		cell.innerHTML = "<input type=\"text\" id=\"col_width_" + cId + "\" style=\"width:28px;\" value=\""+colData[cId-1].width+"\"/>";
		
		//sort
		cell = row.insertCell(-1);
		//cell.style.width = "80px";
		cell.innerHTML = "<select id=\"col_sort_" + cId + "\" style=\"width:35px;\">"+colSortOptions+"</select><select id=\"col_sort_direction_" + cId + "\" style=\"width:43px;\"><option value=\"a\">Ascending</option><option value=\"d\">Descending</option></select>";

		if(colData[cId-1].sort != "") {
			id("col_sort_" + cId).selectedIndex = parseInt(colData[cId-1].sort,10);
		}

		if(colData[cId-1].direction == "d") {
			id("col_sort_direction_" + cId).selectedIndex = 1;
		}
		
		//Group Header
		cell = row.insertCell(-1);
		cell.innerHTML = "<input type=\"text\" id=\"col_header_" + cId + "\" style=\"width:85px\" value=\""+colData[cId-1].header+"\"/>";

		//Align
		cell = row.insertCell(-1);
		cell.innerHTML = "<select id=\"col_align_" + cId + "\" style=\"width:48px\"><option value=\"l\">Left</option><option value=\"c\">Centre</option><option value=\"r\">Right</option></select>";

		var align = colData[cId-1].align;
		if(align == "c") {
			id("col_align_"+cId).selectedIndex = 1;
		} 
		if(align == "r") {
			id("col_align_"+cId).selectedIndex = 2;
		}
	}
	
	if(cSelected) {
		colRowSelected = row;
		row.onclick(false,true);
	}
	
}

var colSortOptions = "";
function colRegenerate() {
	if(colRowSelected != false) {
		var colRowSelectedId = colRowSelected.colId;
	}
	emptyTable("tblInactiveCol");
	emptyTable("tblActiveCol");

	var colSort = [];
	var sortCount = 1;
	colSortOptions = "<option value=\"\"></option>";
	for(var count=0; count < colData.length; count++) {
		colSortOptions += "<option value=\"" + sortCount.toString() + "\">" + sortCount.toString() + "</option>";
		sortCount++;
	}
	for(var count=0; count < colData.length; count++) {
		if(colData[count].active != "1") {
			var selected = false;
			if(colData[count].id == colRowSelectedId) {
				selected = true;
			}
			colRow("tblInactiveCol",colData[count].id,colData[count].name,selected);
		} else {
			colSort[colData[count].order] = count;
		}
	}

	for(var count=1; count < colSort.length; count++) {
		var selected = false;
		if(colData[colSort[count]].id == colRowSelectedId) {
			selected = true;
		}
		colRow("tblActiveCol",colData[colSort[count]].id,colData[colSort[count]].name,selected);
	}
  $('.tooltip').not('.tooltipstered').tooltipster({
      theme: 'tooltipster-shadow',
      side: 'right',
      contentAsHTML: true
  });
}

function colOrderArray() {
	var colOrder = [];
	for(var count=0; count < colData.length; count++) {
		if(colData[count].active == "1") {
			colOrder[colData[count].order] = count;
		} else {
			colData[count].order = 0;
		}
	}

	var newColOrder = [];

	for(var count=1; count < colOrder.length; count++) {
		var key = colOrder[count];
		if(colData[key]) {
			newColOrder[newColOrder.length] = key;
		}
	}
	return newColOrder;
}

function colNormaliseOrder() {
	var colOrder = colOrderArray();

	var orderCount = 1;
	for(var count=0; count < colOrder.length; count++) {
		colData[colOrder[count]].order = orderCount;
		orderCount++;
	}
}

function colAdd() {
	if(!colRowSelected) { return false; }

	var maxOrder = 0;
	for(var count=0; count < colData.length; count++) {
		if(parseInt(colData[count].order) > parseInt(maxOrder)) { 
			maxOrder = parseInt(colData[count].order);
		}
	}
	maxOrder++;
	
	for(var count=0; count < colData.length; count++) {
		if(colRowSelected.colId == colData[count].id) {
			colData[count].active = "1";
			colData[count].order = maxOrder;
		}
	}	

	colNormaliseOrder();
	colRegenerate();
}

function colRemove() {
	if(!colRowSelected) { return false; }

	for(var count=0; count < colData.length; count++) {
		if(colRowSelected.colId == colData[count].id) {
			colData[count].active = "0";
		}
	}	
	colNormaliseOrder();
	colRegenerate();
}

function colSwapOrder(key1, key2) {
	var temp = colData[key1].order;
	colData[key1].order = colData[key2].order;
	colData[key2].order = temp;
}

function colMove(direction) {
	if(!colRowSelected) { return false; }

	var colOrder = colOrderArray();
	var colFirst = colOrder[0];
	
	for(var count=0; count < colOrder.length; count++) {
		var key = colOrder[count];
		if(colRowSelected.colId == colData[key].id) {
			if(!direction) {
				if(count != 0) {
					colSwapOrder(key,colOrder[count-1]);
				}
			} else {
				if(count < colOrder.length-1) {
					colSwapOrder(key,colOrder[count+1]);
				}
			}
		}
	}

	colNormaliseOrder();
	colRegenerate();
}

function colUp() {
	colMove();
}

function colDown() {
	colMove(true);
}

//New functions for note section of report builder

var travelColRowSelected = false;

function travelColRow(cObjId,cId,cLabel,cSelected) {
	var row = id(cObjId).insertRow(-1);
	row.tableName = cObjId;
	row.colId = cId;
	row.onmouseover = function() {
		this.style.backgroundColor = "#cfc";
	}
	row.onmouseout = function() {
		if(travelColRowSelected == this) {
			this.style.backgroundColor = "#31ff63";
		} else {
			this.style.backgroundColor = "";
		}
	}
	row.onclick = function(e,force) {
		if(travelColRowSelected != this || (travelColRowSelected == this && force) ) {
			if(travelColRowSelected) {
				travelColRowSelected.style.backgroundColor = "";
				travelColRowSelected.firstChild.style.fontWeight = "";
			}
			travelColRowSelected = this;
			this.firstChild.style.fontWeight = "bold";
			if(this.style.backgroundColor == "") {
				this.style.backgroundColor = "#31ff63";
			}
			if(this.tableName == "tblInactiveTravelCol") {
				id("btnTravelColAdd").disabled = false;
				id("btnTravelColRemove").disabled = true;
				id("btnTravelColUp").disabled = true;
				id("btnTravelColDown").disabled = true;
			} else {
				id("btnTravelColAdd").disabled = true;
				id("btnTravelColRemove").disabled = false;
				id("btnTravelColUp").disabled = false;
				id("btnTravelColDown").disabled = false;
			}
		} else {
			travelColRowSelected = false;
			this.firstChild.style.fontWeight = "";
			id("btnTravelColAdd").disabled = true;
			id("btnTravelColRemove").disabled = true;
			id("btnTravelColUp").disabled = true;
			id("btnTravelColDown").disabled = true;
		}
	}

	// name
	var cell = row.insertCell(-1);
	cell.innerHTML = cLabel;
  cell.title = cLabel;
	cell.className = "imgLink tooltip";
	if(travelColData[cId-1].disable == '1') {
		cell.style.backgroundColor = "#999";
	}
	cell.style.width = "98px";
	if(cObjId == "tblInactiveTravelCol") {
		cell.style.whiteSpace = "nowrap";
	}

	if(cObjId == "tblActiveTravelCol") {
		// label
		cell = row.insertCell(-1);
		//cell.style.width = "105px";
		cell.innerHTML = "<input type=\"text\" id=\"travelCol_label_" + cId + "\" style=\"width:97px;\" value=\""+travelColData[cId-1].label+"\"/><input type=\"hidden\" id=\"travelCol_objType_" + cId + "\" value=\""+travelColData[cId-1].objType+"\"/><input type=\"hidden\" id=\"travelCol_rf_obj_trip_ix_" + cId + "\" value=\""+travelColData[cId-1].rf_obj_trip_ix+"\"/>";
	
		//split
		if(travelColData[cId-1].objType=='3' || travelColData[cId-1].objType=='4' || travelColData[cId-1].objType=='5') {
			var splitChecked = "";
			if(travelColData[cId-1].split == 1) {
				splitChecked = "checked";
			}
			cell = row.insertCell(-1);
			//cell.style.width = "40px";
			cell.innerHTML = "<input type=\"checkbox\" id=\"travelCol_split_" + cId + "\" name=\"splitCheck\"  value=\""+travelColData[cId-1].split+"\" "+splitChecked+"/>";
		} else {
			cell = row.insertCell(-1);
		}

	// width
		cell = row.insertCell(-1);
		//cell.style.width = "40px";
		cell.innerHTML = "<input type=\"text\" id=\"travelCol_width_" + cId + "\" style=\"width:28px;\" value=\""+travelColData[cId-1].width+"\"/>";
		
		//sort
		cell = row.insertCell(-1);
		//cell.style.width = "65px";
		cell.innerHTML = "<select id=\"travelCol_sort_" + cId + "\" style=\"width:35px;\">"+travelColSortOptions+"</select><select id=\"travelCol_sort_direction_" + cId + "\" style=\"width:43px;\"><option value=\"a\">Ascending</option><option value=\"d\">Descending</option></select>";

		if(travelColData[cId-1].sort != "") {
			id("travelCol_sort_" + cId).selectedIndex = parseInt(travelColData[cId-1].sort,10);
		}

		if(travelColData[cId-1].direction == "d") {
			id("travelCol_sort_direction_" + cId).selectedIndex = 1;
		}
		
		//Group Header
		cell = row.insertCell(-1);
		//cell.style.width = "100px";
		cell.innerHTML = "<input type=\"text\" id=\"travelCol_header_" + cId + "\" style=\"width:85px\" value=\""+travelColData[cId-1].header+"\"/>";

		//Align
		cell = row.insertCell(-1);
		//cell.style.width = "45px";
		cell.innerHTML = "<select id=\"travelCol_align_" + cId + "\" style=\"width:48px\"><option value=\"l\">Left</option><option value=\"c\">Centre</option><option value=\"r\">Right</option></select>";

		var align = travelColData[cId-1].align;
		if(align == "c") {
			id("travelCol_align_"+cId).selectedIndex = 1;
		} 
		if(align == "r") {
			id("travelCol_align_"+cId).selectedIndex = 2;
		}
	}
	
	if(cSelected) {
		travelColRowSelected = row;
		row.onclick(false,true);
	}
	
}

var travelColSortOptions = "";
function travelColRegenerate() {
	if(travelColRowSelected != false) {
		var travelColRowSelectedId = travelColRowSelected.colId;
	}
	emptyTable("tblInactiveTravelCol");
	emptyTable("tblActiveTravelCol");

	var travelColSort = [];
	var sortCount = 1;
	travelColSortOptions = "<option value=\"\"></option>";
	for(var count=0; count < travelColData.length; count++) {
		travelColSortOptions += "<option value=\"" + sortCount.toString() + "\">" + sortCount.toString() + "</option>";
		sortCount++;
	}
	for(var count=0; count < travelColData.length; count++) {
		if(travelColData[count].active != "1") {
			var selected = false;
			if(travelColData[count].id == travelColRowSelectedId) {
				selected = true;
			}
			travelColRow("tblInactiveTravelCol",travelColData[count].id,travelColData[count].name,selected);
		} else {
			travelColSort[travelColData[count].order] = count;
		}
	}

	for(var count=1; count < travelColSort.length; count++) {
		var selected = false;
		if(travelColData[travelColSort[count]].id == travelColRowSelectedId) {
			selected = true;
		}
		travelColRow("tblActiveTravelCol",travelColData[travelColSort[count]].id,travelColData[travelColSort[count]].name,selected);
	}
  $('.tooltip').not('.tooltipstered').tooltipster({
      theme: 'tooltipster-shadow',
      side: 'right',
      contentAsHTML: true
  });
}

function travelColOrderArray() {
	var travelColOrder = [];
	for(var count=0; count < travelColData.length; count++) {
		if(travelColData[count].active == "1") {
			travelColOrder[travelColData[count].order] = count;
		} else {
			travelColData[count].order = 0;
		}
	}

	var newColOrder = [];

	for(var count=1; count < travelColOrder.length; count++) {
		var key = travelColOrder[count];
		if(travelColData[key]) {
			newColOrder[newColOrder.length] = key;
		}
	}
	return newColOrder;
}

function travelColNormaliseOrder() {
	var travelColOrder = travelColOrderArray();

	var travelOrderCount = 1;
	for(var count=0; count < travelColOrder.length; count++) {
		travelColData[travelColOrder[count]].order = travelOrderCount;
		travelOrderCount++;
	}
}

function travelColAdd() {
	if(!travelColRowSelected) { return false; }

	var maxOrder = 0;
	for(var count=0; count < travelColData.length; count++) {
		if(parseInt(travelColData[count].order) > parseInt(maxOrder)) { 
			maxOrder = parseInt(travelColData[count].order);
		}
	}
	maxOrder++;
	
	for(var count=0; count < travelColData.length; count++) {
		if(travelColRowSelected.colId == travelColData[count].id) {
			travelColData[count].active = "1";
			travelColData[count].order = maxOrder;
		}
	}	

	travelColNormaliseOrder();
	travelColRegenerate();
}

function travelColRemove() {
	if(!travelColRowSelected) { return false; }

	for(var count=0; count < travelColData.length; count++) {
		if(travelColRowSelected.colId == travelColData[count].id) {
			travelColData[count].active = "0";
		}
	}	
	travelColNormaliseOrder();
	travelColRegenerate();
}

function travelColSwapOrder(key1, key2) {
	var temp = travelColData[key1].order;
	travelColData[key1].order = travelColData[key2].order;
	travelColData[key2].order = temp;
}

function travelColMove(direction) {
	if(!travelColRowSelected) { return false; }

	var colOrder = travelColOrderArray();
	var colFirst = colOrder[0];
	
	for(var count=0; count < colOrder.length; count++) {
		var key = colOrder[count];
		if(travelColRowSelected.colId == travelColData[key].id) {
			if(!direction) {
				if(count != 0) {
					travelColSwapOrder(key,colOrder[count-1]);
				}
			} else {
				if(count < colOrder.length-1) {
					travelColSwapOrder(key,colOrder[count+1]);
				}
			}
		}
	}

	travelColNormaliseOrder();
	travelColRegenerate();
}

function travelColUp() {
	travelColMove();
}

function travelColDown() {
	travelColMove(true);
}

var dateObj = "";

function openCal(obj,e) {
   dateObj = obj;
   screenPosX = getClickPosition(e,'x');
   screenPosY = getClickPosition(e,'y');
   openPopup('/resource/Resrequest/Application/public/html/calendar.htm',300,185,screenPosX,screenPosY);
}

function resLinkToggle(mode){
	if(mode == '0') {
		id('guestResDetailsRow1').className = "collapse printCollapse";
		id('guestResDetailsRow2').className = "collapse printCollapse";
		id('guestResDetailsRow3').className = "collapse printCollapse";
		id('guestResDetailsRow4').className = "collapse printCollapse";
		id('guestResDetailsRow5').className = "collapse printCollapse";
		id('guestResDetailsRow6').className = "collapse printCollapse";
		id('guestResDetailsRow7').className = "collapse printCollapse";
        id('guestResDetailsRow8').className = "collapse printCollapse";
        id('guestResDetailsRow9').className = "collapse printCollapse";
	} else {
		id('guestResDetailsRow1').className = "";
		id('guestResDetailsRow2').className = "";
		id('guestResDetailsRow3').className = "";
		id('guestResDetailsRow4').className = "";
		id('guestResDetailsRow5').className = "";
		id('guestResDetailsRow6').className = "";
		id('guestResDetailsRow7').className = "";
        id('guestResDetailsRow8').className = "";
        id('guestResDetailsRow9').className = "";
	}
}

function exportOptionToggle() {
	if(id("exportHorizontal").checked) {
		id("exportRepeat").checked = false;
		id("exportRepeat").disabled = true;
	} else {
		id("exportRepeat").disabled = false;
	}
}
