var origin = "";
var enabledButtons = new Array("Back","Forward","Refresh","Print","Calendar","Internet","Home","Help","NewWindow");
var enabledFunctions = new Array("Back","Forward","Refresh","Print","Calendar","Internet","Home","Help");

function initialisePage () {
	initTop();
	enableButtons(enabledButtons);	// Enable default buttons (as defined in toolbar object)
	dateSelector();
	
	id("user").innerHTML = FirstName + " " + LastName;
	id("server").innerHTML = Domain;
	id("genDate").innerHTML = genDateVal;
	runLastReportParams();

	$(document).ready(function() {
		initialiseToolTipster();
	});
}

function initialiseToolTipster() {
	$('.tooltipster').tooltipster({
		"theme": "tooltipster-borderless",
		"maxWidth": 400,
		contentAsHTML: true
	});
}

function chngSort(var1) {
	id("sortBy").value = var1;
	generateReport();
}

function openFilter(filter) {
	$("#openedFilter").val(filter);
	var selectedArray = id(filter + "Ids").value;
	var selectedFunctionArray = id("miscFunctionIds").value;
	url = ["reservation.php?661",
			filter,
			selectedArray,
			selectedFunctionArray
		];
	openPopup(url.join("+"),280,360);                          
}

function onAfterFilter() {
	if ($("#openedFilter").val() == "miscFunction") {
		// Reset Type selection when Function selection changes
		$("#miscTypeIds").val('');
		$("#miscTypeFilter").html('All');
	}
	$("#openedFilter").val('');
}
					
function showHideFilters() {
	var filters = id("filters");
	var filterBut = id("filterBut");  
	if(filters.className == "expand") {
		filters.className = "collapse printCollapse";
		filterBut.value = ">> Show Filters";
	} else {
		filters.className = "expand";
		filterBut.value = "<< Hide Filters";
	}
}

function headerRow() {
	var row = `
		<tr>
	        <th class="outLt" style="width: 60px">
	          <div style="float:left;">
	            Date&nbsp;
	            <img class="imgLink printCollapse" onclick="chngSort(0)" id="arrow0" src="/resource/Resrequest/Application/public/img/arrow_up_16.gif" width="14" height="14" alt="Sort in ascending order" title="Sort in ascending order" />
	            <img class="imgLink printCollapse" onclick="chngSort(1)" id="arrow1" src="/resource/Resrequest/Application/public/img/arrow_down_16.gif" width="14" height="14" alt="Sort in descending order" title="Sort in descending order" />
	          </div>
	        </th>
	        <th class="outLt" style="width: 60px">
	          <div style="float:left;">
	            Time
	          </div>
	        </th>
	        <th class="outLt" style="width: 200px">
	          <div style="float:left;">
	            User&nbsp;
	            <img class="imgLink printCollapse" onclick="chngSort(2)" id="arrow2" src="/resource/Resrequest/Application/public/img/arrow_up_16.gif" width="14" height="14" alt="Sort in ascending order" title="Sort in ascending order" />
	            <img class="imgLink printCollapse" onclick="chngSort(3)" id="arrow3" src="/resource/Resrequest/Application/public/img/arrow_down_16.gif" width="14" height="14" alt="Sort in descending order" title="Sort in descending order" />
	          </div>
	        </th>
	        <th class="outLt" style="width: 250px">
	          <div style="float:left;">
	            Function&nbsp;
	            <img class="imgLink printCollapse" onclick="chngSort(4)" id="arrow4" src="/resource/Resrequest/Application/public/img/arrow_up_16.gif" width="14" height="14" alt="Sort in ascending order" title="Sort in ascending order" />
	            <img class="imgLink printCollapse" onclick="chngSort(5)" id="arrow5" src="/resource/Resrequest/Application/public/img/arrow_down_16.gif" width="14" height="14" alt="Sort in descending order" title="Sort in descending order" />
	          </div>
	        </th>
	        <th class="outLt" style="width: 60px">
	          <div style="float:left;">
	            Env&nbsp;
	            <img class="imgLink printCollapse" onclick="chngSort(8)" id="arrow8" src="/resource/Resrequest/Application/public/img/arrow_up_16.gif" width="14" height="14" alt="Sort in ascending order" title="Sort in ascending order" />
	            <img class="imgLink printCollapse" onclick="chngSort(9)" id="arrow9" src="/resource/Resrequest/Application/public/img/arrow_down_16.gif" width="14" height="14" alt="Sort in descending order" title="Sort in descending order" />
	          </div>
	        </th>
      	</tr>`;
    $("#resultTable").empty().append(row);
}

function generateReport(type="getHeaders") {
	$("#generateButton").hide();
	$("#spinner").show();

	var dateFrom = $("#fromYear").val() + '-' + ("0" + $("#fromMonth").val()).slice(-2) + '-' + ("0" + $("#fromDay").val()).slice(-2);
	var dateTo = $("#toYear").val() + '-' + ("0" + $("#toMonth").val()).slice(-2) + '-' + ("0" + $("#toDay").val()).slice(-2);

	var urlParams = type +  '+' +
		$("#miscAuditUserIds").val() +  '+' +
		$("#miscAuditUserFilter").val() +  '+' +
		$("#miscFunctionIds").val() +  '+' +
		$("#miscFunctionFilter").val() +  '+' +
		$("#miscTypeIds").val() +  '+' +
		$("#miscTypeFilter").val() +  '+' +
		dateFrom +  '+' +
		dateTo +  '+' +
		$("#sortBy").val();

	$.ajax({
		method: "POST",
		url: "reservation.php?6040+" + urlParams
	})
	.done(function(result) {
		result = JSON.parse(result);
		$("#rows").show();
		$("#generateButton").show();
		$("#spinner").hide();

		if (type == "getCSV") {
			let csvContent = "data:text/csv;charset=utf-8," + result.map(e => e.join(",")).join("\n");
			var encodedUri = encodeURI(csvContent);
			var link = document.createElement("a");
			link.setAttribute("href", encodedUri);
			link.setAttribute("download", "Misc_Audit_" + dateFrom + "_to_" + dateTo + ".csv");
			document.body.appendChild(link); // Required for FF
			link.click();
		}

		if (type == "getHeaders") {
			$("#resultTable").empty();

			if (result.length == 0) {
				var row = `<tr valign="top">
					<td colspan="5" align="center" style="padding: 20px;">
						No results returned
					</td>
				</tr>`;
				$("#resultTable").append(row);
				$("#exportButtons").hide();
			} else {
				headerRow();
				$.each(result, function(key, record) {
					var row = `<tr style="height: 20px;" valign="top" class="highlightRow tooltipster" onclick="getDetail('` + record.misc_id + `')" title="Open details of this change">
							<td class="br">` + record.misc_date_formatted + `</td>
							<td class="br">` + record.misc_time + `</td>
							<td class="br">` + record.pr_name + `</td>
							<td class="br">` + record.misc_action + `</td>
							<td class="br">` + record.misc_database + `</td>
						</tr>`;
					$("#resultTable").append(row);
				});
				$("#exportButtons").show();
				$("#exportButtons").show();
				var current_arrow = $("#arrow" + $("#sortBy").val()).attr("src");
				$("#arrow" + $("#sortBy").val()).attr("src", current_arrow.replace('.gif', '_z.gif'));
				initialiseToolTipster();
			}
		}
	});
}

function getDetail(id) {
	var content = `<div id="detailsPopup"><div style="padding: 20px 0px 20px 0px;"><div class="loaderCircle"></div></div></div>`;
    var buttons = {
        'a':{'label':'Close', 'callback':'', 'class':''}
    };

    overlayPopup('Audit Details', content, buttons, 670);
    applyTrans(1);

	var urlParams = "getDetail" +  '++++++++++' + id;

	$.ajax({
		method: "POST",
		url: "reservation.php?6040+" + urlParams
	})
	.done(function(result) {
		result = JSON.parse(result);
		$("#generateButton").show();
		$("#spinner").hide();

		var content = `
			<div style="padding: 20px; text-align: left; max-height: 60vh; overflow: scroll;">
				<table cellpadding="2" cellspacing="0" border="0" style="margin-bottom: 20px;">
					<tr><td>Time:</td><td>` + result.header.misc_date_formatted +` ` + result.header.misc_time +`</td></tr>
					<tr><td>Name:</td><td>` + result.header.pr_name +`</td></tr>
					<tr><td>Action:</td><td>` + result.header.misc_action +`</td></tr>
					<tr><td style="width: 100px;">Environment:</td><td>` + result.header.misc_database +`</td></tr>
				</table>
            	<table width="100%" cellpadding="0" cellspacing="0" border="0">
        `;

		if (result.detail.length == 0) {
			var row = `<tr valign="top">
				<td colspan="5" align="center" style="padding: 20px;">
					No result returned
				</td>
			</tr>`;
			$("#resultTable").append(row);
			$("#exportButtons").hide();
		} else {
			var actions = {
				1: "Add",
				2: "Edit",
				3: "Delete"
			}
			content += `<tr style="height: 20px;" valign="top">
						<td style="border-bottom-style: solid; border-bottom-width: 1px;">Action</td>
						<td style="border-bottom-style: solid; border-bottom-width: 1px;">Desciption</td>
						<td style="border-bottom-style: solid; border-bottom-width: 1px;">Before</td>
						<td style="border-bottom-style: solid; border-bottom-width: 1px;">After</td>
					</tr>`;
			$.each(result.detail, function(key, record) {
				content += `<tr style="height: 20px;" valign="top">
						<td>` + actions[record.action] + `</td>
						<td>` + record.module_desc + `</td>
						<td class="">` + record.value_from + `</td>
						<td class="">` + record.value_to + `</td>
					</tr>`;
			});
		}

		content += `</table></div>`;
		$("#detailsPopup").html(content);
		centerDivOnPage('overlayPopup');
	});
}

function runLastReportParams() {
	if ($("#runLastReportParams").val() != '') {
		$("#runLastReportParams").val('');
		generateReport();
	}
}