function initialisePage() {
	dateSelector();
	initTop();
	enableButtons(enabledButtons);
	
	populateDateFields("fromYear", _fromY, "fromMonth", _fromM, "fromDay", _fromD);
	populateDateFields("toYear", _toY, "toMonth", _toM, "toDay", _toD);

	dateTypeChange();
	colRegenerate();
	noteColRegenerate();
	showHideDupArrSty();
}

function openFilter(filter){
	var selectedArray = id(filter + "Ids").value;

	url = "reservation.php?661+"
		+ filter
		+ "+"
		+ selectedArray;    
         
	openPopup(url,280,360);                          
}

function openExtrasCat(filter){
	var selectedArray = id(filter + "Ids").value;

	url = "reservation.php?753+"
		+ filter
		+ "+"
		+ selectedArray;

	openPopup(url,290,400);
}

function buildDate(prefix) {
	dayValue = id(prefix+"Day").options[id(prefix+"Day").selectedIndex].value;
	monthValue = id(prefix+"Month").options[id(prefix+"Month").selectedIndex].value;

	dayValue = dayValue<10?"0"+dayValue:dayValue;
	monthValue = monthValue<10?"0"+monthValue:monthValue;
	 
	resultDate = id(prefix+"Year").value+"-"+monthValue+"-"+dayValue;
      
	if(dayValue < 1) { 
		id(prefix+"Day").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(monthValue < 1) {
		id(prefix+"Month").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(id(prefix+"Year").value == "") {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;		 
	 }		 
	if(id(prefix+"Year").value.search(/^\d{4}$/) == -1) {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}

	return resultDate;
}  

function buildOptions(bName) {
	var list = document.getElementsByName(bName +"Check");
	var chosen = [];
	for(var count = 0; count < list.length; count++) {
		if(list[count].checked) {
			chosen.push(list[count].id.toString().replace(bName,""));
		}
	}
	return chosen.join(":");
}

function getDateType() {
	if(id("dateTypeToday").checked) {
		return "1";
	}
	if(id("dateTypeDayCount").checked) {
		return "2";
	}
	if(id("dateTypeTomorrow").checked) {
		return "4";
	}	
	return "3";
}

function getExtraOption() {
	if(id("extraShowAll").checked) {
		return "1";
	} else if(id("extraShowProp").checked) {
		return "2";
	} else {
		return "3";
	}
}

function getNoteSort() {
	if(id("noteSortArrive").checked) {
		return "1";
	} else if(id("noteSortDepart").checked) {
		return "2";
	} else if(id("noteSortId").checked) {
		return "3";
	} else {
		return "4";
	}
}

function buildCols() {
	var cols = [];
	for(var count=0; count<colData.length; count++) {
		var cWidth = colData[count].width;
		var cLabel = colData[count].label;
		var cHeader = colData[count].header;
		var cAlign = colData[count].align;
		
		if(colData[count].active == "1") {
			cWidth = id("col_width_" + colData[count].id).value;
			cLabel = id("col_label_" + colData[count].id).value;
			cHeader = id("col_header_" + colData[count].id).value;
			cAlign = selValue("col_align_" + colData[count].id);
		}
		var col = [
			colData[count].active,
			colData[count].order,
			cWidth,
			cLabel,
			cHeader,
			cAlign
		]
		cols[cols.length] = col.join(",");     //cSort, cDirection,
	}
	return cols.join(":");
}

function buildNoteCols() {
	var noteCols = [];
	for(var count=0; count<noteColData.length; count++) {
		var cLabel = noteColData[count].label;
		var cAlign = noteColData[count].align;
		
		if(noteColData[count].active == "1") {
			cLabel = id("col_label_" + noteColData[count].id).value;
			cAlign = selValue("col_align_" + noteColData[count].id);
		}
		var col = [
			noteColData[count].active,
			noteColData[count].order,
			cLabel,
			cAlign
		]
		noteCols[noteCols.length] = col.join(",");    
	}
	return noteCols.join(":");
}

function buildOptionsNew(bName) {
	var colArr = [];
	var i=0;
	for(var count=0; count<colData.length; count++) {
		if(id("col_"+bName+"_" + colData[count].id)) {
			if(id("col_"+bName+"_" + colData[count].id).checked) {
				//cols[cols.length] = colData[count].id;
				colArr[i] = colData[count].id;
				i++;
			}
		}
	}
	return colArr.join(":");
}

function buildOptionsNote(bName) {
	var cols = [];
	for(var count=0; count<noteColData.length; count++) {
		if(id("col_"+bName+"_" + noteColData[count].id)) {
			if(id("col_"+bName+"_" + noteColData[count].id).value == 1) {
				cols[cols.length] = noteColData[count].id;
			}
		}
	}
	return cols.join(":");
}

function getNoteHeader() {
	var hdr = [];
	if(id("noteHeaderProperty").checked) {
		hdr[hdr.length] = 1;
	}
	if(id("noteHeaderId").checked) {
		hdr[hdr.length] = 2;
	} 
	if(id("noteHeaderName").checked) {
		hdr[hdr.length] = 3;
	}
	if(id("noteHeaderArr").checked) {
		hdr[hdr.length] = 4;
	}
	if(id("noteHeaderDepart").checked) {
		hdr[hdr.length] = 5;
	}
	return hdr.join(":");
}

function buildURL(renderOption) {
	renderOption &= 15;		// Render CSV from XML (REP_VIEW_CSV_FROM_XML)
	_urlCount++;

	var dateType = getDateType();
	var dayCount = id("dayCount").value;
	var fromDate = "";
	var toDaye = "";
	if(dateType == "3") { 
		var fromDate = buildDate("from");
		if(!fromDate) { return false; }
		var toDate = buildDate("to");
		if(!toDate) { return false; }
		if(buildDate("from") > buildDate("to") ) {
			id("toDay").focus();
			openMessage("Please enter a To date that is greater than or equal to the From date","a",120);
			return false;
		}

	}

	var groupingSepAs = 1;
	if(id("groupingSepAsCol").checked) {
		var groupingSepAs = 2;
	} else if(id("groupingSepAsTab").checked) {
		var groupingSepAs = 3;
	}

	var roomShow = buildOptionsNew("Room");
	var soShow = buildOptionsNew("SO");
	var departShow = buildOptionsNew("Depart");
	var colourShow = buildOptionsNew("Colour");
	var legendShow = buildOptionsNew("Legend");
	var perDayShow = buildOptionsNew("PerDay");
	var noteShow = buildOptionsNote("Note");
	if(roomShow == "") {
		roomShow = "1"
	}
	var cols = buildCols();
	var noteCols = buildNoteCols();
	setExtrasIds();
	var url = [
		/*  0 */ "reservation.php?312",
		/*  1 */ dateType,
		/*  2 */ dayCount,
		/*  3 */ fromDate,
		/*  4 */ toDate,
		/*  5 */ id("accommIds").value,
		/*  6 */ id("statusRoomIds").value, // status filter goes here
		/*  7 */ id("extraFilterTypeCategory").checked?"1":"2",
		/*  8 */ id("extrasIds").value,
		/*  9 */ id("extraCategoryIds").value,
		/* 10 */ getExtraOption(),
		/* 11 */ id("directionRoom").checked?"1":"2",
		/* 12 */ id("roomSortNumber").checked?"1":"2",
		/* 13 */ id("autoRoom").checked?"1":"2",
		/* 14 */ id("showChart").checked?"1":"2",
		/* 15 */ id("showNotes").checked?"1":"2",
		/* 16 */ id("showAccomm").checked?"1":"2",
		/* 17 */ id("showPAX").checked?"1":"2",
		/* 18 */ id("showLegend").checked?"1":"2",
		/* 19 */ id("showUnitLabel").checked?"1":"2",
		/* 20 */ id("showUnitNumber").checked?"1":"2",
		/* 21 */ id("showDatePAX").checked?"1":"2",
		/* 22 */ roomShow,
		/* 23 */ departShow,
		/* 24 */ colourShow,
		/* 25 */ legendShow,
		/* 26 */ noteShow,
		/* 27 getNoteSort()*/id("noteSort").value,
		/* 28 */ id("noteDateReservation").checked?"1":"2",
		/* 29 */ renderOption,
		/* 30 */ _randomId + "_" + _urlCount.toString(),
		/* 31 */ id("showCatExtras").checked?"1":"2",
		/* 32 */ id("componentsIds").value,
		/* 33 */ cols,
		/* 34 */ groupingSepAs,
		/* 35 */ id("groupingCombArrSty").checked?"1":"2",
		/* 36 */ id("detailAsRow").checked?"1":"2",
		/* 37 */ soShow,
		/* 38 */ perDayShow,
		/* 39 */ getNoteHeader(),
		/* 40 */ id("pdfOrnt").value,
		/* 41 */ noteCols,
		/* 42 */ id("rateIds").value,
		/* 43 */ id("showEmptyRooms").checked?"1":"2",
		/* 44 */ id("hideAccommType").checked?"1":"2",
		/* 45 */ id("groupingDupArrSty").checked?"1":"2"
	];
   
	return url.join("+");
}

function generateReport() {
	if(id("showChart").checked==false && (id("showNotes").checked==true && id("autoRoom").checked==false)) {
		openMessage("Please select Auto-allocate rooms option.");
			return false;
	}
	url = buildURL();
	if(url) {
		id("urlForm").target = "_self";
		id("url").value = url;
		id("urlForm").submit();
	}
}

function openCSV() {
	if(totalRows > 256 && id("showChart").checked == true) {
		openMessage("The maximum number of columns allowed by Excel / Open Office<br>is 256 and has been exceeded (this report has "+totalRows+" columns).<br>Please reduce number of columns to allow this export.", '', 140);
		return false;
	}
	url = buildURL(4);
	if(url) {
		id("urlForm").target = "_self";
		id("url").value = url;
		id("urlForm").submit();
	}
}

function openXmlCSV() {
	url = buildURL(15);
	if(url) {
		id("urlForm").target = "_self";
		id("url").value = url;
		id("urlForm").submit();
	}
}

function openPDF(){
	url = buildURL(1);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading PDF...",640,480,0,0,0,1,"pdfWin","opener.id('urlForm').submit();");
	}
}

function sendPDF(){
	url = buildURL(2);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin = openPopup("/resource/Resrequest/Application/public/html/wait.htm?Loading email popup...",775,615,0,0,0,0,"pdfWin","opener.id('urlForm').submit();");
	}
}

function select_daymonth_changed(){
	setDayList(id("fromDay"),id("fromMonth").options[id("fromMonth").selectedIndex].value,id("fromYear").value);
	setDayList(id("toDay"),id("toMonth").options[id("toMonth").selectedIndex].value,id("toYear").value);
}

function showHideFilters(){
	var filters = id("filters");
	var filterBut = id("filterBut");
	
	mnuInitialise = false;
	
	if( filters.className == "collapse printCollapse" ) {
		filters.className = "expand";
		filterBut.value 	= "<< Hide Filters";
	} else {
		filters.className = "collapse printCollapse";
		filterBut.value 	= ">> Show Filters";
	}
}

function dateTypeChange() {
	if (!id("dateTypeRange").checked ) {
		populateDateFields("fromYear", "", "fromMonth", 0, "fromDay", 0);
		populateDateFields("toYear", "", "toMonth", 0, "toDay", 0);
	} else {
		populateDateFields("fromYear", _fromY, "fromMonth", _fromM, "fromDay", _fromD);
		populateDateFields("toYear", _toY, "toMonth", _toM, "toDay", _toD);
	}
	return true;
}

function toggleCollapse(objId) {
	if(id(objId).className == "") {
		id(objId).className = "collapse printCollapse";
	} else {
		id(objId).className = "";
	}
}

function setExtrasIds() {
	list = document.getElementsByName("extraIds");
	last = [];
	if(list.length > 0) {
		for(count=0; count<list.length; count++) {
			tmp = list[count].value.toString().split(":");
			for(count2=0;count2<tmp.length; count2++) {
				last[last.length] = tmp[count2];
			}
		}
		id("extrasIds").value = last.join(":");
	} else {
		id("extrasIds").value = "";
	}	
}

function removeExtraIds(rCatId) {
	id("extra_"+rCatId).parentNode.removeChild(id("extra_"+rCatId));
	id("extraIds_"+rCatId).parentNode.removeChild(id("extraIds_"+rCatId));
	if(document.getElementsByName("extraIds").length === 0) {
		id("extraAll").className = "";
	} else {
		id("extraAll").className = "collapse";
	}
}

function openPropFilter() {
	var accomm = id("accommIds").value;
	openPopup("reservation.php?293+"+accomm,556,407);
}

function openOptReqFilter() {
	var accomm = id("accommIds").value;
	openPopup("reservation.php?661+components+"+accomm,556,407);
}

function printReport() {
	window.print();
}

function openOffice() {
	if(totalRows > 256 && id("showChart").checked == true) {
		openMessage("The maximum number of columns allowed by Excel / Open Office<br>is 256 and has been exceeded (this report has "+totalRows+" columns).<br>Please reduce number of columns to allow this export.", '', 140);
		return false;
	}
	url = buildURL(7);
	if(url) {
		id("urlForm").target = "_self";
		id("url").value = url;
		id("urlForm").submit();
	}
}

function showExportMenu(e, flag) {
	if ( !e ) {
		e = window.event;
	}
	stopBubble(e);

	var posx = 0;
	var posy = 0;
	
	if (e.pageX || e.pageY) 	{
		posx = e.pageX;
		posy = e.pageY;
	} else if (e.clientX || e.clientY) 	{
		posx = e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
		posy = e.clientY + document.body.scrollTop + document.documentElement.scrollTop;
	}

	if(flag == 1) {
		posy = posy-60;
	}

	id("exportOptionDiv").style.display	= "";
	id("exportOptionDiv").style.left = posx;
	id("exportOptionDiv").style.top = posy;
}

function closeOptDiv() {
	id('exportOptionDiv').style.display = "none";
}

//New functions forchart section of report builder
function emptyTable(objId) {
	var obj = id(objId);
	for(var count=obj.rows.length-1;count > -1; count--) {
		obj.deleteRow(count);
	}
}

var colRowSelected = false;

function changeValue(flag, cid) {
	if(flag == "label")
		colData[cid-1].label = id("col_"+flag+"_"+cid).value;
	if(flag == "width")
		colData[cid-1].width = id("col_"+flag+"_"+cid).value;
	if(flag == "header")
		colData[cid-1].header = id("col_"+flag+"_"+cid).value;
	if(flag == "align")
		colData[cid-1].align = id("col_"+flag+"_"+cid).value;
	if(flag == "room")
		colData[cid-1].room = id("col_Room_"+cid).checked?1:0;
	if(flag == "sover")
		colData[cid-1].sover = id("col_SO_"+cid).checked?1:0;
	if(flag == "depart")
		colData[cid-1].depart = id("col_Depart_"+cid).checked?1:0;
	if(flag == "perDay")
		colData[cid-1].perDay = id("col_PerDay_"+cid).checked?1:0;
	if(flag == "color")
		colData[cid-1].color = id("col_Colour_"+cid).checked?1:0;
	if(flag == "legend")
		colData[cid-1].legend = id("col_Legend_"+cid).checked?1:0;
	
}

function colRow(cObjId,cId,cLabel,cSelected) {
	var row = id(cObjId).insertRow(-1);
	row.tableName = cObjId;
	row.colId = cId;
	row.onmouseover = function() {
		this.style.backgroundColor = "#cfc";
	}
	row.onmouseout = function() {
		if(colRowSelected == this) {
			this.style.backgroundColor = "#31ff63";
		} else {
			this.style.backgroundColor = "";
		}
	}
	row.onclick = function(e,force) {
		if(colRowSelected != this || (colRowSelected == this && force) ) {
			if(colRowSelected) {
				colRowSelected.style.backgroundColor = "";
				colRowSelected.firstChild.style.fontWeight = "";
			}
			colRowSelected = this;
			this.firstChild.style.fontWeight = "bold";
			if(this.style.backgroundColor == "") {
				this.style.backgroundColor = "#31ff63";
			}
			if(this.tableName == "tblInactiveCol") {
				id("btnColAdd").disabled = false;
				id("btnColRemove").disabled = true;
				id("btnColUp").disabled = true;
				id("btnColDown").disabled = true;
			} else {
				id("btnColAdd").disabled = true;
				id("btnColRemove").disabled = false;
				id("btnColUp").disabled = false;
				id("btnColDown").disabled = false;
			}
		} else {
			colRowSelected = false;
			this.firstChild.style.fontWeight = "";
			id("btnColAdd").disabled = true;
			id("btnColRemove").disabled = true;
			id("btnColUp").disabled = true;
			id("btnColDown").disabled = true;
		}
	}

	// name
	var cell = row.insertCell(-1);
	cell.innerHTML = cLabel;
	cell.className = "imgLink";
	if(cObjId == "tblInactiveCol") {
		cell.style.whiteSpace = "nowrap";
		if(colData[cId-1].fulDesc != '') {
			cell.onmouseover = function(){overlib(colData[cId-1].fulDesc,WIDTH,110);};
			cell.onmouseout = function() {nd();};
		}
	}

	if(cObjId == "tblActiveCol") {
		// label
		cell = row.insertCell(-1);
		//cell.style.width = "95px";
		cell.innerHTML = "<input type=\"text\" id=\"col_label_" + cId + "\" style=\"width:98px;\" value=\""+colData[cId-1].label+"\" onblur=\"changeValue('label',"+cId+");\"/>";

		// width
		cell = row.insertCell(-1);
		cell.innerHTML = "<input type=\"text\" id=\"col_width_" + cId + "\" style=\"width:28px;\" value=\""+colData[cId-1].width+"\" onblur=\"changeValue('width',"+cId+");\"/>";

		//Group Header
		cell = row.insertCell(-1);
		cell.innerHTML = "<input type=\"text\" id=\"col_header_" + cId + "\" style=\"width:78px\" value=\""+colData[cId-1].header+"\" onblur=\"changeValue('header',"+cId+");\"/>";

		//Align
		cell = row.insertCell(-1);
		cell.innerHTML = "<select id=\"col_align_" + cId + "\" style=\"width:40px\" onchange=\"changeValue('align',"+cId+");\"><option value=\"l\">Left</option><option value=\"c\">Centre</option><option value=\"r\">Right</option></select>";

		var align = colData[cId-1].align;
		if(align == "c") {
			id("col_align_"+cId).selectedIndex = 1;
		} 
		if(align == "r") {
			id("col_align_"+cId).selectedIndex = 2;
		}
		
		// Inhouse
		var roomChecked = "checked";
		if(colData[cId-1].room == '0') {
			roomChecked = "";
		}
		cell = row.insertCell(-1);
		cell.innerHTML = "<input type=\"checkbox\" id=\"col_Room_" + cId + "\" name=\"RoomCheck\" value=\""+colData[cId-1].room+"\" "+roomChecked+" onclick=\"changeValue('room',"+cId+");\"/>";

		// stay over
		var soChecked = "checked";
		if(colData[cId-1].sover == '0') {
			soChecked = "";
		}
		cell = row.insertCell(-1);
		cell.innerHTML = "<input type=\"checkbox\" id=\"col_SO_" + cId + "\" name=\"SOCheck\"  value=\""+colData[cId-1].sover+"\" "+soChecked+" onclick=\"changeValue('sover',"+cId+");\"/>";

		// depart
		var departChecked = "checked";
		if(colData[cId-1].depart == '0') {
			departChecked = "";
		}
		cell = row.insertCell(-1);
		cell.innerHTML = "<input type=\"checkbox\" id=\"col_Depart_" + cId + "\" name=\"DepartCheck\"  value=\""+colData[cId-1].depart+"\" "+departChecked+" onclick=\"changeValue('depart',"+cId+");\"/>";

		if(colData[cId-1].pDay=='1') {
			// PerDay
			var perDayChecked = "";
			if(colData[cId-1].perDay == 1) {
				perDayChecked = "checked";
			}
			cell = row.insertCell(-1);
			cell.style.width = "30px";
			cell.innerHTML = "<input type=\"checkbox\" id=\"col_PerDay_" + cId + "\" name=\"perDayCheck\"  value=\""+colData[cId-1].perDay+"\" "+perDayChecked+" onclick=\"changeValue('perDay',"+cId+");\" onmouseover=\"overlib('Summarise by day', WIDTH, 100);\" onmouseout=\"nd();\"/>";
		} else {
			cell = row.insertCell(-1);
		}

		if(colData[cId-1].colorOpt) {
			// colour
			var colorChecked = "";
			var legendChecked = "";
			if(colData[cId-1].color == 1) {
				colorChecked = "checked";
			}
			cell = row.insertCell(-1);
			cell.innerHTML = "<input type=\"checkbox\" id=\"col_Colour_" + cId + "\" name=\"ColourCheck\"  value=\""+colData[cId-1].color+"\" "+colorChecked+" onclick=\"changeValue('color',"+cId+");\"/>";

			// legend
			if(colData[cId-1].legend == 1) {
				legendChecked = "checked";
			}
			cell = row.insertCell(-1);
			cell.innerHTML = "<input type=\"checkbox\" id=\"col_Legend_" + cId + "\" name=\"LegendCheck\"  value=\""+colData[cId-1].legend+"\" "+legendChecked+" onclick=\"changeValue('legend',"+cId+");\"/>";
		} else {
			cell = row.insertCell(-1);
			cell = row.insertCell(-1);
		}
	}
	
	if(cSelected) {
		colRowSelected = row;
		row.onclick(false,true);
	}
	
}

var colSortOptions = "";
function colRegenerate() {
	if(colRowSelected != false) {
		var colRowSelectedId = colRowSelected.colId;
	}
	
	emptyTable("tblInactiveCol");
	emptyTable("tblActiveCol");

	var colSort = [];
	var sortCount = 1;
	colSortOptions = "<option value=\"\"></option>";
	for(var count=0; count < colData.length; count++) {
		colSortOptions += "<option value=\"" + sortCount.toString() + "\">" + sortCount.toString() + "</option>";
		sortCount++;
	}
	for(var count=0; count < colData.length; count++) {
		if(colData[count].active != "1") {
			var selected = false;
			if(colData[count].id == colRowSelectedId) {
				selected = true;
			}
			colRow("tblInactiveCol",colData[count].id,colData[count].name,selected);
		} else {
			colSort[colData[count].order] = count;
		}
	}

	
	for(var count=1; count < colSort.length; count++) {
		var selected = false;
		if(colData[colSort[count]].id == colRowSelectedId) {
			selected = true;
		}
		colRow("tblActiveCol",colData[colSort[count]].id,colData[colSort[count]].name,selected);
	}
}

function colOrderArray() {
	var colOrder = [];
	for(var count=0; count < colData.length; count++) {
		if(colData[count].active == "1") {
			colOrder[colData[count].order] = count;
		} else {
			colData[count].order = 0;
		}
	}

	var newColOrder = [];

	for(var count=1; count < colOrder.length; count++) {
		var key = colOrder[count];
		if(colData[key]) {
			newColOrder[newColOrder.length] = key;
		}
	}
	return newColOrder;
}

function colNormaliseOrder() {
	var colOrder = colOrderArray();

	var orderCount = 1;
	for(var count=0; count < colOrder.length; count++) {
		colData[colOrder[count]].order = orderCount;
		orderCount++;
	}
}

function colAdd() {
	if(!colRowSelected) { return false; }
	var maxOrder = 0;
	for(var count=0; count < colData.length; count++) {
		if(parseInt(colData[count].order) > parseInt(maxOrder)) { 
			maxOrder = parseInt(colData[count].order);
		}
	}
	maxOrder++;
	
	for(var count=0; count < colData.length; count++) {
		if(colRowSelected.colId == colData[count].id) {
			colData[count].active = "1";
			colData[count].order = maxOrder;
		}
	}	

	colNormaliseOrder();
	colRegenerate();
}

function colRemove() {
	if(!colRowSelected) { return false; }

	for(var count=0; count < colData.length; count++) {
		if(colRowSelected.colId == colData[count].id) {
			colData[count].active = "0";
		}
	}	
	colNormaliseOrder();
	colRegenerate();
}

function colSwapOrder(key1, key2) {
	var temp = colData[key1].order;
	colData[key1].order = colData[key2].order;
	colData[key2].order = temp;
}

function colMove(direction) {
	if(!colRowSelected) { return false; }

	var colOrder = colOrderArray();
	var colFirst = colOrder[0];
	
	for(var count=0; count < colOrder.length; count++) {
		var key = colOrder[count];
		if(colRowSelected.colId == colData[key].id) {
			if(!direction) {
				if(count != 0) {
					colSwapOrder(key,colOrder[count-1]);
				}
			} else {
				if(count < colOrder.length-1) {
					colSwapOrder(key,colOrder[count+1]);
				}
			}
		}
	}

	colNormaliseOrder();
	colRegenerate();
}

function colUp() {
	colMove();
}

function colDown() {
	colMove(true);
}

//New functions for note section of report builder

var noteColRowSelected = false;

function changeNoteValue(flag, cid) {
	if(flag == "label")
		noteColData[cid-1].label = id("col_"+flag+"_"+cid).value;
	if(flag == "align")
		noteColData[cid-1].align = id("col_"+flag+"_"+cid).value;
}

function noteColRow(cObjId,cId,cLabel,cSelected) {
	var row = id(cObjId).insertRow(-1);
	row.tableName = cObjId;
	row.colId = cId;
	row.onmouseover = function() {
		this.style.backgroundColor = "#cfc";
	}
	row.onmouseout = function() {
		if(noteColRowSelected == this) {
			this.style.backgroundColor = "#31ff63";
		} else {
			this.style.backgroundColor = "";
		}
	}
	row.onclick = function(e,force) {
		if(noteColRowSelected != this || (noteColRowSelected == this && force) ) {
			if(noteColRowSelected) {
				noteColRowSelected.style.backgroundColor = "";
				noteColRowSelected.firstChild.style.fontWeight = "";
			}
			noteColRowSelected = this;
			this.firstChild.style.fontWeight = "bold";
			if(this.style.backgroundColor == "") {
				this.style.backgroundColor = "#31ff63";
			}
			if(this.tableName == "tblInactiveNoteCol") {
				id("btnNoteColAdd").disabled = false;
				id("btnNoteColRemove").disabled = true;
				id("btnNoteColUp").disabled = true;
				id("btnNoteColDown").disabled = true;
			} else {
				id("btnNoteColAdd").disabled = true;
				id("btnNoteColRemove").disabled = false;
				id("btnNoteColUp").disabled = false;
				id("btnNoteColDown").disabled = false;
			}
		} else {
			noteColRowSelected = false;
			this.firstChild.style.fontWeight = "";
			id("btnNoteColAdd").disabled = true;
			id("btnNoteColRemove").disabled = true;
			id("btnNoteColUp").disabled = true;
			id("btnNoteColDown").disabled = true;
		}
	}

	// name
	var cell = row.insertCell(-1);
	cell.innerHTML = cLabel;
	cell.className = "imgLink";
	cell.style.width = "145px";
	if(cObjId == "tblInactiveNoteCol") {
		cell.style.whiteSpace = "nowrap";
	}

	if(cObjId == "tblActiveNoteCol") {
		// label
		cell = row.insertCell(-1);
		cell.style.width = "150px";
		cell.innerHTML = "<input type=\"text\" id=\"col_label_" + cId + "\" style=\"width:145px;\" value=\""+noteColData[cId-1].label+"\" onblur=\"changeNoteValue('label',"+cId+");\"/>";

		//Align
		cell = row.insertCell(-1);
		cell.innerHTML = "<select id=\"col_align_" + cId + "\" style=\"width:60px\" onchange=\"changeNoteValue('align',"+cId+");\"><option value=\"l\">Left</option><option value=\"c\">Centre</option><option value=\"r\">Right</option></select>";

		var align = noteColData[cId-1].align;
		if(align == "c") {
			id("col_align_"+cId).selectedIndex = 1;
		} 
		if(align == "r") {
			id("col_align_"+cId).selectedIndex = 2;
		}

		cell.innerHTML += "<input type=\"hidden\" id=\"col_Note_" + cId + "\" name=\"NoteCheck\"  value='1' />";

	}
	
	if(cSelected) {
		noteColRowSelected = row;
		row.onclick(false,true);
	}
	
}

var noteColSortOptions = "";
function noteColRegenerate() {
	if(noteColRowSelected != false) {
		var noteColRowSelectedId = noteColRowSelected.colId;
	}
	emptyTable("tblInactiveNoteCol");
	emptyTable("tblActiveNoteCol");

	var colSort = [];
	var sortCount = 1;
	noteColSortOptions = "<option value=\"\"></option>";
	for(var count=0; count < noteColData.length; count++) {
		noteColSortOptions += "<option value=\"" + sortCount.toString() + "\">" + sortCount.toString() + "</option>";
		sortCount++;
	}
	for(var count=0; count < noteColData.length; count++) {
		if(noteColData[count].active != "1") {
			var selected = false;
			if(noteColData[count].id == noteColRowSelectedId) {
				selected = true;
			}
			noteColRow("tblInactiveNoteCol",noteColData[count].id,noteColData[count].name,selected);
		} else {
			colSort[noteColData[count].order] = count;
		}
	}

	for(var count=1; count < colSort.length; count++) {
		var selected = false;
		if(noteColData[colSort[count]].id == noteColRowSelectedId) {
			selected = true;
		}
		noteColRow("tblActiveNoteCol",noteColData[colSort[count]].id,noteColData[colSort[count]].name,selected);
	}
}

function noteColOrderArray() {
	var colOrder = [];
	for(var count=0; count < noteColData.length; count++) {
		if(noteColData[count].active == "1") {
			colOrder[noteColData[count].order] = count;
		} else {
			noteColData[count].order = 0;
		}
	}

	var newColOrder = [];

	for(var count=1; count < colOrder.length; count++) {
		var key = colOrder[count];
		if(noteColData[key]) {
			newColOrder[newColOrder.length] = key;
		}
	}
	return newColOrder;
}

function noteColNormaliseOrder() {
	var colOrder = noteColOrderArray();

	var orderCount = 1;
	for(var count=0; count < colOrder.length; count++) {
		noteColData[colOrder[count]].order = orderCount;
		orderCount++;
	}
}

function noteColAdd() {
	if(!noteColRowSelected) { return false; }

	var maxOrder = 0;
	for(var count=0; count < noteColData.length; count++) {
		if(parseInt(noteColData[count].order) > maxOrder) maxOrder = parseInt(noteColData[count].order);
	}
	maxOrder++;
	
	for(var count=0; count < noteColData.length; count++) {
		if(noteColRowSelected.colId == noteColData[count].id) {
			noteColData[count].active = "1";
			noteColData[count].order = maxOrder;
		}
	}	

	noteColNormaliseOrder();
	noteColRegenerate();
}

function noteColRemove() {
	if(!noteColRowSelected) { return false; }

	for(var count=0; count < noteColData.length; count++) {
		if(noteColRowSelected.colId == noteColData[count].id) {
			noteColData[count].active = "0";
		}
	}	
	noteColNormaliseOrder();
	noteColRegenerate();
}

function noteColSwapOrder(key1, key2) {
	var temp = noteColData[key1].order;
	noteColData[key1].order = noteColData[key2].order;
	noteColData[key2].order = temp;
}

function noteColMove(direction) {
	if(!noteColRowSelected) { return false; }

	var colOrder = noteColOrderArray();
	var colFirst = colOrder[0];
	
	for(var count=0; count < colOrder.length; count++) {
		var key = colOrder[count];
		if(noteColRowSelected.colId == noteColData[key].id) {
			if(!direction) {
				if(count != 0) {
					noteColSwapOrder(key,colOrder[count-1]);
				}
			} else {
				if(count < colOrder.length-1) {
					noteColSwapOrder(key,colOrder[count+1]);
				}
			}
		}
	}

	noteColNormaliseOrder();
	noteColRegenerate();
}

function noteColUp() {
	noteColMove();
}

function noteColDown() {
	noteColMove(true);
}

