function initialisePage() {
	dateSelector();
	initTop();
	enableButtons(enabledButtons);

	// get print info
	id("user").innerHTML = FirstName + " " + LastName;
	id("server").innerHTML = Domain;
	id("genDate").innerHTML = genDateVal;

	populateDateFields("fromYear", fromY, "fromMonth", fromM, "fromDay", fromD);
	populateDateFields("toYear", toY, "toMonth", toM, "toDay", toD);
	populateDateFields("recordFromYear", recordFromY, "recordFromMonth", recordFromM, "recordFromDay", recordFromD);
	populateDateFields("recordToYear", recordToY, "recordToMonth", recordToM, "recordToDay", recordToD);
	populateDateFields("travelFromYear", travelFromY, "travelFromMonth", travelFromM, "travelFromDay", travelFromD);
	populateDateFields("travelToYear", travelToY, "travelToMonth", travelToM, "travelToDay", travelToD);
	populateDateFields("arriveFromYear", arriveFromY, "arriveFromMonth", arriveFromM, "arriveFromDay", arriveFromD);
	populateDateFields("arriveToYear", arriveToY, "arriveToMonth", arriveToM, "arriveToDay", arriveToD);
}

function buildDate(prefix) {
	dayValue = id(prefix+"Day").options[id(prefix+"Day").selectedIndex].value;
	monthValue = id(prefix+"Month").options[id(prefix+"Month").selectedIndex].value;

	dayValue = dayValue<10?"0"+dayValue:dayValue;
	monthValue = monthValue<10?"0"+monthValue:monthValue;
	 
	resultDate = id(prefix+"Year").value+"-"+monthValue+"-"+dayValue;
      
	if(dayValue < 1) { 
		id(prefix+"Day").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(monthValue < 1) {
		id(prefix+"Month").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(id(prefix+"Year").value == "") {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;		 
	 }		 
	if(id(prefix+"Year").value.search(/^\d{4}$/) == -1) {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}

	return resultDate;
}  

function buildURL(renderOption) {
	var dateType = "0";
	if(id("dateRecorded").checked) {
		dateType = "1";
	}
	var fromDate = buildDate("from");
	if(!fromDate) { return false; }

	var toDate = buildDate("to");
	if(!toDate) { return false; }

	var recordFromDate = buildDate("recordFrom");
	if(!recordFromDate) { return false; }

	var recordToDate = buildDate("recordTo");
	if(!recordToDate) { return false; }

	var travelFromDate = buildDate("travelFrom");
	if(!travelFromDate) { return false; }

	var travelToDate = buildDate("travelTo");
	if(!travelToDate) { return false; }

	var arriveFromDate = buildDate("arriveFrom");
	if(!arriveFromDate) { return false; }

	var arriveToDate = buildDate("arriveTo");
	if(!arriveToDate) { return false; }

	renderOption &= 7;
	_urlCount++;


	var url = [
		/*  0 */ "reservation.php?291",
		/*  1 */ dateType,
		/*  2 */ fromDate,
		/*  3 */ toDate,
		/*  4 */ recordFromDate,
		/*  5 */ recordToDate,
		/*  6 */ id("bankIds").value, // bank+cash point
		/*  7 */ id("currenciesIds").value,
		/*  8 */ id("mthdpayIds").value,
		/*  9 */ id("folioCheck").checked?"1":"0",
		/* 10 */ id("invoiceCheck").checked?"1":"0",
		/* 11 */ 1, // filter state
		/* 12 */ renderOption.toString(),
		/* 13 */ _randomId + "_" + _urlCount.toString(),
		/* 14 */ travelFromDate,
		/* 15 */ travelToDate,
		/* 16 */ id("travelDateRange").checked?"1":"0",
		/* 17 */ arriveFromDate,
		/* 18 */ arriveToDate,
		/* 19 */ id("arriveDateRange").checked?"1":"0"
	];
	return url.join("+");
}

function generateReport(renderOption,sortOption) {
	var url = buildURL(renderOption,sortOption);
	if(url) {
		id("urlForm").target = "";
		id("url").value = url
		id("urlForm").action = "reservation.php?" + jobId;
		id("urlForm").submit();
	}
}

function openPDF() {
	var url = buildURL(1);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading PDF...",640,480,0,0,0,1,"pdfWin","opener.id('urlForm').submit();");
	}
}

function sendPDF() {
	var url = buildURL(2);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin = openPopup("/resource/Resrequest/Application/public/html/wait.htm?Loading email popup...",775,615,0,0,0,0,"pdfWin","opener.id('urlForm').submit();");
	}
}

function openCSV() {
	var url = buildURL(4);
	if(url) { 
		id("urlForm").target = "_self";		
		id("url").value = url;
		id("urlForm").submit();
  }
}

function openFilter(filter){
	var selectedArray = id(filter + "Ids").value;
	url = "reservation.php?661+"
		+ filter
		+ "+"
		+ selectedArray;    
         
	openPopup(url,280,360);                          
}

function select_daymonth_changed(){
	setDayList(id("fromDay"),id("fromMonth").options[id("fromMonth").selectedIndex].value,id("fromYear").value);
	setDayList(id("toDay"),id("toMonth").options[id("toMonth").selectedIndex].value,id("toYear").value);
	setDayList(id("recordFromDay"),id("recordFromMonth").options[id("recordFromMonth").selectedIndex].value,id("recordFromYear").value);
	setDayList(id("recordToDay"),id("recordToMonth").options[id("recordToMonth").selectedIndex].value,id("recordToYear").value);
	setDayList(id("travelFromDay"),id("travelFromMonth").options[id("travelFromMonth").selectedIndex].value,id("travelFromYear").value);
	setDayList(id("travelToDay"),id("travelToMonth").options[id("travelToMonth").selectedIndex].value,id("travelToYear").value);
	setDayList(id("arriveFromDay"),id("arriveFromMonth").options[id("arriveFromMonth").selectedIndex].value,id("arriveFromYear").value);
	setDayList(id("arriveToDay"),id("arriveToMonth").options[id("arriveToMonth").selectedIndex].value,id("arriveToYear").value);
}

function showHideFilters(){
	var filters = id("filters");
	var filterBut = id("filterBut");
	
	mnuInitialise = false;
	
	if ( filters.className == "collapse printCollapse" ) {
		filters.className = "expand";
		filterBut.value 	= "<< Hide Filters";
		filterButtonState = "0";
	} else {
		filters.className = "collapse printCollapse";
		filterBut.value 	= ">> Show Filters";
		filterButtonState = "1"
	}
}
