function initialisePage() {
	dateSelector();
	initTop();
	enableButtons(enabledButtons);
	levelChange();

	populateDateFields("fromYear", _fromY, "fromMonth", _fromM, "fromDay", _fromD);
	populateDateFields("fromTravelYear", _fromTravelY, "fromTravelMonth", _fromTravelM, "fromTravelDay", _fromTravelD);
	populateDateFields("toTravelYear", _toTravelY, "toTravelMonth", _toTravelM, "toTravelDay", _toTravelD);

	toggleStartDate();

	try {
		id("monthCount").focus();
	} catch(e) {}
}

function buildDate(prefix) {
	dayValue = id(prefix+"Day").options[id(prefix+"Day").selectedIndex].value;
	monthValue = id(prefix+"Month").options[id(prefix+"Month").selectedIndex].value;

	dayValue = dayValue<10?"0"+dayValue:dayValue;
	monthValue = monthValue<10?"0"+monthValue:monthValue;
	 
	resultDate = id(prefix+"Year").value+"-"+monthValue+"-"+dayValue;
      
	if(dayValue < 1) { 
		id(prefix+"Day").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(monthValue < 1) {
		id(prefix+"Month").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}
	if(id(prefix+"Year").value == "") {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;		 
	 }		 
	if(id(prefix+"Year").value.search(/^\d{4}$/) == -1) {
		id(prefix+"Year").focus();
		openMessage("Please enter a valid "+prefix+" date","a",100);
		return false;
	}

	return resultDate;
}  

function buildURL(renderOption) {
	renderOption &= 7;
	_urlCount++;
	groups = new Array();
	for(var count=0; count<groupCount; count++) {
		groups.push(selValue("groupBy" + count.toString()));;
	}

	var fromDate = buildDate("from");
	var fromTravelDate = buildDate("fromTravel");
	var toTravelDate = buildDate("toTravel");

	url = new Array("reservation.php?" + _job,
		/*  1 */ selValue("monthCount"),
		/*  2 */ id("includeSummary").checked?"1":"0",
		/*  3 */ id("includePrevious").checked?"1":"0",
		/*  4 */ id("agentIds").value,
		/*  5 */ id("statusIds").value,
		/*  6 */ id("accommIds").value,
		/*  7 */ id("consultantIds").value,
		/*  8 */ id("paymentPlanIds").value,
		/*  9 */ groups.join(":"),
		/* 10 */ id("includeCredits").checked?"1":"0",
		/* 11 */ id("includeExtras").checked?"1":"0",
		/* 12 */ id("travelDateRange").checked?"1":"0",
		/* 13 */ fromTravelDate,
		/* 14 */ toTravelDate,
		/* 15 */ id("overrideStartDate").checked?"1":"0",
		/* 16 */ fromDate,
		/* 17 */ renderOption,
		/* 18 */ _randomId + "_" + _urlCount.toString(),
		/* 19 */ selValue("dateRangeType")
	);
	return url.join("+");
}

function openCSV() {
	url = buildURL(4);
	if(url) {
		id("urlForm").target = "_self";
		id("url").value = url;
		id("urlForm").submit();
	}
}

function openPDF(){
	url = buildURL(1);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading PDF...",640,480,0,0,0,1,"pdfWin","opener.id('urlForm').submit();");
	}
}

function sendPDF(){
	url = buildURL(2);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "pdfWin";
		pdfWin=openPopup("/resource/Resrequest/Application/public/html/wait.htm?Loading email popup...",775,615,0,0,0,0,"pdfWin","opener.id('urlForm').submit();");
	}
}

function keyDown(e) {
	if(e.keyCode == 13) {
		processForm();
		e.keyCode=0;
		e.returnValue=false;
	}
}

function processReport(num) {
	url = buildURL(num);
	if(url) {
		id("url").value = url;
		id("urlForm").target = "_self";
		id("urlForm").submit();
	}
}

function levelChange() {
	var count;
	for(count=0; count<groupCount; count++) {
		if(selValue("groupBy"+count.toString()) == "all") {
			break;
		}
	}
	id("groupBy"+count.toString()).disabled = false;
	count++;
	for(;count<groupCount;count++) {
		id("groupBy"+count.toString()).selectedIndex = 0;
		id("groupBy"+count.toString()).disabled = true;
	}
}

function showHideFilters(){
	mnuInitialise = false;
	
	if(id("filters").className == "collapse printCollapse" ) {
		id("filters").className = "expand";
		id("filterBut").value 	= "<< Hide Filters";
	} else {
		id("filters").className = "collapse printCollapse";
		id("filterBut").value 	= ">> Show Filters";
	}
}

function toggleOptions() {
	if(id("advancedForm").className == "collapse") {
		id("advancedForm").className = "colLt";
		id("advancedTag").value = ">>  More";		// For <input> element
		id("advancedTag").innerHTML = ">>  More";	// For <button> element
	} else {
		id("advancedForm").className = "collapse";
		id("advancedTag").value = "<<  More";
		id("advancedTag").innerHTML = "<<  More";
	}
}

function toggleStartDate() {
	if(id("overrideStartDate").checked) {
		id("startDateCell").className = "expand";
	} else {
		id("startDateCell").className = "collapse printCollapse";
	}
}

function rowOn(obj) {
	obj.style.backgroundColor = '#CCFFCC';
}

function rowOff(obj) {
	obj.style.backgroundColor = '';
}

function colOn(num) {
	id("dateCol"+num.toString()).style.backgroundColor = '#CCFFCC';
}

function colOff(num) {
	id("dateCol"+num.toString()).style.backgroundColor = '';
}

function drillDown(url) {
	id("paymentsDueUrl").value = url;
	id("paymentsDueForm").submit();
}

function openPropFilter() {
	var accomm = id("accommIds").value;
	openPopup("reservation.php?293+"+accomm,556,407);
}

function toggleTravelDateRange() {
	if(id('travelDateRange').checked) {
		id('travelDateRangeSpan').className = 'expand';
	} else {
		id('travelDateRangeSpan').className = 'collapse';
	}
}

function select_daymonth_changed() {
	setDayList(id("fromDay"),id("fromMonth").options[id("fromMonth").selectedIndex].value,id("fromYear").value);
	setDayList(id("fromTravelDay"),id("fromTravelMonth").options[id("fromTravelMonth").selectedIndex].value,id("fromTravelYear").value);
	setDayList(id("toTravelDay"),id("toTravelMonth").options[id("toTravelMonth").selectedIndex].value,id("toTravelYear").value);
}

